/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.functions.Func5;
import rx.functions.Func6;
import rx.functions.Func7;
import rx.functions.Func8;
import rx.functions.Func9;
import rx.functions.FuncN;
import rx.functions.Functions;
import rx.internal.operators.BackpressureUtils;
import rx.internal.util.RxRingBuffer;
import rx.subscriptions.CompositeSubscription;

public final class OperatorZip<R>
implements Observable.Operator<R, Observable<?>[]> {
    final FuncN<? extends R> zipFunction;

    public OperatorZip(FuncN<? extends R> f) {
        this.zipFunction = f;
    }

    public OperatorZip(Func2 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func3 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func4 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func5 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func6 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func7 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func8 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func9 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    @Override
    public Subscriber<? super Observable[]> call(Subscriber<? super R> child) {
        Zip<? extends R> zipper = new Zip<R>(child, this.zipFunction);
        ZipProducer<? extends R> producer = new ZipProducer<R>(zipper);
        ZipSubscriber subscriber = new ZipSubscriber(child, zipper, producer);
        child.add(subscriber);
        child.setProducer(producer);
        return subscriber;
    }

    static final class Zip<R>
    extends AtomicLong {
        private static final long serialVersionUID = 5995274816189928317L;
        final Observer<? super R> child;
        private final FuncN<? extends R> zipFunction;
        private final CompositeSubscription childSubscription = new CompositeSubscription();
        static final int THRESHOLD = (int)((double)RxRingBuffer.SIZE * 0.7);
        int emitted;
        private volatile Object[] subscribers;
        private AtomicLong requested;

        public Zip(Subscriber<? super R> child, FuncN<? extends R> zipFunction) {
            this.child = child;
            this.zipFunction = zipFunction;
            child.add(this.childSubscription);
        }

        public void start(Observable[] os, AtomicLong requested) {
            int i;
            Object[] subscribers = new Object[os.length];
            for (i = 0; i < os.length; ++i) {
                InnerSubscriber io = new InnerSubscriber();
                subscribers[i] = io;
                this.childSubscription.add(io);
            }
            this.requested = requested;
            this.subscribers = subscribers;
            for (i = 0; i < os.length; ++i) {
                os[i].unsafeSubscribe((InnerSubscriber)subscribers[i]);
            }
        }

        void tick() {
            Object[] subscribers = this.subscribers;
            if (subscribers == null) {
                return;
            }
            if (this.getAndIncrement() == 0L) {
                int length = subscribers.length;
                Observer<R> child = this.child;
                AtomicLong requested = this.requested;
                while (true) {
                    Object[] vs = new Object[length];
                    boolean allHaveValues = true;
                    for (int i = 0; i < length; ++i) {
                        RxRingBuffer buffer = ((InnerSubscriber)subscribers[i]).items;
                        Object n = buffer.peek();
                        if (n == null) {
                            allHaveValues = false;
                            continue;
                        }
                        if (buffer.isCompleted(n)) {
                            child.onCompleted();
                            this.childSubscription.unsubscribe();
                            return;
                        }
                        vs[i] = buffer.getValue(n);
                    }
                    if (requested.get() > 0L && allHaveValues) {
                        try {
                            child.onNext(this.zipFunction.call(vs));
                            requested.decrementAndGet();
                            ++this.emitted;
                        }
                        catch (Throwable e) {
                            Exceptions.throwOrReport(e, child, (Object)vs);
                            return;
                        }
                        for (Object obj : subscribers) {
                            RxRingBuffer buffer = ((InnerSubscriber)obj).items;
                            buffer.poll();
                            if (!buffer.isCompleted(buffer.peek())) continue;
                            child.onCompleted();
                            this.childSubscription.unsubscribe();
                            return;
                        }
                        if (this.emitted <= THRESHOLD) continue;
                        for (Object obj : subscribers) {
                            ((InnerSubscriber)obj).requestMore(this.emitted);
                        }
                        this.emitted = 0;
                        continue;
                    }
                    if (this.decrementAndGet() <= 0L) break;
                }
            }
        }

        final class InnerSubscriber
        extends Subscriber {
            final RxRingBuffer items = RxRingBuffer.getSpmcInstance();

            InnerSubscriber() {
            }

            @Override
            public void onStart() {
                this.request(RxRingBuffer.SIZE);
            }

            public void requestMore(long n) {
                this.request(n);
            }

            @Override
            public void onCompleted() {
                this.items.onCompleted();
                Zip.this.tick();
            }

            @Override
            public void onError(Throwable e) {
                Zip.this.child.onError(e);
            }

            @Override
            public void onNext(Object t) {
                try {
                    this.items.onNext(t);
                }
                catch (MissingBackpressureException e) {
                    this.onError(e);
                }
                Zip.this.tick();
            }
        }
    }

    static final class ZipProducer<R>
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = -1216676403723546796L;
        final Zip<R> zipper;

        public ZipProducer(Zip<R> zipper) {
            this.zipper = zipper;
        }

        @Override
        public void request(long n) {
            BackpressureUtils.getAndAddRequest(this, n);
            this.zipper.tick();
        }
    }

    final class ZipSubscriber
    extends Subscriber<Observable[]> {
        final Subscriber<? super R> child;
        final Zip<R> zipper;
        final ZipProducer<R> producer;
        boolean started;

        public ZipSubscriber(Subscriber<? super R> child, Zip<R> zipper, ZipProducer<R> producer) {
            this.child = child;
            this.zipper = zipper;
            this.producer = producer;
        }

        @Override
        public void onCompleted() {
            if (!this.started) {
                this.child.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(Observable[] observables) {
            if (observables == null || observables.length == 0) {
                this.child.onCompleted();
            } else {
                this.started = true;
                this.zipper.start(observables, this.producer);
            }
        }
    }
}

