/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace;

import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressAliasCache;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.core.profiling.trace.analyze.ProfileAnalyzer;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.SegmentProfileAnalyzeQuery;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.LogEntity;
import org.apache.skywalking.oap.server.core.query.type.ProfileAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLog;
import org.apache.skywalking.oap.server.core.query.type.ProfiledSpan;
import org.apache.skywalking.oap.server.core.query.type.ProfiledTraceSegments;
import org.apache.skywalking.oap.server.core.query.type.Ref;
import org.apache.skywalking.oap.server.core.query.type.RefType;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileTaskQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileTaskQueryService.class);
    private final ModuleManager moduleManager;
    private IProfileTaskQueryDAO profileTaskQueryDAO;
    private IProfileTaskLogQueryDAO profileTaskLogQueryDAO;
    private IProfileThreadSnapshotQueryDAO profileThreadSnapshotQueryDAO;
    private NetworkAddressAliasCache networkAddressAliasCache;
    private IComponentLibraryCatalogService componentLibraryCatalogService;
    private ITraceQueryDAO traceQueryDAO;
    private final ProfileAnalyzer profileAnalyzer;

    public ProfileTaskQueryService(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        this.profileAnalyzer = new ProfileAnalyzer(moduleManager, moduleConfig.getMaxPageSizeOfQueryProfileSnapshot(), moduleConfig.getMaxSizeOfAnalyzeProfileSnapshot());
    }

    private IProfileTaskQueryDAO getProfileTaskDAO() {
        if (Objects.isNull(this.profileTaskQueryDAO)) {
            this.profileTaskQueryDAO = (IProfileTaskQueryDAO)this.moduleManager.find("storage").provider().getService(IProfileTaskQueryDAO.class);
        }
        return this.profileTaskQueryDAO;
    }

    private IProfileTaskLogQueryDAO getProfileTaskLogQueryDAO() {
        if (Objects.isNull(this.profileTaskLogQueryDAO)) {
            this.profileTaskLogQueryDAO = (IProfileTaskLogQueryDAO)this.moduleManager.find("storage").provider().getService(IProfileTaskLogQueryDAO.class);
        }
        return this.profileTaskLogQueryDAO;
    }

    private IProfileThreadSnapshotQueryDAO getProfileThreadSnapshotQueryDAO() {
        if (Objects.isNull(this.profileThreadSnapshotQueryDAO)) {
            this.profileThreadSnapshotQueryDAO = (IProfileThreadSnapshotQueryDAO)this.moduleManager.find("storage").provider().getService(IProfileThreadSnapshotQueryDAO.class);
        }
        return this.profileThreadSnapshotQueryDAO;
    }

    private NetworkAddressAliasCache getNetworkAddressAliasCache() {
        if (this.networkAddressAliasCache == null) {
            this.networkAddressAliasCache = (NetworkAddressAliasCache)this.moduleManager.find("core").provider().getService(NetworkAddressAliasCache.class);
        }
        return this.networkAddressAliasCache;
    }

    private IComponentLibraryCatalogService getComponentLibraryCatalogService() {
        if (this.componentLibraryCatalogService == null) {
            this.componentLibraryCatalogService = (IComponentLibraryCatalogService)this.moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
        }
        return this.componentLibraryCatalogService;
    }

    private ITraceQueryDAO getTraceQueryDAO() {
        if (this.traceQueryDAO == null) {
            this.traceQueryDAO = (ITraceQueryDAO)this.moduleManager.find("storage").provider().getService(ITraceQueryDAO.class);
        }
        return this.traceQueryDAO;
    }

    public List<ProfileTask> getTaskList(String serviceId, String endpointName) throws IOException {
        List<ProfileTask> tasks = this.getProfileTaskDAO().getTaskList(serviceId, endpointName, null, null, null);
        List<ProfileTaskLog> taskLogList = this.getProfileTaskLogQueryDAO().getTaskLogList();
        if (taskLogList == null) {
            taskLogList = Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(tasks)) {
            for (ProfileTask task : tasks) {
                IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(task.getServiceId());
                task.setServiceName(serviceIDDefinition.getName());
                task.setLogs(this.findMatchedLogs(task.getId(), taskLogList));
            }
        }
        return tasks;
    }

    public List<ProfileTaskLog> getProfileTaskLogs(String taskID) throws IOException {
        List<ProfileTaskLog> taskLogList = this.getProfileTaskLogQueryDAO().getTaskLogList();
        if (CollectionUtils.isEmpty(taskLogList)) {
            return Collections.emptyList();
        }
        return this.findMatchedLogs(taskID, taskLogList);
    }

    public ProfileAnalyzation getProfileAnalyze(List<SegmentProfileAnalyzeQuery> queries) throws IOException {
        return this.profileAnalyzer.analyze(queries);
    }

    public List<SegmentRecord> getTaskSegments(String taskId) throws IOException {
        List<ProfileThreadSnapshotRecord> records = this.getProfileThreadSnapshotQueryDAO().queryRecords(taskId);
        List<String> profiledSegmentIdList = records.stream().map(ProfileThreadSnapshotRecord::getSegmentId).collect(Collectors.toList());
        long endTimestamp = 0L;
        for (ProfileThreadSnapshotRecord record : records) {
            if (record.getDumpTime() <= endTimestamp) continue;
            endTimestamp = record.getDumpTime();
        }
        long startTimestamp = endTimestamp - 300000L;
        Duration duration = new Duration();
        duration.setStep(Step.SECOND);
        DateTime endTime = new DateTime(endTimestamp);
        DateTime startTime = new DateTime(startTimestamp);
        duration.setStart(startTime.toString("yyyy-MM-dd HHmmss"));
        duration.setEnd(endTime.toString("yyyy-MM-dd HHmmss"));
        return this.getTraceQueryDAO().queryBySegmentIdList(profiledSegmentIdList, duration);
    }

    public List<ProfiledTraceSegments> getProfileTaskSegments(String taskId) throws IOException {
        List<SegmentRecord> segmentRecords = this.getTaskSegments(taskId);
        if (CollectionUtils.isEmpty(segmentRecords)) {
            return Collections.emptyList();
        }
        Map<String, List> traceWithInstances = segmentRecords.stream().collect(Collectors.toMap(SegmentRecord::getTraceId, s -> new ArrayList<String>(List.of(s.getServiceInstanceId())), (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        }));
        HashSet<String> traceIdList = new HashSet<String>(segmentRecords.size());
        HashSet<String> instanceIdList = new HashSet<String>(segmentRecords.size());
        for (SegmentRecord segment : segmentRecords) {
            traceIdList.add(segment.getTraceId());
            instanceIdList.add(segment.getServiceInstanceId());
        }
        List<SegmentRecord> traceRelatedSegments = this.getTraceQueryDAO().queryByTraceIdWithInstanceId(new ArrayList<String>(traceIdList), new ArrayList<String>(instanceIdList), null);
        Map<String, List> instanceTraceWithSegments = traceRelatedSegments.stream().filter(s -> {
            List includingInstances = (List)traceWithInstances.get(s.getTraceId());
            return includingInstances.contains(s.getServiceInstanceId());
        }).collect(Collectors.toMap(s -> s.getTraceId() + s.getServiceInstanceId(), s -> new ArrayList<SegmentRecord>(List.of(s)), (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        }));
        List profiledSegmentIdList = segmentRecords.stream().map(SegmentRecord::getSegmentId).collect(Collectors.toList());
        return instanceTraceWithSegments.values().stream().flatMap(s -> this.buildProfiledSegmentsList((List<SegmentRecord>)s, profiledSegmentIdList).stream()).collect(Collectors.toList());
    }

    protected List<ProfiledTraceSegments> buildProfiledSegmentsList(List<SegmentRecord> segmentRecords, List<String> profiledSegmentIdList) {
        Map<String, ProfiledTraceSegments> segments = segmentRecords.stream().map(s -> {
            try {
                return Tuple.of((Object)s, (Object)SegmentObject.parseFrom((byte[])s.getDataBinary()));
            }
            catch (InvalidProtocolBufferException e) {
                log.warn("parsing segment data error", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).filter(s -> CollectionUtils.isNotEmpty((List)((SegmentObject)s._2).getSpansList())).collect(Collectors.toMap(tuple -> ((SegmentRecord)tuple._1).getSegmentId(), tuple -> {
            IDManager.ServiceInstanceID.InstanceIDDefinition serviceInstance = IDManager.ServiceInstanceID.analysisId(((SegmentRecord)tuple._1).getServiceInstanceId());
            ProfiledTraceSegments seg = new ProfiledTraceSegments();
            boolean profiled = profiledSegmentIdList.contains(((SegmentRecord)tuple._1).getSegmentId());
            seg.setTraceId(((SegmentRecord)tuple._1).getTraceId());
            seg.setInstanceId(((SegmentRecord)tuple._1).getServiceInstanceId());
            seg.setInstanceName(serviceInstance.getName());
            seg.getEndpointNames().add(IDManager.EndpointID.analysisId(((SegmentRecord)tuple._1).getEndpointId()).getEndpointName());
            seg.setDuration(((SegmentRecord)tuple._1).getLatency());
            seg.setStart(String.valueOf(((SegmentRecord)tuple._1).getStartTime()));
            seg.getSpans().addAll(this.buildProfiledSpanList((SegmentObject)tuple._2, profiled));
            seg.setContainsProfiled(profiled);
            return seg;
        }));
        ArrayList<ProfiledTraceSegments> results = new ArrayList<ProfiledTraceSegments>();
        Iterator<Map.Entry<String, ProfiledTraceSegments>> entryIterator = segments.entrySet().iterator();
        HashSet<ProfiledSpan> mergedSpans = new HashSet<ProfiledSpan>();
        while (entryIterator.hasNext()) {
            Map.Entry<String, ProfiledTraceSegments> current = entryIterator.next();
            boolean spanBeenAdded = false;
            for (ProfiledSpan span : current.getValue().getSpans()) {
                if (mergedSpans.contains(span) || CollectionUtils.isEmpty(span.getRefs())) continue;
                Ref ref = span.getRefs().get(0);
                if (RefType.CROSS_PROCESS.equals((Object)ref.getType())) {
                    results.add(current.getValue());
                    spanBeenAdded = true;
                    break;
                }
                ProfiledTraceSegments parentSegments = segments.get(ref.getParentSegmentId());
                if (parentSegments == null) continue;
                mergedSpans.addAll(current.getValue().getSpans());
                parentSegments.merge(current.getValue());
                current.setValue(parentSegments);
                spanBeenAdded = true;
                break;
            }
            if (spanBeenAdded) continue;
            results.add(current.getValue());
        }
        return results.stream().filter(ProfiledTraceSegments::isContainsProfiled).peek(this::removeAllCrossProcessRef).collect(Collectors.toList());
    }

    private void removeAllCrossProcessRef(ProfiledTraceSegments segments) {
        segments.getSpans().stream().filter(s -> CollectionUtils.isNotEmpty(s.getRefs())).forEach(s -> s.getRefs().removeIf(ref -> RefType.CROSS_PROCESS.equals((Object)ref.getType())));
    }

    private List<ProfiledSpan> buildProfiledSpanList(SegmentObject segmentObject, boolean profiled) {
        ArrayList<ProfiledSpan> spans = new ArrayList<ProfiledSpan>();
        segmentObject.getSpansList().forEach(spanObject -> {
            ProfiledSpan span = new ProfiledSpan();
            span.setSpanId(spanObject.getSpanId());
            span.setParentSpanId(spanObject.getParentSpanId());
            span.setSegmentId(segmentObject.getTraceSegmentId());
            span.setStartTime(spanObject.getStartTime());
            span.setEndTime(spanObject.getEndTime());
            span.setError(spanObject.getIsError());
            span.setLayer(spanObject.getSpanLayer().name());
            span.setType(spanObject.getSpanType().name());
            span.setEndpointName(spanObject.getOperationName());
            span.setPeer(spanObject.getPeer());
            span.setEndpointName(spanObject.getOperationName());
            span.setServiceCode(segmentObject.getService());
            span.setServiceInstanceName(segmentObject.getServiceInstance());
            span.setComponent(this.getComponentLibraryCatalogService().getComponentName(spanObject.getComponentId()));
            spanObject.getTagsList().forEach(tag -> {
                KeyValue keyValue = new KeyValue();
                keyValue.setKey(tag.getKey());
                keyValue.setValue(tag.getValue());
                span.getTags().add(keyValue);
            });
            spanObject.getLogsList().forEach(log -> {
                LogEntity logEntity = new LogEntity();
                logEntity.setTime(log.getTime());
                log.getDataList().forEach(data -> {
                    KeyValue keyValue = new KeyValue();
                    keyValue.setKey(data.getKey());
                    keyValue.setValue(data.getValue());
                    logEntity.getData().add(keyValue);
                });
                span.getLogs().add(logEntity);
            });
            List<Ref> refs = spanObject.getRefsList().stream().map(r -> {
                Ref ref = new Ref();
                ref.setTraceId(r.getTraceId());
                ref.setParentSegmentId(r.getParentTraceSegmentId());
                ref.setParentSpanId(r.getParentSpanId());
                switch (r.getRefType()) {
                    case CrossThread: {
                        ref.setType(RefType.CROSS_THREAD);
                        break;
                    }
                    case CrossProcess: {
                        ref.setType(RefType.CROSS_PROCESS);
                    }
                }
                return ref;
            }).collect(Collectors.toList());
            span.setRefs(refs);
            span.setProfiled(profiled);
            spans.add(span);
        });
        return spans;
    }

    private List<ProfileTaskLog> findMatchedLogs(String taskID, List<ProfileTaskLog> allLogs) {
        return allLogs.stream().filter(l -> com.google.common.base.Objects.equal((Object)l.getTaskId(), (Object)taskID)).map(this::extendTaskLog).collect(Collectors.toList());
    }

    private ProfileTaskLog extendTaskLog(ProfileTaskLog log) {
        IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId(log.getInstanceId());
        log.setInstanceName(instanceIDDefinition.getName());
        return log;
    }
}

