/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.hierarchy.instance.InstanceHierarchyRelationTraffic;
import org.apache.skywalking.oap.server.core.hierarchy.service.ServiceHierarchyRelationTraffic;
import org.apache.skywalking.oap.server.core.storage.query.IHierarchyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchScroller;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class HierarchyQueryEsDAO
extends EsDAO
implements IHierarchyQueryDAO {
    private final int queryMaxSize;
    private final int scrollingBatchSize;
    protected final Function<SearchHit, ServiceHierarchyRelationTraffic> serviceRelationsFunction = hit -> {
        Map sourceAsMap = hit.getSource();
        ServiceHierarchyRelationTraffic.Builder builder = new ServiceHierarchyRelationTraffic.Builder();
        return builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("service_hierarchy_relation", sourceAsMap));
    };
    protected final Function<SearchHit, InstanceHierarchyRelationTraffic> instanceRelationsFunction = hit -> {
        Map sourceAsMap = hit.getSource();
        InstanceHierarchyRelationTraffic.Builder builder = new InstanceHierarchyRelationTraffic.Builder();
        return builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("instance_hierarchy_relation", sourceAsMap));
    };

    public HierarchyQueryEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.queryMaxSize = config.getMetadataQueryMaxSize();
        this.scrollingBatchSize = config.getScrollingBatchSize();
    }

    public List<ServiceHierarchyRelationTraffic> readAllServiceHierarchyRelations() {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("service_hierarchy_relation");
        int batchSize = Math.min(this.queryMaxSize, this.scrollingBatchSize);
        BoolQueryBuilder query = Query.bool();
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(batchSize));
        if (IndexController.LogicIndicesRegister.isMergedTable("service_hierarchy_relation")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"service_hierarchy_relation"));
        }
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).queryMaxSize(this.queryMaxSize).resultConverter(this.serviceRelationsFunction).build();
        return scroller.scroll();
    }

    public List<InstanceHierarchyRelationTraffic> readInstanceHierarchyRelations(String instanceId, String layer) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("instance_hierarchy_relation");
        int layerValue = Layer.valueOf((String)layer).value();
        BoolQueryBuilder instanceSide = Query.bool().must((QueryBuilder)Query.term((String)"instance_id", (Object)instanceId)).must((QueryBuilder)Query.term((String)"service_layer", (Object)layerValue));
        BoolQueryBuilder relatedInstanceSide = Query.bool().must((QueryBuilder)Query.term((String)"related_instance_id", (Object)instanceId)).must((QueryBuilder)Query.term((String)"related_service_layer", (Object)layerValue));
        BoolQueryBuilder instanceQuery = Query.bool().should((QueryBuilder)instanceSide).should((QueryBuilder)relatedInstanceSide);
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)instanceQuery);
        if (IndexController.LogicIndicesRegister.isMergedTable("instance_hierarchy_relation")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"instance_hierarchy_relation"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return this.buildInstanceHierarchyRelations(response);
    }

    private List<InstanceHierarchyRelationTraffic> buildInstanceHierarchyRelations(SearchResponse response) {
        ArrayList<InstanceHierarchyRelationTraffic> relations = new ArrayList<InstanceHierarchyRelationTraffic>();
        for (SearchHit searchHit : response.getHits()) {
            relations.add(this.instanceRelationsFunction.apply(searchHit));
        }
        return relations;
    }
}

