/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategy;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategyBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategyFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfig;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigBuilder;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class DeploymentSpecFluentImpl<A extends DeploymentSpecFluent<A>>
extends BaseFluent<A>
implements DeploymentSpecFluent<A> {
    private Integer minReadySeconds;
    private Boolean paused;
    private Integer progressDeadlineSeconds;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private RollbackConfigBuilder rollbackTo;
    private LabelSelectorBuilder selector;
    private DeploymentStrategyBuilder strategy;
    private PodTemplateSpecBuilder template;
    private Map<String, Object> additionalProperties;

    public DeploymentSpecFluentImpl() {
    }

    public DeploymentSpecFluentImpl(DeploymentSpec instance) {
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withPaused(instance.getPaused());
            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
            this.withReplicas(instance.getReplicas());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withRollbackTo(instance.getRollbackTo());
            this.withSelector(instance.getSelector());
            this.withStrategy(instance.getStrategy());
            this.withTemplate(instance.getTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public Boolean getPaused() {
        return this.paused;
    }

    @Override
    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    @Override
    public Boolean hasPaused() {
        return this.paused != null;
    }

    @Override
    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    @Override
    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    @Deprecated
    public RollbackConfig getRollbackTo() {
        return this.rollbackTo != null ? this.rollbackTo.build() : null;
    }

    @Override
    public RollbackConfig buildRollbackTo() {
        return this.rollbackTo != null ? this.rollbackTo.build() : null;
    }

    @Override
    public A withRollbackTo(RollbackConfig rollbackTo) {
        this._visitables.get((Object)"rollbackTo").remove(this.rollbackTo);
        if (rollbackTo != null) {
            this.rollbackTo = new RollbackConfigBuilder(rollbackTo);
            this._visitables.get((Object)"rollbackTo").add(this.rollbackTo);
        } else {
            this.rollbackTo = null;
            this._visitables.get((Object)"rollbackTo").remove(this.rollbackTo);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRollbackTo() {
        return this.rollbackTo != null;
    }

    @Override
    public A withNewRollbackTo(Long revision) {
        return this.withRollbackTo(new RollbackConfig(revision));
    }

    @Override
    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo() {
        return new RollbackToNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item) {
        return new RollbackToNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.RollbackToNested<A> editRollbackTo() {
        return this.withNewRollbackToLike(this.getRollbackTo());
    }

    @Override
    public DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackTo() {
        return this.withNewRollbackToLike(this.getRollbackTo() != null ? this.getRollbackTo() : new RollbackConfigBuilder().build());
    }

    @Override
    public DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackToLike(RollbackConfig item) {
        return this.withNewRollbackToLike(this.getRollbackTo() != null ? this.getRollbackTo() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public DeploymentStrategy getStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public DeploymentStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public A withStrategy(DeploymentStrategy strategy) {
        this._visitables.get((Object)"strategy").remove(this.strategy);
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.get((Object)"strategy").add(this.strategy);
        } else {
            this.strategy = null;
            this._visitables.get((Object)"strategy").remove(this.strategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : new DeploymentStrategyBuilder().build());
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item) {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : item);
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentSpecFluentImpl that = (DeploymentSpecFluentImpl)o;
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.paused, that.paused)) {
            return false;
        }
        if (!Objects.equals(this.progressDeadlineSeconds, that.progressDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.revisionHistoryLimit, that.revisionHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.rollbackTo, that.rollbackTo)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.strategy, that.strategy)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.paused, this.progressDeadlineSeconds, this.replicas, this.revisionHistoryLimit, this.rollbackTo, this.selector, this.strategy, this.template, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.paused != null) {
            sb.append("paused:");
            sb.append(this.paused + ",");
        }
        if (this.progressDeadlineSeconds != null) {
            sb.append("progressDeadlineSeconds:");
            sb.append(this.progressDeadlineSeconds + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.rollbackTo != null) {
            sb.append("rollbackTo:");
            sb.append(this.rollbackTo + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withPaused() {
        return this.withPaused(true);
    }

    class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<DeploymentSpecFluent.TemplateNested<N>>
    implements DeploymentSpecFluent.TemplateNested<N>,
    Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    class StrategyNestedImpl<N>
    extends DeploymentStrategyFluentImpl<DeploymentSpecFluent.StrategyNested<N>>
    implements DeploymentSpecFluent.StrategyNested<N>,
    Nested<N> {
        DeploymentStrategyBuilder builder;

        StrategyNestedImpl(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        StrategyNestedImpl() {
            this.builder = new DeploymentStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withStrategy(this.builder.build());
        }

        @Override
        public N endStrategy() {
            return this.and();
        }
    }

    class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<DeploymentSpecFluent.SelectorNested<N>>
    implements DeploymentSpecFluent.SelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    class RollbackToNestedImpl<N>
    extends RollbackConfigFluentImpl<DeploymentSpecFluent.RollbackToNested<N>>
    implements DeploymentSpecFluent.RollbackToNested<N>,
    Nested<N> {
        RollbackConfigBuilder builder;

        RollbackToNestedImpl(RollbackConfig item) {
            this.builder = new RollbackConfigBuilder(this, item);
        }

        RollbackToNestedImpl() {
            this.builder = new RollbackConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withRollbackTo(this.builder.build());
        }

        @Override
        public N endRollbackTo() {
            return this.and();
        }
    }
}

