/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingDataRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCEBPFProfilingDataDAO
implements IEBPFProfilingDataDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<EBPFProfilingDataRecord> queryData(List<String> scheduleIdList, long beginTime, long endTime) {
        List<String> tables = this.tableHelper.getTablesForRead("ebpf_profiling_data", TimeBucket.getTimeBucket((long)beginTime, (DownSampling)DownSampling.Day), TimeBucket.getTimeBucket((long)endTime, (DownSampling)DownSampling.Day));
        ArrayList<EBPFProfilingDataRecord> results = new ArrayList<EBPFProfilingDataRecord>();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQL(scheduleIdList, beginTime, endTime, table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildDataList, sqlAndParameters.parameters()));
        }
        return results;
    }

    protected SQLAndParameters buildSQL(List<String> scheduleIdList, long beginTime, long endTime, String table) {
        StringBuilder sql = new StringBuilder();
        StringBuilder conditions = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(scheduleIdList.size() + 3);
        sql.append("select * from ").append(table);
        conditions.append(" where ").append("table_name").append(" = ? ");
        parameters.add("ebpf_profiling_data");
        this.appendConditions(conditions, parameters, "schedule_id", scheduleIdList);
        this.appendCondition(conditions, parameters, "upload_time", ">=", beginTime);
        this.appendCondition(conditions, parameters, "upload_time", "<", endTime);
        if (conditions.length() > 0) {
            sql.append((CharSequence)conditions);
        }
        return new SQLAndParameters(sql.toString(), parameters);
    }

    private List<EBPFProfilingDataRecord> buildDataList(ResultSet resultSet) throws SQLException {
        ArrayList<EBPFProfilingDataRecord> dataList = new ArrayList<EBPFProfilingDataRecord>();
        while (resultSet.next()) {
            EBPFProfilingDataRecord data = new EBPFProfilingDataRecord();
            data.setScheduleId(resultSet.getString("schedule_id"));
            data.setTaskId(resultSet.getString("task_id"));
            data.setStackIdList(resultSet.getString("stack_id"));
            String dataBinaryBase64 = resultSet.getString("dump_binary");
            if (StringUtil.isNotEmpty((String)dataBinaryBase64)) {
                data.setDataBinary(Base64.getDecoder().decode(dataBinaryBase64));
            }
            data.setTargetType(resultSet.getInt("target_type"));
            data.setUploadTime(resultSet.getLong("upload_time"));
            dataList.add(data);
        }
        return dataList;
    }

    private void appendCondition(StringBuilder conditionSql, List<Object> condition, String field, String compare, Object data) {
        if (conditionSql.length() > 0) {
            conditionSql.append(" and ");
        }
        conditionSql.append(field).append(compare).append("?");
        condition.add(data);
    }

    private <T> void appendConditions(StringBuilder conditionSql, List<Object> condition, String field, List<T> data) {
        if (conditionSql.length() > 0) {
            conditionSql.append(" and ");
        }
        conditionSql.append(field).append(" in ").append(data.stream().map(it -> "?").collect(Collectors.joining(", ", "(", ")")));
        condition.addAll(data);
    }

    @Generated
    public JDBCEBPFProfilingDataDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

