/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.handler.v8.grpc;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentCollection;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.TraceSegmentReportServiceGrpc;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.ISegmentParserService;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSegmentReportServiceHandler
extends TraceSegmentReportServiceGrpc.TraceSegmentReportServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceSegmentReportServiceHandler.class);
    private HistogramMetrics histogram;
    private CounterMetrics errorCounter;
    private ISegmentParserService segmentParserService;

    public TraceSegmentReportServiceHandler(ModuleManager moduleManager) {
        this.segmentParserService = (ISegmentParserService)moduleManager.find("agent-analyzer").provider().getService(ISegmentParserService.class);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("trace_in_latency", "The process latency of trace data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("trace_analysis_error_count", "The error number of trace analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}));
    }

    public StreamObserver<SegmentObject> collect(final StreamObserver<Commands> responseObserver) {
        return new StreamObserver<SegmentObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(SegmentObject segment) {
                if (log.isDebugEnabled()) {
                    log.debug("received segment in streaming");
                }
                HistogramMetrics.Timer timer = TraceSegmentReportServiceHandler.this.histogram.createTimer();
                try {
                    TraceSegmentReportServiceHandler.this.segmentParserService.send(segment);
                }
                catch (Exception e) {
                    TraceSegmentReportServiceHandler.this.errorCounter.inc();
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    timer.finish();
                }
            }

            public void onError(Throwable throwable) {
                Status status = Status.fromThrowable((Throwable)throwable);
                if (Status.CANCELLED.getCode() == status.getCode()) {
                    if (log.isDebugEnabled()) {
                        log.debug(throwable.getMessage(), throwable);
                    }
                    return;
                }
                log.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }

    public void collectInSync(SegmentCollection request, StreamObserver<Commands> responseObserver) {
        if (log.isDebugEnabled()) {
            log.debug("received {} segments", (Object)request.getSegmentsCount());
        }
        request.getSegmentsList().forEach(segment -> {
            HistogramMetrics.Timer timer = this.histogram.createTimer();
            try {
                this.segmentParserService.send(segment);
            }
            catch (Exception e) {
                this.errorCounter.inc();
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                timer.finish();
            }
        });
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }
}

