/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.pprof.provider.handler;

import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.pprof.v10.PprofCollectionResponse;
import org.apache.skywalking.apm.network.pprof.v10.PprofData;
import org.apache.skywalking.apm.network.pprof.v10.PprofMetaData;
import org.apache.skywalking.apm.network.pprof.v10.PprofTaskCommandQuery;
import org.apache.skywalking.apm.network.pprof.v10.PprofTaskGrpc;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.cache.PprofTaskCache;
import org.apache.skywalking.oap.server.core.command.CommandService;
import org.apache.skywalking.oap.server.core.profiling.pprof.storage.PprofTaskLogRecord;
import org.apache.skywalking.oap.server.core.query.type.PprofTask;
import org.apache.skywalking.oap.server.core.query.type.PprofTaskLogOperationType;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.network.trace.component.command.PprofTaskCommand;
import org.apache.skywalking.oap.server.receiver.pprof.provider.handler.stream.PprofByteBufCollectionObserver;
import org.apache.skywalking.oap.server.receiver.pprof.provider.handler.stream.PprofCollectionMetaData;
import org.apache.skywalking.oap.server.receiver.pprof.provider.handler.stream.PprofFileCollectionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PprofServiceHandler
extends PprofTaskGrpc.PprofTaskImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PprofServiceHandler.class);
    private final IPprofTaskQueryDAO taskDAO;
    private final SourceReceiver sourceReceiver;
    private final CommandService commandService;
    private final PprofTaskCache taskCache;
    private final int pprofMaxSize;
    private final boolean memoryParserEnabled;

    public PprofServiceHandler(ModuleManager moduleManager, int pprofMaxSize, boolean memoryParserEnabled) {
        this.taskDAO = (IPprofTaskQueryDAO)moduleManager.find("storage").provider().getService(IPprofTaskQueryDAO.class);
        this.commandService = (CommandService)moduleManager.find("core").provider().getService(CommandService.class);
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.taskCache = (PprofTaskCache)moduleManager.find("core").provider().getService(PprofTaskCache.class);
        this.pprofMaxSize = pprofMaxSize;
        this.memoryParserEnabled = memoryParserEnabled;
    }

    public StreamObserver<PprofData> collect(StreamObserver<PprofCollectionResponse> responseObserver) {
        return this.memoryParserEnabled ? new PprofByteBufCollectionObserver(this.taskDAO, responseObserver, this.sourceReceiver, this.pprofMaxSize) : new PprofFileCollectionObserver(this.taskDAO, responseObserver, this.sourceReceiver, this.pprofMaxSize);
    }

    public void getPprofTaskCommands(PprofTaskCommandQuery request, StreamObserver<Commands> responseObserver) {
        String serviceId = IDManager.ServiceID.buildId((String)request.getService(), (boolean)true);
        String serviceInstanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)request.getServiceInstance());
        List taskList = this.taskCache.getPprofTaskList(serviceId);
        if (CollectionUtils.isEmpty((List)taskList)) {
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
            return;
        }
        long lastCommandTime = request.getLastCommandTime();
        long minCreateTime = Long.MAX_VALUE;
        PprofTask taskResult = null;
        for (PprofTask task : taskList) {
            if (task.getCreateTime() <= lastCommandTime || !CollectionUtils.isEmpty((List)task.getServiceInstanceIds()) && !task.getServiceInstanceIds().contains(serviceInstanceId) || task.getCreateTime() >= minCreateTime) continue;
            minCreateTime = task.getCreateTime();
            taskResult = task;
        }
        if (taskResult == null) {
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
            return;
        }
        PprofTaskCommand pprofTaskCommand = this.commandService.newPprofTaskCommand(taskResult);
        Commands commands = Commands.newBuilder().addCommands(pprofTaskCommand.serialize()).build();
        responseObserver.onNext((Object)commands);
        responseObserver.onCompleted();
        PprofServiceHandler.recordPprofTaskLog(taskResult, serviceInstanceId, PprofTaskLogOperationType.NOTIFIED);
    }

    public static void recordPprofTaskLog(PprofTask task, String instanceId, PprofTaskLogOperationType operationType) {
        PprofTaskLogRecord logRecord = new PprofTaskLogRecord();
        logRecord.setTaskId(task.getId());
        logRecord.setInstanceId(instanceId);
        logRecord.setOperationType(operationType.getCode());
        logRecord.setOperationTime(System.currentTimeMillis());
        long timestamp = task.getCreateTime() + TimeUnit.SECONDS.toMillis(task.getDuration());
        logRecord.setTimestamp(timestamp);
        logRecord.setTimeBucket(TimeBucket.getRecordTimeBucket((long)timestamp));
        RecordStreamProcessor.getInstance().in((Record)logRecord);
    }

    public static PprofCollectionMetaData parseMetaData(PprofMetaData metaData, IPprofTaskQueryDAO taskDAO) throws IOException {
        String taskId = metaData.getTaskId();
        PprofTask task = taskDAO.getById(taskId);
        String serviceId = IDManager.ServiceID.buildId((String)metaData.getService(), (boolean)true);
        String serviceInstanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)metaData.getServiceInstance());
        return PprofCollectionMetaData.builder().task(task).serviceId(serviceId).instanceId(serviceInstanceId).type(metaData.getType()).contentSize(metaData.getContentSize()).uploadTime(System.currentTimeMillis()).build();
    }
}

