/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl;

import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamily;

public class Result {
    private final boolean success;
    private final boolean isThrowable;
    private final String error;
    private final SampleFamily data;

    public static Result fail(Throwable throwable) {
        return new Result(false, true, throwable.getMessage(), SampleFamily.EMPTY);
    }

    public static Result fail(String message) {
        return new Result(false, false, message, SampleFamily.EMPTY);
    }

    public static Result fail() {
        return new Result(false, false, null, SampleFamily.EMPTY);
    }

    public static Result success(SampleFamily sf) {
        return new Result(true, false, null, sf);
    }

    @Generated
    private Result(boolean success, boolean isThrowable, String error, SampleFamily data) {
        this.success = success;
        this.isThrowable = isThrowable;
        this.error = error;
        this.data = data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.isThrowable() != other.isThrowable()) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        SampleFamily this$data = this.getData();
        SampleFamily other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + (this.isThrowable() ? 79 : 97);
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        SampleFamily $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Result(success=" + this.isSuccess() + ", isThrowable=" + this.isThrowable() + ", error=" + this.getError() + ", data=" + String.valueOf(this.getData()) + ")";
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public boolean isThrowable() {
        return this.isThrowable;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public SampleFamily getData() {
        return this.data;
    }
}

