/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanType;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.SegmentParserListenerManager;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.EntryAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.ExitAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.FirstAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.LocalAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.SegmentListener;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceAnalyzer.class);
    private final ModuleManager moduleManager;
    private final SegmentParserListenerManager listenerManager;
    private final AnalyzerModuleConfig config;
    private List<AnalysisListener> analysisListeners = new ArrayList<AnalysisListener>();

    public void doAnalysis(SegmentObject segmentObject) {
        if (segmentObject.getSpansList().size() == 0) {
            return;
        }
        this.createSpanListeners();
        this.notifySegmentListener(segmentObject);
        segmentObject.getSpansList().forEach(spanObject -> {
            if (spanObject.getSpanId() == 0) {
                this.notifyFirstListener((SpanObject)spanObject, segmentObject);
            }
            if (SpanType.Exit.equals((Object)spanObject.getSpanType())) {
                this.notifyExitListener((SpanObject)spanObject, segmentObject);
            } else if (SpanType.Entry.equals((Object)spanObject.getSpanType())) {
                this.notifyEntryListener((SpanObject)spanObject, segmentObject);
            } else if (SpanType.Local.equals((Object)spanObject.getSpanType())) {
                this.notifyLocalListener((SpanObject)spanObject, segmentObject);
            } else {
                log.error("span type value was unexpected, span type name: {}", (Object)spanObject.getSpanType().name());
            }
        });
        this.notifyListenerToBuild();
    }

    private void notifyListenerToBuild() {
        this.analysisListeners.forEach(AnalysisListener::build);
    }

    private void notifyExitListener(SpanObject span, SegmentObject segmentObject) {
        this.analysisListeners.forEach(listener -> {
            if (listener.containsPoint(AnalysisListener.Point.Exit)) {
                ((ExitAnalysisListener)listener).parseExit(span, segmentObject);
            }
        });
    }

    private void notifyEntryListener(SpanObject span, SegmentObject segmentObject) {
        this.analysisListeners.forEach(listener -> {
            if (listener.containsPoint(AnalysisListener.Point.Entry)) {
                ((EntryAnalysisListener)listener).parseEntry(span, segmentObject);
            }
        });
    }

    private void notifyLocalListener(SpanObject span, SegmentObject segmentObject) {
        this.analysisListeners.forEach(listener -> {
            if (listener.containsPoint(AnalysisListener.Point.Local)) {
                ((LocalAnalysisListener)listener).parseLocal(span, segmentObject);
            }
        });
    }

    private void notifyFirstListener(SpanObject span, SegmentObject segmentObject) {
        this.analysisListeners.forEach(listener -> {
            if (listener.containsPoint(AnalysisListener.Point.First)) {
                ((FirstAnalysisListener)listener).parseFirst(span, segmentObject);
            }
        });
    }

    private void notifySegmentListener(SegmentObject segmentObject) {
        this.analysisListeners.forEach(listener -> {
            if (listener.containsPoint(AnalysisListener.Point.Segment)) {
                ((SegmentListener)listener).parseSegment(segmentObject);
            }
        });
    }

    private void createSpanListeners() {
        this.listenerManager.getSpanListenerFactories().forEach(spanListenerFactory -> this.analysisListeners.add(spanListenerFactory.create(this.moduleManager, this.config)));
    }

    @Generated
    public TraceAnalyzer(ModuleManager moduleManager, SegmentParserListenerManager listenerManager, AnalyzerModuleConfig config) {
        this.moduleManager = moduleManager;
        this.listenerManager = listenerManager;
        this.config = config;
    }
}

