/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.clr.provider.handler;

import io.grpc.stub.StreamObserver;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.agent.v3.CLRMetric;
import org.apache.skywalking.apm.network.language.agent.v3.CLRMetricCollection;
import org.apache.skywalking.apm.network.language.agent.v3.CLRMetricReportServiceGrpc;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.receiver.clr.provider.handler.CLRSourceDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLRMetricReportServiceHandler
extends CLRMetricReportServiceGrpc.CLRMetricReportServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CLRMetricReportServiceHandler.class);
    private final CLRSourceDispatcher clrSourceDispatcher;
    private final NamingControl namingControl;

    public CLRMetricReportServiceHandler(ModuleManager moduleManager) {
        this.clrSourceDispatcher = new CLRSourceDispatcher(moduleManager);
        this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
    }

    public void collect(CLRMetricCollection request, StreamObserver<Commands> responseObserver) {
        if (log.isDebugEnabled()) {
            log.debug("receive the clr metrics from service instance, id: {}", (Object)request.getServiceInstance());
        }
        CLRMetricCollection.Builder builder = request.toBuilder();
        builder.setService(this.namingControl.formatServiceName(builder.getService()));
        builder.setServiceInstance(this.namingControl.formatInstanceName(builder.getServiceInstance()));
        request.getMetricsList().forEach(metrics -> {
            long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)metrics.getTime());
            this.clrSourceDispatcher.sendMetric(request.getService(), request.getServiceInstance(), minuteTimeBucket, (CLRMetric)metrics);
        });
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }
}

