/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class AuthenticationInfo
extends HashMap<String, Object> {
    public static final AuthenticationInfo DOING_AUTH = new ReadOnlyAuthenticationInfo("DOING_AUTH");
    public static final AuthenticationInfo FAIL_AUTH = new ReadOnlyAuthenticationInfo("FAIL_AUTH");
    public static final String AUTH_TYPE = "sling.authType";

    public AuthenticationInfo(String authType) {
        this(authType, null, null);
    }

    public AuthenticationInfo(String authType, String userId) {
        this(authType, userId, null);
    }

    public AuthenticationInfo(String authType, String userId, char[] password) {
        super.put(AUTH_TYPE, authType);
        this.putIfNotNull("user.name", userId);
        this.putIfNotNull("user.password", password);
    }

    public final void setAuthType(String authType) {
        this.putIfNotNull(AUTH_TYPE, authType);
    }

    public final String getAuthType() {
        return (String)this.get(AUTH_TYPE);
    }

    public final void setUser(String user) {
        this.putIfNotNull("user.name", user);
    }

    public final String getUser() {
        return (String)this.get("user.name");
    }

    public final void setPassword(char[] password) {
        this.putIfNotNull("user.password", password);
    }

    public final char[] getPassword() {
        return (char[])this.get("user.password");
    }

    @Override
    public Object put(String key, Object value) {
        if (AUTH_TYPE.equals(key) && !(value instanceof String)) {
            throw new IllegalArgumentException("sling.authType property must be a String");
        }
        if ("user.name".equals(key) && !(value instanceof String)) {
            throw new IllegalArgumentException("user.name property must be a String");
        }
        if ("user.password".equals(key) && !(value instanceof char[])) {
            throw new IllegalArgumentException("user.password property must be a char[]");
        }
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (AUTH_TYPE.equals(key)) {
            return null;
        }
        return super.remove(key);
    }

    @Override
    public void clear() {
        String authType = this.getAuthType();
        super.clear();
        this.setAuthType(authType);
    }

    private void putIfNotNull(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    private static final class ReadOnlyAuthenticationInfo
    extends AuthenticationInfo {
        private final transient Map<String, Object> unmodifiableMap;
        private final transient ThreadLocal<Boolean> stackGuard = new ThreadLocal();

        ReadOnlyAuthenticationInfo(String authType) {
            super(authType);
            this.unmodifiableMap = Collections.unmodifiableMap(this);
        }

        @Override
        public Object put(String key, Object value) {
            return this.unmodifiableMap.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            this.unmodifiableMap.putAll(m);
        }

        @Override
        public Object remove(Object key) {
            return this.unmodifiableMap.remove(key);
        }

        @Override
        public void clear() {
            this.unmodifiableMap.clear();
        }

        @Override
        public Set<String> keySet() {
            if (Boolean.TRUE.equals(this.stackGuard.get())) {
                return super.keySet();
            }
            try {
                this.stackGuard.set(Boolean.TRUE);
                Set<String> set = this.unmodifiableMap.keySet();
                return set;
            }
            finally {
                this.stackGuard.remove();
            }
        }

        @Override
        public Collection<Object> values() {
            if (Boolean.TRUE.equals(this.stackGuard.get())) {
                return super.values();
            }
            try {
                this.stackGuard.set(Boolean.TRUE);
                Collection<Object> collection = this.unmodifiableMap.values();
                return collection;
            }
            finally {
                this.stackGuard.remove();
            }
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            if (Boolean.TRUE.equals(this.stackGuard.get())) {
                return super.entrySet();
            }
            try {
                this.stackGuard.set(Boolean.TRUE);
                Set<Map.Entry<String, Object>> set = this.unmodifiableMap.entrySet();
                return set;
            }
            finally {
                this.stackGuard.remove();
            }
        }

        @Override
        public Object putIfAbsent(String key, Object value) {
            return this.unmodifiableMap.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.unmodifiableMap.remove(key, value);
        }

        @Override
        public boolean replace(String key, Object oldValue, Object newValue) {
            return this.unmodifiableMap.replace(key, oldValue, newValue);
        }

        @Override
        public Object replace(String key, Object value) {
            return this.unmodifiableMap.replace(key, value);
        }

        @Override
        public Object computeIfAbsent(String key, Function<? super String, ? extends Object> mappingFunction) {
            return this.unmodifiableMap.computeIfAbsent(key, mappingFunction);
        }

        @Override
        public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
            return this.unmodifiableMap.computeIfPresent(key, remappingFunction);
        }

        @Override
        public Object compute(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
            return this.unmodifiableMap.compute(key, remappingFunction);
        }

        @Override
        public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
            return this.unmodifiableMap.merge(key, value, remappingFunction);
        }

        @Override
        public void replaceAll(BiFunction<? super String, ? super Object, ? extends Object> function) {
            this.unmodifiableMap.replaceAll(function);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }
    }
}

