/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.impl.ConfigHolder;
import org.apache.sling.commons.scheduler.impl.InternalScheduleOptions;
import org.apache.sling.commons.scheduler.impl.NonParallelQuartzJobExecutor;
import org.apache.sling.commons.scheduler.impl.QuartzJobExecutor;
import org.apache.sling.commons.scheduler.impl.QuartzSchedulerConfiguration;
import org.apache.sling.commons.scheduler.impl.SchedulerProxy;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={QuartzScheduler.class}, property={"service.vendor=The Apache Software Foundation"}, immediate=true)
@Designate(ocd=QuartzSchedulerConfiguration.class)
public class QuartzScheduler
implements BundleListener {
    static final String DATA_MAP_OBJECT = "QuartzJobScheduler.Object";
    static final String DATA_MAP_PROVIDED_NAME = "QuartzJobScheduler.ProvidedJobName";
    static final String DATA_MAP_NAME = "QuartzJobScheduler.JobName";
    static final String DATA_MAP_CONFIGURATION = "QuartzJobScheduler.Configuration";
    static final String DATA_MAP_LOGGER = "QuartzJobScheduler.Logger";
    static final String DATA_MAP_RUN_ON = "QuartzJobScheduler.runOn";
    static final String DATA_MAP_BUNDLE_ID = "QuartzJobScheduler.bundleId";
    static final String DATA_MAP_SERVICE_ID = "QuartzJobScheduler.serviceId";
    static final String DATA_MAP_QUARTZ_SCHEDULER = "QuartzJobScheduler.QuartzScheduler";
    static final String DATA_MAP_THREAD_POOL_NAME = "QuartzJobScheduler.threadPoolName";
    static final String METRICS_NAME_RUNNING_JOBS = "commons.scheduler.running.jobs";
    static final String METRICS_NAME_TIMER = "commons.scheduler.timer";
    static final String METRICS_NAME_OLDEST_RUNNING_JOB_MILLIS = "commons.scheduler.oldest.running.job.millis";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ThreadPoolManager threadPoolManager;
    @Reference(target="(name=sling)")
    MetricRegistry metricsRegistry;
    ConfigHolder configHolder;
    private final Map<String, SchedulerProxy> schedulers = new HashMap<String, SchedulerProxy>();
    private volatile String defaultPoolName;
    private volatile String[] allowedPoolNames;
    private volatile boolean active;

    @Activate
    protected void activate(BundleContext ctx, QuartzSchedulerConfiguration configuration) {
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", Boolean.TRUE.toString());
        QuartzJobExecutor.FORCE_LEADER.set(configuration.scheduler_useleaderforsingle());
        this.defaultPoolName = configuration.poolName();
        this.allowedPoolNames = configuration.allowedPoolNames();
        if (this.allowedPoolNames == null) {
            this.allowedPoolNames = new String[0];
        }
        ctx.addBundleListener((BundleListener)this);
        this.configHolder = new ConfigHolder(configuration);
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(BundleContext ctx) {
        HashMap<String, SchedulerProxy> proxies;
        ctx.removeBundleListener((BundleListener)this);
        Map<String, SchedulerProxy> map = this.schedulers;
        synchronized (map) {
            this.active = false;
            proxies = new HashMap<String, SchedulerProxy>(this.schedulers);
            this.schedulers.clear();
        }
        for (SchedulerProxy proxy : proxies.values()) {
            proxy.dispose();
        }
    }

    private String getThreadPoolName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return this.defaultPoolName;
        }
        for (String n : this.allowedPoolNames) {
            if (!name.trim().equals(n)) continue;
            return n;
        }
        this.logger.warn("Scheduler job requested thread pool with name " + name + " but this thread pool is not in the list of allowed pools.");
        return this.defaultPoolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            Long bundleId = event.getBundle().getBundleId();
            Map<String, SchedulerProxy> map = this.schedulers;
            synchronized (map) {
                if (this.active) {
                    for (SchedulerProxy proxy : this.schedulers.values()) {
                        try {
                            List<String> groups = proxy.getScheduler().getJobGroupNames();
                            for (String group : groups) {
                                Set<JobKey> keys = proxy.getScheduler().getJobKeys(GroupMatcher.jobGroupEquals(group));
                                for (JobKey key : keys) {
                                    Long jobBundleId;
                                    JobDetail detail = proxy.getScheduler().getJobDetail(key);
                                    if (detail == null) continue;
                                    String jobName = (String)detail.getJobDataMap().get(DATA_MAP_NAME);
                                    Object job = detail.getJobDataMap().get(DATA_MAP_OBJECT);
                                    if (jobName == null || job == null || (jobBundleId = (Long)detail.getJobDataMap().get(DATA_MAP_BUNDLE_ID)) == null || !jobBundleId.equals(bundleId)) continue;
                                    proxy.getScheduler().deleteJob(key);
                                    this.logger.debug("Unscheduling job with name {}", (Object)jobName);
                                }
                            }
                        }
                        catch (SchedulerException schedulerException) {
                        }
                    }
                }
            }
        }
    }

    private JobDataMap initDataMap(Long bundleId, Long serviceId, String jobName, Object job, InternalScheduleOptions options) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_OBJECT, job);
        if (options.providedName != null) {
            jobDataMap.put(DATA_MAP_PROVIDED_NAME, options.providedName);
        }
        jobDataMap.put(DATA_MAP_NAME, jobName);
        jobDataMap.put(DATA_MAP_LOGGER, (Object)this.logger);
        jobDataMap.put(DATA_MAP_QUARTZ_SCHEDULER, (Object)this);
        jobDataMap.put(DATA_MAP_THREAD_POOL_NAME, this.getThreadPoolName(options.threadPoolName));
        if (bundleId != null) {
            jobDataMap.put(DATA_MAP_BUNDLE_ID, (Object)bundleId);
        }
        if (serviceId != null) {
            jobDataMap.put(DATA_MAP_SERVICE_ID, (Object)serviceId);
        }
        if (options.configuration != null) {
            jobDataMap.put(DATA_MAP_CONFIGURATION, (Object)options.configuration);
        }
        if (options.runOn != null) {
            if (options.runOn.length > 1 || !"LEADER".equals(options.runOn[0]) && !"SINGLE".equals(options.runOn[0])) {
                this.logger.warn("Job {} ({}) is scheduled to run on specific Sling Instances. This feature is deprecated. Please don't use it anymore.", (Object)jobName, job);
            }
            jobDataMap.put(DATA_MAP_RUN_ON, (Object)options.runOn);
        }
        return jobDataMap;
    }

    private JobDetail createJobDetail(String name, JobDataMap jobDataMap, boolean concurrent) {
        JobDetail detail = JobBuilder.newJob(concurrent ? QuartzJobExecutor.class : NonParallelQuartzJobExecutor.class).withIdentity(name).usingJobData(jobDataMap).build();
        return detail;
    }

    private void checkJob(Object job) throws IllegalArgumentException {
        if (!(job instanceof Runnable) && !(job instanceof Job)) {
            throw new IllegalArgumentException("Job object is neither an instance of " + Runnable.class.getName() + " nor " + Job.class.getName());
        }
    }

    public void addJob(Long bundleId, Long serviceId, String name, Object job, Map<String, Serializable> config, String schedulingExpression, boolean canRunConcurrently) throws SchedulerException {
        this.scheduleJob(bundleId, serviceId, job, this.EXPR(schedulingExpression).name(name).config(config).canRunConcurrently(canRunConcurrently));
    }

    public void addPeriodicJob(Long bundleId, Long serviceId, String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently) throws SchedulerException {
        this.addPeriodicJob(bundleId, serviceId, name, job, config, period, canRunConcurrently, false);
    }

    public void addPeriodicJob(Long bundleId, Long serviceId, String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently, boolean startImmediate) throws SchedulerException {
        this.scheduleJob(bundleId, serviceId, job, this.PERIODIC(period, startImmediate).name(name).config(config).canRunConcurrently(canRunConcurrently));
    }

    private ScheduleOptions PERIODIC(long period, boolean startImmediate) {
        if (period < 1L) {
            return new InternalScheduleOptions(new IllegalArgumentException("Period argument must be higher than 0"));
        }
        long ms = period * 1000L;
        TriggerBuilder<SimpleTrigger> builder = TriggerBuilder.newTrigger().startAt(new Date(System.currentTimeMillis() + ms)).withSchedule(SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds(ms));
        if (startImmediate) {
            return new InternalScheduleOptions(builder.startNow());
        }
        return new InternalScheduleOptions(builder.startAt(new Date(System.currentTimeMillis() + ms)));
    }

    public void fireJob(Long bundleId, Long serviceId, Object job, Map<String, Serializable> config) throws SchedulerException {
        this.scheduleJob(bundleId, serviceId, job, this.NOW().config(config));
    }

    public void fireJobAt(Long bundleId, Long serviceId, String name, Object job, Map<String, Serializable> config, Date date) throws SchedulerException {
        this.scheduleJob(bundleId, serviceId, job, this.AT(date).name(name).config(config));
    }

    public boolean fireJob(Long bundleId, Long serviceId, Object job, Map<String, Serializable> config, int times, long period) {
        return this.schedule(bundleId, serviceId, job, this.NOW(times, period).config(config));
    }

    public boolean fireJobAt(Long bundleId, Long serviceId, String name, Object job, Map<String, Serializable> config, Date date, int times, long period) {
        return this.schedule(bundleId, serviceId, job, this.AT(date, times, period).name(name).config(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(Long bundleId, String jobName) throws NoSuchElementException {
        Map<String, SchedulerProxy> map = this.schedulers;
        synchronized (map) {
            if (this.active) {
                for (SchedulerProxy proxy : this.schedulers.values()) {
                    try {
                        JobKey key = JobKey.jobKey(jobName);
                        JobDetail jobdetail = proxy.getScheduler().getJobDetail(key);
                        if (jobdetail == null) continue;
                        proxy.getScheduler().deleteJob(key);
                        this.logger.debug("Unscheduling job with name {}", (Object)jobName);
                        return;
                    }
                    catch (SchedulerException schedulerException) {
                    }
                }
            }
        }
        if (this.active) {
            throw new NoSuchElementException("No job found with name " + jobName);
        }
    }

    public ScheduleOptions NOW() {
        return new InternalScheduleOptions(TriggerBuilder.newTrigger().startNow());
    }

    public ScheduleOptions NOW(int times, long period) {
        if (times < 2 && times != -1) {
            return new InternalScheduleOptions(new IllegalArgumentException("Times argument must be higher than 1 or -1"));
        }
        if (period < 1L) {
            return new InternalScheduleOptions(new IllegalArgumentException("Period argument must be higher than 0"));
        }
        SimpleScheduleBuilder sb = times == -1 ? SimpleScheduleBuilder.simpleSchedule().repeatForever() : SimpleScheduleBuilder.simpleSchedule().withRepeatCount(times - 1);
        return new InternalScheduleOptions(TriggerBuilder.newTrigger().startNow().withSchedule(sb.withIntervalInMilliseconds(period * 1000L)));
    }

    public ScheduleOptions AT(Date date) {
        if (date == null) {
            return new InternalScheduleOptions(new IllegalArgumentException("Date can't be null"));
        }
        return new InternalScheduleOptions(TriggerBuilder.newTrigger().startAt(date));
    }

    public ScheduleOptions AT(Date date, int times, long period) {
        if (date == null) {
            return new InternalScheduleOptions(new IllegalArgumentException("Date can't be null"));
        }
        if (times < 2 && times != -1) {
            return new InternalScheduleOptions(new IllegalArgumentException("Times argument must be higher than 1 or -1"));
        }
        if (period < 1L) {
            return new InternalScheduleOptions(new IllegalArgumentException("Period argument must be higher than 0"));
        }
        SimpleScheduleBuilder sb = times == -1 ? SimpleScheduleBuilder.simpleSchedule().repeatForever() : SimpleScheduleBuilder.simpleSchedule().withRepeatCount(times - 1);
        return new InternalScheduleOptions(TriggerBuilder.newTrigger().startAt(date).withSchedule(sb.withIntervalInMilliseconds(period * 1000L)));
    }

    public ScheduleOptions EXPR(String expression) {
        if (expression == null) {
            return new InternalScheduleOptions(new IllegalArgumentException("Expression can't be null"));
        }
        if (!CronExpression.isValidExpression(expression)) {
            return new InternalScheduleOptions(new IllegalArgumentException("Expressionis invalid : " + expression));
        }
        return new InternalScheduleOptions(TriggerBuilder.newTrigger().withSchedule(CronScheduleBuilder.cronSchedule(expression)));
    }

    public boolean schedule(Long bundleId, Long serviceId, Object job, ScheduleOptions options) {
        try {
            this.scheduleJob(bundleId, serviceId, job, options);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        catch (SchedulerException se) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unschedule(Long bundleId, String jobName) {
        if (jobName != null) {
            Map<String, SchedulerProxy> map = this.schedulers;
            synchronized (map) {
                for (SchedulerProxy proxy : this.schedulers.values()) {
                    try {
                        JobKey key = JobKey.jobKey(jobName);
                        JobDetail jobdetail = proxy.getScheduler().getJobDetail(key);
                        if (jobdetail == null) continue;
                        proxy.getScheduler().deleteJob(key);
                        this.logger.debug("Unscheduling job with name {}", (Object)jobName);
                        return true;
                    }
                    catch (SchedulerException schedulerException) {
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(Long bundleId, Long serviceId, Object job, ScheduleOptions options) throws SchedulerException {
        this.checkJob(job);
        if (!(options instanceof InternalScheduleOptions)) {
            throw new IllegalArgumentException("Options has not been created via schedule or is null.");
        }
        InternalScheduleOptions opts = (InternalScheduleOptions)options;
        if (opts.argumentException != null) {
            throw opts.argumentException;
        }
        Map<String, SchedulerProxy> map = this.schedulers;
        synchronized (map) {
            String name;
            String poolName = this.getThreadPoolName(opts.threadPoolName);
            SchedulerProxy proxy = null;
            Map<String, SchedulerProxy> map2 = this.schedulers;
            synchronized (map2) {
                if (this.active && (proxy = this.schedulers.get(poolName)) == null) {
                    proxy = new SchedulerProxy(this.threadPoolManager, poolName);
                    this.schedulers.put(poolName, proxy);
                }
            }
            if (proxy == null) {
                throw new IllegalStateException("Scheduler is not available anymore.");
            }
            if (opts.name != null) {
                this.unschedule(bundleId, opts.name);
                name = opts.name;
            } else {
                name = job.getClass().getName() + ':' + UUID.randomUUID();
            }
            Trigger trigger = opts.trigger.withIdentity(name).build();
            JobDataMap jobDataMap = this.initDataMap(bundleId, serviceId, name, job, opts);
            JobDetail detail = this.createJobDetail(name, jobDataMap, opts.canRunConcurrently);
            this.logger.debug("Scheduling job {} with name {} and trigger {}", new Object[]{job, name, trigger});
            proxy.getScheduler().scheduleJob(detail, trigger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, SchedulerProxy> getSchedulers() {
        Map<String, SchedulerProxy> map = this.schedulers;
        synchronized (map) {
            return new HashMap<String, SchedulerProxy>(this.schedulers);
        }
    }
}

