/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.sling.commons.scheduler.impl.QuartzJobExecutor;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={TopologyEventListener.class}, property={"service.vendor=The Apache Software Foundation"})
public class TopologyHandler
implements TopologyEventListener {
    @Activate
    public void activate() {
        QuartzJobExecutor.DISCOVERY_AVAILABLE.set(true);
    }

    @Deactivate
    public void deactivate() {
        QuartzJobExecutor.DISCOVERY_AVAILABLE.set(false);
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (event.getType() == TopologyEvent.Type.TOPOLOGY_INIT || event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED) {
            ArrayList<String> ids = new ArrayList<String>();
            for (InstanceDescription desc : event.getNewView().getInstances()) {
                ids.add(desc.getSlingId());
            }
            Collections.sort(ids);
            QuartzJobExecutor.IS_LEADER.set(event.getNewView().getLocalInstance().isLeader());
            QuartzJobExecutor.DISCOVERY_INFO_AVAILABLE.set(true);
            QuartzJobExecutor.SLING_IDS.set(ids.toArray(new String[ids.size()]));
        } else if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
            QuartzJobExecutor.IS_LEADER.set(false);
            QuartzJobExecutor.DISCOVERY_INFO_AVAILABLE.set(false);
            QuartzJobExecutor.SLING_IDS.set(null);
        }
    }
}

