/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.console;

import java.io.PrintWriter;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WebConsoleConfigPrinter.class}, property={"felix.webconsole.label=slingfilter", "felix.webconsole.title=Sling Servlet Filter", "felix.webconsole.configprinter.modes=always"})
public class WebConsoleConfigPrinter {
    private final ServletFilterManager filterManager;

    @Activate
    public WebConsoleConfigPrinter(@Reference ServletFilterManager filterManager) {
        this.filterManager = filterManager;
    }

    private void printFilterChain(PrintWriter pw, FilterHandle[] entries) {
        for (FilterHandle entry : entries) {
            pw.printf("%d : %s (id: %d, property: %s); called: %d; time: %dms; time/call: %d\u00b5s%n", entry.getOrder(), entry.getFilter().getClass(), entry.getFilterId(), entry.getOrderSource(), entry.getCalls(), entry.getTime(), entry.getTimePerCall());
        }
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Current Apache Sling Servlet Filter Configuration");
        for (ServletFilterManager.FilterChainType type : ServletFilterManager.FilterChainType.values()) {
            pw.println();
            pw.println(String.valueOf((Object)type) + " Filters:");
            this.printFilterChain(pw, this.filterManager.getFilterChain(type).getFilters());
        }
    }
}

