/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.servlets.JakartaErrorHandler;
import org.apache.sling.engine.impl.SlingJakartaHttpServletResponseImpl;
import org.apache.sling.engine.impl.filter.AbstractSlingFilterChain;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.request.DispatchingInfo;

public class ErrorFilterChain
extends AbstractSlingFilterChain {
    private static final String RECURSION_ATTRIBUTE = ErrorFilterChain.class.getName() + ".RECURSION";
    private static final String PREFIX_COMMITTED = "handleError: Response already committed; cannot send error ";
    private static final String PREFIX_RECURSION = "handleError: Recursive invocation. Not further handling status ";
    private final int status;
    private final String message;
    private final JakartaErrorHandler errorHandler;
    private final Throwable throwable;
    private final Mode mode;
    private boolean firstCall = true;

    public ErrorFilterChain(FilterHandle[] filters, JakartaErrorHandler errorHandler, int status, String message) {
        super(filters);
        this.mode = Mode.STATUS;
        this.status = status;
        this.message = message;
        this.errorHandler = errorHandler;
        this.throwable = null;
    }

    public ErrorFilterChain(FilterHandle[] filters, JakartaErrorHandler errorHandler, Throwable t) {
        super(filters);
        this.mode = Mode.THROWABLE;
        this.status = 0;
        this.message = null;
        this.throwable = t;
        this.errorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.firstCall) {
            if (request.getAttribute(RECURSION_ATTRIBUTE) != null) {
                if (this.mode == Mode.STATUS) {
                    if (this.message == null) {
                        LOG.warn(PREFIX_RECURSION.concat(String.valueOf(this.status)));
                    } else {
                        LOG.warn(PREFIX_RECURSION.concat(String.valueOf(this.status)).concat(" : ").concat(this.message));
                    }
                } else if (this.throwable.getMessage() != null) {
                    LOG.warn(PREFIX_RECURSION.concat(this.throwable.getMessage()), this.throwable);
                } else {
                    LOG.warn(PREFIX_RECURSION.concat(this.throwable.getClass().getName()), this.throwable);
                }
                return;
            }
            request.setAttribute(RECURSION_ATTRIBUTE, (Object)"true");
            this.firstCall = false;
            if (response.isCommitted()) {
                if (this.mode == Mode.STATUS) {
                    if (this.message == null) {
                        LOG.warn(PREFIX_COMMITTED.concat(String.valueOf(this.status)));
                    } else {
                        LOG.warn(PREFIX_COMMITTED.concat(String.valueOf(this.status)).concat(" : ").concat(this.message));
                    }
                } else if (this.throwable.getMessage() != null) {
                    LOG.warn(PREFIX_COMMITTED.concat(this.throwable.getMessage()), this.throwable);
                } else {
                    LOG.warn(PREFIX_COMMITTED.concat(this.throwable.getClass().getName()), this.throwable);
                }
                return;
            }
            if (response instanceof SlingJakartaHttpServletResponseImpl) {
                SlingJakartaHttpServletResponseImpl slingResponse = (SlingJakartaHttpServletResponseImpl)response;
                DispatchingInfo originalInfo = null;
                try {
                    originalInfo = slingResponse.getRequestData().getDispatchingInfo();
                    DispatchingInfo dispatchInfo = new DispatchingInfo(DispatcherType.ERROR);
                    slingResponse.getRequestData().setDispatchingInfo(dispatchInfo);
                    response.reset();
                    super.doFilter(request, response);
                }
                finally {
                    slingResponse.getRequestData().setDispatchingInfo(originalInfo);
                }
            } else {
                response.reset();
                super.doFilter(request, response);
            }
        } else {
            super.doFilter(request, response);
        }
    }

    @Override
    protected void render(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException, ServletException {
        if (this.mode == Mode.STATUS) {
            this.errorHandler.handleError(this.status, this.message, request, response);
        } else {
            this.errorHandler.handleError(this.throwable, request, response);
        }
    }

    private static enum Mode {
        THROWABLE,
        STATUS;

    }
}

