/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ops4j.peaberry.AttributeFilter;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceWatcher;
import org.ops4j.peaberry.cache.AbstractServiceListener;
import org.ops4j.peaberry.cache.CachingServiceRegistry;
import org.ops4j.peaberry.cache.FilteredIterableService;
import org.ops4j.peaberry.cache.FilteredServiceWatcher;
import org.ops4j.peaberry.util.Filters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceRegistry
implements CachingServiceRegistry {
    private final boolean useNativeFilter;
    private final ConcurrentMap<String, AbstractServiceListener<?>> listenerMap = new ConcurrentHashMap(16, 0.75f, 2);

    protected AbstractServiceRegistry(boolean useNativeFilter) {
        this.useNativeFilter = useNativeFilter;
    }

    @Override
    public final <T> Iterable<Import<T>> lookup(Class<T> clazz, AttributeFilter filter) {
        AttributeFilter[] filterRef = new AttributeFilter[]{filter};
        String ldapFilter = this.getLdapFilter(clazz, filterRef);
        return new FilteredIterableService(this.registerListener(ldapFilter), filterRef[0]);
    }

    @Override
    public final <T> void watch(Class<T> clazz, AttributeFilter filter, ServiceWatcher<? super T> watcher) {
        AttributeFilter[] filterRef = new AttributeFilter[]{filter};
        String ldapFilter = this.getLdapFilter(clazz, filterRef);
        if (null == filterRef[0]) {
            this.registerListener(ldapFilter).addWatcher(watcher);
        } else {
            this.registerListener(ldapFilter).addWatcher(new FilteredServiceWatcher<T>(filter, watcher));
        }
    }

    @Override
    public final void flush(int targetGeneration) {
        for (AbstractServiceListener i : this.listenerMap.values()) {
            i.flush(targetGeneration);
        }
    }

    private AbstractServiceListener<?> registerListener(String ldapFilter) {
        AbstractServiceListener newListener;
        String key = null == ldapFilter ? "" : ldapFilter;
        AbstractServiceListener listener = (AbstractServiceListener)this.listenerMap.get(key);
        if (null == listener && null == (listener = this.listenerMap.putIfAbsent(key, newListener = this.createListener(ldapFilter)))) {
            newListener.start();
            return newListener;
        }
        return listener;
    }

    private String getLdapFilter(Class<?> clazz, AttributeFilter[] filterRef) {
        String clazzFilter = null != clazz && Object.class != clazz ? "(objectClass=" + clazz.getName() + ')' : null;
        if (this.useNativeFilter && null != filterRef[0]) {
            try {
                String ldapFilter = Filters.ldap(filterRef[0].toString()).toString();
                filterRef[0] = null;
                return null == clazzFilter ? ldapFilter : "(&" + clazzFilter + ldapFilter + ')';
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return clazzFilter;
    }

    protected abstract <T> AbstractServiceListener<T> createListener(String var1);
}

