/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.caconfig;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.caconfig.annotation.Configuration;
import org.apache.sling.testing.mock.caconfig.ConfigurationMetadataUtil;
import org.apache.sling.testing.mock.caconfig.ConfigurationPersistHelper;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class MockContextAwareConfig {
    private MockContextAwareConfig() {
    }

    public static void registerAnnotationClasses(@NotNull SlingContextImpl context, String ... classNames) {
        ConfigurationMetadataUtil.registerAnnotationClasses(context.bundleContext(), classNames);
    }

    public static void registerAnnotationClasses(@NotNull SlingContextImpl context, Class ... classes) {
        ConfigurationMetadataUtil.registerAnnotationClasses(context.bundleContext(), classes);
    }

    public static void registerAnnotationPackages(@NotNull SlingContextImpl context, String ... packageNames) {
        Collection<Class> classes = ConfigurationMetadataUtil.getConfigurationClassesForPackages(StringUtils.join((Object[])packageNames, (String)","));
        MockContextAwareConfig.registerAnnotationClasses(context, classes.toArray(new Class[classes.size()]));
    }

    public static void writeConfiguration(@NotNull SlingContextImpl context, @NotNull String contextPath, @NotNull Class<?> configClass, @NotNull Map<String, Object> values) {
        MockContextAwareConfig.writeConfiguration(context, contextPath, MockContextAwareConfig.getConfigurationName(configClass), values);
    }

    public static void writeConfiguration(@NotNull SlingContextImpl context, @NotNull String contextPath, @NotNull String configName, @NotNull Map<String, Object> values) {
        ConfigurationPersistHelper helper = new ConfigurationPersistHelper(context, contextPath);
        helper.writeConfiguration(configName, values);
    }

    public static void writeConfiguration(@NotNull SlingContextImpl context, @NotNull String contextPath, Class<?> configClass, Object ... values) {
        MockContextAwareConfig.writeConfiguration(context, contextPath, MockContextAwareConfig.getConfigurationName(configClass), values);
    }

    public static void writeConfiguration(@NotNull SlingContextImpl context, @NotNull String contextPath, @NotNull String configName, Object ... values) {
        MockContextAwareConfig.writeConfiguration(context, contextPath, configName, (Map<String, Object>)MapUtil.toMap((Object[])values));
    }

    public static void writeConfigurationCollection(@NotNull SlingContextImpl context, @NotNull String contextPath, @NotNull Class<?> configClass, @NotNull @NotNull Collection<@NotNull Map<String, Object>> values) {
        MockContextAwareConfig.writeConfigurationCollection(context, contextPath, MockContextAwareConfig.getConfigurationName(configClass), values);
    }

    public static void writeConfigurationCollection(@NotNull SlingContextImpl context, @NotNull String contextPath, @NotNull String configName, @NotNull @NotNull Collection<@NotNull Map<String, Object>> values) {
        ConfigurationPersistHelper helper = new ConfigurationPersistHelper(context, contextPath);
        helper.writeConfigurationCollection(configName, values);
    }

    @NotNull
    private static String getConfigurationName(Class<?> configClass) {
        Configuration annotation = configClass.getAnnotation(Configuration.class);
        if (annotation != null && StringUtils.isNotBlank((CharSequence)annotation.name())) {
            return annotation.name();
        }
        return configClass.getName();
    }
}

