/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.blob.datastore.InMemoryDataRecord;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreBlob
implements Blob {
    private static final Logger LOG = LoggerFactory.getLogger(BlobStoreBlob.class);
    private final BlobStore blobStore;
    private final String blobId;

    public BlobStoreBlob(BlobStore blobStore, String blobId) {
        this.blobStore = blobStore;
        this.blobId = blobId;
    }

    @Override
    @NotNull
    public InputStream getNewStream() {
        try {
            return this.blobStore.getInputStream(this.blobId);
        }
        catch (IOException e) {
            LOG.warn("Error occurred while obtaining InputStream for blobId [" + this.blobId + "]", (Throwable)e);
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    throw new IOException(e);
                }
            };
        }
    }

    @Override
    public long length() {
        try {
            return this.blobStore.getBlobLength(this.blobId);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid blob id: " + this.blobId, e);
        }
    }

    @Override
    @Nullable
    public String getReference() {
        return this.blobStore.getReference(this.blobId);
    }

    @Override
    public String getContentIdentity() {
        return this.blobId;
    }

    @Override
    public boolean isInlined() {
        return InMemoryDataRecord.isInstance(this.blobId);
    }

    public String getBlobId() {
        return this.blobId;
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    public String toString() {
        return this.blobId;
    }

    public int hashCode() {
        return this.blobId.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BlobStoreBlob) {
            BlobStoreBlob b = (BlobStoreBlob)other;
            return b.blobId.equals(this.blobId);
        }
        return false;
    }
}

