/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.BeanFactory;
import org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanHelper {
    private static final Map<String, BeanFactory> BEAN_FACTORIES = Collections.synchronizedMap(new HashMap());
    private static BeanFactory defaultBeanFactory = DefaultBeanFactory.INSTANCE;

    private BeanHelper() {
    }

    public static void registerBeanFactory(String name, BeanFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException("Name for bean factory must not be null!");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Bean factory must not be null!");
        }
        BEAN_FACTORIES.put(name, factory);
    }

    public static BeanFactory deregisterBeanFactory(String name) {
        return BEAN_FACTORIES.remove(name);
    }

    public static Set<String> registeredFactoryNames() {
        return BEAN_FACTORIES.keySet();
    }

    public static BeanFactory getDefaultBeanFactory() {
        return defaultBeanFactory;
    }

    public static void setDefaultBeanFactory(BeanFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Default bean factory must not be null!");
        }
        defaultBeanFactory = factory;
    }

    public static void initBean(Object bean, BeanDeclaration data) throws ConfigurationRuntimeException {
        block6: {
            Map<String, Object> nestedBeans;
            block7: {
                BeanHelper.initBeanProperties(bean, data);
                nestedBeans = data.getNestedBeanDeclarations();
                if (nestedBeans == null) break block6;
                if (!(bean instanceof Collection)) break block7;
                Collection coll = (Collection)bean;
                if (nestedBeans.size() != 1) break block6;
                Map.Entry<String, Object> e = nestedBeans.entrySet().iterator().next();
                String propName = e.getKey();
                Class<?> defaultClass = BeanHelper.getDefaultClass(bean, propName);
                if (e.getValue() instanceof List) {
                    List decls = (List)e.getValue();
                    for (BeanDeclaration decl : decls) {
                        coll.add(BeanHelper.createBean(decl, defaultClass));
                    }
                } else {
                    BeanDeclaration decl = (BeanDeclaration)e.getValue();
                    coll.add(BeanHelper.createBean(decl, defaultClass));
                }
                break block6;
            }
            for (Map.Entry<String, Object> e : nestedBeans.entrySet()) {
                String propName = e.getKey();
                Class<?> defaultClass = BeanHelper.getDefaultClass(bean, propName);
                Object prop = e.getValue();
                if (prop instanceof Collection) {
                    Collection<Object> beanCollection = BeanHelper.createPropertyCollection(propName, defaultClass);
                    for (Object elemDef : (Collection)prop) {
                        beanCollection.add(BeanHelper.createBean((BeanDeclaration)elemDef));
                    }
                    BeanHelper.initProperty(bean, propName, beanCollection);
                    continue;
                }
                BeanHelper.initProperty(bean, propName, BeanHelper.createBean((BeanDeclaration)e.getValue(), defaultClass));
            }
        }
    }

    public static void initBeanProperties(Object bean, BeanDeclaration data) throws ConfigurationRuntimeException {
        Map<String, Object> properties = data.getBeanProperties();
        if (properties != null) {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propName = e.getKey();
                BeanHelper.initProperty(bean, propName, e.getValue());
            }
        }
    }

    private static Class<?> getDefaultClass(Object bean, String propName) {
        try {
            PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor(bean, propName);
            if (desc == null) {
                return null;
            }
            return desc.getPropertyType();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void initProperty(Object bean, String propName, Object value) throws ConfigurationRuntimeException {
        if (!PropertyUtils.isWriteable(bean, propName)) {
            throw new ConfigurationRuntimeException("Property " + propName + " cannot be set on " + bean.getClass().getName());
        }
        try {
            BeanUtils.setProperty(bean, propName, value);
        }
        catch (IllegalAccessException iaex) {
            throw new ConfigurationRuntimeException(iaex);
        }
        catch (InvocationTargetException itex) {
            throw new ConfigurationRuntimeException(itex);
        }
    }

    private static Collection<Object> createPropertyCollection(String propName, Class<?> propertyClass) {
        AbstractCollection beanCollection = null;
        if (List.class.isAssignableFrom(propertyClass)) {
            beanCollection = new ArrayList<Object>();
        } else if (Set.class.isAssignableFrom(propertyClass)) {
            beanCollection = new TreeSet();
        } else {
            throw new UnsupportedOperationException("Unable to handle collection of type : " + propertyClass.getName() + " for property " + propName);
        }
        return beanCollection;
    }

    public static void setProperty(Object bean, String propName, Object value) {
        if (PropertyUtils.isWriteable(bean, propName)) {
            BeanHelper.initProperty(bean, propName, value);
        }
    }

    public static Object createBean(BeanDeclaration data, Class<?> defaultClass, Object param) throws ConfigurationRuntimeException {
        if (data == null) {
            throw new IllegalArgumentException("Bean declaration must not be null!");
        }
        BeanFactory factory = BeanHelper.fetchBeanFactory(data);
        try {
            return factory.createBean(BeanHelper.fetchBeanClass(data, defaultClass, factory), data, param);
        }
        catch (Exception ex) {
            throw new ConfigurationRuntimeException(ex);
        }
    }

    public static Object createBean(BeanDeclaration data, Class<?> defaultClass) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(data, defaultClass, null);
    }

    public static Object createBean(BeanDeclaration data) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(data, null);
    }

    static Class<?> loadClass(String name, Class<?> callingClass) throws ClassNotFoundException {
        return ClassUtils.getClass((String)name);
    }

    private static Class<?> fetchBeanClass(BeanDeclaration data, Class<?> defaultClass, BeanFactory factory) throws ConfigurationRuntimeException {
        String clsName = data.getBeanClassName();
        if (clsName != null) {
            try {
                return BeanHelper.loadClass(clsName, factory.getClass());
            }
            catch (ClassNotFoundException cex) {
                throw new ConfigurationRuntimeException(cex);
            }
        }
        if (defaultClass != null) {
            return defaultClass;
        }
        Class<?> clazz = factory.getDefaultBeanClass();
        if (clazz == null) {
            throw new ConfigurationRuntimeException("Bean class is not specified!");
        }
        return clazz;
    }

    private static BeanFactory fetchBeanFactory(BeanDeclaration data) throws ConfigurationRuntimeException {
        String factoryName = data.getBeanFactoryName();
        if (factoryName != null) {
            BeanFactory factory = BEAN_FACTORIES.get(factoryName);
            if (factory == null) {
                throw new ConfigurationRuntimeException("Unknown bean factory: " + factoryName);
            }
            return factory;
        }
        return BeanHelper.getDefaultBeanFactory();
    }
}

