/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rel2sql;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;

public class RelToSqlConverter
extends SqlImplementor
implements ReflectiveVisitor {
    private static final SqlRowOperator ANONYMOUS_ROW = new SqlRowOperator(" ");
    private final ReflectUtil.MethodDispatcher<SqlImplementor.Result> dispatcher = ReflectUtil.createMethodDispatcher(SqlImplementor.Result.class, this, "visit", RelNode.class, new Class[0]);

    public RelToSqlConverter(SqlDialect dialect) {
        super(dialect);
    }

    protected SqlImplementor.Result dispatch(RelNode e) {
        return this.dispatcher.invoke(e);
    }

    @Override
    public SqlImplementor.Result visitChild(int i, RelNode e) {
        return this.dispatch(e);
    }

    public SqlImplementor.Result visit(RelNode e) {
        throw new AssertionError((Object)("Need to implement " + e.getClass().getName()));
    }

    public SqlImplementor.Result visit(Join e) {
        SqlImplementor.Result leftResult = this.visitChild(0, e.getLeft());
        SqlImplementor.Result rightResult = this.visitChild(1, e.getRight());
        SqlImplementor.Context leftContext = leftResult.qualifiedContext();
        SqlImplementor.Context rightContext = rightResult.qualifiedContext();
        SqlNode sqlCondition = RelToSqlConverter.convertConditionToSqlNode(e.getCondition(), leftContext, rightContext, e.getLeft().getRowType().getFieldCount());
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), RelToSqlConverter.joinType(e.getJoinType()).symbol(POS), rightResult.asFrom(), JoinConditionType.ON.symbol(POS), sqlCondition);
        return this.result(join, leftResult, rightResult);
    }

    public SqlImplementor.Result visit(Filter e) {
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        SqlImplementor.Builder builder = x.builder(e, SqlImplementor.Clause.WHERE);
        builder.setWhere(builder.context.toSql(null, e.getCondition()));
        return builder.result();
    }

    public SqlImplementor.Result visit(Project e) {
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        if (RelToSqlConverter.isStar(e.getChildExps(), e.getInput().getRowType())) {
            return x;
        }
        SqlImplementor.Builder builder = x.builder(e, SqlImplementor.Clause.SELECT);
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        for (RexNode ref : e.getChildExps()) {
            SqlNode sqlExpr = builder.context.toSql(null, ref);
            this.addSelect(selectList, sqlExpr, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        return builder.result();
    }

    public SqlImplementor.Result visit(Aggregate e) {
        SqlImplementor.Builder builder;
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        if (e.getInput() instanceof Project) {
            builder = x.builder(e, new SqlImplementor.Clause[0]);
            builder.clauses.add(SqlImplementor.Clause.GROUP_BY);
        } else {
            builder = x.builder(e, SqlImplementor.Clause.GROUP_BY);
        }
        Expressions.FluentList groupByList = Expressions.list();
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        Iterator<Object> i$ = e.getGroupSet().iterator();
        while (i$.hasNext()) {
            int group = i$.next();
            SqlNode field = builder.context.field(group);
            this.addSelect(selectList, field, e.getRowType());
            groupByList.add(field);
        }
        for (AggregateCall aggCall : e.getAggCallList()) {
            SqlNode aggCallSqlNode = builder.context.toSql(aggCall);
            if (aggCall.getAggregation() instanceof SqlSingleValueAggFunction) {
                aggCallSqlNode = RelToSqlConverter.rewriteSingleValueExpr(aggCallSqlNode, this.dialect);
            }
            this.addSelect(selectList, aggCallSqlNode, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        if (!groupByList.isEmpty() || e.getAggCallList().isEmpty()) {
            builder.setGroupBy(new SqlNodeList((Collection<? extends SqlNode>)groupByList, POS));
        }
        return builder.result();
    }

    public SqlImplementor.Result visit(TableScan e) {
        SqlIdentifier identifier = new SqlIdentifier(e.getTable().getQualifiedName(), SqlParserPos.ZERO);
        return this.result(identifier, (Collection<SqlImplementor.Clause>)ImmutableList.of((Object)((Object)SqlImplementor.Clause.FROM)), e, null);
    }

    public SqlImplementor.Result visit(Union e) {
        return this.setOpToSql(e.all ? SqlStdOperatorTable.UNION_ALL : SqlStdOperatorTable.UNION, e);
    }

    public SqlImplementor.Result visit(Intersect e) {
        return this.setOpToSql(e.all ? SqlStdOperatorTable.INTERSECT_ALL : SqlStdOperatorTable.INTERSECT, e);
    }

    public SqlImplementor.Result visit(Minus e) {
        return this.setOpToSql(e.all ? SqlStdOperatorTable.EXCEPT_ALL : SqlStdOperatorTable.EXCEPT, e);
    }

    public SqlImplementor.Result visit(Calc e) {
        SqlImplementor.Builder builder;
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        RexProgram program = e.getProgram();
        SqlImplementor.Builder builder2 = builder = program.getCondition() != null ? x.builder(e, SqlImplementor.Clause.WHERE) : x.builder(e, new SqlImplementor.Clause[0]);
        if (!RelToSqlConverter.isStar(program)) {
            ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
            for (RexLocalRef ref : program.getProjectList()) {
                SqlNode sqlExpr = builder.context.toSql(program, ref);
                this.addSelect(selectList, sqlExpr, e.getRowType());
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
        }
        if (program.getCondition() != null) {
            builder.setWhere(builder.context.toSql(program, program.getCondition()));
        }
        return builder.result();
    }

    public SqlImplementor.Result visit(Values e) {
        ImmutableList clauses = ImmutableList.of((Object)((Object)SqlImplementor.Clause.SELECT));
        ImmutableMap pairs = ImmutableMap.of();
        SqlImplementor.Context context = this.aliasContext((Map<String, RelDataType>)pairs, false);
        SqlNodeList selects = new SqlNodeList(POS);
        for (List tuple : e.getTuples()) {
            selects.add(ANONYMOUS_ROW.createCall(this.exprList(context, tuple)));
        }
        SqlCall query = SqlStdOperatorTable.VALUES.createCall(selects);
        return this.result(query, (Collection<SqlImplementor.Clause>)clauses, e, null);
    }

    public SqlImplementor.Result visit(Sort e) {
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        SqlImplementor.Builder builder = x.builder(e, SqlImplementor.Clause.ORDER_BY);
        Expressions.FluentList orderByList = Expressions.list();
        for (RelFieldCollation field : e.getCollation().getFieldCollations()) {
            builder.addOrderItem((List<SqlNode>)orderByList, field);
        }
        if (!orderByList.isEmpty()) {
            builder.setOrderBy(new SqlNodeList((Collection<? extends SqlNode>)orderByList, POS));
            x = builder.result();
        }
        if (e.fetch != null) {
            builder = x.builder(e, SqlImplementor.Clause.FETCH);
            builder.setFetch(builder.context.toSql(null, e.fetch));
            x = builder.result();
        }
        if (e.offset != null) {
            builder = x.builder(e, SqlImplementor.Clause.OFFSET);
            builder.setOffset(builder.context.toSql(null, e.offset));
            x = builder.result();
        }
        return x;
    }

    public SqlImplementor.Result visit(TableModify modify) {
        ImmutableMap pairs = ImmutableMap.of();
        SqlImplementor.Context context = this.aliasContext((Map<String, RelDataType>)pairs, false);
        SqlIdentifier sqlTargetTable = new SqlIdentifier(modify.getTable().getQualifiedName(), POS);
        switch (modify.getOperation()) {
            case INSERT: {
                SqlNode sqlSource = this.visitChild(0, modify.getInput()).asQueryOrValues();
                SqlInsert sqlInsert = new SqlInsert(POS, SqlNodeList.EMPTY, sqlTargetTable, sqlSource, this.identifierList(modify.getInput().getRowType().getFieldNames()));
                return this.result(sqlInsert, (Collection<SqlImplementor.Clause>)ImmutableList.of(), modify, null);
            }
            case UPDATE: {
                SqlImplementor.Result input = this.visitChild(0, modify.getInput());
                SqlUpdate sqlUpdate = new SqlUpdate(POS, sqlTargetTable, this.identifierList(modify.getUpdateColumnList()), this.exprList(context, modify.getSourceExpressionList()), ((SqlSelect)input.node).getWhere(), input.asSelect(), null);
                return this.result(sqlUpdate, (Collection<SqlImplementor.Clause>)input.clauses, modify, null);
            }
            case DELETE: {
                SqlImplementor.Result input = this.visitChild(0, modify.getInput());
                SqlDelete sqlDelete = new SqlDelete(POS, sqlTargetTable, input.asSelect().getWhere(), input.asSelect(), null);
                return this.result(sqlDelete, (Collection<SqlImplementor.Clause>)input.clauses, modify, null);
            }
        }
        throw new AssertionError((Object)("not implemented: " + modify));
    }

    private SqlNodeList exprList(final SqlImplementor.Context context, List<? extends RexNode> exprs) {
        return new SqlNodeList(Lists.transform(exprs, (Function)new Function<RexNode, SqlNode>(){

            public SqlNode apply(RexNode e) {
                return context.toSql(null, e);
            }
        }), POS);
    }

    private SqlNodeList identifierList(List<String> names) {
        return new SqlNodeList(Lists.transform(names, (Function)new Function<String, SqlNode>(){

            public SqlNode apply(String name) {
                return new SqlIdentifier(name, SqlImplementor.POS);
            }
        }), POS);
    }

    @Override
    public void addSelect(List<SqlNode> selectList, SqlNode node, RelDataType rowType) {
        String name = rowType.getFieldNames().get(selectList.size());
        String alias = SqlValidatorUtil.getAlias(node, -1);
        if (name.toLowerCase().startsWith("expr$")) {
            this.ordinalMap.put(name.toLowerCase(), node);
        } else if (alias == null || !alias.equals(name)) {
            node = SqlStdOperatorTable.AS.createCall(POS, node, new SqlIdentifier(name, POS));
        }
        selectList.add(node);
    }
}

