/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.ZooKeeperRegistry;

@InterfaceAudience.Private
class RegistryFactory {
    RegistryFactory() {
    }

    static Registry getRegistry(Connection connection) throws IOException {
        String registryClass = connection.getConfiguration().get("hbase.client.registry.impl", ZooKeeperRegistry.class.getName());
        Registry registry = null;
        try {
            registry = (Registry)Class.forName(registryClass).newInstance();
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        registry.init(connection);
        return registry;
    }
}

