/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CheckpointSubsumeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointSubsumeHelper.class);

    CheckpointSubsumeHelper() {
    }

    public static void subsume(Deque<CompletedCheckpoint> checkpoints, int numRetain, SubsumeAction subsumeAction) throws Exception {
        if (checkpoints.isEmpty() || checkpoints.size() <= numRetain) {
            return;
        }
        CompletedCheckpoint latest = checkpoints.peekLast();
        Optional<CompletedCheckpoint> latestNotSavepoint = CheckpointSubsumeHelper.getLatestNotSavepoint(checkpoints);
        Iterator<CompletedCheckpoint> iterator = checkpoints.iterator();
        while (checkpoints.size() > numRetain && iterator.hasNext()) {
            CompletedCheckpoint next = iterator.next();
            if (!CheckpointSubsumeHelper.canSubsume(next, latest, latestNotSavepoint)) continue;
            iterator.remove();
            try {
                subsumeAction.subsume(next);
            }
            catch (Exception e) {
                LOG.warn("Fail to subsume the old checkpoint.", (Throwable)e);
            }
        }
    }

    private static Optional<CompletedCheckpoint> getLatestNotSavepoint(Deque<CompletedCheckpoint> completed) {
        Iterator<CompletedCheckpoint> descendingIterator = completed.descendingIterator();
        while (descendingIterator.hasNext()) {
            CompletedCheckpoint next = descendingIterator.next();
            if (next.getProperties().isSavepoint()) continue;
            return Optional.of(next);
        }
        return Optional.empty();
    }

    private static boolean canSubsume(CompletedCheckpoint next, CompletedCheckpoint latest, Optional<CompletedCheckpoint> latestNonSavepoint) {
        if (next == latest) {
            return false;
        }
        if (next.getProperties().isSavepoint()) {
            return true;
        }
        if (latest.getProperties().isSynchronous()) {
            return true;
        }
        return latestNonSavepoint.filter(checkpoint -> checkpoint != next).isPresent();
    }

    @FunctionalInterface
    static interface SubsumeAction {
        public void subsume(CompletedCheckpoint var1) throws Exception;
    }
}

