/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.annotation.ApiAccess;
import org.apache.streampark.console.core.entity.YarnQueue;
import org.apache.streampark.console.core.service.YarnQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="YARN_QUEUE_TAG")
@Validated
@RestController
@RequestMapping(value={"flink/yarnQueue"})
public class YarnQueueController {
    private static final Logger log = LoggerFactory.getLogger(YarnQueueController.class);
    @Autowired
    private YarnQueueService yarnQueueService;

    @Operation(summary="List yarn queues")
    @ApiAccess
    @PostMapping(value={"list"})
    public RestResponse list(RestRequest restRequest, YarnQueue yarnQueue) {
        IPage<YarnQueue> queuePage = this.yarnQueueService.findYarnQueues(yarnQueue, restRequest);
        return RestResponse.success(queuePage);
    }

    @Operation(summary="Check yarn queue valid")
    @ApiAccess
    @PostMapping(value={"check"})
    public RestResponse check(YarnQueue yarnQueue) {
        return RestResponse.success(this.yarnQueueService.checkYarnQueue(yarnQueue));
    }

    @Operation(summary="Create yarn queue")
    @ApiAccess
    @PostMapping(value={"create"})
    @RequiresPermissions(value={"yarnQueue:create"})
    public RestResponse create(YarnQueue yarnQueue) {
        return RestResponse.success(this.yarnQueueService.createYarnQueue(yarnQueue));
    }

    @Operation(summary="Update yarn queue")
    @ApiAccess
    @PostMapping(value={"update"})
    @RequiresPermissions(value={"yarnQueue:update"})
    public RestResponse update(YarnQueue yarnQueue) {
        this.yarnQueueService.updateYarnQueue(yarnQueue);
        return RestResponse.success();
    }

    @Operation(summary="Delete yarn queue", description="delete by (team id & yarn queue) or yarn queue id")
    @ApiAccess
    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"yarnQueue:delete"})
    public RestResponse delete(YarnQueue yarnQueue) {
        this.yarnQueueService.deleteYarnQueue(yarnQueue);
        return RestResponse.success();
    }
}

