/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

import {
    animate,
    animateChild,
    group,
    query,
    style,
    transition,
    trigger,
} from '@angular/animations';

export const slideInAnimation = trigger('routeAnimations', [
    transition('* <=> LoginPage', [
        style({ position: 'relative' }),
        query(
            ':enter, :leave',
            [
                style({
                    position: 'absolute',
                    top: 0,
                    left: 0,
                    width: '100%',
                }),
            ],
            { optional: true },
        ),
        query(':enter', [style({ opacity: 0 })], { optional: true }),
        query(':leave', animateChild(), { optional: true }),
        group([
            query(':leave', [animate('200ms', style({ opacity: 0 }))], {
                optional: true,
            }),
            query(':enter', [animate('300ms', style({ opacity: 1 }))], {
                optional: true,
            }),
        ]),
        query(':enter', animateChild(), { optional: true }),
    ]),
]);
