/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.DefaultAlertPolicy;
import com.google.gxp.compiler.alerts.ErroringAlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileSystem;
import com.google.gxp.compiler.fs.ResourceFileSystem;
import com.google.gxp.compiler.schema.ElementBuilder;
import com.google.gxp.compiler.schema.FileBackedSchemaFactory;
import com.google.gxp.compiler.schema.Schema;
import com.google.gxp.compiler.schema.SchemaFactory;
import com.google.gxp.compiler.schema.SchemaRef;
import java.util.Collections;
import java.util.Map;

public class BuiltinSchemaFactory
extends FileBackedSchemaFactory {
    public static final SchemaFactory INSTANCE = new BuiltinSchemaFactory();
    Map<String, Schema> nonMarkupSchemas = Maps.newHashMap();
    private static final String PATH_PREFIX = "/com/google/gxp/compiler/schema/";

    public BuiltinSchemaFactory() {
        this(new ErroringAlertSink(DefaultAlertPolicy.INSTANCE));
    }

    public BuiltinSchemaFactory(AlertSink alertSink) {
        super(alertSink);
        Schema plaintextSchema = this.addNonMarkupSchema("plaintext", "text/plain", null, "PlaintextClosure", "PlaintextAppender", "gxp/text/plaintext.h", "com.google.gxp.text.PlaintextClosure", "com.google.gxp.text.PlaintextAppender", "com.google.gxp.text.*", "goog.gxp.text.PlaintextClosure");
        this.addNonMarkupSchema("javascript", "text/javascript", plaintextSchema, "JavascriptClosure", "JavascriptAppender", "gxp/js/javascript.h", "com.google.gxp.js.JavascriptClosure", "com.google.gxp.js.JavascriptAppender", "com.google.gxp.js.*", "goog.gxp.js.JavascriptClosure");
        this.addNonMarkupSchema("css", "text/css", plaintextSchema, "CssClosure", "CssAppender", "gxp/css/css.h", "com.google.gxp.css.CssClosure", "com.google.gxp.css.CssAppender", "com.google.gxp.css.*", "goog.gxp.css.CssClosure");
        ResourceFileSystem fs = new ResourceFileSystem();
        this.add(fs, "html.xml", "http://www.w3.org/1999/xhtml", "text/html", "application/xhtml+xml");
    }

    private void add(FileSystem fs, String fnam, String nsUri, String ... contentTypeNames) {
        FileRef ref = fs.parseFilename(PATH_PREFIX).join(fnam);
        this.addSchemaPromise(ref, nsUri, contentTypeNames);
    }

    private Schema addNonMarkupSchema(String name, String contentType, Schema msgSchema, String cppType, String cppAppender, String cppImport, String javaType, String javaAppender, String javaImport, String javaScriptType) {
        Schema schema = new Schema(new SourcePosition(name), "<schema>", name, "", contentType, false, contentType, null, cppType, cppAppender, ImmutableList.of(cppImport), javaType, javaAppender, ImmutableList.of(javaImport), javaScriptType, Iterables.<ElementBuilder>emptyIterable(), Collections.<SchemaRef>emptySet(), msgSchema);
        this.nonMarkupSchemas.put(contentType, schema);
        return schema;
    }

    @Override
    public Schema fromContentTypeName(String contentTypeName) {
        Schema schema = this.nonMarkupSchemas.get(contentTypeName);
        return schema != null ? schema : super.fromContentTypeName(contentTypeName);
    }
}

