/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.properties;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.DefaultedMessageProvider;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.LocalizedMessageProvider;
import net.sf.jasperreports.engine.util.MessageProvider;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.metadata.properties.CompiledPropertiesMetadata;
import net.sf.jasperreports.metadata.properties.CompiledPropertyMetadata;
import net.sf.jasperreports.metadata.properties.StandardPropertiesMetadataSerialization;
import net.sf.jasperreports.properties.PropertyMetadata;
import net.sf.jasperreports.properties.StandardPropertyMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourcePropertiesMetadataReader {
    private static final Log log = LogFactory.getLog(ResourcePropertiesMetadataReader.class);
    private static final ResourcePropertiesMetadataReader INSTANCE = new ResourcePropertiesMetadataReader();

    public static ResourcePropertiesMetadataReader instance() {
        return INSTANCE;
    }

    protected ResourcePropertiesMetadataReader() {
    }

    public Map<String, PropertyMetadata> readProperties(JasperReportsContext context, Locale locale) {
        MessageUtil messageUtil = MessageUtil.getInstance(context);
        LinkedHashMap<String, PropertyMetadata> properties = new LinkedHashMap<String, PropertyMetadata>();
        List<URL> resources = JRLoader.getResources("properties-metadata.json");
        StandardPropertiesMetadataSerialization metadataSerialization = StandardPropertiesMetadataSerialization.instance();
        for (URL resource : resources) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading properties metadata from " + resource));
            }
            InputStream in = null;
            try {
                in = resource.openStream();
                CompiledPropertiesMetadata resourceProperties = metadataSerialization.readProperties(in);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded " + resourceProperties.getProperties().size() + " properties from " + resource));
                }
                MessageProvider messageProvider = messageUtil.getMessageProvider(resourceProperties.getMessagesName());
                messageProvider = DefaultedMessageProvider.wrap(messageProvider, resourceProperties.getMessagesName() + "-defaults.properties");
                LocalizedMessageProvider localizedMessageProvider = new LocalizedMessageProvider(messageProvider, locale);
                for (CompiledPropertyMetadata compiledProperty : resourceProperties.getProperties()) {
                    if (!properties.containsKey(compiledProperty.getName())) {
                        PropertyMetadata property = this.toProperty(compiledProperty, localizedMessageProvider);
                        properties.put(compiledProperty.getName(), property);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Found duplicate property " + compiledProperty.getName()));
                }
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Failed to close input stream for " + resource), (Throwable)e);
                }
            }
        }
        return properties;
    }

    protected PropertyMetadata toProperty(CompiledPropertyMetadata compiledProperty, LocalizedMessageProvider messageProvider) {
        StandardPropertyMetadata property = new StandardPropertyMetadata();
        String name = compiledProperty.getName();
        property.setName(name);
        property.setCategory(compiledProperty.getCategory());
        property.setConstantDeclarationClass(compiledProperty.getConstantDeclarationClass());
        property.setConstantFieldName(compiledProperty.getConstantFieldName());
        property.setLabel(messageProvider.getMessage("property.label." + name));
        property.setDescription(messageProvider.getMessage("property.description." + name));
        property.setDefaultValue(compiledProperty.getDefaultValue());
        property.setScopes(compiledProperty.getScopes());
        property.setScopeQualifications(compiledProperty.getScopeQualifications());
        property.setSinceVersion(compiledProperty.getSinceVersion());
        property.setValueType(compiledProperty.getValueType());
        property.setDeprecated(compiledProperty.isDeprecated());
        return property;
    }
}

