/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.prepare.factory;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.api.preparer.ViewPreparer;
import org.apache.tiles.core.prepare.factory.PreparerFactory;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.reflect.ClassUtil;

public class BasicPreparerFactory
implements PreparerFactory {
    private static final Logger LOG = LogManager.getLogger(BasicPreparerFactory.class);
    protected Map<String, ViewPreparer> preparers = new HashMap<String, ViewPreparer>();

    @Override
    public ViewPreparer getPreparer(String name, Request context) {
        if (!this.preparers.containsKey(name)) {
            this.preparers.put(name, this.createPreparer(name));
        }
        return this.preparers.get(name);
    }

    protected ViewPreparer createPreparer(String name) {
        LOG.debug("Creating ViewPreparer '{}'", (Object)name);
        Object instance = ClassUtil.instantiate(name, true);
        return (ViewPreparer)instance;
    }
}

