/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.test.context.bean.override.BeanOverrideRegistry;
import org.springframework.util.StringUtils;

class WrapEarlyBeanPostProcessor
implements SmartInstantiationAwareBeanPostProcessor,
PriorityOrdered {
    private final Map<String, Object> earlyReferences = new ConcurrentHashMap<String, Object>(16);
    private final BeanOverrideRegistry beanOverrideRegistry;

    WrapEarlyBeanPostProcessor(BeanOverrideRegistry beanOverrideRegistry) {
        this.beanOverrideRegistry = beanOverrideRegistry;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Object getEarlyBeanReference(Object bean, String beanName) throws BeansException {
        if (bean instanceof FactoryBean) {
            return bean;
        }
        this.earlyReferences.put(this.getCacheKey(bean, beanName), bean);
        return this.beanOverrideRegistry.wrapBeanIfNecessary(bean, beanName);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof FactoryBean) {
            return bean;
        }
        if (this.earlyReferences.remove(this.getCacheKey(bean, beanName)) != bean) {
            return this.beanOverrideRegistry.wrapBeanIfNecessary(bean, beanName);
        }
        return bean;
    }

    private String getCacheKey(Object bean, String beanName) {
        return StringUtils.hasLength((String)beanName) ? beanName : bean.getClass().getName();
    }
}

