/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class TestContextResourceUtils {
    private static final String SLASH = "/";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(".*\\$\\{[^}]+\\}.*");

    public static String[] convertToClasspathResourcePaths(Class<?> clazz, String ... paths) {
        return TestContextResourceUtils.convertToClasspathResourcePaths(clazz, false, paths);
    }

    public static String[] convertToClasspathResourcePaths(Class<?> clazz, boolean preservePlaceholders, String ... paths) {
        String[] convertedPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            convertedPaths[i] = path.startsWith(SLASH) ? "classpath:" + path : (!ResourcePatternUtils.isUrl((String)path) ? "classpath:/" + ClassUtils.classPackageAsResourcePath(clazz) + SLASH + path : path);
            if (preservePlaceholders && PLACEHOLDER_PATTERN.matcher(convertedPaths[i]).matches()) continue;
            convertedPaths[i] = StringUtils.cleanPath((String)convertedPaths[i]);
        }
        return convertedPaths;
    }

    public static Resource[] convertToResources(ResourceLoader resourceLoader, String ... paths) {
        return (Resource[])TestContextResourceUtils.stream(resourceLoader, paths).toArray(Resource[]::new);
    }

    public static List<Resource> convertToResourceList(ResourceLoader resourceLoader, String ... paths) {
        return TestContextResourceUtils.stream(resourceLoader, paths).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<Resource> convertToResourceList(ResourceLoader resourceLoader, Environment environment, String ... paths) {
        return Arrays.stream(paths).map(arg_0 -> ((Environment)environment).resolveRequiredPlaceholders(arg_0)).map(arg_0 -> ((ResourceLoader)resourceLoader).getResource(arg_0)).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Stream<Resource> stream(ResourceLoader resourceLoader, String ... paths) {
        return Arrays.stream(paths).map(arg_0 -> ((ResourceLoader)resourceLoader).getResource(arg_0));
    }
}

