/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ReflectionHints {
    private final Map<TypeReference, TypeHint.Builder> types = new HashMap<TypeReference, TypeHint.Builder>();

    public Stream<TypeHint> typeHints() {
        return this.types.values().stream().map(TypeHint.Builder::build);
    }

    @Nullable
    public TypeHint getTypeHint(TypeReference type) {
        TypeHint.Builder typeHintBuilder = this.types.get(type);
        return typeHintBuilder != null ? typeHintBuilder.build() : null;
    }

    @Nullable
    public TypeHint getTypeHint(Class<?> type) {
        return this.getTypeHint(TypeReference.of(type));
    }

    public ReflectionHints registerType(TypeReference type, Consumer<TypeHint.Builder> typeHint) {
        TypeHint.Builder builder = this.types.computeIfAbsent(type, TypeHint.Builder::new);
        typeHint.accept(builder);
        return this;
    }

    public ReflectionHints registerType(TypeReference type, MemberCategory ... memberCategories) {
        return this.registerType(type, TypeHint.builtWith(memberCategories));
    }

    public ReflectionHints registerType(Class<?> type, Consumer<TypeHint.Builder> typeHint) {
        Assert.notNull(type, "'type' must not be null");
        if (type.getCanonicalName() != null) {
            this.registerType(TypeReference.of(type), typeHint);
        }
        return this;
    }

    public ReflectionHints registerType(Class<?> type, MemberCategory ... memberCategories) {
        Assert.notNull(type, "'type' must not be null");
        if (type.getCanonicalName() != null) {
            this.registerType(TypeReference.of(type), memberCategories);
        }
        return this;
    }

    public ReflectionHints registerTypeIfPresent(@Nullable ClassLoader classLoader, String typeName, Consumer<TypeHint.Builder> typeHint) {
        if (ClassUtils.isPresent(typeName, classLoader)) {
            this.registerType(TypeReference.of(typeName), typeHint);
        }
        return this;
    }

    public ReflectionHints registerTypeIfPresent(@Nullable ClassLoader classLoader, String typeName, MemberCategory ... memberCategories) {
        return this.registerTypeIfPresent(classLoader, typeName, TypeHint.builtWith(memberCategories));
    }

    public ReflectionHints registerTypes(Iterable<TypeReference> types, Consumer<TypeHint.Builder> typeHint) {
        types.forEach(type -> this.registerType((TypeReference)type, typeHint));
        return this;
    }

    public ReflectionHints registerForInterfaces(Class<?> type, Consumer<TypeHint.Builder> typeHint) {
        for (Class<?> currentClass = type; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Class<?> interfaceType : currentClass.getInterfaces()) {
                if (ClassUtils.isJavaLanguageInterface(interfaceType)) continue;
                this.registerType(interfaceType, typeHint);
                this.registerForInterfaces(interfaceType, typeHint);
            }
        }
        return this;
    }

    public ReflectionHints registerField(Field field) {
        return this.registerType(TypeReference.of(field.getDeclaringClass()), (TypeHint.Builder typeHint) -> typeHint.withField(field.getName()));
    }

    public ReflectionHints registerConstructor(Constructor<?> constructor, ExecutableMode mode) {
        return this.registerType(TypeReference.of(constructor.getDeclaringClass()), (TypeHint.Builder typeHint) -> typeHint.withConstructor(this.mapParameters(constructor), mode));
    }

    public ReflectionHints registerMethod(Method method, ExecutableMode mode) {
        return this.registerType(TypeReference.of(method.getDeclaringClass()), (TypeHint.Builder typeHint) -> typeHint.withMethod(method.getName(), this.mapParameters(method), mode));
    }

    private List<TypeReference> mapParameters(Executable executable) {
        return TypeReference.listOf(executable.getParameterTypes());
    }
}

