/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.interactive;

import java.io.Serializable;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrosstabOrderAttributes
implements Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(CrosstabOrderAttributes.class);
    private JRDesignCrosstab crosstab;
    private boolean dataPreSorted;
    private BucketOrder[] rowGroupOrders;
    private BucketOrder[] colGroupOrders;
    private String orderByColumnProp;

    public CrosstabOrderAttributes(JRDesignCrosstab crosstab) {
        this.crosstab = crosstab;
        this.dataPreSorted = crosstab.getDataset().isDataPreSorted();
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        this.rowGroupOrders = new BucketOrder[rowGroups.length];
        for (int i = 0; i < rowGroups.length; ++i) {
            this.rowGroupOrders[i] = rowGroups[i].getBucket().getOrder();
        }
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        this.colGroupOrders = new BucketOrder[colGroups.length];
        for (int i = 0; i < colGroups.length; ++i) {
            this.colGroupOrders[i] = colGroups[i].getBucket().getOrder();
        }
        this.orderByColumnProp = crosstab.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.order.by.column");
        if (log.isDebugEnabled()) {
            log.debug((Object)("crosstab " + crosstab.getUUID() + " has order attributes " + this.toString()));
        }
    }

    public void prepareSorting() {
        if (this.dataPreSorted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("crosstab " + this.crosstab.getUUID() + " has the presorted flag set, converting to order NONE"));
            }
            ((JRDesignCrosstabDataset)this.crosstab.getDataset()).setDataPreSorted(false);
            JRCrosstabRowGroup[] rowGroups = this.crosstab.getRowGroups();
            for (int i = 0; i < rowGroups.length; ++i) {
                ((JRDesignCrosstabBucket)rowGroups[i].getBucket()).setOrder(BucketOrder.NONE);
            }
            JRCrosstabColumnGroup[] colGroups = this.crosstab.getColumnGroups();
            for (int i = 0; i < colGroups.length; ++i) {
                ((JRDesignCrosstabBucket)colGroups[i].getBucket()).setOrder(BucketOrder.NONE);
            }
        }
    }

    public void restore() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("restoring crosstab " + this.crosstab.getUUID() + " order attributes"));
        }
        ((JRDesignCrosstabDataset)this.crosstab.getDataset()).setDataPreSorted(this.dataPreSorted);
        JRCrosstabRowGroup[] rowGroups = this.crosstab.getRowGroups();
        for (int i = 0; i < rowGroups.length; ++i) {
            ((JRDesignCrosstabBucket)rowGroups[i].getBucket()).setOrder(this.rowGroupOrders[i]);
        }
        JRCrosstabColumnGroup[] colGroups = this.crosstab.getColumnGroups();
        for (int i = 0; i < colGroups.length; ++i) {
            ((JRDesignCrosstabBucket)colGroups[i].getBucket()).setOrder(this.colGroupOrders[i]);
        }
        this.crosstab.getPropertiesMap().setProperty("net.sf.jasperreports.crosstab.order.by.column", this.orderByColumnProp);
    }

    public String toString() {
        int i;
        StringBuilder string = new StringBuilder();
        string.append("{").append(this.dataPreSorted).append(",[");
        for (i = 0; i < this.rowGroupOrders.length; ++i) {
            string.append(this.rowGroupOrders[i].getName()).append(",");
        }
        string.append("],[");
        for (i = 0; i < this.colGroupOrders.length; ++i) {
            string.append(this.colGroupOrders[i].getName()).append(",");
        }
        string.append("],").append(this.orderByColumnProp).append("}");
        return string.toString();
    }
}

