/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.DatasetResetTypeEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseElementDataset
implements JRElementDataset,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected DatasetResetTypeEnum datasetResetType;
    protected IncrementTypeEnum incrementType;
    protected String resetGroup;
    protected String incrementGroup;
    protected JRDatasetRun datasetRun;
    protected JRExpression incrementWhenExpression;

    protected JRBaseElementDataset() {
    }

    protected JRBaseElementDataset(JRElementDataset dataset) {
        if (dataset != null) {
            this.datasetResetType = dataset.getDatasetResetType();
            this.incrementType = dataset.getIncrementType();
            this.resetGroup = dataset.getResetGroup();
            this.incrementGroup = dataset.getIncrementGroup();
            this.datasetRun = dataset.getDatasetRun();
            this.incrementWhenExpression = dataset.getIncrementWhenExpression();
        }
    }

    protected JRBaseElementDataset(JRElementDataset dataset, JRBaseObjectFactory factory) {
        factory.put(dataset, this);
        this.datasetResetType = dataset.getDatasetResetType();
        this.incrementType = dataset.getIncrementType();
        this.resetGroup = dataset.getResetGroup();
        this.incrementGroup = dataset.getIncrementGroup();
        this.datasetRun = factory.getDatasetRun(dataset.getDatasetRun());
        this.incrementWhenExpression = factory.getExpression(dataset.getIncrementWhenExpression());
    }

    @Override
    public DatasetResetTypeEnum getDatasetResetType() {
        return this.datasetResetType;
    }

    @Override
    public IncrementTypeEnum getIncrementType() {
        return this.incrementType;
    }

    @Override
    public String getResetGroup() {
        return this.resetGroup;
    }

    @Override
    public String getIncrementGroup() {
        return this.incrementGroup;
    }

    @Override
    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    @Override
    public JRExpression getIncrementWhenExpression() {
        return this.incrementWhenExpression;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
    }

    @Override
    public Object clone() {
        JRBaseElementDataset clone = null;
        try {
            clone = (JRBaseElementDataset)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.incrementWhenExpression = JRCloneUtils.nullSafeClone(this.incrementWhenExpression);
        clone.datasetRun = JRCloneUtils.nullSafeClone(this.datasetRun);
        return clone;
    }
}

