/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.List;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.GenericElementHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerBundle;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GenericElementHandlerEnviroment {
    private static final Log log = LogFactory.getLog(GenericElementHandlerEnviroment.class);
    public static final String EXCEPTION_MESSAGE_KEY_HANDLERS_NOT_FOUND_FOR_NAMESPACE = "export.common.handlers.not.found.for.namespace";
    private final ReferenceMap<Object, List<GenericElementHandlerBundle>> handlersCache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    private JasperReportsContext jasperReportsContext;

    private GenericElementHandlerEnviroment(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static GenericElementHandlerEnviroment getInstance(JasperReportsContext jasperReportsContext) {
        return new GenericElementHandlerEnviroment(jasperReportsContext);
    }

    public GenericElementHandler getElementHandler(JRGenericElementType type, String exporterKey) {
        String namespace = type.getNamespace();
        String name = type.getName();
        List<GenericElementHandlerBundle> handlerBundles = this.getBundles();
        List handlers = handlerBundles.stream().filter(bundle -> bundle.getNamespace().equals(namespace)).map(bundle -> bundle.getHandler(name, exporterKey)).filter(handler -> handler != null).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            return null;
        }
        if (handlers.size() > 1) {
            log.warn((Object)("Found " + handlers.size() + " handlers for name " + type.getName() + ", namespace " + namespace + ", exporter " + exporterKey));
        }
        return (GenericElementHandler)handlers.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<GenericElementHandlerBundle> getBundles() {
        List<GenericElementHandlerBundle> handlerBundles;
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap<Object, List<GenericElementHandlerBundle>> referenceMap = this.handlersCache;
        synchronized (referenceMap) {
            handlerBundles = (List<GenericElementHandlerBundle>)this.handlersCache.get(cacheKey);
            if (handlerBundles == null) {
                handlerBundles = this.loadBundles();
                this.handlersCache.put(cacheKey, handlerBundles);
            }
        }
        return handlerBundles;
    }

    protected List<GenericElementHandlerBundle> loadBundles() {
        List<GenericElementHandlerBundle> bundleList = this.jasperReportsContext.getExtensions(GenericElementHandlerBundle.class);
        return bundleList;
    }
}

