/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.Locale;
import net.sf.jasperreports.engine.export.HtmlFontFamily;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.util.JRDataUtils;

public class HtmlFont {
    private static final String LOCALE_SEPARATOR = "_-";
    private static final int IE_FONT_NAME_MAX_LENGTH = 31;
    private HtmlFontFamily family;
    private Locale locale;
    private String fontName;
    private String ttf;
    private String eot;
    private String svg;
    private String woff;
    private boolean isBold;
    private boolean isItalic;
    private String id;
    private String shortId;

    private HtmlFont(HtmlFontFamily family, Locale locale, FontFace fontFace, boolean isBold, boolean isItalic) {
        this.family = family;
        this.locale = locale;
        this.fontName = fontFace.getName();
        this.ttf = fontFace.getTtf();
        this.eot = fontFace.getEot();
        this.svg = fontFace.getSvg();
        this.woff = fontFace.getWoff();
        this.isBold = isBold;
        this.isItalic = isItalic;
        this.createIds();
    }

    public static HtmlFont getInstance(HtmlFontFamily family, Locale locale, FontFace fontFace, boolean isBold, boolean isItalic) {
        HtmlFont htmlFont = null;
        if (fontFace.getTtf() != null || fontFace.getEot() != null || fontFace.getSvg() != null || fontFace.getWoff() != null) {
            htmlFont = new HtmlFont(family, locale, fontFace, isBold, isItalic);
        }
        return htmlFont;
    }

    private void createIds() {
        String prefix = this.fontName;
        String suffix = (this.isBold || this.isItalic ? "-" : "") + (this.isBold ? "Bold" : "") + (this.isItalic ? "Italic" : "") + (this.locale == null ? "" : LOCALE_SEPARATOR + JRDataUtils.getLocaleCode(this.locale));
        this.id = prefix + suffix;
        if (prefix.length() + suffix.length() > 31) {
            prefix = prefix.replaceAll("\\s", "");
        }
        if (prefix.length() + suffix.length() > 31) {
            suffix = (this.isBold || this.isItalic ? "-" : "") + (this.isBold ? "B" : "") + (this.isItalic ? "I" : "") + (this.locale == null ? "" : LOCALE_SEPARATOR + JRDataUtils.getLocaleCode(this.locale));
        }
        if (prefix.length() + suffix.length() > 31) {
            prefix = prefix.substring(0, 1) + prefix.substring(1).replaceAll("[AaEeIiOoUu]", "");
        }
        if (prefix.length() + suffix.length() > 31) {
            prefix = prefix.substring(0, 31 - suffix.length());
        }
        this.shortId = prefix + suffix;
    }

    public String getId() {
        return this.id;
    }

    public String getShortId() {
        return this.shortId;
    }

    public HtmlFontFamily getFamily() {
        return this.family;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getTtf() {
        return this.ttf;
    }

    public String getEot() {
        return this.eot;
    }

    public String getSvg() {
        return this.svg;
    }

    public String getWoff() {
        return this.woff;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }
}

