/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AwtTextRenderer;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRStyledText;

public class TextDrawer
extends ElementDrawer<JRPrintText> {
    protected AwtTextRenderer textRenderer;

    public TextDrawer(JasperReportsContext jasperReportsContext, AwtTextRenderer textRenderer) {
        super(jasperReportsContext);
        this.textRenderer = textRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D grx, JRPrintText text, int offsetX, int offsetY) {
        this.textRenderer.initialize(grx, text, offsetX, offsetY);
        JRStyledText styledText = this.textRenderer.getStyledText();
        if (styledText == null) {
            return;
        }
        double angle = 0.0;
        switch (text.getRotation()) {
            case LEFT: {
                angle = -1.5707963267948966;
                break;
            }
            case RIGHT: {
                angle = 1.5707963267948966;
                break;
            }
            case UPSIDE_DOWN: {
                angle = Math.PI;
                break;
            }
        }
        Shape oldClip = grx.getClip();
        grx.rotate(angle, this.textRenderer.getX(), this.textRenderer.getY());
        if (text.getMode() == ModeEnum.OPAQUE) {
            grx.setColor(text.getBackcolor());
            grx.fillRect(this.textRenderer.getX(), this.textRenderer.getY(), this.textRenderer.getWidth(), this.textRenderer.getHeight());
        }
        grx.clip(new Rectangle(this.textRenderer.getX() + this.textRenderer.getLeftPadding(), this.textRenderer.getY() + this.textRenderer.getTopPadding(), this.textRenderer.getWidth() - this.textRenderer.getLeftPadding() - this.textRenderer.getRightPadding(), this.textRenderer.getHeight() - this.textRenderer.getTopPadding() - this.textRenderer.getBottomPadding()));
        try {
            String allText = this.textRenderer.getPlainText();
            if (allText.length() > 0) {
                grx.setColor(text.getForecolor());
                this.textRenderer.render();
            }
        }
        finally {
            grx.rotate(-angle, this.textRenderer.getX(), this.textRenderer.getY());
            grx.setClip(oldClip);
        }
        this.drawBox(grx, text.getLineBox(), text, offsetX, offsetY);
    }
}

