/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;

public class JRFillField
implements JRField {
    protected JRField parent;
    protected JRFillExpressionEvaluator expressionEvaluator;
    protected List<JRPropertyExpression> propertyExpressions;
    protected JRPropertiesMap staticProperties;
    protected JRPropertiesMap mergedProperties;
    private Object previousOldValue;
    private Object oldValue;
    private Object value;
    private Object savedValue;

    protected JRFillField(JRField field, JRFillObjectFactory factory) {
        factory.put(field, this);
        this.parent = field;
        this.expressionEvaluator = factory.getExpressionEvaluator();
        this.mergedProperties = this.staticProperties = field.hasProperties() ? field.getPropertiesMap().cloneProperties() : null;
        JRPropertyExpression[] fieldPropertyExpressions = field.getPropertyExpressions();
        this.propertyExpressions = fieldPropertyExpressions == null ? new ArrayList<JRPropertyExpression>(0) : new ArrayList<JRPropertyExpression>(Arrays.asList(fieldPropertyExpressions));
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public String getDescription() {
        return this.parent.getDescription();
    }

    @Override
    public void setDescription(String description) {
    }

    @Override
    public Class<?> getValueClass() {
        return this.parent.getValueClass();
    }

    @Override
    public String getValueClassName() {
        return this.parent.getValueClassName();
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue(byte evaluation) {
        Object returnValue;
        switch (evaluation) {
            case 1: {
                returnValue = this.oldValue;
                break;
            }
            default: {
                returnValue = this.value;
            }
        }
        return returnValue;
    }

    public void overwriteValue(Object newValue, byte evaluation) {
        switch (evaluation) {
            case 1: {
                this.savedValue = this.oldValue;
                this.oldValue = newValue;
                break;
            }
            default: {
                this.savedValue = this.value;
                this.value = newValue;
            }
        }
    }

    public void restoreValue(byte evaluation) {
        switch (evaluation) {
            case 1: {
                this.oldValue = this.savedValue;
                break;
            }
            default: {
                this.value = this.savedValue;
            }
        }
        this.savedValue = null;
    }

    public Object getPreviousOldValue() {
        return this.previousOldValue;
    }

    public void setPreviousOldValue(Object previousOldValue) {
        this.previousOldValue = previousOldValue;
    }

    @Override
    public boolean hasProperties() {
        return this.mergedProperties != null && this.mergedProperties.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.mergedProperties;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public JRPropertyExpression[] getPropertyExpressions() {
        return this.propertyExpressions.toArray(new JRPropertyExpression[this.propertyExpressions.size()]);
    }

    protected void evaluateProperties() throws JRException {
        if (this.propertyExpressions.isEmpty()) {
            this.mergedProperties = this.staticProperties;
        } else {
            JRPropertiesMap dynamicProperties = new JRPropertiesMap();
            for (JRPropertyExpression prop : this.propertyExpressions) {
                String value = (String)this.evaluateExpression(prop.getValueExpression());
                dynamicProperties.setProperty(prop.getName(), value);
            }
            this.mergedProperties = dynamicProperties.cloneProperties();
            this.mergedProperties.setBaseProperties(this.staticProperties);
        }
    }

    protected final Object evaluateExpression(JRExpression expression) throws JRException {
        return this.expressionEvaluator.evaluate(expression, (byte)3);
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

