/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatCountIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatSumIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatVarianceIncrementer;
import net.sf.jasperreports.engine.type.CalculationEnum;

public final class JRFloatIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Float ZERO = Float.valueOf(0.0f);
    private static JRFloatIncrementerFactory mainInstance = new JRFloatIncrementerFactory();

    public static JRFloatIncrementerFactory getInstance() {
        return mainInstance;
    }

    @Override
    public JRExtendedIncrementer getExtendedIncrementer(CalculationEnum calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case COUNT: {
                incrementer = JRFloatCountIncrementer.getInstance();
                break;
            }
            case SUM: {
                incrementer = JRFloatSumIncrementer.getInstance();
                break;
            }
            case AVERAGE: {
                incrementer = JRFloatAverageIncrementer.getInstance();
                break;
            }
            case LOWEST: 
            case HIGHEST: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                incrementer = JRFloatStandardDeviationIncrementer.getInstance();
                break;
            }
            case VARIANCE: {
                incrementer = JRFloatVarianceIncrementer.getInstance();
                break;
            }
            case DISTINCT_COUNT: {
                incrementer = JRFloatDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

