/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.style;

import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.style.PropertyStyleProvider;
import net.sf.jasperreports.engine.style.StyleProvider;
import net.sf.jasperreports.engine.style.StyleProviderContext;
import net.sf.jasperreports.engine.style.StyleProviderFactory;

public final class PropertyStyleProviderFactory
implements StyleProviderFactory {
    private static final PropertyStyleProviderFactory INSTANCE = new PropertyStyleProviderFactory();

    private PropertyStyleProviderFactory() {
    }

    public static PropertyStyleProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public StyleProvider getStyleProvider(StyleProviderContext context, JasperReportsContext jasperreportsContext) {
        HashMap<String, JRPropertyExpression> stylePropertyExpressions = null;
        JRPropertyExpression[] propertyExpressions = context.getElement().getPropertyExpressions();
        if (propertyExpressions != null) {
            for (JRPropertyExpression propertyExpression : propertyExpressions) {
                if (!propertyExpression.getName().startsWith("net.sf.jasperreports.style.")) continue;
                if (stylePropertyExpressions == null) {
                    stylePropertyExpressions = new HashMap<String, JRPropertyExpression>();
                }
                stylePropertyExpressions.put(propertyExpression.getName(), propertyExpression);
            }
        }
        List<JRPropertiesUtil.PropertySuffix> styleProperties = JRPropertiesUtil.getProperties(context.getElement(), "net.sf.jasperreports.style.");
        if (stylePropertyExpressions != null || styleProperties != null && styleProperties.size() > 0) {
            return new PropertyStyleProvider(context, stylePropertyExpressions);
        }
        return null;
    }
}

