/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.XmlNamespace;

public class JRXmlWriteHelper {
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_SCHEMA_NAMESPACE_PREFIX = "xsi";
    public static final String XML_NAMESPACE_ATTRIBUTE = "xmlns";
    public static final String XML_SCHEMA_LOCATION_ATTRIBUTE = "schemaLocation";
    private final Writer writer;
    private final List<char[]> indents;
    private int indent;
    private final List<StackElement> elementStack;
    private StringBuilder builder;
    private StackElement lastElement;
    protected static final Pattern PATTERN_CDATA_CLOSE = Pattern.compile("\\]\\]\\>");
    protected static final String ESCAPED_CDATA_CLOSE = "]]]]><![CDATA[>";

    public JRXmlWriteHelper(Writer writer) {
        this.writer = writer;
        this.indents = new ArrayList<char[]>();
        this.indent = 0;
        this.elementStack = new ArrayList<StackElement>();
        this.lastElement = null;
        this.clearBuffer();
    }

    public void writeProlog(String encoding) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
    }

    public void writePublicDoctype(String rootElement, String description, String dtdLocation) throws IOException {
        this.writer.write("<!DOCTYPE " + rootElement + " PUBLIC \"" + description + "\" \"" + dtdLocation + "\">\n\n");
    }

    public void startElement(String name) {
        this.startElement(name, null);
    }

    public void startElement(String name, XmlNamespace namespace) {
        boolean startsNS = false;
        XmlNamespace elementNS = null;
        if (namespace == null) {
            elementNS = this.getParentNamespace();
        } else {
            elementNS = this.findContextNamespace(namespace.getNamespaceURI());
            if (elementNS == null) {
                startsNS = true;
                elementNS = namespace;
            }
        }
        ++this.indent;
        this.lastElement = new StackElement(name, elementNS);
        this.elementStack.add(this.lastElement);
        if (startsNS) {
            String xmlnsAttr = XML_NAMESPACE_ATTRIBUTE;
            if (namespace.getPrefix() != null) {
                xmlnsAttr = xmlnsAttr + ":" + namespace.getPrefix();
            }
            this.lastElement.addAttribute(xmlnsAttr, namespace.getNamespaceURI(), false);
            if (this.indent == 1) {
                String xmlSchemaXmlns = "xmlns:xsi";
                this.lastElement.addAttribute(xmlSchemaXmlns, XML_SCHEMA_NAMESPACE, false);
            }
            if (namespace.getSchemaURI() != null) {
                String schemaLocationAttr = JRXmlWriteHelper.getQualifiedName(XML_SCHEMA_LOCATION_ATTRIBUTE, XML_SCHEMA_NAMESPACE_PREFIX);
                String schemaLocation = namespace.getNamespaceURI() + " " + namespace.getSchemaURI();
                this.lastElement.addAttribute(schemaLocationAttr, schemaLocation, false);
            }
        }
    }

    protected XmlNamespace getParentNamespace() {
        return this.lastElement == null ? null : this.lastElement.namespace;
    }

    protected XmlNamespace findContextNamespace(String namespaceURI) {
        XmlNamespace ns = null;
        ListIterator<StackElement> it = this.elementStack.listIterator(this.elementStack.size());
        while (it.hasPrevious()) {
            StackElement element = it.previous();
            if (element.namespace == null || !namespaceURI.equals(element.namespace.getNamespaceURI())) continue;
            ns = element.namespace;
            break;
        }
        return ns;
    }

    protected static String getQualifiedName(String name, XmlNamespace ns) {
        return ns == null ? name : JRXmlWriteHelper.getQualifiedName(name, ns.getPrefix());
    }

    protected static String getQualifiedName(String name, String nsPrefix) {
        String qName = nsPrefix == null ? name : nsPrefix + ":" + name;
        return qName;
    }

    protected void writeParents(boolean content) throws IOException {
        int stackSize = this.elementStack.size();
        for (int startWrite = stackSize - 1; startWrite >= 0; --startWrite) {
            StackElement element = this.elementStack.get(startWrite);
            if (element.hasChildren) break;
            if (startWrite < stackSize - 1) {
                element.hasChildren = true;
                continue;
            }
            element.hasChildren |= content;
        }
        for (int i = startWrite + 1; i < stackSize; ++i) {
            StackElement element = this.elementStack.get(i);
            this.writeElementAttributes(element, i);
        }
    }

    public void writeCDATA(String data) throws IOException {
        if (data != null) {
            this.writeParents(true);
            this.builder.append(this.getIndent(this.indent));
            this.builder.append("<![CDATA[");
            this.builder.append(JRXmlWriteHelper.encodeCDATA(data));
            this.builder.append("]]>\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String name, String data) throws IOException {
        this.writeCDATAElement(name, this.getParentNamespace(), data);
    }

    public void writeCDATAElement(String name, XmlNamespace namespace, String data) throws IOException {
        if (data != null) {
            this.writeParents(true);
            this.builder.append(this.getIndent(this.indent));
            this.builder.append('<');
            String qName = JRXmlWriteHelper.getQualifiedName(name, namespace);
            this.builder.append(qName);
            this.builder.append("><![CDATA[");
            this.builder.append(JRXmlWriteHelper.encodeCDATA(data));
            this.builder.append("]]></");
            this.builder.append(qName);
            this.builder.append(">\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String name, String data, String attName, String attValue) throws IOException {
        this.writeCDATAElement(name, data, attName, (Object)attValue);
    }

    public void writeCDATAElement(String name, String data, String attName, Object attValue) throws IOException {
        this.writeCDATAElement(name, this.getParentNamespace(), data, attName, attValue);
    }

    public void writeCDATAElement(String name, XmlNamespace namespace, String data, String attName, Object attValue) throws IOException {
        this.writeCDATAElement(name, namespace, data, new String[]{attName}, new Object[]{attValue});
    }

    public void writeCDATAElement(String name, XmlNamespace namespace, String data, String[] attNames, Object[] attValues) throws IOException {
        if (data != null) {
            this.writeParents(true);
            this.builder.append(this.getIndent(this.indent));
            this.builder.append('<');
            String qName = JRXmlWriteHelper.getQualifiedName(name, namespace);
            this.builder.append(qName);
            if (attNames != null) {
                for (int i = 0; i < attNames.length; ++i) {
                    if (attValues[i] == null) continue;
                    this.builder.append(' ');
                    this.builder.append(attNames[i]);
                    this.builder.append("=\"");
                    this.builder.append(attValues[i]);
                    this.builder.append("\"");
                }
            }
            this.builder.append("><![CDATA[");
            this.builder.append(JRXmlWriteHelper.encodeCDATA(data));
            this.builder.append("]]></");
            this.builder.append(qName);
            this.builder.append(">\n");
            this.flushBuffer();
        }
    }

    protected void writeElementAttributes(StackElement element, int level) throws IOException {
        this.builder.append(this.getIndent(level));
        this.builder.append('<');
        this.builder.append(element.qName);
        for (Attribute att : element.atts) {
            this.builder.append(' ');
            this.builder.append(att.name);
            this.builder.append("=\"");
            this.builder.append(att.value);
            this.builder.append('\"');
        }
        if (element.hasChildren) {
            this.builder.append(">\n");
        } else {
            this.builder.append("/>\n");
        }
        this.flushBuffer();
    }

    public void closeElement() throws IOException {
        this.closeElement(false);
    }

    public void closeElement(boolean skipIfEmpty) throws IOException {
        --this.indent;
        if (skipIfEmpty && !this.lastElement.hasAttributes && !this.lastElement.hasChildren) {
            this.clearBuffer();
        } else {
            this.writeParents(false);
            if (this.lastElement.hasChildren) {
                this.builder.append(this.getIndent(this.indent));
                this.builder.append("</");
                this.builder.append(this.lastElement.qName);
                this.builder.append(">\n");
                this.flushBuffer();
            }
        }
        this.elementStack.remove(this.indent);
        this.lastElement = this.indent > 0 ? this.elementStack.get(this.indent - 1) : null;
    }

    protected char[] getIndent(int level) {
        if (level >= this.indents.size()) {
            for (int i = this.indents.size(); i <= level; ++i) {
                char[] str = new char[i];
                Arrays.fill(str, '\t');
                this.indents.add(str);
            }
        }
        return this.indents.get(level);
    }

    protected void flushBuffer() throws IOException {
        this.writer.write(this.builder.toString());
        this.clearBuffer();
    }

    protected void clearBuffer() {
        this.builder = new StringBuilder();
    }

    public void writeExpression(String name, XmlNamespace namespace, JRExpression expression) throws IOException {
        if (expression != null) {
            this.writeCDATAElement(name, namespace, expression.getText());
        }
    }

    public void writeExpression(String name, JRExpression expression) throws IOException {
        this.writeExpression(name, this.getParentNamespace(), expression);
    }

    protected void writeAttribute(String name, String value) {
        this.lastElement.addAttribute(name, value);
    }

    public void addAttribute(String name, String value) {
        if (value != null) {
            this.writeAttribute(name, value);
        }
    }

    public void addEncodedAttribute(String name, String value) {
        if (value != null) {
            this.writeAttribute(name, JRStringUtil.encodeXmlAttribute(value));
        }
    }

    public void addAttribute(String name, String value, String defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.writeAttribute(name, value);
        }
    }

    public void addEncodedAttribute(String name, String value, String defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.writeAttribute(name, JRStringUtil.encodeXmlAttribute(value));
        }
    }

    public void addAttribute(String name, Object value) {
        if (value != null) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, Number value, Number defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, Float value, boolean withMinDecimals) {
        if (value != null) {
            Number number = value;
            if (withMinDecimals && (float)value.intValue() == value.floatValue()) {
                number = value.intValue();
            }
            this.writeAttribute(name, String.valueOf(number));
        }
    }

    public void addAttribute(String name, NamedEnum value) {
        if (value != null) {
            this.writeAttribute(name, value.getName());
        }
    }

    public void addAttribute(String name, NamedEnum value, NamedEnum defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.writeAttribute(name, value.getName());
        }
    }

    public void addAttribute(String name, int value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttributePositive(String name, int value) {
        if (value > 0) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, float value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttribute(String name, float value, float defaultValue) {
        if (value != defaultValue) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, double value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttribute(String name, double value, double defaultValue) {
        if (value != defaultValue) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, int value, int defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, boolean value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttribute(String name, Boolean value, boolean defaultValue) {
        if (value != null && value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, Color color) {
        if (color != null) {
            this.writeAttribute(name, JRColorUtil.getCssColor(color));
        }
    }

    public void addAttribute(String name, Color value, Color defaultValue) {
        if (value != null && value.getRGB() != defaultValue.getRGB()) {
            this.addAttribute(name, value);
        }
    }

    public Writer getUnderlyingWriter() {
        return this.writer;
    }

    protected static String encodeCDATA(String data) {
        if (data == null) {
            return null;
        }
        Matcher matcher = PATTERN_CDATA_CLOSE.matcher(data);
        return matcher.replaceAll(ESCAPED_CDATA_CLOSE);
    }

    protected static class StackElement {
        String name;
        List<Attribute> atts;
        boolean hasChildren;
        XmlNamespace namespace;
        String qName;
        boolean hasAttributes = false;

        StackElement(String name, XmlNamespace namespace) {
            this.name = name;
            this.atts = new ArrayList<Attribute>();
            this.hasChildren = false;
            this.namespace = namespace;
            this.qName = JRXmlWriteHelper.getQualifiedName(this.name, this.namespace);
        }

        void addAttribute(String attName, String value) {
            this.addAttribute(attName, value, true);
        }

        void addAttribute(String attName, String value, boolean count) {
            this.atts.add(new Attribute(attName, value));
            this.hasAttributes |= count;
        }
    }

    protected static class Attribute {
        String name;
        String value;

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

