/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.util.VirtualizationSerializer;
import net.sf.jasperreports.engine.virtualization.LocalVirtualizationInput;
import net.sf.jasperreports.engine.virtualization.LocalVirtualizationOutput;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class LocalVirtualizationSerializer
extends VirtualizationSerializer {
    protected static final int CLASSLOADER_IDX_NOT_SET = -1;
    protected final AtomicInteger classLoaderIndex = new AtomicInteger();
    protected final ConcurrentMap<ClassLoader, Integer> classLoadersIndexes = new ConcurrentHashMap<ClassLoader, Integer>();
    protected final ConcurrentMap<Integer, ClassLoader> classLoaders = new ConcurrentHashMap<Integer, ClassLoader>();
    protected final AtomicInteger classIndex = new AtomicInteger();
    protected final ConcurrentMap<Class<?>, Integer> classIndexes = new ConcurrentHashMap();
    protected final ConcurrentMap<Integer, Class<?>> classes = new ConcurrentHashMap();

    protected static boolean isAncestorClassLoader(ClassLoader loader) {
        for (ClassLoader ancestor = JRAbstractLRUVirtualizer.class.getClassLoader(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.equals(loader)) continue;
            return true;
        }
        return false;
    }

    public int getClassloaderIdx(Class<?> clazz) {
        int loaderIdx;
        ClassLoader classLoader = clazz.getClassLoader();
        if (clazz.isPrimitive() || classLoader == null || LocalVirtualizationSerializer.isAncestorClassLoader(classLoader)) {
            loaderIdx = -1;
        } else {
            Integer idx = (Integer)this.classLoadersIndexes.get(classLoader);
            if (idx == null) {
                idx = this.classLoaderIndex.getAndIncrement();
                Integer previousIndex = this.classLoadersIndexes.putIfAbsent(classLoader, idx);
                if (previousIndex == null) {
                    this.classLoaders.put(idx, classLoader);
                } else {
                    idx = previousIndex;
                }
            }
            loaderIdx = idx;
        }
        return loaderIdx;
    }

    public Class<?> resolveClass(ObjectStreamClass desc, int loaderIdx) throws ClassNotFoundException {
        if (loaderIdx == -1) {
            return null;
        }
        ClassLoader loader = (ClassLoader)this.classLoaders.get(loaderIdx);
        Class<?> clazz = Class.forName(desc.getName(), false, loader);
        return clazz;
    }

    public int getClassDescriptorIdx(Class<?> clazz) {
        Integer classIdx = (Integer)this.classIndexes.get(clazz);
        if (classIdx == null) {
            classIdx = this.classIndex.getAndIncrement();
            Integer previousIndex = this.classIndexes.putIfAbsent(clazz, classIdx);
            if (previousIndex == null) {
                this.classes.put(classIdx, clazz);
            } else {
                classIdx = previousIndex;
            }
        }
        return classIdx;
    }

    public Class<?> getClassForDescriptorIdx(int descriptorIdx) {
        return (Class)this.classes.get(descriptorIdx);
    }

    @Override
    protected VirtualizationOutput createOutput(JRVirtualizationContext context, OutputStream out) throws IOException {
        return new LocalVirtualizationOutput(out, this, context);
    }

    @Override
    protected VirtualizationInput createInput(JRVirtualizationContext context, InputStream in) throws IOException {
        return new LocalVirtualizationInput(in, this, context);
    }
}

