/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.PrintParts;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.ReadOnlyPartJasperPrint;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInputItem;

public class PrintPartUnrollExporterInput
implements ExporterInput {
    private Class<? extends ReportExportConfiguration> itemConfigurationInterface;
    private List<ExporterInputItem> partItems;

    public PrintPartUnrollExporterInput(ExporterInput exporterInput, Class<? extends ReportExportConfiguration> itemConfigurationInterface) {
        this.itemConfigurationInterface = itemConfigurationInterface;
        this.partItems = new ArrayList<ExporterInputItem>();
        for (ExporterInputItem item : exporterInput.getItems()) {
            JasperPrint jasperPrint = item.getJasperPrint();
            if (jasperPrint.hasParts()) {
                PrintParts parts = jasperPrint.getParts();
                Iterator<Map.Entry<Integer, PrintPart>> it = parts.partsIterator();
                Map.Entry<Integer, PrintPart> part = it.next();
                while (it.hasNext()) {
                    Map.Entry<Integer, PrintPart> next = it.next();
                    this.addPartItem(item, part.getValue(), part.getKey(), next.getKey());
                    part = next;
                }
                this.addPartItem(item, part.getValue(), part.getKey(), jasperPrint.getPages().size());
                continue;
            }
            this.partItems.add(item);
        }
    }

    private void addPartItem(ExporterInputItem item, PrintPart part, int partStartIndex, int partEndIndex) {
        int itemEndIndex;
        JasperPrint jasperPrint = item.getJasperPrint();
        ReportExportConfiguration configuration = item.getConfiguration();
        Integer configStartPageIndex = null;
        Integer configEndPageIndex = null;
        if (configuration != null) {
            Integer configPageIndex = configuration.getPageIndex();
            configStartPageIndex = configPageIndex == null ? configuration.getStartPageIndex() : configPageIndex;
            configEndPageIndex = configPageIndex == null ? configuration.getEndPageIndex() : configPageIndex;
        }
        int itemStartIndex = configStartPageIndex == null ? partStartIndex : Math.max(configStartPageIndex, partStartIndex);
        int n = itemEndIndex = configStartPageIndex == null ? partEndIndex : Math.min(configEndPageIndex + 1, partEndIndex);
        if (itemStartIndex < itemEndIndex) {
            ReadOnlyPartJasperPrint itemJasperPrint = new ReadOnlyPartJasperPrint(jasperPrint, part, partStartIndex, partEndIndex);
            ReportExportConfiguration itemConfiguration = !(configStartPageIndex != null && configStartPageIndex != itemStartIndex - partStartIndex || configEndPageIndex != null && configEndPageIndex != itemEndIndex - partStartIndex - 1) ? configuration : this.overrideConfiguration(configuration, itemStartIndex - partStartIndex, itemEndIndex - partStartIndex - 1);
            this.partItems.add(new SimpleExporterInputItem(itemJasperPrint, itemConfiguration));
        }
    }

    private ReportExportConfiguration overrideConfiguration(final ReportExportConfiguration configuration, final int startIndex, final int endIndex) {
        return (ReportExportConfiguration)Proxy.newProxyInstance(JRAbstractExporter.class.getClassLoader(), new Class[]{this.itemConfigurationInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getPageIndex")) {
                    return null;
                }
                if (method.getName().equals("getStartPageIndex")) {
                    return startIndex;
                }
                if (method.getName().equals("getEndPageIndex")) {
                    return endIndex;
                }
                return method.invoke((Object)configuration, args);
            }
        });
    }

    @Override
    public List<ExporterInputItem> getItems() {
        return this.partItems;
    }
}

