/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.util.StringBufferWriter;
import net.sf.jasperreports.util.StringBuilderWriter;

public class SimpleWriterExporterOutput
implements WriterExporterOutput {
    private final String encoding;
    private Writer writer;
    private boolean toClose;

    public SimpleWriterExporterOutput(StringBuffer sbuffer) {
        this.encoding = "UTF-8";
        if (sbuffer != null) {
            this.writer = new StringBufferWriter(sbuffer);
        }
    }

    public SimpleWriterExporterOutput(StringBuilder sbuilder) {
        this.encoding = "UTF-8";
        if (sbuilder != null) {
            this.writer = new StringBuilderWriter(sbuilder);
        }
    }

    public SimpleWriterExporterOutput(Writer writer) {
        this.encoding = "UTF-8";
        this.writer = writer;
        this.toClose = false;
    }

    public SimpleWriterExporterOutput(OutputStream outputStream) {
        this(outputStream, "UTF-8");
    }

    public SimpleWriterExporterOutput(OutputStream outputStream, String encoding) {
        this.encoding = encoding;
        if (outputStream != null) {
            try {
                this.writer = new OutputStreamWriter(outputStream, encoding);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        this.toClose = false;
    }

    public SimpleWriterExporterOutput(File file) {
        this(file, "UTF-8");
    }

    public SimpleWriterExporterOutput(File file, String encoding) {
        this.encoding = encoding;
        if (file != null) {
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                this.writer = new OutputStreamWriter((OutputStream)os, encoding);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        this.toClose = true;
    }

    public SimpleWriterExporterOutput(String fileName) {
        this(fileName == null ? null : new File(fileName));
    }

    public SimpleWriterExporterOutput(String fileName, String encoding) {
        this(fileName == null ? null : new File(fileName), encoding);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void close() {
        if (this.toClose && this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

