/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import net.sf.jasperreports.engine.util.ObjectUtils;
import net.sf.jasperreports.repo.RepositoryContext;

public class ResourcePathKey {
    private final String contextPath;
    private final String resoucePath;

    public static ResourcePathKey absolute(String resoucePath) {
        return new ResourcePathKey(null, resoucePath);
    }

    public static ResourcePathKey inContext(RepositoryContext repositoryContext, String resoucePath) {
        String contextPath = repositoryContext == null || repositoryContext.getResourceContext() == null ? null : repositoryContext.getResourceContext().getContextLocation();
        return new ResourcePathKey(contextPath, resoucePath);
    }

    public ResourcePathKey(String contextPath, String resoucePath) {
        this.contextPath = contextPath;
        this.resoucePath = resoucePath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getResoucePath() {
        return this.resoucePath;
    }

    public int hashCode() {
        int hash = 47;
        hash = 29 * hash + ObjectUtils.hashCode(this.contextPath);
        hash = 29 * hash + ObjectUtils.hashCode(this.resoucePath);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourcePathKey)) {
            return false;
        }
        ResourcePathKey o = (ResourcePathKey)obj;
        return ObjectUtils.equals(this.contextPath, o.contextPath) && ObjectUtils.equals(this.resoucePath, o.resoucePath);
    }

    public String toString() {
        return "context " + this.contextPath + ", path " + this.resoucePath;
    }
}

