/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.ognl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.struts2.ognl.OgnlCache;

public class OgnlDefaultCache<K, V>
implements OgnlCache<K, V> {
    private final ConcurrentHashMap<K, V> ognlCache;
    private final AtomicInteger cacheEvictionLimit;

    public OgnlDefaultCache(int evictionLimit, int initialCapacity, float loadFactor) {
        this.cacheEvictionLimit = new AtomicInteger(evictionLimit);
        this.ognlCache = new ConcurrentHashMap(initialCapacity, loadFactor);
    }

    @Override
    public V get(K key) {
        return this.ognlCache.get(key);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.ognlCache.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public void put(K key, V value) {
        this.ognlCache.put(key, value);
        this.clearIfEvictionLimitExceeded();
    }

    @Override
    public void putIfAbsent(K key, V value) {
        this.ognlCache.putIfAbsent(key, value);
        this.clearIfEvictionLimitExceeded();
    }

    @Override
    public int size() {
        return this.ognlCache.size();
    }

    @Override
    public void clear() {
        this.ognlCache.clear();
    }

    @Override
    public int getEvictionLimit() {
        return this.cacheEvictionLimit.get();
    }

    @Override
    public void setEvictionLimit(int newCacheEvictionLimit) {
        this.cacheEvictionLimit.set(newCacheEvictionLimit);
    }

    private void clearIfEvictionLimitExceeded() {
        if (this.ognlCache.size() > this.cacheEvictionLimit.get()) {
            this.ognlCache.clear();
        }
    }
}

