/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ObjectFactory;
import org.apache.struts2.inject.Inject;

public class CdiObjectFactory
extends ObjectFactory {
    private static final Logger LOG = LogManager.getLogger(CdiObjectFactory.class);
    public static final String CDI_JNDIKEY_BEANMANAGER_COMP = "java:comp/BeanManager";
    public static final String CDI_JNDIKEY_BEANMANAGER_APP = "java:app/BeanManager";
    public static final String CDI_JNDIKEY_BEANMANAGER_COMP_ENV = "java:comp/env/BeanManager";
    public static final String STRUTS_OBJECT_FACTORY_CDI_JNDI_KEY = "struts.objectFactory.cdi.jndiKey";
    private String jndiKey;
    protected BeanManager beanManager;
    Map<Class<?>, InjectionTarget<?>> injectionTargetCache = new ConcurrentHashMap();

    @Inject(value="struts.objectFactory.cdi.jndiKey", required=false)
    public void setJndiKey(String jndiKey) {
        this.jndiKey = jndiKey;
    }

    public CdiObjectFactory() {
        LOG.info("Initializing Struts2 CDI integration...");
        this.beanManager = this.findBeanManager();
        if (this.beanManager != null) {
            LOG.info("Struts2 CDI integration initialized.");
        } else {
            LOG.error("Struts2 CDI integration could not be initialized.");
        }
    }

    protected BeanManager findBeanManager() {
        BeanManager bm = null;
        try {
            InitialContext initialContext = new InitialContext();
            if (this.jndiKey != null && this.jndiKey.trim().length() > 0) {
                bm = this.lookup(initialContext, this.jndiKey);
            }
            if (bm == null) {
                bm = this.lookup(initialContext, CDI_JNDIKEY_BEANMANAGER_COMP);
            }
            if (bm == null) {
                bm = this.lookup(initialContext, CDI_JNDIKEY_BEANMANAGER_APP);
            }
            if (bm == null) {
                bm = this.lookup(initialContext, CDI_JNDIKEY_BEANMANAGER_COMP_ENV);
            }
            if (bm == null) {
                LOG.error("[findBeanManager]: Could not find BeanManager instance for any given JNDI key, giving up");
            }
        }
        catch (NamingException e) {
            LOG.error("[findBeanManager]: Unable to get InitialContext for BeanManager lookup", (Throwable)e);
        }
        return bm;
    }

    protected BeanManager lookup(Context context, String jndiKeyToCheck) {
        LOG.info("[lookup]: Checking for BeanManager under JNDI key {}", (Object)jndiKeyToCheck);
        BeanManager result = null;
        try {
            result = (BeanManager)context.lookup(jndiKeyToCheck);
        }
        catch (NamingException e) {
            LOG.debug("[lookup]: BeanManager lookup failed for JNDI key {}", (Object)jndiKeyToCheck, (Object)e);
        }
        return result;
    }

    public Object buildBean(String className, Map<String, Object> extraContext, boolean injectInternal) throws Exception {
        Class clazz = this.getClassInstance(className);
        InjectionTarget<?> injectionTarget = this.getInjectionTarget(clazz);
        CreationalContext ctx = this.buildNonContextualCreationalContext(this.beanManager);
        Object o = injectionTarget.produce(ctx);
        injectionTarget.inject(o, ctx);
        injectionTarget.postConstruct(o);
        if (injectInternal) {
            this.injectInternalBeans(o);
        }
        return o;
    }

    protected InjectionTarget<?> getInjectionTarget(Class<?> clazz) {
        InjectionTarget result = this.injectionTargetCache.get(clazz);
        if (result == null) {
            InjectionTargetFactory injectionTargetFactory = this.beanManager.getInjectionTargetFactory(this.beanManager.createAnnotatedType(clazz));
            result = injectionTargetFactory.createInjectionTarget(null);
            this.injectionTargetCache.put(clazz, result);
        }
        return result;
    }

    protected CreationalContext buildNonContextualCreationalContext(BeanManager beanManager) {
        return beanManager != null ? beanManager.createCreationalContext(null) : null;
    }

    public boolean isNoArgConstructorRequired() {
        return false;
    }
}

