/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.beanvalidation.constraints.impl;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.beanvalidation.constraints.FieldMatch;

public class FieldMatchValidator
implements ConstraintValidator<FieldMatch, Object> {
    private static final Logger LOG = LogManager.getLogger(FieldMatchValidator.class);
    private String firstFieldName;
    private String secondFieldName;

    public void initialize(FieldMatch constraintAnnotation) {
        this.firstFieldName = constraintAnnotation.first();
        this.secondFieldName = constraintAnnotation.second();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        try {
            Object firstObj = this.readPropertyValue(value, this.firstFieldName);
            Object secondObj = this.readPropertyValue(value, this.secondFieldName);
            return firstObj == null && secondObj == null || firstObj != null && firstObj.equals(secondObj);
        }
        catch (Exception ex) {
            LOG.info("Error while getting values from object", (Throwable)ex);
            return false;
        }
    }

    private Object readPropertyValue(Object bean, String propertyName) throws Exception {
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            if (!propertyName.equals(descriptor.getName())) continue;
            return descriptor.getReadMethod().invoke(bean, new Object[0]);
        }
        return null;
    }
}

