<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## Change Log

- [3.0.3](#303-tue-jan-9-164807-2023--0300)
- [3.0.2](#302-mon-nov-20-073838-2023--0500)
- [3.0.1](#301-tue-oct-13-103221-2023--0700)
- [3.0.0](#300-thu-aug-24-133627-2023--0600)
- [2.1.3](#213-fri-dec-8-163651-2023--0700)
- [2.1.2](#212-wed-oct-18-165930-2023--0700)
- [2.1.1](#211-sun-apr-23-154421-2023-0100)
- [2.1.0](#210-thu-mar-16-211305-2023--0700)
- [2.0.1](#201-fri-nov-4-103402-2022--0400)
- [2.0.0](#200-tue-jun-28-085302-2022--0400)
- [1.5.3](#153-thu-jan-5-150544-2023--0500)
- [1.5.2](#152-wed-sep-14-171151-2022-0530)
- [1.5.1](#151-thu-may-26-144520-2022-0300)
- [1.5.0](#150-fri-apr-22-172330-2022--0400)
- [1.4.2](#142-sat-mar-19-000806-2022-0200)
- [1.4.1](#141)

### 3.0.3 (Tue Jan 9 16:48:07 2023 -0300)

**Fixes**

- [#26429](https://github.com/apache/superset/pull/26429) fix(post-processing): handle missing values in cumulative operator (@villebro)
- [#26424](https://github.com/apache/superset/pull/26424) fix(translations): Clear all (@capping)
- [#26404](https://github.com/apache/superset/pull/26404) fix(plugin-chart-echarts): support forced categorical x-axis (@villebro)
- [#26415](https://github.com/apache/superset/pull/26415) fix: In chart gallery thumbnail is rendered in case of no example in #16707 (@sivasathyaseeelan)
- [#26393](https://github.com/apache/superset/pull/26393) fix(chart): Resolve incorrect column customization when switching metrics in table chart (@soniagtm)
- [#26313](https://github.com/apache/superset/pull/26313) fix(dashboard): narrow empty drop area (@justinpark)
- [#26410](https://github.com/apache/superset/pull/26410) fix(dashboard): Chart menu disable is fixed on chart-fullscreen in issue #25992 (@sivasathyaseeelan)
- [#26362](https://github.com/apache/superset/pull/26362) fix: Reactivates native filters E2E tests (@michael-s-molina)
- [#26353](https://github.com/apache/superset/pull/26353) fix(SelectControl): select zero value (@rekilina)
- [#26302](https://github.com/apache/superset/pull/26302) fix: Invalid references in the basic template (@michael-s-molina)
- [#26380](https://github.com/apache/superset/pull/26380) fix: Removes non-existent columns in the 2018 FCC Survey dataset (@michael-s-molina)
- [#26151](https://github.com/apache/superset/pull/26151) fix(chart): Set max row limit + removed the option to use an empty row limit value (@CorbinBullard)
- [#26333](https://github.com/apache/superset/pull/26333) fix(logging): Add logging of change_dashboard_filter event for native dashboard filters (@john-bodley)
- [#26326](https://github.com/apache/superset/pull/26326) fix(accessibility): Enable tabbing on sort header of table chart (@arunthirumani)
- [#26340](https://github.com/apache/superset/pull/26340) fix(dashboard): Don't switch to first tab when directPathToChild changes (@kgabryje)
- [#26283](https://github.com/apache/superset/pull/26283) fix(redshift): convert_dttm method for redshift dataset and tests (@gaurav7261)
- [#26281](https://github.com/apache/superset/pull/26281) fix(sql lab): Use quote_schema instead of quote method to format schema name (@guenp)
- [#25967](https://github.com/apache/superset/pull/25967) fix(typings): model_id is a multiple option (@gnought)
- [#26279](https://github.com/apache/superset/pull/26279) fix: Cannot expand initially hidden SQL Lab tab (@michael-s-molina)
- [#26269](https://github.com/apache/superset/pull/26269) fix(plugin-chart-echarts): use scale for truncating x-axis (@villebro)
- [#26264](https://github.com/apache/superset/pull/26264) fix: Stacked charts with numerical columns (@michael-s-molina)
- [#26187](https://github.com/apache/superset/pull/26187) fix: bump pyarrow constraints (CVE-2023-47248) (@cwegener)
- [#26215](https://github.com/apache/superset/pull/26215) fix(plugin-chart-echarts): support truncated numeric x-axis (@villebro)
- [#26199](https://github.com/apache/superset/pull/26199) fix(chart-filter): Avoid column denormalization if not enabled (@Vitor-Avila)
- [#26211](https://github.com/apache/superset/pull/26211) fix: support custom links in markdown (@villebro)
- [#26189](https://github.com/apache/superset/pull/26189) fix(dashboard): title formatting (@nytai)
- [#26207](https://github.com/apache/superset/pull/26207) fix: Includes 90° x-axis label rotation (@michael-s-molina)
- [#26157](https://github.com/apache/superset/pull/26157) fix(init-job): Fix envFrom for init job in helm chart (@sumagoudb)
- [#25878](https://github.com/apache/superset/pull/25878) fix(embedded): Hide sensitive payload data from guest users (@jfrag1)
- [#25894](https://github.com/apache/superset/pull/25894) fix(Alerts/Reports): allow use of ";" separator in slack recipient entry (@rtexelm)
- [#26116](https://github.com/apache/superset/pull/26116) fix(database-import): Support importing a DB connection with a version set (@Vitor-Avila)
- [#26154](https://github.com/apache/superset/pull/26154) fix: set label on adhoc column should persist (@betodealmeida)
- [#26140](https://github.com/apache/superset/pull/26140) fix(annotations): time grain column (@betodealmeida)
- [#23916](https://github.com/apache/superset/pull/23916) fix: remove default secret key from helm (@dpgaspar)
- [#26120](https://github.com/apache/superset/pull/26120) fix: alias column when fetching values (@betodealmeida)
- [#26106](https://github.com/apache/superset/pull/26106) fix: flaky test_explore_json_async test v2 (@villebro)
- [#26091](https://github.com/apache/superset/pull/26091) fix: bump node-fetch to 2.6.7 (@dpgaspar)
- [#26087](https://github.com/apache/superset/pull/26087) fix(plugin-chart-echarts): support numerical x-axis (@villebro)
- [#26059](https://github.com/apache/superset/pull/26059) fix: Flaky test_explore_json_async test (@michael-s-molina)
- [#26023](https://github.com/apache/superset/pull/26023) fix: Prevent cached bootstrap data from leaking between users w/ same first/last name (@jfrag1)
- [#26060](https://github.com/apache/superset/pull/26060) fix: Optimize fetching samples logic (@john-bodley)
- [#26010](https://github.com/apache/superset/pull/26010) fix: Remove annotation Fuzzy to get french translation (@aehanno)
- [#26005](https://github.com/apache/superset/pull/26005) fix(security): restore default value of SESSION_COOKIE_SECURE to False (@sfirke)
- [#25883](https://github.com/apache/superset/pull/25883) fix(horizontal filter bar filter labels): Increase max-width to 96px (@rtexelm)

**Others**

- [#26312](https://github.com/apache/superset/pull/26312) chore(Embedded): Avoid creating a filter key for guest users (@Vitor-Avila)
- [#26317](https://github.com/apache/superset/pull/26317) chore: Adds a tooltip for the alert's SQL input (@michael-s-molina)
- [#26310](https://github.com/apache/superset/pull/26310) chore: Disables minor ticks by default (@michael-s-molina)
- [#26287](https://github.com/apache/superset/pull/26287) chore: update changelog for 2.1.3 (@eschutho)
- [#26251](https://github.com/apache/superset/pull/26251) chore: improve CSP add base uri restriction (@dpgaspar)
- [#26208](https://github.com/apache/superset/pull/26208) chore: Adds note about numerical x-axis (@michael-s-molina)
- [#26158](https://github.com/apache/superset/pull/26158) chore: Clean up the examples dashboards (@michael-s-molina)
- [#25931](https://github.com/apache/superset/pull/25931) chore(deps): bump pillow deps (@gnought)

### 3.0.2 (Mon Nov 20 07:38:38 2023 -0500)

**Fixes**

- [#26037](https://github.com/apache/superset/pull/26037) fix: update FAB to 4.3.10, Azure user info fix (@dpgaspar)
- [#25901](https://github.com/apache/superset/pull/25901) fix(native filters): rendering performance improvement by reduce overrendering (@justinpark)
- [#25985](https://github.com/apache/superset/pull/25985) fix(explore): redandant force param (@justinpark)
- [#25993](https://github.com/apache/superset/pull/25993) fix: Make Select component fire onChange listener when a selection is pasted in (@jfrag1)
- [#25997](https://github.com/apache/superset/pull/25997) fix(rls): Update text from tables to datasets in RLS modal (@yousoph)
- [#25703](https://github.com/apache/superset/pull/25703) fix(helm): Restart all related deployments when bootstrap script changed (@josedev-union)
- [#25973](https://github.com/apache/superset/pull/25973) fix: naming denomalized to denormalized in helpers.py (@hughhhh)
- [#25919](https://github.com/apache/superset/pull/25919) fix: always denorm column value before querying values (@hughhhh)
- [#25947](https://github.com/apache/superset/pull/25947) fix: update flask-caching to avoid breaking redis cache, solves #25339 (@ggbaro)
- [#25903](https://github.com/apache/superset/pull/25903) fix(sqllab): invalid sanitization on comparison symbol (@justinpark)
- [#25857](https://github.com/apache/superset/pull/25857) fix(table): Double percenting ad-hoc percentage metrics (@john-bodley)
- [#25872](https://github.com/apache/superset/pull/25872) fix(trino): allow impersonate_user flag to be imported (@FGrobelny)
- [#25897](https://github.com/apache/superset/pull/25897) fix: trino cursor (@betodealmeida)
- [#25898](https://github.com/apache/superset/pull/25898) fix: database version field (@betodealmeida)
- [#25877](https://github.com/apache/superset/pull/25877) fix: Saving Mixed Chart with dashboard filter applied breaks adhoc_filter_b (@kgabryje)
- [#25842](https://github.com/apache/superset/pull/25842) fix(charts): Time grain is None when dataset uses Jinja (@Antonio-RiveroMartnez)
- [#25843](https://github.com/apache/superset/pull/25843) fix: remove `update_charts_owners` (@betodealmeida)
- [#25707](https://github.com/apache/superset/pull/25707) fix(table chart): Show Cell Bars correctly #25625 (@SA-Ark)
- [#25429](https://github.com/apache/superset/pull/25429) fix: the temporal x-axis results in a none time_range. (@mapledan)
- [#25853](https://github.com/apache/superset/pull/25853) fix: Fires onChange when clearing all values of single select (@michael-s-molina)
- [#25814](https://github.com/apache/superset/pull/25814) fix(sqllab): infinite fetching status after results are landed (@justinpark)
- [#25768](https://github.com/apache/superset/pull/25768) fix(SQL field in edit dataset modal): display full sql query (@rtexelm)
- [#25804](https://github.com/apache/superset/pull/25804) fix: Resolve issue #24195 (@john-bodley)
- [#25801](https://github.com/apache/superset/pull/25801) fix: Revert "fix: Apply normalization to all dttm columns (#25147)" (@john-bodley)
- [#25779](https://github.com/apache/superset/pull/25779) fix: DB-specific quoting in Jinja macro (@betodealmeida)
- [#25640](https://github.com/apache/superset/pull/25640) fix: allow for backward compatible errors (@eschutho)
- [#25741](https://github.com/apache/superset/pull/25741) fix(sqllab): slow pop datasource query (@justinpark)
- [#25756](https://github.com/apache/superset/pull/25756) fix: dataset update uniqueness (@betodealmeida)
- [#25753](https://github.com/apache/superset/pull/25753) fix: Revert "fix(Charts): Set max row limit + removed the option to use an empty row limit value" (@geido)
- [#25732](https://github.com/apache/superset/pull/25732) fix(horizontal filter label): show full tooltip with ellipsis (@rtexelm)
- [#25712](https://github.com/apache/superset/pull/25712) fix: bump to FAB 4.3.9 remove CSP exception (@dpgaspar)
- [#24709](https://github.com/apache/superset/pull/24709) fix(chore): dashboard requests to database equal the number of slices it has (@Always-prog)
- [#25679](https://github.com/apache/superset/pull/25679) fix: remove unnecessary redirect (@Khrol)
- [#25680](https://github.com/apache/superset/pull/25680) fix(sqllab): reinstate "Force trino client async execution" (@giftig)
- [#25657](https://github.com/apache/superset/pull/25657) fix(dremio): Fixes issue with Dremio SQL generation for Charts with Series Limit (@OskarNS)
- [#23638](https://github.com/apache/superset/pull/23638) fix: warning of nth-child (@justinpark)
- [#25658](https://github.com/apache/superset/pull/25658) fix: improve upload ZIP file validation (@dpgaspar)
- [#25495](https://github.com/apache/superset/pull/25495) fix(header navlinks): link navlinks to path prefix (@fisjac)
- [#25112](https://github.com/apache/superset/pull/25112) fix: permalink save/overwrites in explore (@hughhhh)
- [#25493](https://github.com/apache/superset/pull/25493) fix(import): Make sure query context is overwritten for overwriting imports (@jfrag1)
- [#25553](https://github.com/apache/superset/pull/25553) fix: avoid 500 errors with SQLLAB_BACKEND_PERSISTENCE (@Khrol)
- [#25626](https://github.com/apache/superset/pull/25626) fix(sqllab): template validation error within comments (@justinpark)
- [#25523](https://github.com/apache/superset/pull/25523) fix(sqllab): Mistitled for new tab after rename (@justinpark)

**Others**

- [#25995](https://github.com/apache/superset/pull/25995) chore: Optimize fetching samples logic (@john-bodley)
- [#23619](https://github.com/apache/superset/pull/23619) chore(colors): Updating Airbnb brand colors (@john-bodley)

### 3.0.1 (Tue Oct 13 10:32:21 2023 -0700)

**Database Migrations**

- [#25320](https://github.com/apache/superset/pull/25320) fix: Add explicit ON DELETE CASCADE for dashboard_roles (@john-bodley)

**Fixes**

- [#25541](https://github.com/apache/superset/pull/25541) fix: revert fix(sqllab): Force trino client async execution (#24859) (@villebro)
- [#25618](https://github.com/apache/superset/pull/25618) fix: finestTemporalGrainFormatter (@betodealmeida)
- [#25599](https://github.com/apache/superset/pull/25599) fix(window): unavailable localStorage and sessionStorage (@frassinier)
- [#25579](https://github.com/apache/superset/pull/25579) fix(Charts): Set max row limit + removed the option to use an empty row limit value (@CorbinBullard)
- [#25559](https://github.com/apache/superset/pull/25559) fix(Presto): catch DatabaseError when testing Presto views (@zhaorui2022)
- [#25486](https://github.com/apache/superset/pull/25486) fix: thubmnails loading - Talisman default config (@Khrol)
- [#25400](https://github.com/apache/superset/pull/25400) fix(RLS): Fix Info Tooltip + Button Alignment on RLS Modal (@CorbinBullard)
- [#25590](https://github.com/apache/superset/pull/25590) fix: REST API CSRF exempt list (@dpgaspar)
- [#25147](https://github.com/apache/superset/pull/25147) fix: Apply normalization to all dttm columns (@kgabryje)
- [#25516](https://github.com/apache/superset/pull/25516) fix: tags permissions error message (@Khrol)
- [#25519](https://github.com/apache/superset/pull/25519) fix: Expand error detail on screencapture (@justinpark)
- [#25490](https://github.com/apache/superset/pull/25490) fix(sqllab): Broken query containing 'children' (@justinpark)
- [#25390](https://github.com/apache/superset/pull/25390) fix: Unable to sync columns when database or dataset name contains `+` (@mapledan)
- [#25494](https://github.com/apache/superset/pull/25494) fix: Address Mypy issue which is causing CI to fail (@john-bodley)
- [#25469](https://github.com/apache/superset/pull/25469) fix(sqllab): error with lazy_gettext for tab titles (@nytai)
- [#25468](https://github.com/apache/superset/pull/25468) fix: Styles not loading because of faulty CSP setting (@kgabryje)
- [#24241](https://github.com/apache/superset/pull/24241) fix(mysql): handle string typed decimal results (@villebro)
- [#25373](https://github.com/apache/superset/pull/25373) fix(helm chart): set chart appVersion to 3.0.0 (@celalettin1286)
- [#25445](https://github.com/apache/superset/pull/25445) fix: update the SQLAlchemy model definition at json column for Log table (@cnabro)
- [#25447](https://github.com/apache/superset/pull/25447) fix: Duplicate items when pasting into Select (@michael-s-molina)
- [#25372](https://github.com/apache/superset/pull/25372) fix(SqlLab): make icon placement even (@CorbinBullard)
- [#25282](https://github.com/apache/superset/pull/25282) fix(nativeFilters): Speed up native filters by removing unnecessary rerenders (@Always-prog)
- [#25437](https://github.com/apache/superset/pull/25437) fix(sqllab): invalid start date (@justinpark)
- [#25404](https://github.com/apache/superset/pull/25404) fix: smarter date formatter (@betodealmeida)
- [#25368](https://github.com/apache/superset/pull/25368) fix: swagger UI CSP error (@dpgaspar)
- [#25425](https://github.com/apache/superset/pull/25425) fix: chart import (@betodealmeida)
- [#25106](https://github.com/apache/superset/pull/25106) fix: preventing save button from flickering in SQL Lab (@fisjac)
- [#25424](https://github.com/apache/superset/pull/25424) fix: Rename on_delete parameter to ondelete (@john-bodley)
- [#25398](https://github.com/apache/superset/pull/25398) fix(sqllab): invalid persisted tab state (#25308) (@justinpark)
- [#25399](https://github.com/apache/superset/pull/25399) fix: Workaround for Cypress ECONNRESET error (@michael-s-molina)
- [#25318](https://github.com/apache/superset/pull/25318) fix: datetime with timezone excel export (@betodealmeida)
- [#25349](https://github.com/apache/superset/pull/25349) fix: DashboardRoles cascade operation (@michael-s-molina)
- [#25239](https://github.com/apache/superset/pull/25239) fix: Improve the reliability of alerts & reports (@jfrag1)
- [#25229](https://github.com/apache/superset/pull/25229) fix: Use RLS clause instead of ID for cache key (@jfrag1)
- [#25126](https://github.com/apache/superset/pull/25126) fix(chart): Supporting custom SQL as temporal x-axis column with filter (@zephyring)
- [#25290](https://github.com/apache/superset/pull/25290) fix: is_select with UNION (@betodealmeida)

### 3.0.0 (Thu Aug 24 13:36:27 2023 -0600)

**Database Migrations**

- [#25053](https://github.com/apache/superset/pull/25053) fix: extend user email size (@dpgaspar)
- [#24982](https://github.com/apache/superset/pull/24982) fix(snowflake): opt-in denormalization of column names (@villebro)
- [#24939](https://github.com/apache/superset/pull/24939) chore: Add explicit ON DELETE CASCADE for embedded_dashboards (@john-bodley)
- [#24938](https://github.com/apache/superset/pull/24938) chore: Add explicit ON DELETE CASCADE for dashboard_slices (@john-bodley)
- [#24911](https://github.com/apache/superset/pull/24911) fix(logs): increase json field for logs table (@cnabro)
- [#24884](https://github.com/apache/superset/pull/24884) fix: Migration to fix out of sync schema_perm in charts and datasets (@jfrag1)
- [#24831](https://github.com/apache/superset/pull/24831) fix(migration): Ensure cascadeParentIds key exists (@john-bodley)
- [#24510](https://github.com/apache/superset/pull/24510) fix(dashboard): increase json_metadata field (@cnabro)
- [#24749](https://github.com/apache/superset/pull/24749) fix(native filter): clean deleted parent filter ids (@justinpark)
- [#24737](https://github.com/apache/superset/pull/24737) fix(druid): Delete obsolete Druid NoSQL slice parameters (@john-bodley)
- [#24628](https://github.com/apache/superset/pull/24628) chore(dao): Add explicit ON DELETE CASCADE for ownership (@john-bodley)
- [#24661](https://github.com/apache/superset/pull/24661) fix: Ensure config is a dict in cross filters scope migration (@kgabryje)
- [#24629](https://github.com/apache/superset/pull/24629) chore: Drop rouge constraints and tables (@john-bodley)
- [#24558](https://github.com/apache/superset/pull/24558) chore: better styling alerts/reports modal (@betodealmeida)
- [#24547](https://github.com/apache/superset/pull/24547) feat: customize screenshot width for alerts/reports (@betodealmeida)
- [#24553](https://github.com/apache/superset/pull/24553) feat: add description column to Tags (@hughhhh)
- [#24548](https://github.com/apache/superset/pull/24548) fix: heads (@betodealmeida)
- [#24488](https://github.com/apache/superset/pull/24488) chore(dao): Add explicit ON DELETE CASCADE when deleting datasets (@john-bodley)
- [#24517](https://github.com/apache/superset/pull/24517) feat: Implement currencies formatter for saved metrics (@kgabryje)
- [#24266](https://github.com/apache/superset/pull/24266) chore: Remove deprecated ENABLE_ACCESS_REQUEST workflow (@john-bodley)
- [#23910](https://github.com/apache/superset/pull/23910) feat: Migrates Dual Line Chart to Mixed Chart (@michael-s-molina)
- [#23741](https://github.com/apache/superset/pull/23741) feat: Migrates TreeMap chart (@michael-s-molina)
- [#23712](https://github.com/apache/superset/pull/23712) feat: Migrates Pivot Table v1 to v2 (@michael-s-molina)
- [#24306](https://github.com/apache/superset/pull/24306) chore: reorder k-v migration for 2.1.1 (@villebro)
- [#24280](https://github.com/apache/superset/pull/24280) fix: ensure json is not None (@eschutho)
- [#24197](https://github.com/apache/superset/pull/24197) chore(pre-commit): Add pyupgrade and pycln hooks (@john-bodley)
- [#24127](https://github.com/apache/superset/pull/24127) chore: Embrace the walrus operator (@john-bodley)
- [#24020](https://github.com/apache/superset/pull/24020) feat: Cross filters scoping (@kgabryje)
- [#23942](https://github.com/apache/superset/pull/23942) fix: update migration chart_ds_constraint to have seperate batch op (@hughhhh)
- [#23925](https://github.com/apache/superset/pull/23925) fix(migration): add log for values unseen in `Slice.datasource_type` (@hughhhh)
- [#23614](https://github.com/apache/superset/pull/23614) chore: add check constraint to restrict `Slice` models datasource_type != "table" (@hughhhh)
- [#23650](https://github.com/apache/superset/pull/23650) fix(migration): Only attempt to drop types if they exist (@jfrag1)
- [#23526](https://github.com/apache/superset/pull/23526) fix(tags): convert postgres enum type to varchar (@nytai)
- [#23410](https://github.com/apache/superset/pull/23410) feat(echarts): Implement stream graph for Echarts Timeseries (@kgabryje)
- [#23173](https://github.com/apache/superset/pull/23173) chore: Update pre-commit packages (@hughhhh)
- [#23276](https://github.com/apache/superset/pull/23276) fix(migration): Address issue in #23228 (@john-bodley)
- [#23273](https://github.com/apache/superset/pull/23273) fix(plugin-chart-echarts): render horizontal categories from top (@villebro)
- [#23228](https://github.com/apache/superset/pull/23228) chore: Deprecate show_native_filters (@john-bodley)
- [#19677](https://github.com/apache/superset/pull/19677) chore(backend): Spelling (@jsoref)

**Features**

- [#24718](https://github.com/apache/superset/pull/24718) feat: Add currencies controls in control panels (@kgabryje)
- [#24960](https://github.com/apache/superset/pull/24960) feat: Adds options to show subtotals in Pivot Table (@michael-s-molina)
- [#24703](https://github.com/apache/superset/pull/24703) feat: migrate charts on import (@betodealmeida)
- [#24433](https://github.com/apache/superset/pull/24433) feat: use Scarf Gateway for Superset npm downloads (@arjundevarajan)
- [#24432](https://github.com/apache/superset/pull/24432) feat: use Scarf Gateway for Superset helm charts/Docker compose downloads (@arjundevarajan)
- [#24329](https://github.com/apache/superset/pull/24329) feat(sqllab): add shortcut for run current sql (@justinpark)
- [#24594](https://github.com/apache/superset/pull/24594) feat: Implement support for currencies in more charts (@kgabryje)
- [#24549](https://github.com/apache/superset/pull/24549) feat: screenshot reports with custom width (@betodealmeida)
- [#24518](https://github.com/apache/superset/pull/24518) feat(tags): move tags from navbar to settings (@hughhhh)
- [#24277](https://github.com/apache/superset/pull/24277) feat(docker): Add support LDAP/AD authorization (@alekseyolg)
- [#24388](https://github.com/apache/superset/pull/24388) feat: Allows new values for single value filters (@michael-s-molina)
- [#24287](https://github.com/apache/superset/pull/24287) feat: add dashboard page full xlsx export (@vitoldi)
- [#24368](https://github.com/apache/superset/pull/24368) feat: make data tables support html (@mistercrunch)
- [#24369](https://github.com/apache/superset/pull/24369) feat(sshtunnel): add configuration for SSH_TIMEOUT (@hughhhh)
- [#24348](https://github.com/apache/superset/pull/24348) feat: add a tooltip to clarify metric_name in the DatasetEditor (@mistercrunch)
- [#24043](https://github.com/apache/superset/pull/24043) feat: Configurable default row limit for native filters (@cleslie)
- [#24345](https://github.com/apache/superset/pull/24345) feat: Convert ENABLE_BROAD_ACTIVITY_ACCESS and MENU_HIDE_USER_INFO into feature flags (@michael-s-molina)
- [#23943](https://github.com/apache/superset/pull/23943) feat: Removes the preset-chart-xy plugin (@michael-s-molina)
- [#23933](https://github.com/apache/superset/pull/23933) feat: Removes the Multiple Line Charts (@michael-s-molina)
- [#24237](https://github.com/apache/superset/pull/24237) feat: support complex types and use get_columns implementation of starrrocks python client (@miomiocat)
- [#24205](https://github.com/apache/superset/pull/24205) feat(sqllab): SQLEditor Extension (@Antonio-RiveroMartnez)
- [#24232](https://github.com/apache/superset/pull/24232) feat(flags): enabling and deprecating a few feature flags (@rusackas)
- [#24191](https://github.com/apache/superset/pull/24191) feat: extension hook for DB delete (@betodealmeida)
- [#23209](https://github.com/apache/superset/pull/23209) feat: Add StarRocks support (@miomiocat)
- [#24067](https://github.com/apache/superset/pull/24067) feat: split database information (@betodealmeida)
- [#23551](https://github.com/apache/superset/pull/23551) feat: Add deck.gl Heatmap Visualization (@Mattc1221)
- [#24005](https://github.com/apache/superset/pull/24005) feat: dashboard page xlsx export (@vitoldi)
- [#23174](https://github.com/apache/superset/pull/23174) feat: database extension registry (@betodealmeida)
- [#24048](https://github.com/apache/superset/pull/24048) feat: Make time shifted series colors match the original series (@michael-s-molina)
- [#23035](https://github.com/apache/superset/pull/23035) feat: Use AntD table in FilterableTable (@EugeneTorap)
- [#24035](https://github.com/apache/superset/pull/24035) feat: implement time grain in temporal filters (@villebro)
- [#23970](https://github.com/apache/superset/pull/23970) feat(chart-controls): Show detailed data type tooltip when hovering type icon (@ved-kashyap-samsung)
- [#23890](https://github.com/apache/superset/pull/23890) feat!: bump to Python3.9 (@sebastianliebscher)
- [#23975](https://github.com/apache/superset/pull/23975) feat: Allows dynamic type on viz migrations (@michael-s-molina)
- [#23917](https://github.com/apache/superset/pull/23917) feat: Adds a control to set the Secondary Y-axis bounds in Mixed charts (@michael-s-molina)
- [#23905](https://github.com/apache/superset/pull/23905) feat: Considers GENERIC_CHART_AXES in viz migrations (@michael-s-molina)
- [#20075](https://github.com/apache/superset/pull/20075) feat: custom d3 number locale (@ebaratte)
- [#23869](https://github.com/apache/superset/pull/23869) feat: Changes the Select component to preserve the search value when selecting (@michael-s-molina)
- [#23064](https://github.com/apache/superset/pull/23064) feat: conditional coloring for big number chart (@gbusch)
- [#23698](https://github.com/apache/superset/pull/23698) feat: format timestamps in drill by breadcrumbs (@lilykuang)
- [#23655](https://github.com/apache/superset/pull/23655) feat: add verbose map to get /dataset/ endpoint (@lilykuang)
- [#23716](https://github.com/apache/superset/pull/23716) feat: create dtype option for csv upload (@eschutho)
- [#23777](https://github.com/apache/superset/pull/23777) feat(revert): Re-introduces the RLS page (@michael-s-molina)
- [#22812](https://github.com/apache/superset/pull/22812) feat: Add Ocient support (@alexclavel-ocient)
- [#23768](https://github.com/apache/superset/pull/23768) feat: Display both queries result in Table mode for Mixed Chart in drill by modal (@kgabryje)
- [#23269](https://github.com/apache/superset/pull/23269) feat(native-filters): Add legacy (filter-box) to native filter migration script (@john-bodley)
- [#23748](https://github.com/apache/superset/pull/23748) feat(adhoc-column): add resize option (@villebro)
- [#23724](https://github.com/apache/superset/pull/23724) feat: Drill by error management (@kgabryje)
- [#23634](https://github.com/apache/superset/pull/23634) feat: Makes "Add to dashboard" in Save chart modal paginated (@michael-s-molina)
- [#23697](https://github.com/apache/superset/pull/23697) feat: Add loading state to sqllab save/overwrite dataset modal (@jfrag1)
- [#23720](https://github.com/apache/superset/pull/23720) feat(sqllab): add headers when copying results to clipboard (@villebro)
- [#23707](https://github.com/apache/superset/pull/23707) feat(helm): update redis version due to critical CVE (HIGH PRIORITY) (@justmike1)
- [#23664](https://github.com/apache/superset/pull/23664) feat: Implement breadcrumbs in Drill By modal (@kgabryje)
- [#23644](https://github.com/apache/superset/pull/23644) feat(plugin-chart-echarts): add x-axis sort to multi series (@villebro)
- [#23615](https://github.com/apache/superset/pull/23615) feat: Support further drill by in the modal (@kgabryje)
- [#23657](https://github.com/apache/superset/pull/23657) feat(dashboard): make color indices referable (@villebro)
- [#23603](https://github.com/apache/superset/pull/23603) feat: implement drill by table (@lilykuang)
- [#23402](https://github.com/apache/superset/pull/23402) feat(lang): update messages.po(t) and add missing German translations (@hbruch)
- [#23328](https://github.com/apache/superset/pull/23328) feat(wrap-text): Wrap text support for specific columns in Grid (@SamraHanifCareem)
- [#23601](https://github.com/apache/superset/pull/23601) feat(helm): ability to disable helm hooks (@justmike1)
- [#23602](https://github.com/apache/superset/pull/23602) feat(snowflake): `get_catalog_names` (@betodealmeida)
- [#23599](https://github.com/apache/superset/pull/23599) feat(presto): `get_catalog_names` (@betodealmeida)
- [#23547](https://github.com/apache/superset/pull/23547) feat: Shows user charts by default when editing a dashboard (@michael-s-molina)
- [#23590](https://github.com/apache/superset/pull/23590) feat: Enables ECharts legend selector (@michael-s-molina)
- [#23594](https://github.com/apache/superset/pull/23594) feat(helm): Upgrade default Superset version to 2.1.0 (@dnskr)
- [#23461](https://github.com/apache/superset/pull/23461) feat(bigquery): `get_catalog_names` (@betodealmeida)
- [#23575](https://github.com/apache/superset/pull/23575) feat: Drill by open in Explore (@kgabryje)
- [#23542](https://github.com/apache/superset/pull/23542) feat: Add metadata bar to drill by modal (@kgabryje)
- [#23524](https://github.com/apache/superset/pull/23524) feat: drill by display chart (@lilykuang)
- [#23509](https://github.com/apache/superset/pull/23509) feat(cross-filters): using verbose map in applied cross-filters (@Always-prog)
- [#23439](https://github.com/apache/superset/pull/23439) feat: add ability to disable cache (@villebro)
- [#23458](https://github.com/apache/superset/pull/23458) feat: drill by modal (@lilykuang)
- [#23454](https://github.com/apache/superset/pull/23454) feat: Implement context menu for drill by (@kgabryje)
- [#23416](https://github.com/apache/superset/pull/23416) feat(helm): add nodeselector and tolerations to init job (@dim-ops)
- [#23459](https://github.com/apache/superset/pull/23459) feat: Allows reload on default filter value error (@michael-s-molina)
- [#23447](https://github.com/apache/superset/pull/23447) feat(DB engine spec): `get_catalog_names` (@betodealmeida)
- [#23450](https://github.com/apache/superset/pull/23450) feat(echarts): Add x axis sort by to all series charts (@kgabryje)
- [#23415](https://github.com/apache/superset/pull/23415) feat: add new cache_query_by_user key (@eschutho)
- [#23377](https://github.com/apache/superset/pull/23377) feat(sqllab): log error_detail on fetch failed (@justinpark)
- [#23338](https://github.com/apache/superset/pull/23338) feat(chart): Added SriLanka country map (@rukshn)
- [#23401](https://github.com/apache/superset/pull/23401) feat(postgresql): dynamic schema (@betodealmeida)
- [#23392](https://github.com/apache/superset/pull/23392) feat(plugin-chart-echarts): add series sorting (@villebro)
- [#23319](https://github.com/apache/superset/pull/23319) feat(native-filters): allow cascading from time and numeric filters (@villebro)
- [#23350](https://github.com/apache/superset/pull/23350) feat(dashboard): Change default opacity of icon in FiltersBadge (@kgabryje)
- [#23286](https://github.com/apache/superset/pull/23286) feat(dashboard): Refactor FiltersBadge (@kgabryje)
- [#23287](https://github.com/apache/superset/pull/23287) feat(docs): adds BugHerd to documentation site. (@rusackas)
- [#23274](https://github.com/apache/superset/pull/23274) feat(generic-x-axis): add x sorting on series limit metric (@villebro)
- [#23138](https://github.com/apache/superset/pull/23138) feat: Cross Filters in FilterBar (@geido)
- [#23099](https://github.com/apache/superset/pull/23099) feat(ssh_tunnel): Import/Export Databases with SSHTunnel credentials (@Antonio-RiveroMartnez)
- [#23141](https://github.com/apache/superset/pull/23141) feat(dashboard): Add cross filter from context menu (@kgabryje)
- [#22886](https://github.com/apache/superset/pull/22886) feat: Enable cross fitlers in WorldMap and Graph charts (@kgabryje)
- [#23143](https://github.com/apache/superset/pull/23143) feat: return UUID on database creation (@betodealmeida)
- [#20876](https://github.com/apache/superset/pull/20876) feat: Frontend tagging (@cccs-RyanK)

**Fixes**

- [#25217](https://github.com/apache/superset/pull/25217) fix: inability to remove chart filter when dashboard time filter is applied (@lilykuang)
- [#25268](https://github.com/apache/superset/pull/25268) fix: Add line height to metadata bar (@kgabryje)
- [#25251](https://github.com/apache/superset/pull/25251) fix(dockefile): broken docker image (@hugosjoberg)
- [#25248](https://github.com/apache/superset/pull/25248) fix: Currency formatting in Table raw mode (@kgabryje)
- [#25249](https://github.com/apache/superset/pull/25249) fix: Don't apply number formatting to the label in Treemap (@kgabryje)
- [#25238](https://github.com/apache/superset/pull/25238) fix: Clearing the currency format has no effect on the chart (@michael-s-molina)
- [#25223](https://github.com/apache/superset/pull/25223) fix: Cypress test to force mouseover (follow-up) (@michael-s-molina)
- [#25213](https://github.com/apache/superset/pull/25213) fix: granularity_sqla and GENERIC_CHART_AXES (@betodealmeida)
- [#24859](https://github.com/apache/superset/pull/24859) fix(sqllab): Force trino client async execution (@giftig)
- [#25209](https://github.com/apache/superset/pull/25209) fix: Cypress test to force mouseover (@michael-s-molina)
- [#25189](https://github.com/apache/superset/pull/25189) fix: `is_select` (@betodealmeida)
- [#25202](https://github.com/apache/superset/pull/25202) fix: All values being selected in Select (@michael-s-molina)
- [#25190](https://github.com/apache/superset/pull/25190) fix: DML failures in SQL Lab (@hughhhh)
- [#25157](https://github.com/apache/superset/pull/25157) fix: Issue #24493; Resolved report selection menu in chart and dashboard page (@suicide11)
- [#25156](https://github.com/apache/superset/pull/25156) fix: Applying Dashboard Time Range Filters to Overwritten Charts (@lilykuang)
- [#25133](https://github.com/apache/superset/pull/25133) fix(sqllab): Invalid start date (@justinpark)
- [#25159](https://github.com/apache/superset/pull/25159) fix: Sunburst chart error when secondary metric is null (@michael-s-molina)
- [#20078](https://github.com/apache/superset/pull/20078) fix: Fixing untranslated FR strings (@aehanno)
- [#25150](https://github.com/apache/superset/pull/25150) fix: Chart series limit doesn't work for some databases (@KSPT-taylorjohn)
- [#25135](https://github.com/apache/superset/pull/25135) fix: Handle Python date format for GENERIC_CHART_AXES feature (@john-bodley)
- [#24711](https://github.com/apache/superset/pull/24711) fix: add format for timestamp in crdb to correctly use times values (@elewis787)
- [#25090](https://github.com/apache/superset/pull/25090) fix: Bumps Flask Caching to fix RCE vulnerability (@michael-s-molina)
- [#25119](https://github.com/apache/superset/pull/25119) fix(DB Connection): Update placeholder values for Snowflake connection (@Vitor-Avila)
- [#25113](https://github.com/apache/superset/pull/25113) fix: Date format when importing international timestamps (@michael-s-molina)
- [#25114](https://github.com/apache/superset/pull/25114) fix(sqllab): error while removing a referenced table (@justinpark)
- [#25091](https://github.com/apache/superset/pull/25091) fix(sqllab): rendering performance regression by resultset (@justinpark)
- [#25081](https://github.com/apache/superset/pull/25081) fix: Allow embedded guest user datasource access with dashboard context (@jfrag1)
- [#25086](https://github.com/apache/superset/pull/25086) fix(assets import): Ensure old datasource ids are not referenced in imported charts (@jfrag1)
- [#25087](https://github.com/apache/superset/pull/25087) fix: Filter names overflow wrap (@michael-s-molina)
- [#25043](https://github.com/apache/superset/pull/25043) fix: dataset update permission out of sync (@zephyring)
- [#25020](https://github.com/apache/superset/pull/25020) fix(embedded sdk): Remove trailing slash from passed superset domain if there is one (@jfrag1)
- [#25074](https://github.com/apache/superset/pull/25074) fix: Cross filters initial scope (@michael-s-molina)
- [#24008](https://github.com/apache/superset/pull/24008) fix(table): condition formatting can't formate 0 values (@Always-prog)
- [#21255](https://github.com/apache/superset/pull/21255) fix(cli): import-directory is missing the application context (@rdubois)
- [#25031](https://github.com/apache/superset/pull/25031) fix: Ensure SQLAlchemy sessions are closed (@john-bodley)
- [#24686](https://github.com/apache/superset/pull/24686) fix: dataset safe URL for explore_url (@dpgaspar)
- [#25057](https://github.com/apache/superset/pull/25057) fix: Error when using the legacy dataset editor (@michael-s-molina)
- [#25029](https://github.com/apache/superset/pull/25029) fix: Native filter dashboard RBAC aware dataset permission (@john-bodley)
- [#25055](https://github.com/apache/superset/pull/25055) fix: docker-compose non-dev (@michael-s-molina)
- [#24999](https://github.com/apache/superset/pull/24999) fix(mssql): avoid trying to return a resultset for DML queries with not resultset (@Yuval-Moshe)
- [#25014](https://github.com/apache/superset/pull/25014) fix: CTE queries with non-SELECT statements (@dpgaspar)
- [#25028](https://github.com/apache/superset/pull/25028) fix: Dashboard fullscreen is removing custom URL params (@michael-s-molina)
- [#25008](https://github.com/apache/superset/pull/25008) fix: Address regression introduced in #24789 (@john-bodley)
- [#24991](https://github.com/apache/superset/pull/24991) fix: Don't let users see dashboards only because it's favorited (@jfrag1)
- [#25017](https://github.com/apache/superset/pull/25017) fix: Downgrades Prophet to 1.1.1 and Holidays to 0.23 (@michael-s-molina)
- [#25009](https://github.com/apache/superset/pull/25009) fix: Date column in Heatmap is displayed as unix timestamp (@michael-s-molina)
- [#24965](https://github.com/apache/superset/pull/24965) fix(sqllab): scroll position after run current sql (@justinpark)
- [#24989](https://github.com/apache/superset/pull/24989) fix: Calendar Heatmap day offset (@michael-s-molina)
- [#24906](https://github.com/apache/superset/pull/24906) fix: Duplicated options in Select when using numerical values (@michael-s-molina)
- [#24959](https://github.com/apache/superset/pull/24959) fix: Tooltips don't disappear on the Heatmap chart (@michael-s-molina)
- [#24953](https://github.com/apache/superset/pull/24953) fix: calls to `_get_sqla_engine` (@betodealmeida)
- [#24903](https://github.com/apache/superset/pull/24903) fix(charts): View in SQL Lab with relevant perm (@giftig)
- [#24946](https://github.com/apache/superset/pull/24946) fix: remove unused file (@mdeshmu)
- [#24806](https://github.com/apache/superset/pull/24806) fix: Dashboard aware RBAC "Save as" menu item (@john-bodley)
- [#24916](https://github.com/apache/superset/pull/24916) fix: Tooltip of area chart shows undefined total (@michael-s-molina)
- [#24886](https://github.com/apache/superset/pull/24886) fix(explore): double resize triggered (@justinpark)
- [#24789](https://github.com/apache/superset/pull/24789) fix: Dashboard aware RBAC dataset permission (@john-bodley)
- [#24892](https://github.com/apache/superset/pull/24892) fix: revert "fix(embedded): adding logic to check dataset used by filters (#24808) (@john-bodley)
- [#24829](https://github.com/apache/superset/pull/24829) fix(dataset): resizable dataset layout left column (@justinpark)
- [#24876](https://github.com/apache/superset/pull/24876) fix(explore): invalid "No Filter" applied (@justinpark)
- [#24874](https://github.com/apache/superset/pull/24874) fix(annotation): Address regression from #24694 (@john-bodley)
- [#24849](https://github.com/apache/superset/pull/24849) fix: validation errors appearing after ssh tunnel switch (@hughhhh)
- [#24862](https://github.com/apache/superset/pull/24862) fix: Explore misleading save action (@michael-s-molina)
- [#24847](https://github.com/apache/superset/pull/24847) fix(sqllab): Add docText for long keyword (@justinpark)
- [#24850](https://github.com/apache/superset/pull/24850) fix(legacy-chart): corrupted raw chart data (@justinpark)
- [#24846](https://github.com/apache/superset/pull/24846) fix: Links in tooltips of dashboard chart cards (@michael-s-molina)
- [#24808](https://github.com/apache/superset/pull/24808) fix(embedded): adding logic to check dataset used by filters (@Vitor-Avila)
- [#24803](https://github.com/apache/superset/pull/24803) fix: Python3.11 (str, Enum) issue (@EugeneTorap)
- [#24796](https://github.com/apache/superset/pull/24796) fix(datasets): give possibility to add dataset with slashes in name (@Always-prog)
- [#24821](https://github.com/apache/superset/pull/24821) fix: Allow chart import to update the dataset an existing chart points to (@jfrag1)
- [#24814](https://github.com/apache/superset/pull/24814) fix: Removes unnecessary query on filters (@michael-s-molina)
- [#24815](https://github.com/apache/superset/pull/24815) fix: pass schema on dataset creation (@betodealmeida)
- [#24801](https://github.com/apache/superset/pull/24801) fix: Filters alert width (@michael-s-molina)
- [#24677](https://github.com/apache/superset/pull/24677) fix(sqllab): Replace autocomplete logic by a hook (@justinpark)
- [#24816](https://github.com/apache/superset/pull/24816) fix: docs invalid client redirect (@dpgaspar)
- [#23988](https://github.com/apache/superset/pull/23988) fix: Department names fixed for CountryMap of France (@xavier-GitHub76)
- [#24798](https://github.com/apache/superset/pull/24798) fix(chore): switching between languages should be without timeout 60 seconds (@Always-prog)
- [#24772](https://github.com/apache/superset/pull/24772) fix(sqllab): Replace margin style by gap on query results (@justinpark)
- [#24698](https://github.com/apache/superset/pull/24698) fix: Select onChange is being fired without explicit selection (@michael-s-molina)
- [#24747](https://github.com/apache/superset/pull/24747) fix: update svgr webpack config to use svg dimensions (@eschutho)
- [#23816](https://github.com/apache/superset/pull/23816) fix(docs): respect no_proxy environment variable (@karsten-wagner)
- [#24756](https://github.com/apache/superset/pull/24756) fix: Tooltip no longer highlights hovered data series (@michael-s-molina)
- [#24740](https://github.com/apache/superset/pull/24740) fix: column/metric type icons look too small (@mistercrunch)
- [#24739](https://github.com/apache/superset/pull/24739) fix: `search_path` in RDS (@betodealmeida)
- [#24599](https://github.com/apache/superset/pull/24599) fix(datasets): Replace left panel layout by TableSelector (@justinpark)
- [#24710](https://github.com/apache/superset/pull/24710) fix(pvt2): migrations from legacy pivot table error when form_data have pieces of pvt2 (@Always-prog)
- [#24746](https://github.com/apache/superset/pull/24746) fix: Dashboard time grain in Table (@michael-s-molina)
- [#24716](https://github.com/apache/superset/pull/24716) fix(range-slider): removed localization of metric key (@Always-prog)
- [#24671](https://github.com/apache/superset/pull/24671) fix(cache): Add cache warmup for non-legacy charts (@john-bodley)
- [#24670](https://github.com/apache/superset/pull/24670) fix: color collision in dashboard with tabs (@lilykuang)
- [#24663](https://github.com/apache/superset/pull/24663) fix(dataset-import): support empty strings for extra fields (@Vitor-Avila)
- [#24690](https://github.com/apache/superset/pull/24690) fix: embedded dashboard check (@betodealmeida)
- [#24665](https://github.com/apache/superset/pull/24665) fix: Dashboard time grain in Pivot Table (@michael-s-molina)
- [#24611](https://github.com/apache/superset/pull/24611) fix(sqllab): missing column meta on autocomplete (@justinpark)
- [#24630](https://github.com/apache/superset/pull/24630) fix: Chart can be added to dashboard by non-owner via save as option (@jfrag1)
- [#24642](https://github.com/apache/superset/pull/24642) fix: Incorrect initial global scoping of cross filters (@kgabryje)
- [#24610](https://github.com/apache/superset/pull/24610) fix: Validation of out of scope filters and interaction with Clear All (@michael-s-molina)
- [#24646](https://github.com/apache/superset/pull/24646) fix: CSP, bump FAB to 4.3.4 (@dpgaspar)
- [#24625](https://github.com/apache/superset/pull/24625) fix: fix extra insert for count on dataset creation (@hughhhh)
- [#24643](https://github.com/apache/superset/pull/24643) fix: Ensure metrics is an array in Mixed Chart (@kgabryje)
- [#24644](https://github.com/apache/superset/pull/24644) fix: remove spaces and EOL from nonce attr (@dpgaspar)
- [#24617](https://github.com/apache/superset/pull/24617) fix: Wrong positioning of filter tooltips on scroll (@michael-s-molina)
- [#24609](https://github.com/apache/superset/pull/24609) fix: change naming convention for count metric on Dataset creation (@hughhhh)
- [#24567](https://github.com/apache/superset/pull/24567) fix: remove underscore from builtin_time_grains label (@cnabro)
- [#24608](https://github.com/apache/superset/pull/24608) fix: Incorrect dependency between filters related feature flags (@michael-s-molina)
- [#24612](https://github.com/apache/superset/pull/24612) fix(report): edit without custom width (@betodealmeida)
- [#24552](https://github.com/apache/superset/pull/24552) fix(ssh): Editting Database w/ SSH Tunneling (@hughhhh)
- [#24556](https://github.com/apache/superset/pull/24556) fix: set max version for pyocient (@jwilliams-ocient)
- [#24129](https://github.com/apache/superset/pull/24129) fix: Bump prophet, re-enable tests, and remedy column eligibility logic (@john-bodley)
- [#24593](https://github.com/apache/superset/pull/24593) fix: Clicking on a tag in the dashboard and charts lists does not work (@michael-s-molina)
- [#24196](https://github.com/apache/superset/pull/24196) fix: SSH Tunnel creation with dynamic form (@hughhhh)
- [#24555](https://github.com/apache/superset/pull/24555) fix: Metric is truncated in tooltip (@michael-s-molina)
- [#24565](https://github.com/apache/superset/pull/24565) fix: docker compose refusing to start (@dpgaspar)
- [#24536](https://github.com/apache/superset/pull/24536) fix(sqllab): Add threshold for checking inactive queries (@justinpark)
- [#24546](https://github.com/apache/superset/pull/24546) fix: Error when searching for a dashboard in the chart list (@michael-s-molina)
- [#24550](https://github.com/apache/superset/pull/24550) fix: Deque mutated during iteration (@michael-s-molina)
- [#24541](https://github.com/apache/superset/pull/24541) fix(docs): Typo in filter migration. (@Hikari)
- [#24475](https://github.com/apache/superset/pull/24475) fix(translations): typo mistake (translation to Spanish) (@santi-pragma)
- [#24519](https://github.com/apache/superset/pull/24519) fix: SQL Lab - correct setting name from DISPLAY_MAX_ROWS to DISPLAY_MAX_ROW (@jgillick)
- [#24537](https://github.com/apache/superset/pull/24537) fix: Use Celery task ETA for alert/report schedule (@john-bodley)
- [#24545](https://github.com/apache/superset/pull/24545) fix: Revert enable strong session protection by default (#24256) (@michael-s-molina)
- [#24544](https://github.com/apache/superset/pull/24544) fix: Release scripts Python version (@michael-s-molina)
- [#24542](https://github.com/apache/superset/pull/24542) fix(native-filters): Infinite load when filter with default first value is out of scope in horizontal bar (@kgabryje)
- [#24492](https://github.com/apache/superset/pull/24492) fix(charts): big-number display broken in echarts (@curious86)
- [#24506](https://github.com/apache/superset/pull/24506) fix: Native filter dynamic numeric search (@john-bodley)
- [#24477](https://github.com/apache/superset/pull/24477) fix: Total calculation in stacked Timeseries charts (@michael-s-molina)
- [#24471](https://github.com/apache/superset/pull/24471) fix(oracle): denormalize column names where applicable (@villebro)
- [#24476](https://github.com/apache/superset/pull/24476) fix: Revert enabling CSP (@kgabryje)
- [#24418](https://github.com/apache/superset/pull/24418) fix: Native filter dynamic numeric search (@john-bodley)
- [#24447](https://github.com/apache/superset/pull/24447) fix(charts): Fix chart load task error handling (@giftig)
- [#24405](https://github.com/apache/superset/pull/24405) fix: creating a new chart with dashboard time filters but filter can't apply again (@lilykuang)
- [#24434](https://github.com/apache/superset/pull/24434) fix: Revert to old endpoint temporarily to enable sharing saved queries (@jfrag1)
- [#24248](https://github.com/apache/superset/pull/24248) fix: save columns reference from sqllab save datasets flow (@hughhhh)
- [#24429](https://github.com/apache/superset/pull/24429) fix: Viz migration adjustments - 2 (@michael-s-molina)
- [#24440](https://github.com/apache/superset/pull/24440) fix(translations): regularise the capitalisation of 'CSV' in en localisation (@stuartyeates)
- [#24410](https://github.com/apache/superset/pull/24410) fix: force data load on import examples (@eschutho)
- [#24422](https://github.com/apache/superset/pull/24422) fix(sql-lab): remove redundant onChange schema property (@villebro)
- [#24420](https://github.com/apache/superset/pull/24420) fix: FE call to changed recent_activity endpoint (@dpgaspar)
- [#24428](https://github.com/apache/superset/pull/24428) fix: deck.gl Geojson path not visible (@kgabryje)
- [#24392](https://github.com/apache/superset/pull/24392) fix: Fixes #24391 (Problems with celery beat running with docker when the machine is rebooted suddenly) (@alvarolmedo)
- [#24221](https://github.com/apache/superset/pull/24221) fix(helm): Add fullname prefix to init job (@NickLarsenNZ)
- [#24121](https://github.com/apache/superset/pull/24121) fix: Address regression introduced in #22853 (@john-bodley)
- [#24143](https://github.com/apache/superset/pull/24143) fix: Ensure "Import Dashboard" menu item adheres to PVM (@john-bodley)
- [#24350](https://github.com/apache/superset/pull/24350) fix: Address dashboard permission regression in #23586 (@john-bodley)
- [#24363](https://github.com/apache/superset/pull/24363) fix: deck.gl Scatterplot min/max radius (@kgabryje)
- [#24344](https://github.com/apache/superset/pull/24344) fix(sqllab): Inefficient SqlaTable query (#24343) (@giftig)
- [#24341](https://github.com/apache/superset/pull/24341) fix: Viz migration adjustments - 1 (@michael-s-molina)
- [#24317](https://github.com/apache/superset/pull/24317) fix: update order of build for testing a release (@eschutho)
- [#24303](https://github.com/apache/superset/pull/24303) fix: Copy dashboard filters when copying dashboard (@jfrag1)
- [#24176](https://github.com/apache/superset/pull/24176) fix: Time shifts with different granularity for ECharts (@michael-s-molina)
- [#24315](https://github.com/apache/superset/pull/24315) fix: DB extension collapse (@betodealmeida)
- [#19808](https://github.com/apache/superset/pull/19808) fix(sql-lab): SQL Lab commit connection even if no CTA query is made (@snt1017)
- [#24265](https://github.com/apache/superset/pull/24265) fix(capitalization): Capitalizing the 'metric' label in Pivot Tables (@rusackas)
- [#24304](https://github.com/apache/superset/pull/24304) fix(dashboard): max call size stack error (@justinpark)
- [#24293](https://github.com/apache/superset/pull/24293) fix: Removes file extension from textUtils (@michael-s-molina)
- [#24291](https://github.com/apache/superset/pull/24291) fix: Text utils null value when reading module (@michael-s-molina)
- [#24279](https://github.com/apache/superset/pull/24279) fix(migrations): Fixing cross filter migration (@craig-rueda)
- [#24279](https://github.com/apache/superset/pull/24279) fix(migrations): Fixing cross filter migration (@craig-rueda)
- [#24256](https://github.com/apache/superset/pull/24256) fix: enable strong session protection by default (@dpgaspar)
- [#23562](https://github.com/apache/superset/pull/23562) fix(docs): Update databricks.mdx with correct pip package name (@amosdoublec)
- [#24217](https://github.com/apache/superset/pull/24217) fix: Typescript warnings when importing types (@michael-s-molina)
- [#24222](https://github.com/apache/superset/pull/24222) fix(helm): Use correct default hostnames for postgres and redis (@NickLarsenNZ)
- [#24242](https://github.com/apache/superset/pull/24242) fix(dataset-api): allow undefined schema in post (@villebro)
- [#24207](https://github.com/apache/superset/pull/24207) fix: removing problematic "formattable" tag (@rusackas)
- [#24223](https://github.com/apache/superset/pull/24223) fix: Tag link issue from CRUD page (@hughhhh)
- [#24181](https://github.com/apache/superset/pull/24181) fix(translation): complete portuguese(brazilian) translation (@lucas1221)
- [#24177](https://github.com/apache/superset/pull/24177) fix(explore): rendering regression on standalone (@justinpark)
- [#24186](https://github.com/apache/superset/pull/24186) fix(plugin-chart-echarts): force min y-tick for log axis with zero (@villebro)
- [#24060](https://github.com/apache/superset/pull/24060) fix: always allow tags to be returned via the API (@hughhhh)
- [#24142](https://github.com/apache/superset/pull/24142) fix(sqllab): Table options rendering regression (@justinpark)
- [#24113](https://github.com/apache/superset/pull/24113) fix: Errors when saving dataset (@jfrag1)
- [#24158](https://github.com/apache/superset/pull/24158) fix(table): percentage metric should use verbose map (@Always-prog)
- [#24159](https://github.com/apache/superset/pull/24159) fix(reports): error when creation alert/report with localization (@Always-prog)
- [#23762](https://github.com/apache/superset/pull/23762) fix: repeated color in the same chart (@lilykuang)
- [#24124](https://github.com/apache/superset/pull/24124) fix: Revert tox basepython (@john-bodley)
- [#24134](https://github.com/apache/superset/pull/24134) fix(plugin-chart-echarts): normalize temporal string groupbys (@villebro)
- [#24120](https://github.com/apache/superset/pull/24120) fix(sqllab): Disable Select All on table selector (@justinpark)
- [#24114](https://github.com/apache/superset/pull/24114) fix(ci): remove username from owner (@villebro)
- [#23814](https://github.com/apache/superset/pull/23814) fix(ocient): convert pyocient GIS data types to geoJSON (@jwilliams-ocient)
- [#23867](https://github.com/apache/superset/pull/23867) fix(docs): Installation instruction changes (@artofcomputing)
- [#24070](https://github.com/apache/superset/pull/24070) fix(alert modal): set current user as default alert owner during new alert initialization (@curious86)
- [#24068](https://github.com/apache/superset/pull/24068) fix: Handle python_date_format in ExploreMixin (@john-bodley)
- [#24062](https://github.com/apache/superset/pull/24062) fix: handle `python_date_format` in ExploreMixin (@betodealmeida)
- [#24028](https://github.com/apache/superset/pull/24028) fix: typing and using enter to select the table on sql lab layout (@lilykuang)
- [#24009](https://github.com/apache/superset/pull/24009) fix(sqllab): rollback clean comments out (@justinpark)
- [#23971](https://github.com/apache/superset/pull/23971) fix: MySQL et al. super calls (@john-bodley)
- [#23715](https://github.com/apache/superset/pull/23715) fix(filters): Stop breaking if translateToSql returns an object (@Antonio-RiveroMartnez)
- [#23952](https://github.com/apache/superset/pull/23952) fix(sqllab): custom url params disappeared (@justinpark)
- [#23935](https://github.com/apache/superset/pull/23935) fix: methods incorrect type and update deprecated targets (@dpgaspar)
- [#23908](https://github.com/apache/superset/pull/23908) fix(sqllab): clean comments within quotes (@justinpark)
- [#23924](https://github.com/apache/superset/pull/23924) fix: timeout should be an integer (@betodealmeida)
- [#23892](https://github.com/apache/superset/pull/23892) fix(sql-editor): Fix run stop button color to improve usability (@curious86)
- [#23909](https://github.com/apache/superset/pull/23909) fix: remove feature flag for tags on Dashboard API for `Tags` (@hughhhh)
- [#23881](https://github.com/apache/superset/pull/23881) fix(native-filters): Address spelling mistakes (@john-bodley)
- [#23778](https://github.com/apache/superset/pull/23778) fix(chart): scrollbar keep flusing on and off (@justinpark)
- [#23868](https://github.com/apache/superset/pull/23868) fix: move dynamic schema out of base Postgres class (@hughhhh)
- [#23702](https://github.com/apache/superset/pull/23702) fix: npm run dev-server error resolved (@Abhishek-kumar-samsung)
- [#23872](https://github.com/apache/superset/pull/23872) fix(dremio): query with alias (@betodealmeida)
- [#23860](https://github.com/apache/superset/pull/23860) fix(alerts): flaky test error (@justinpark)
- [#23832](https://github.com/apache/superset/pull/23832) fix(native-filters): Address spelling mistakes (@john-bodley)
- [#23856](https://github.com/apache/superset/pull/23856) fix(tests): Ensure deterministic SELECT ordering for CSV upload tests (@john-bodley)
- [#23627](https://github.com/apache/superset/pull/23627) fix(chart): chart updates are not retained (@justinpark)
- [#23857](https://github.com/apache/superset/pull/23857) fix(ephemerals): Quick fix for ephemeral spin-up (@craig-rueda)
- [#23831](https://github.com/apache/superset/pull/23831) fix: Preserve filters from previous drillings in drill by (@kgabryje)
- [#23830](https://github.com/apache/superset/pull/23830) fix: Loading state when cols for drill by are loading (@kgabryje)
- [#23818](https://github.com/apache/superset/pull/23818) fix(revert): Reverts storybook-addon-mock inclusion (@michael-s-molina)
- [#23685](https://github.com/apache/superset/pull/23685) fix(utils): evaluate date parser multiple holiday results correctly (@arkid15r)
- [#23811](https://github.com/apache/superset/pull/23811) fix: Hide FiltersPanel in standalone mode 3 (@geido)
- [#23731](https://github.com/apache/superset/pull/23731) fix: pivot v2 charts created before `GENERIC_CHART_AXES` is enabled (@betodealmeida)
- [#23819](https://github.com/apache/superset/pull/23819) fix: Clean up docker-ephemeral-env secrets command (@michael-s-molina)
- [#23817](https://github.com/apache/superset/pull/23817) fix(rls api): Add missing init file (@jfrag1)
- [#23805](https://github.com/apache/superset/pull/23805) fix(sqllab): test failed due to legacy api url (@justinpark)
- [#23783](https://github.com/apache/superset/pull/23783) fix(datasource): saving new calculated columns (@Always-prog)
- [#23786](https://github.com/apache/superset/pull/23786) fix: Docker ephemeral env (@michael-s-molina)
- [#23797](https://github.com/apache/superset/pull/23797) fix: Context menu crashing when there is no dimension in Echarts Series charts (@kgabryje)
- [#23776](https://github.com/apache/superset/pull/23776) fix: [chart power query] error show when user input column with x-axis (@hughhhh)
- [#23779](https://github.com/apache/superset/pull/23779) fix(native-filters): Fix encoding of non-temporal default values (@john-bodley)
- [#23087](https://github.com/apache/superset/pull/23087) fix(sqllab): Persisting tab state for saved query (@piyush9923)
- [#23757](https://github.com/apache/superset/pull/23757) fix: Drill by modal resizing (@kgabryje)
- [#23754](https://github.com/apache/superset/pull/23754) fix: Further drilling by different groupby fields (@kgabryje)
- [#23758](https://github.com/apache/superset/pull/23758) fix: Make sure the DeprecatedSelect label is always a string (@michael-s-molina)
- [#23157](https://github.com/apache/superset/pull/23157) fix(cache): coerce schema_cache_timeout to None (@cemremengu)
- [#23747](https://github.com/apache/superset/pull/23747) fix(ace-editor): use monospace fonts by default (@villebro)
- [#23737](https://github.com/apache/superset/pull/23737) fix: get or create db with an existing invalid URL (@dpgaspar)
- [#23669](https://github.com/apache/superset/pull/23669) fix(sqllab): infinite running state on disconnect (@justinpark)
- [#22370](https://github.com/apache/superset/pull/22370) fix: is_select check for lowercase select with "WITH" clauses (@fcomuniz)
- [#23695](https://github.com/apache/superset/pull/23695) fix(sqllab): rendering performance regression (@justinpark)
- [#23686](https://github.com/apache/superset/pull/23686) fix: Database modal parameter inputs persisting after modal closed and reopened (@jfrag1)
- [#23675](https://github.com/apache/superset/pull/23675) fix(plugin-chart-echarts): reorder totals and support multimetric sort (@villebro)
- [#23117](https://github.com/apache/superset/pull/23117) fix(ci): Fix GitHub workflow behavior for forks (@jsoref)
- [#23692](https://github.com/apache/superset/pull/23692) fix: Further drill by in Pivot Table (@kgabryje)
- [#23649](https://github.com/apache/superset/pull/23649) fix: Zero values on Dual Line axis bounds (@michael-s-molina)
- [#23641](https://github.com/apache/superset/pull/23641) fix: url_params cache miss with global async query (@kekwan)
- [#23682](https://github.com/apache/superset/pull/23682) fix: allow for dependencies that could be undefined (@eschutho)
- [#23624](https://github.com/apache/superset/pull/23624) fix(docker): optimize docker build by better utilizing build cache (@sebastianliebscher)
- [#23671](https://github.com/apache/superset/pull/23671) fix(sqllab): Revert "rendering performance regression (#23653)" (@justinpark)
- [#23666](https://github.com/apache/superset/pull/23666) fix: presto CI failed test (@hughhhh)
- [#23604](https://github.com/apache/superset/pull/23604) fix: update log message for ALERT_REPORTS_NOTIFICATION_DRY_RUN (@nytai)
- [#23653](https://github.com/apache/superset/pull/23653) fix(sqllab): rendering performance regression (@justinpark)
- [#23637](https://github.com/apache/superset/pull/23637) fix: Removes Redux state mutations - iteration 3 (@michael-s-molina)
- [#23611](https://github.com/apache/superset/pull/23611) fix(saved_queries): wrong enum for object_type of saved_query (@akzarma)
- [#23396](https://github.com/apache/superset/pull/23396) fix(Gauge echart): displaying column label (@AkashBoora)
- [#22677](https://github.com/apache/superset/pull/22677) fix(localization): localize legacy pivot table (@artemonsh)
- [#23589](https://github.com/apache/superset/pull/23589) fix(charts): Time range filters are not being applied to charts that were overwritten (@Antonio-RiveroMartnez)
- [#23421](https://github.com/apache/superset/pull/23421) fix(#23176): adding URL decoding to SQLAlchemy URI (@RekhaZemoso)
- [#23617](https://github.com/apache/superset/pull/23617) fix: Error on Cypress test (@michael-s-molina)
- [#23588](https://github.com/apache/superset/pull/23588) fix: Disables email reports for unsaved charts (@michael-s-molina)
- [#23597](https://github.com/apache/superset/pull/23597) fix: Ensure verbose mapping exists for SQL Lab Query model (@john-bodley)
- [#23613](https://github.com/apache/superset/pull/23613) fix: Increases the options limit for Annotation Layers (@michael-s-molina)
- [#23587](https://github.com/apache/superset/pull/23587) fix(docker-compose): Make worker use correct healthcheck (#23455) (@sebastianliebscher)
- [#23129](https://github.com/apache/superset/pull/23129) fix(translation): correct translation errors for Chinese(zh) (@zRich)
- [#23585](https://github.com/apache/superset/pull/23585) fix: Ensure the reporting framework handles charts with no data (@john-bodley)
- [#23579](https://github.com/apache/superset/pull/23579) fix(revert): "fix: cache warmup solution non legacy charts. (#23012)" (@john-bodley)
- [#23535](https://github.com/apache/superset/pull/23535) fix: Removes Redux state mutations - iteration 2 (@michael-s-molina)
- [#23576](https://github.com/apache/superset/pull/23576) fix(dashboard): Cross filters badge for cols with verbose names (@kgabryje)
- [#23567](https://github.com/apache/superset/pull/23567) fix: QueryParamProvider error on backend rendered views (@michael-s-molina)
- [#23548](https://github.com/apache/superset/pull/23548) fix: tags features flag on base models (@hughhhh)
- [#23565](https://github.com/apache/superset/pull/23565) fix: Add default empty array to filter dependencies (@dayknightmare)
- [#23533](https://github.com/apache/superset/pull/23533) fix(plugin-chart-table): Include time control (@kgabryje)
- [#23549](https://github.com/apache/superset/pull/23549) fix(sqllab): undefined issue_codes on query error (@justinpark)
- [#23543](https://github.com/apache/superset/pull/23543) fix: Hide FilterBar for Reports (@geido)
- [#23514](https://github.com/apache/superset/pull/23514) fix(sqllab): dedupe table_schemas in active_tab (@justinpark)
- [#23522](https://github.com/apache/superset/pull/23522) fix: Removes Redux state mutations - iteration 1 (@michael-s-molina)
- [#22880](https://github.com/apache/superset/pull/22880) fix: moved alerts and reports default values to config (@Always-prog)
- [#23469](https://github.com/apache/superset/pull/23469) fix(area chart legacy): tool tip shows actual value rather than y axi… (@AkashBoora)
- [#23137](https://github.com/apache/superset/pull/23137) fix(conditional formatting): controls looses on save (@Always-prog)
- [#23517](https://github.com/apache/superset/pull/23517) fix(word cloud): series label format fixed for custom sql queries (@ashgorithm)
- [#23513](https://github.com/apache/superset/pull/23513) fix(plugin-generator): Addresses linter errors in newly generated Superset plugin (@alex-bain)
- [#23521](https://github.com/apache/superset/pull/23521) fix(dashboards): apply tag filter correctly (@akzarma)
- [#23515](https://github.com/apache/superset/pull/23515) fix(plugin-chart-table): Invalid d3Formatter on String column (@justinpark)
- [#23475](https://github.com/apache/superset/pull/23475) fix: Preserves selected scopes when toggling between scope types (@michael-s-molina)
- [#23502](https://github.com/apache/superset/pull/23502) fix(dashboard): Add remark plugin on markdown (@justinpark)
- [#23480](https://github.com/apache/superset/pull/23480) fix: Chart crashing if timeseries_limit_metric is an empty array (@kgabryje)
- [#23378](https://github.com/apache/superset/pull/23378) fix(sqllab): throw errors of commented out query (@justinpark)
- [#23471](https://github.com/apache/superset/pull/23471) fix: broken helm chart ingress (@paulinjo)
- [#23452](https://github.com/apache/superset/pull/23452) fix(chart): add missing toleration for init-job (@ZeJ0hn)
- [#23265](https://github.com/apache/superset/pull/23265) fix(sqllab): dedupe active_tab in tabHistory (@justinpark)
- [#23446](https://github.com/apache/superset/pull/23446) fix: Allow setting ingress hosts directly through yaml (@paulinjo)
- [#23414](https://github.com/apache/superset/pull/23414) fix: prevent ForeignKeyViolation error on delete (@betodealmeida)
- [#23386](https://github.com/apache/superset/pull/23386) fix: schedule query option showing up (@betodealmeida)
- [#23432](https://github.com/apache/superset/pull/23432) fix: safe check when computing chart thumbnail (@zephyring)
- [#23433](https://github.com/apache/superset/pull/23433) fix: database dropdown keys (@betodealmeida)
- [#23389](https://github.com/apache/superset/pull/23389) fix(dashboard): `show_native_filters` leftover (@betodealmeida)
- [#23409](https://github.com/apache/superset/pull/23409) fix(docker): multi-architecture image build (@EugeneTorap)
- [#23330](https://github.com/apache/superset/pull/23330) fix: revert back to use security manager authz for dashboard when get by uuid (@zephyring)
- [#23318](https://github.com/apache/superset/pull/23318) fix: Table sorting reset (@geido)
- [#23376](https://github.com/apache/superset/pull/23376) fix: dataset_macro (@betodealmeida)
- [#23356](https://github.com/apache/superset/pull/23356) fix: table schema permissions (@betodealmeida)
- [#23314](https://github.com/apache/superset/pull/23314) fix(native-filters): Caching scope (@john-bodley)
- [#23365](https://github.com/apache/superset/pull/23365) fix(chart-controls): Error if x_axis_sort and timeseries_limit_metric are included in main metrics (@kgabryje)
- [#23361](https://github.com/apache/superset/pull/23361) fix(safari): remove autocomplete in table select (@villebro)
- [#23302](https://github.com/apache/superset/pull/23302) fix(sqllab): empty large query results from localStorage (@justinpark)
- [#23322](https://github.com/apache/superset/pull/23322) fix(examples): Cleanup granularity_sqla column (@john-bodley)
- [#23324](https://github.com/apache/superset/pull/23324) fix(trino): Disallow alias to source column (@john-bodley)
- [#23329](https://github.com/apache/superset/pull/23329) fix(dashboard): deepmerge htmlSchemaOverrides (@justinpark)
- [#23348](https://github.com/apache/superset/pull/23348) fix: dashboard DAO small code improvement (@dpgaspar)
- [#23347](https://github.com/apache/superset/pull/23347) fix(dashboard): Cross filters with time shifted series (@kgabryje)
- [#23339](https://github.com/apache/superset/pull/23339) fix(trino): normalize non-iso timestamps (@villebro)
- [#23296](https://github.com/apache/superset/pull/23296) fix(clickhouse): Update to working clickhouse-connect version (@genzgd)
- [#23260](https://github.com/apache/superset/pull/23260) fix(examples): Cleanup dashboard filter scopes (@john-bodley)
- [#23283](https://github.com/apache/superset/pull/23283) fix(dashboard): Allow selecting text in cells in Table and PivotTable without triggering cross filters (@kgabryje)
- [#23262](https://github.com/apache/superset/pull/23262) fix: ignore ts warnings from older typescript versions (@eschutho)
- [#23256](https://github.com/apache/superset/pull/23256) fix(dashboard): Missing filter card styles (@kgabryje)
- [#23250](https://github.com/apache/superset/pull/23250) fix(dashboard): Cross-filter search icon in filter bar (@kgabryje)
- [#23242](https://github.com/apache/superset/pull/23242) fix: Video Game Sales dashboard default filters (@john-bodley)
- [#23239](https://github.com/apache/superset/pull/23239) fix(explore): Dashboard filters on adhoc cols not working in Explore (@kgabryje)
- [#23194](https://github.com/apache/superset/pull/23194) fix(dashboard): Cross-filters not working properly for new dashboards (@kgabryje)
- [#23215](https://github.com/apache/superset/pull/23215) fix(dashboard): Page crashing when cross filter applied on adhoc column (@kgabryje)
- [#23202](https://github.com/apache/superset/pull/23202) fix(docs): Change postgres to postgresql in brew install command (@lyndsiWilliams)
- [#23130](https://github.com/apache/superset/pull/23130) fix: Pagination of VirtualTable (@EugeneTorap)
- [#23022](https://github.com/apache/superset/pull/23022) fix(dashboard): Chart's empty state not centered (@kgabryje)
- [#23135](https://github.com/apache/superset/pull/23135) fix: gamma sql_json test (@dpgaspar)
- [#23126](https://github.com/apache/superset/pull/23126) fix(ci): explicity set yaml Loader (@villebro)

**Others**

- [#25275](https://github.com/apache/superset/pull/25275) chore: Remove the ability to switch to filter-box chart when DASHBOARD_NATIVE_FILTERS feature is enabled (@john-bodley)
- [#25211](https://github.com/apache/superset/pull/25211) chore(trino): remove unnecessary index checks (@villebro)
- [#25161](https://github.com/apache/superset/pull/25161) chore: Add a note about adhoc subqueries in UPDATING.md (@michael-s-molina)
- [#25127](https://github.com/apache/superset/pull/25127) docs: Fix typo in UPDATING.md (@john-bodley)
- [#25129](https://github.com/apache/superset/pull/25129) refactor(frontend): make "Search" box the first filter for charts and datasets (@sfirke)
- [#25115](https://github.com/apache/superset/pull/25115) docs: Update UPDATING.md regarding potential breaking change to `ab_user.email` column (@john-bodley)
- [#24942](https://github.com/apache/superset/pull/24942) refactor(pinot): The `python_date_format` for a temporal column was not being passed to `get_timestamp_expr` (@ege-st)
- [#24826](https://github.com/apache/superset/pull/24826) chore: remove CssTemplate and Annotation access from gamma role (@lilykuang)
- [#25016](https://github.com/apache/superset/pull/25016) chore: use os.getenv to simplify superset_config.py (@sebastianliebscher)
- [#25025](https://github.com/apache/superset/pull/25025) chore: Pass the dashboard id when requesting filter values (@michael-s-molina)
- [#25003](https://github.com/apache/superset/pull/25003) chore: isolate examples database by default (@dpgaspar)
- [#24923](https://github.com/apache/superset/pull/24923) chore: modify UPDATING.md for logs table migrations (@cnabro)
- [#24324](https://github.com/apache/superset/pull/24324) chore: rate limit requests (@betodealmeida)
- [#24935](https://github.com/apache/superset/pull/24935) chore: Removes duplicated featureFlags.ts (@michael-s-molina)
- [#24864](https://github.com/apache/superset/pull/24864) chore: Refine native dashboard cleanup logic (@john-bodley)
- [#24804](https://github.com/apache/superset/pull/24804) chore: Refactor dashboard security access (@john-bodley)
- [#24774](https://github.com/apache/superset/pull/24774) chore: add talisman env var to config (@eschutho)
- [#24613](https://github.com/apache/superset/pull/24613) build(deps): bump tox from 4.6.3 to 4.6.4 in /requirements (@dependabot[bot])
- [#24769](https://github.com/apache/superset/pull/24769) docs: update security policy and add CVE info (@dpgaspar)
- [#24758](https://github.com/apache/superset/pull/24758) chore(view_api): return application/json as content-type for api/v1/form_data endpoint (@zephyring)
- [#24759](https://github.com/apache/superset/pull/24759) chore(docs): Adding link to additional visualization content (@rusackas)
- [#24766](https://github.com/apache/superset/pull/24766) docs: Fix STANDARD_ROLES.md for Gamma role permissions on tableschemaview (@mattitoo)
- [#24736](https://github.com/apache/superset/pull/24736) chore: make control panel sub sections look better (@mistercrunch)
- [#24559](https://github.com/apache/superset/pull/24559) chore(native filters): Expandable filter config modal (@justinpark)
- [#24741](https://github.com/apache/superset/pull/24741) chore: make antd table font size same as data table (@mistercrunch)
- [#24627](https://github.com/apache/superset/pull/24627) chore: turn off talisman for ephemeral environments in ci (@eschutho)
- [#24731](https://github.com/apache/superset/pull/24731) chore: Bump PyYAML bounds (@john-bodley)
- [#24694](https://github.com/apache/superset/pull/24694) chore: Remove obsolete legacy visualizations (@john-bodley)
- [#24689](https://github.com/apache/superset/pull/24689) chore: move deprecated default version to 4.0.0 (@dpgaspar)
- [#24607](https://github.com/apache/superset/pull/24607) chore(command): Condense delete/bulk-delete operations (@john-bodley)
- [#24647](https://github.com/apache/superset/pull/24647) chore: Bump holidays to 0.28 (@arkid15r)
- [#24652](https://github.com/apache/superset/pull/24652) chore: Bump/relax Flask libs (@john-bodley)
- [#24466](https://github.com/apache/superset/pull/24466) chore(dao): Condense delete/bulk-delete operations (@john-bodley)
- [#24554](https://github.com/apache/superset/pull/24554) chore(sqllab): Log current local storage usage (@justinpark)
- [#24452](https://github.com/apache/superset/pull/24452) build(deps): bump tox from 4.6.1 to 4.6.3 in /requirements (@dependabot[bot])
- [#24524](https://github.com/apache/superset/pull/24524) build(deps-dev): bump @types/node from 20.3.1 to 20.3.2 in /superset-websocket (@dependabot[bot])
- [#24522](https://github.com/apache/superset/pull/24522) build(deps-dev): bump @typescript-eslint/parser from 5.60.0 to 5.60.1 in /superset-websocket (@dependabot[bot])
- [#24501](https://github.com/apache/superset/pull/24501) build(deps): bump semver from 7.3.8 to 7.5.3 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#24404](https://github.com/apache/superset/pull/24404) chore: deprecate FLASK_ENV and improve conf.ENVIRONMENT_TAG_CONFIG (@mistercrunch)
- [#24534](https://github.com/apache/superset/pull/24534) build(docker): add dockerize image (@alekseyolg)
- [#24462](https://github.com/apache/superset/pull/24462) docs: updating images and markdown (@rusackas)
- [#24543](https://github.com/apache/superset/pull/24543) chore: Un-revert enabling CSP by default (@kgabryje)
- [#24514](https://github.com/apache/superset/pull/24514) refactor: pkg_resources -> importlib.metadata (@cwegener)
- [#24538](https://github.com/apache/superset/pull/24538) chore: Constrain selenium version (@john-bodley)
- [#24505](https://github.com/apache/superset/pull/24505) chore: update d3-colors (@hughhhh)
- [#24499](https://github.com/apache/superset/pull/24499) chore: remove marshmallow-enum dependency and bump FAB (@dpgaspar)
- [#24504](https://github.com/apache/superset/pull/24504) build(docker): simplification of assembly to facilitate further support (@alekseyolg)
- [#24503](https://github.com/apache/superset/pull/24503) chore: update ansi-regex (@hughhhh)
- [#24489](https://github.com/apache/superset/pull/24489) chore(sqllab): add extra_json on tabstate (@justinpark)
- [#24497](https://github.com/apache/superset/pull/24497) build(docker): pin the underlying debain base image (@boenshao)
- [#24371](https://github.com/apache/superset/pull/24371) chore(sqllab): Remove table metadata from state (@justinpark)
- [#24443](https://github.com/apache/superset/pull/24443) build(deps-dev): bump eslint from 8.42.0 to 8.43.0 in /superset-websocket (@dependabot[bot])
- [#24454](https://github.com/apache/superset/pull/24454) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.11 to 5.60.0 in /superset-websocket (@dependabot[bot])
- [#24474](https://github.com/apache/superset/pull/24474) docs: Add CTA to community calendar subscription (@thiagorossener)
- [#24465](https://github.com/apache/superset/pull/24465) chore(dao): Add generic type for better type checking (@john-bodley)
- [#24397](https://github.com/apache/superset/pull/24397) build(deps): bump pre-commit from 3.3.2 to 3.3.3 in /requirements (@dependabot[bot])
- [#24453](https://github.com/apache/superset/pull/24453) build(deps-dev): bump @typescript-eslint/parser from 5.59.11 to 5.60.0 in /superset-websocket (@dependabot[bot])
- [#24262](https://github.com/apache/superset/pull/24262) chore: Enable CSP by default (@kgabryje)
- [#23853](https://github.com/apache/superset/pull/23853) chore: Migrate warm up cache endpoint to api v1 (@jfrag1)
- [#24331](https://github.com/apache/superset/pull/24331) chore(dao): Organize DAOs according to SIP-92 (@john-bodley)
- [#23835](https://github.com/apache/superset/pull/23835) docs: Show clickable link instead of code-formatting (@rusackas)
- [#24437](https://github.com/apache/superset/pull/24437) chore: toning down grayscale on X icon (@mistercrunch)
- [#24415](https://github.com/apache/superset/pull/24415) chore: Remove obsolete Druid NoSQL REGEX operator (@john-bodley)
- [#24419](https://github.com/apache/superset/pull/24419) build(deps): bump tox from 4.6.0 to 4.6.1 in /requirements (@dependabot[bot])
- [#24378](https://github.com/apache/superset/pull/24378) build(deps-dev): bump @types/node from 20.2.5 to 20.3.1 in /superset-websocket (@dependabot[bot])
- [#24403](https://github.com/apache/superset/pull/24403) chore: cleanup sqlalchemy warnings (@mistercrunch)
- [#24430](https://github.com/apache/superset/pull/24430) chore(ci): make eslint and jest run in --quiet mode (@mistercrunch)
- [#24423](https://github.com/apache/superset/pull/24423) chore: remove deprecated apis /slice_json/ and /annotation_json/ (@dpgaspar)
- [#24400](https://github.com/apache/superset/pull/24400) chore: remove deprecated apis and ENABLE_BROAD_ACTIVITY_ACCESS (@dpgaspar)
- [#24393](https://github.com/apache/superset/pull/24393) docs: Restyle documentation landing page and community page (@thiagorossener)
- [#24401](https://github.com/apache/superset/pull/24401) chore: Remove previously deprecated dataset metrics column from RESTful API (@john-bodley)
- [#24375](https://github.com/apache/superset/pull/24375) chore: remove deprecated apis on superset, get_or_create_table, sqllab_viz (@dpgaspar)
- [#24379](https://github.com/apache/superset/pull/24379) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.9 to 5.59.11 in /superset-websocket (@dependabot[bot])
- [#24310](https://github.com/apache/superset/pull/24310) chore: Update GitHub issue templates (@john-bodley)
- [#24365](https://github.com/apache/superset/pull/24365) build(deps-dev): bump @typescript-eslint/parser from 5.59.8 to 5.59.11 in /superset-websocket (@dependabot[bot])
- [#24360](https://github.com/apache/superset/pull/24360) chore: remove deprecated apis stop_query, queries, search_queries (@dpgaspar)
- [#24353](https://github.com/apache/superset/pull/24353) chore: remove deprecated apis copy_dash, save_dash and add_slices (@dpgaspar)
- [#24198](https://github.com/apache/superset/pull/24198) chore: remove user registrations menu for non-admins (@villebro)
- [#24354](https://github.com/apache/superset/pull/24354) chore: remove deprecated apis on superset, testconn, validate_sql_json, schemas_access_for_file_upload (@dpgaspar)
- [#24381](https://github.com/apache/superset/pull/24381) chore: remove deprecated api /superset/available_domains (@dpgaspar)
- [#24359](https://github.com/apache/superset/pull/24359) chore: remove deprecated apis estimate_query_cost, results, sql_json, csv (@dpgaspar)
- [#24286](https://github.com/apache/superset/pull/24286) build(deps-dev): bump eslint from 8.41.0 to 8.42.0 in /superset-websocket (@dependabot[bot])
- [#24338](https://github.com/apache/superset/pull/24338) build(deps-dev): bump @types/uuid from 9.0.1 to 9.0.2 in /superset-websocket (@dependabot[bot])
- [#24337](https://github.com/apache/superset/pull/24337) build(deps-dev): bump @types/ws from 8.5.4 to 8.5.5 in /superset-websocket (@dependabot[bot])
- [#24362](https://github.com/apache/superset/pull/24362) chore: Disable redux errors (@kgabryje)
- [#24342](https://github.com/apache/superset/pull/24342) chore: remove deprecated api /superset/tables/<int:db_id>/... (@dpgaspar)
- [#24335](https://github.com/apache/superset/pull/24335) chore: remove deprecated api /superset/filter/... (@dpgaspar)
- [#24333](https://github.com/apache/superset/pull/24333) chore: remove deprecated api /superset/datasources (@dpgaspar)
- [#23997](https://github.com/apache/superset/pull/23997) chore(druid): Remove legacy Druid NoSQL logic (@john-bodley)
- [#24330](https://github.com/apache/superset/pull/24330) chore: Removes getUiOverrideRegistry (@michael-s-molina)
- [#24339](https://github.com/apache/superset/pull/24339) docs: Add BurdaForward to "In the Wild" and merge "News" and "Entertainment" to "Media & Entertainment" (@mattitoo)
- [#24082](https://github.com/apache/superset/pull/24082) chore(sqllab): Remove validation result from state (@justinpark)
- [#24322](https://github.com/apache/superset/pull/24322) chore: Deprecates some NVD3 charts in 3.0 (@michael-s-molina)
- [#24313](https://github.com/apache/superset/pull/24313) docs: add link to intro with supported database types (@sfirke)
- [#24312](https://github.com/apache/superset/pull/24312) chore: Remove unused sliceCanEdit logic (@john-bodley)
- [#24299](https://github.com/apache/superset/pull/24299) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.8 to 5.59.9 in /superset-websocket (@dependabot[bot])
- [#24297](https://github.com/apache/superset/pull/24297) build(deps): bump tox from 4.5.2 to 4.6.0 in /requirements (@dependabot[bot])
- [#24295](https://github.com/apache/superset/pull/24295) chore: Adds #24029 breaking change to UPDATING.md (@michael-s-molina)
- [#24288](https://github.com/apache/superset/pull/24288) docs: Adds new permissions from 2.1.0 and fixes some sql_lab permissions (@mattitoo)
- [#24250](https://github.com/apache/superset/pull/24250) chore(build): creating default superset_text.yaml placeholder file (@rusackas)
- [#24118](https://github.com/apache/superset/pull/24118) chore(docs): upgrading docusaurus (fixes header links) (@rusackas)
- [#24110](https://github.com/apache/superset/pull/24110) build(deps): bump pre-commit from 3.3.1 to 3.3.2 in /requirements (@dependabot[bot])
- [#24246](https://github.com/apache/superset/pull/24246) build(deps-dev): bump @typescript-eslint/parser from 5.59.7 to 5.59.8 in /superset-websocket (@dependabot[bot])
- [#24253](https://github.com/apache/superset/pull/24253) docs: fix broken link in the security page (@eltimen)
- [#24251](https://github.com/apache/superset/pull/24251) chore: tests for #24249 (@betodealmeida)
- [#24206](https://github.com/apache/superset/pull/24206) chore(native-filters): Ensure consistent error handling (@john-bodley)
- [#24231](https://github.com/apache/superset/pull/24231) docs: removed extra ` from documentation (@SaishNarvekar)
- [#24235](https://github.com/apache/superset/pull/24235) docs: point the reader to "setup.py" for latest package version (@boenshao)
- [#24245](https://github.com/apache/superset/pull/24245) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.7 to 5.59.8 in /superset-websocket (@dependabot[bot])
- [#24240](https://github.com/apache/superset/pull/24240) build(deps-dev): bump @types/node from 20.2.3 to 20.2.5 in /superset-websocket (@dependabot[bot])
- [#24239](https://github.com/apache/superset/pull/24239) build(deps): bump winston from 3.8.2 to 3.9.0 in /superset-websocket (@dependabot[bot])
- [#24238](https://github.com/apache/superset/pull/24238) build(deps): bump tox from 4.5.1 to 4.5.2 in /requirements (@dependabot[bot])
- [#24214](https://github.com/apache/superset/pull/24214) refactor: Extracts type definitions from ExtensionsRegistry (@michael-s-molina)
- [#24184](https://github.com/apache/superset/pull/24184) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.6 to 5.59.7 in /superset-websocket (@dependabot[bot])
- [#24167](https://github.com/apache/superset/pull/24167) build(deps-dev): bump eslint from 8.40.0 to 8.41.0 in /superset-websocket (@dependabot[bot])
- [#24183](https://github.com/apache/superset/pull/24183) build(deps-dev): bump @typescript-eslint/parser from 5.59.6 to 5.59.7 in /superset-websocket (@dependabot[bot])
- [#24202](https://github.com/apache/superset/pull/24202) chore(ssh): Allow users to set TUNNEL_TIMEOUT from config (@hughhhh)
- [#24026](https://github.com/apache/superset/pull/24026) chore(sqllab): Remove functionNames from sqlLab state (@justinpark)
- [#24045](https://github.com/apache/superset/pull/24045) chore: Bump sqlparse to 0.4.4 (@EugeneTorap)
- [#24168](https://github.com/apache/superset/pull/24168) build(deps-dev): bump @types/node from 20.2.0 to 20.2.3 in /superset-websocket (@dependabot[bot])
- [#24135](https://github.com/apache/superset/pull/24135) chore(sqllab): remove deprecated PyArrow API (@sebastianliebscher)
- [#24128](https://github.com/apache/superset/pull/24128) chore: deprecate rls base related filters (@villebro)
- [#24117](https://github.com/apache/superset/pull/24117) chore: Refactor command exceptions (@john-bodley)
- [#24029](https://github.com/apache/superset/pull/24029) chore: Update QUERY_LOGGER and SQL_QUERY_MUTATOR signatures (@john-bodley)
- [#24107](https://github.com/apache/superset/pull/24107) chore(report): Use for/else clause (@john-bodley)
- [#24111](https://github.com/apache/superset/pull/24111) build(deps-dev): bump @types/node from 20.1.7 to 20.2.0 in /superset-websocket (@dependabot[bot])
- [#23941](https://github.com/apache/superset/pull/23941) build: helm template to set init job annotations (@ybudweiser)
- [#24106](https://github.com/apache/superset/pull/24106) chore: update packages for vanta FE security concerns (@hughhhh)
- [#24087](https://github.com/apache/superset/pull/24087) build(deps-dev): bump @types/node from 20.1.4 to 20.1.7 in /superset-websocket (@dependabot[bot])
- [#22801](https://github.com/apache/superset/pull/22801) chore(thumbnails): change default executor to logged in user (@villebro)
- [#24081](https://github.com/apache/superset/pull/24081) chore(docs): Updating DB connection instructions in 1st Dash instruct… (@rusackas)
- [#22799](https://github.com/apache/superset/pull/22799) chore(reports): change default executor to owner (@villebro)
- [#24073](https://github.com/apache/superset/pull/24073) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.5 to 5.59.6 in /superset-websocket (@dependabot[bot])
- [#24050](https://github.com/apache/superset/pull/24050) chore: add extension for related DB assets on delete (@betodealmeida)
- [#24074](https://github.com/apache/superset/pull/24074) build(deps-dev): bump @typescript-eslint/parser from 5.59.2 to 5.59.6 in /superset-websocket (@dependabot[bot])
- [#24080](https://github.com/apache/superset/pull/24080) chore(docs): tidy up supported DB engines for metadata store (@sfirke)
- [#24079](https://github.com/apache/superset/pull/24079) chore(docs): Updated awkward phrase in FAQ, "force" (@kikobarr)
- [#24069](https://github.com/apache/superset/pull/24069) chore(trino): Bump Trino version to address an IANA time zone issue (@john-bodley)
- [#23581](https://github.com/apache/superset/pull/23581) chore: bump dependencies (@betodealmeida)
- [#24065](https://github.com/apache/superset/pull/24065) build(deps): bump vm2 from 3.9.15 to 3.9.18 in /superset-frontend/cypress-base (@dependabot[bot])
- [#24066](https://github.com/apache/superset/pull/24066) build(deps): bump vm2 from 3.9.17 to 3.9.18 in /superset-frontend (@dependabot[bot])
- [#24058](https://github.com/apache/superset/pull/24058) chore: add log for ssh tunnel information (@hughhhh)
- [#24025](https://github.com/apache/superset/pull/24025) chore(docs): add version for postgres when doing brew install (@rusackas)
- [#24052](https://github.com/apache/superset/pull/24052) build(deps-dev): bump @types/node from 20.1.2 to 20.1.4 in /superset-websocket (@dependabot[bot])
- [#23965](https://github.com/apache/superset/pull/23965) chore: bump werkzeug and Flask (@dpgaspar)
- [#24033](https://github.com/apache/superset/pull/24033) chore: Update mypy and fix stubs issue (@EugeneTorap)
- [#24023](https://github.com/apache/superset/pull/24023) chore: remove duplicates of `validate_adhoc_subquery` (@betodealmeida)
- [#24001](https://github.com/apache/superset/pull/24001) chore: remove deprecated distutils (@sebastianliebscher)
- [#24017](https://github.com/apache/superset/pull/24017) build(deps-dev): bump @types/node from 20.1.1 to 20.1.2 in /superset-websocket (@dependabot[bot])
- [#23756](https://github.com/apache/superset/pull/23756) test: cover empty AdvancedDataTypes internet_address and internet_port (@sebastianliebscher)
- [#23770](https://github.com/apache/superset/pull/23770) chore: fix deprecation warnings for SQLALchemy URL (@sebastianliebscher)
- [#23976](https://github.com/apache/superset/pull/23976) chore: mark explore_json as deprecated in 3.0 (@betodealmeida)
- [#23981](https://github.com/apache/superset/pull/23981) chore: Deprecate DND feature flags (@kgabryje)
- [#23984](https://github.com/apache/superset/pull/23984) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.2 to 5.59.5 in /superset-websocket (@dependabot[bot])
- [#23983](https://github.com/apache/superset/pull/23983) build(deps-dev): bump @types/node from 20.1.0 to 20.1.1 in /superset-websocket (@dependabot[bot])
- [#23951](https://github.com/apache/superset/pull/23951) chore(deps): Add dependency-review action (@rusackas)
- [#23974](https://github.com/apache/superset/pull/23974) chore(actions): adding JavaScript to CodeQL config (@rusackas)
- [#24002](https://github.com/apache/superset/pull/24002) chore: Comment 3.8 PY required CI checks (@EugeneTorap)
- [#23986](https://github.com/apache/superset/pull/23986) chore: Bump python libs (@EugeneTorap)
- [#23994](https://github.com/apache/superset/pull/23994) docs(feature flags): remove the conflicting entry for DRILL_BY (@sfirke)
- [#23760](https://github.com/apache/superset/pull/23760) chore(sqllab): Refactor react-query by redux-toolkit query (@justinpark)
- [#23961](https://github.com/apache/superset/pull/23961) build(deps-dev): bump eslint from 8.39.0 to 8.40.0 in /superset-websocket (@dependabot[bot])
- [#23962](https://github.com/apache/superset/pull/23962) build(deps-dev): bump @types/node from 20.0.0 to 20.1.0 in /superset-websocket (@dependabot[bot])
- [#23744](https://github.com/apache/superset/pull/23744) chore(slack): use recommended method for file upload (@betodealmeida)
- [#23923](https://github.com/apache/superset/pull/23923) chore(helm): Split service templates into separate files (@dnskr)
- [#23936](https://github.com/apache/superset/pull/23936) chore: deprecate /superset/add_slices (@dpgaspar)
- [#23911](https://github.com/apache/superset/pull/23911) docs: fixing a broken markdown link about SSH tunneling (@rusackas)
- [#23949](https://github.com/apache/superset/pull/23949) chore: add codeQL to CI (@dpgaspar)
- [#23947](https://github.com/apache/superset/pull/23947) build(deps-dev): bump @types/node from 18.16.3 to 20.0.0 in /superset-websocket (@dependabot[bot])
- [#23926](https://github.com/apache/superset/pull/23926) chore(helm): Declare missing properties (@dnskr)
- [#23934](https://github.com/apache/superset/pull/23934) chore: Deprecates viz.py (@michael-s-molina)
- [#23795](https://github.com/apache/superset/pull/23795) docs: Add description of standard Superset roles (@mattitoo)
- [#23871](https://github.com/apache/superset/pull/23871) refactor: useEffectEvent for efficient deps (@justinpark)
- [#23913](https://github.com/apache/superset/pull/23913) build(deps): bump pre-commit from 3.2.2 to 3.3.1 in /requirements (@dependabot[bot])
- [#23895](https://github.com/apache/superset/pull/23895) chore(ci): bump actions (@sebastianliebscher)
- [#23841](https://github.com/apache/superset/pull/23841) build(deps-dev): bump @types/jsonwebtoken from 9.0.1 to 9.0.2 in /superset-websocket (@dependabot[bot])
- [#23894](https://github.com/apache/superset/pull/23894) build(deps-dev): bump @typescript-eslint/parser from 5.59.0 to 5.59.2 in /superset-websocket (@dependabot[bot])
- [#23891](https://github.com/apache/superset/pull/23891) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.0 to 5.59.2 in /superset-websocket (@dependabot[bot])
- [#23726](https://github.com/apache/superset/pull/23726) chore(helm): Use template comments for the chart license header (@dnskr)
- [#23887](https://github.com/apache/superset/pull/23887) build(deps-dev): bump @types/node from 18.16.0 to 18.16.3 in /superset-websocket (@dependabot[bot])
- [#23849](https://github.com/apache/superset/pull/23849) chore: Add Cypress tests for drill by (@kgabryje)
- [#23680](https://github.com/apache/superset/pull/23680) chore: bump wtforms and add missing flask-limiter (@dpgaspar)
- [#23862](https://github.com/apache/superset/pull/23862) chore: Use nh3 lib instead of bleach (@EugeneTorap)
- [#23844](https://github.com/apache/superset/pull/23844) chore: Bump polyline to 2.0.0 (@EugeneTorap)
- [#23845](https://github.com/apache/superset/pull/23845) chore: Bump redis to 4.5.4 (@EugeneTorap)
- [#23854](https://github.com/apache/superset/pull/23854) chore: Add logging events for drill by (@kgabryje)
- [#23729](https://github.com/apache/superset/pull/23729) chore: migrate `sqllab_viz` endpoint to api v1 (@hughhhh)
- [#23813](https://github.com/apache/superset/pull/23813) chore: Upgrade Cypress to 10.11.0 (@kgabryje)
- [#23794](https://github.com/apache/superset/pull/23794) docs: discourage the use of SQLite (@dpgaspar)
- [#23785](https://github.com/apache/superset/pull/23785) chore: Deprecates 3.0 consented feature flags (@michael-s-molina)
- [#23820](https://github.com/apache/superset/pull/23820) docs: Add Superset Overview Video to README (@satokonak)
- [#23796](https://github.com/apache/superset/pull/23796) docs: cleanup references to `apache-superset/superset-ui` (@charpeni)
- [#22916](https://github.com/apache/superset/pull/22916) chore: Add tests to SQL lab button components (@diegomedina248)
- [#23791](https://github.com/apache/superset/pull/23791) build(deps-dev): bump @types/node from 18.15.13 to 18.16.0 in /superset-websocket (@dependabot[bot])
- [#23790](https://github.com/apache/superset/pull/23790) build(deps-dev): bump eslint from 8.38.0 to 8.39.0 in /superset-websocket (@dependabot[bot])
- [#23789](https://github.com/apache/superset/pull/23789) build(deps-dev): bump prettier from 2.8.7 to 2.8.8 in /superset-websocket (@dependabot[bot])
- [#23798](https://github.com/apache/superset/pull/23798) chore: Add DRILL_BY to FEATURE_FLAGS.md (@kgabryje)
- [#23784](https://github.com/apache/superset/pull/23784) chore: Deprecates FilterBox (@michael-s-molina)
- [#23765](https://github.com/apache/superset/pull/23765) build(deps-dev): bump @types/node from 18.15.12 to 18.15.13 in /superset-websocket (@dependabot[bot])
- [#23772](https://github.com/apache/superset/pull/23772) chore(e2e): skip the worst offender of flaky tests. (@rusackas)
- [#23670](https://github.com/apache/superset/pull/23670) chore(feature flags): updating the status of a few flags (@rusackas)
- [#23704](https://github.com/apache/superset/pull/23704) chore: remove RemovedInMarshmallow4 warnings (@sebastianliebscher)
- [#23759](https://github.com/apache/superset/pull/23759) chore(actions): Fix for Chromatic action using actions/checkout@v3 (@rusackas)
- [#23725](https://github.com/apache/superset/pull/23725) chore(docs): copy change submitted through BugHerd (@rusackas)
- [#23488](https://github.com/apache/superset/pull/23488) refactor(sqllab): Remove tableOptions from redux state (@justinpark)
- [#23746](https://github.com/apache/superset/pull/23746) build(deps-dev): bump @types/node from 18.15.11 to 18.15.12 in /superset-websocket (@dependabot[bot])
- [#23753](https://github.com/apache/superset/pull/23753) build(deps): bump vm2 from 3.9.15 to 3.9.17 in /superset-frontend (@dependabot[bot])
- [#23718](https://github.com/apache/superset/pull/23718) build(deps-dev): bump @typescript-eslint/parser from 5.58.0 to 5.59.0 in /superset-websocket (@dependabot[bot])
- [#23734](https://github.com/apache/superset/pull/23734) chore(chart-data): add post processing error message to response (@villebro)
- [#23678](https://github.com/apache/superset/pull/23678) chore(api v1): Deprecate datasource/save and datasource/get endpoints (@jfrag1)
- [#23714](https://github.com/apache/superset/pull/23714) chore(api v1): Deprecate superset/override_role_permissions endpoint (@jfrag1)
- [#23681](https://github.com/apache/superset/pull/23681) chore(helm): Reformat helm chart templates (@dnskr)
- [#23719](https://github.com/apache/superset/pull/23719) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.58.0 to 5.59.0 in /superset-websocket (@dependabot[bot])
- [#23663](https://github.com/apache/superset/pull/23663) chore: Removes deprecated feature flags for 3.0 (@michael-s-molina)
- [#23683](https://github.com/apache/superset/pull/23683) docs(translations): point broken tutorial link to Internet Archive copy (@sfirke)
- [#23674](https://github.com/apache/superset/pull/23674) chore(presto): Expose schema and indexes to \_partition_query method (@john-bodley)
- [#23609](https://github.com/apache/superset/pull/23609) docs: nvm error while local setup (@Abhishek-kumar-samsung)
- [#23654](https://github.com/apache/superset/pull/23654) chore: Update cross-filter tooltip text (@yousoph)
- [#23651](https://github.com/apache/superset/pull/23651) chore: Removes the UX_BETA feature flag (@michael-s-molina)
- [#23652](https://github.com/apache/superset/pull/23652) chore: Enables GENERIC_CHART_AXES by default (@michael-s-molina)
- [#23656](https://github.com/apache/superset/pull/23656) chore(db_engine_specs): Refactor get_index (@john-bodley)
- [#23460](https://github.com/apache/superset/pull/23460) refactor: introduce redux toolkit (@justinpark)
- [#23642](https://github.com/apache/superset/pull/23642) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.57.1 to 5.58.0 in /superset-websocket (@dependabot[bot])
- [#23643](https://github.com/apache/superset/pull/23643) build(deps-dev): bump @typescript-eslint/parser from 5.57.1 to 5.58.0 in /superset-websocket (@dependabot[bot])
- [#23646](https://github.com/apache/superset/pull/23646) docs: update CHANGELOG with 2.1.0 (@dpgaspar)
- [#23640](https://github.com/apache/superset/pull/23640) chore(feature flag): removing unused ENFORCE_DB_ENCRYPTION_UI flag (@rusackas)
- [#22853](https://github.com/apache/superset/pull/22853) chore: Refactor ExploreMixin to power both Datasets (SqlaTable) and Query models (@hughhhh)
- [#22853](https://github.com/apache/superset/pull/22853) chore: Refactor ExploreMixin to power both Datasets (SqlaTable) and Query models (@hughhhh)
- [#23633](https://github.com/apache/superset/pull/23633) build(deps-dev): bump eslint from 8.36.0 to 8.38.0 in /superset-websocket (@dependabot[bot])
- [#23625](https://github.com/apache/superset/pull/23625) build(deps): bump vm2 from 3.9.14 to 3.9.15 in /superset-frontend/cypress-base (@dependabot[bot])
- [#19733](https://github.com/apache/superset/pull/19733) docs(contributing): add local vscode config for backend debugging (@cemremengu)
- [#23626](https://github.com/apache/superset/pull/23626) build(deps): bump vm2 from 3.9.13 to 3.9.15 in /superset-frontend (@dependabot[bot])
- [#23572](https://github.com/apache/superset/pull/23572) build(deps-dev): bump @typescript-eslint/parser from 5.55.0 to 5.57.1 in /superset-websocket (@dependabot[bot])
- [#23112](https://github.com/apache/superset/pull/23112) chore: Migrate copy_dash endpoint to api v1 (@jfrag1)
- [#23596](https://github.com/apache/superset/pull/23596) chore(deps): bump kind-of dependency (@rusackas)
- [#23595](https://github.com/apache/superset/pull/23595) chore(deps): bumps ansi-regex to 5.0.1 (@rusackas)
- [#23482](https://github.com/apache/superset/pull/23482) refactor: Moves CRUD features to src/features (@michael-s-molina)
- [#23537](https://github.com/apache/superset/pull/23537) docs(security): more context around Talisman, note side effect of force_https on Alerts & Reports (@sfirke)
- [#23573](https://github.com/apache/superset/pull/23573) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.55.0 to 5.57.1 in /superset-websocket (@dependabot[bot])
- [#23518](https://github.com/apache/superset/pull/23518) build(deps-dev): bump @types/node from 18.15.5 to 18.15.11 in /superset-websocket (@dependabot[bot])
- [#23571](https://github.com/apache/superset/pull/23571) build(deps): bump pre-commit from 3.2.0 to 3.2.2 in /requirements (@dependabot[bot])
- [#23496](https://github.com/apache/superset/pull/23496) build(deps-dev): bump prettier from 2.8.6 to 2.8.7 in /superset-websocket (@dependabot[bot])
- [#23544](https://github.com/apache/superset/pull/23544) chore: Remove wrong information from the Alerts & Reports docs (@geido)
- [#22964](https://github.com/apache/superset/pull/22964) chore: Migrate /superset/user_slices and /superset/fave_slices to API v1 (@diegomedina248)
- [#23491](https://github.com/apache/superset/pull/23491) perf(sqla): avoid unnecessary type check on adhoc column (@villebro)
- [#22803](https://github.com/apache/superset/pull/22803) chore(welcome): harmonize submenu with other routes (@villebro)
- [#23527](https://github.com/apache/superset/pull/23527) ci: disable flaky async test (@villebro)
- [#23536](https://github.com/apache/superset/pull/23536) chore: allow logs to show error levels for ssh tunnel (@hughhhh)
- [#23481](https://github.com/apache/superset/pull/23481) chore: Adds a tooltip to pre-filter in native filters modal (@michael-s-molina)
- [#23165](https://github.com/apache/superset/pull/23165) chore: Migrate /superset/favstar to API v1 (@diegomedina248)
- [#23501](https://github.com/apache/superset/pull/23501) docs: Adds notes to Superset plugin generator about TypeScript errors (@alex-bain)
- [#23477](https://github.com/apache/superset/pull/23477) chore: Changes the inputs of native filters modal to have the same width (@michael-s-molina)
- [#23429](https://github.com/apache/superset/pull/23429) chore: Dataset specific MetadataBar (@kgabryje)
- [#23465](https://github.com/apache/superset/pull/23465) perf(postprocessing): improve pivot postprocessing operation (@Usiel)
- [#23420](https://github.com/apache/superset/pull/23420) docs(contributing): How create or change SECRET_KEY (@pankajsoni22)
- [#23437](https://github.com/apache/superset/pull/23437) build(deps-dev): bump eslint-config-prettier from 8.7.0 to 8.8.0 in /superset-websocket (@dependabot[bot])
- [#23257](https://github.com/apache/superset/pull/23257) chore(sqllab): Remove schemaOptions from redux store (@justinpark)
- [#23417](https://github.com/apache/superset/pull/23417) docs(contributing): added note for creating SECRET_KEY (@Govindarajan-D)
- [#23438](https://github.com/apache/superset/pull/23438) build(deps-dev): bump @types/node from 18.15.3 to 18.15.5 in /superset-websocket (@dependabot[bot])
- [#23451](https://github.com/apache/superset/pull/23451) build(deps-dev): bump prettier from 2.8.4 to 2.8.6 in /superset-websocket (@dependabot[bot])
- [#23430](https://github.com/apache/superset/pull/23430) chore: Add DRILL_BY feature flag (@kgabryje)
- [#23398](https://github.com/apache/superset/pull/23398) chore: Update typing for `Table` component (@hughhhh)
- [#23422](https://github.com/apache/superset/pull/23422) build(deps): bump pre-commit from 3.1.0 to 3.2.0 in /requirements (@dependabot[bot])
- [#23342](https://github.com/apache/superset/pull/23342) build(deps-dev): bump eslint from 8.35.0 to 8.36.0 in /superset-websocket (@dependabot[bot])
- [#23431](https://github.com/apache/superset/pull/23431) docs(security): note the need to set TALISMAN_ENABLED = True (@sfirke)
- [#23303](https://github.com/apache/superset/pull/23303) chore(native-filters): Fetch only the required dataset fields (@john-bodley)
- [#23331](https://github.com/apache/superset/pull/23331) chore: update releasing process for testing (@eschutho)
- [#23226](https://github.com/apache/superset/pull/23226) chore: Hugh/migrate estimate query cost to v1 (@hughhhh)
- [#23359](https://github.com/apache/superset/pull/23359) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.53.0 to 5.55.0 in /superset-websocket (@dependabot[bot])
- [#23366](https://github.com/apache/superset/pull/23366) build(deps-dev): bump webpack from 5.52.1 to 5.76.0 in /superset-frontend (@dependabot[bot])
- [#23343](https://github.com/apache/superset/pull/23343) build(deps): bump ws from 8.12.1 to 8.13.0 in /superset-websocket (@dependabot[bot])
- [#23403](https://github.com/apache/superset/pull/23403) chore(docs): three typos (@rusackas)
- [#23385](https://github.com/apache/superset/pull/23385) chore: improve schema security (@betodealmeida)
- [#23368](https://github.com/apache/superset/pull/23368) build(deps-dev): bump webpack from 5.64.0 to 5.76.0 in /docs (@dependabot[bot])
- [#23367](https://github.com/apache/superset/pull/23367) build(deps-dev): bump webpack from 5.67.0 to 5.76.0 in /superset-embedded-sdk (@dependabot[bot])
- [#23379](https://github.com/apache/superset/pull/23379) build(deps-dev): bump @typescript-eslint/parser from 5.54.1 to 5.55.0 in /superset-websocket (@dependabot[bot])
- [#23369](https://github.com/apache/superset/pull/23369) build(deps): bump @sideway/formula from 3.0.0 to 3.0.1 in /docs (@dependabot[bot])
- [#23261](https://github.com/apache/superset/pull/23261) chore(dashboard): Disable 'Set filter mapping' when appropriate (@john-bodley)
- [#23371](https://github.com/apache/superset/pull/23371) chore: Add code-owners to Select, MetadataBar and DropdownContainer (@geido)
- [#23227](https://github.com/apache/superset/pull/23227) chore: Migrate /superset/schemas_access_for_file_upload to v1 (@hughhhh)
- [#23360](https://github.com/apache/superset/pull/23360) build(deps-dev): bump @types/node from 18.14.6 to 18.15.3 in /superset-websocket (@dependabot[bot])
- [#23216](https://github.com/apache/superset/pull/23216) chore: Remove Cross Filter scoping modal (@geido)
- [#23294](https://github.com/apache/superset/pull/23294) build(deps-dev): bump @typescript-eslint/parser from 5.53.0 to 5.54.1 in /superset-websocket (@dependabot[bot])
- [#23323](https://github.com/apache/superset/pull/23323) docs(alerts and reports): Update ExecutorType class (@mrmooon)
- [#23290](https://github.com/apache/superset/pull/23290) chore: log different selenium timeout errors differently (@eschutho)
- [#23316](https://github.com/apache/superset/pull/23316) docs: add lost \_filters param docs (@villebro)
- [#23317](https://github.com/apache/superset/pull/23317) chore: bump docusaurus to latest stable (@villebro)
- [#23281](https://github.com/apache/superset/pull/23281) build(deps-dev): bump @types/node from 18.14.1 to 18.14.6 in /superset-websocket (@dependabot[bot])
- [#23292](https://github.com/apache/superset/pull/23292) build(deps-dev): bump eslint-config-prettier from 8.6.0 to 8.7.0 in /superset-websocket (@dependabot[bot])
- [#23166](https://github.com/apache/superset/pull/23166) docs: typo 'admnistrators' in security.mdx (@camac)
- [#22890](https://github.com/apache/superset/pull/22890) chore: upgrade @ant-design/icons for react upgrade (@lilykuang)
- [#23266](https://github.com/apache/superset/pull/23266) chore(cache): Tuning logging in cache manager (@craig-rueda)
- [#23255](https://github.com/apache/superset/pull/23255) chore(webdriver): Tuning the Webdriver logging a bit (@craig-rueda)
- [#23142](https://github.com/apache/superset/pull/23142) chore: Remove the ability to add filter-box charts when DASHBOARD_NATIVE_FILTERS feature is enabled (@john-bodley)
- [#23241](https://github.com/apache/superset/pull/23241) refactor: Organizes the pages in their own folder (@michael-s-molina)
- [#23122](https://github.com/apache/superset/pull/23122) build(deps): bump pip-compile-multi from 2.6.1 to 2.6.2 in /requirements (@dependabot[bot])
- [#23225](https://github.com/apache/superset/pull/23225) chore: Add statsd logger for ssh tunneling creation (@hughhhh)
- [#23168](https://github.com/apache/superset/pull/23168) build(deps): bump pre-commit from 3.0.4 to 3.1.0 in /requirements (@dependabot[bot])
- [#22859](https://github.com/apache/superset/pull/22859) build(deps): bump ua-parser-js from 0.7.28 to 0.7.33 in /superset-frontend (@dependabot[bot])
- [#23201](https://github.com/apache/superset/pull/23201) chore: adding code owners for github actions/workflows (@rusackas)
- [#23211](https://github.com/apache/superset/pull/23211) build(deps-dev): bump eslint from 8.34.0 to 8.35.0 in /superset-websocket (@dependabot[bot])
- [#23152](https://github.com/apache/superset/pull/23152) build(deps-dev): bump @types/uuid from 9.0.0 to 9.0.1 in /superset-websocket (@dependabot[bot])
- [#23207](https://github.com/apache/superset/pull/23207) docs: fix typo (@vivekDebugs)
- [#22342](https://github.com/apache/superset/pull/22342) build(deps): bump express and @applitools/eyes-cypress in /superset-frontend/cypress-base (@dependabot[bot])
- [#23132](https://github.com/apache/superset/pull/23132) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.52.0 to 5.53.0 in /superset-websocket (@dependabot[bot])
- [#23203](https://github.com/apache/superset/pull/23203) test: Remove test playgrounds (@lyndsiWilliams)
- [#23180](https://github.com/apache/superset/pull/23180) build(deps-dev): bump @types/node from 18.13.0 to 18.14.1 in /superset-websocket (@dependabot[bot])
- [#23133](https://github.com/apache/superset/pull/23133) build(deps-dev): bump @typescript-eslint/parser from 5.51.0 to 5.53.0 in /superset-websocket (@dependabot[bot])
- [#23145](https://github.com/apache/superset/pull/23145) chore: refactor SparklineCell for react 17 and react 18 upgrade (@lilykuang)
- [#23160](https://github.com/apache/superset/pull/23160) build: Add helm chart option to deploy sidecars with node and worker (@mkramer5454)
- [#23144](https://github.com/apache/superset/pull/23144) chore: revert "feat(native_filter_migration): add transition mode (#16992)" (@john-bodley)
- [#23158](https://github.com/apache/superset/pull/23158) chore: Bump cryptography to 39.0.1 (@EugeneTorap)
- [#23108](https://github.com/apache/superset/pull/23108) chore: Remove yarn.lock from the root folder (@EugeneTorap)

### 2.1.3 (Fri Dec 8 16:36:51 2023 -0700)

**Database Migrations**

**Features**

**Fixes**

- [#25658](https://github.com/apache/superset/pull/25658) fix: improve upload ZIP file validation (@dpgaspar)
- [#25779](https://github.com/apache/superset/pull/25779) fix: DB-specific quoting in Jinja macro (@betodealmeida)
- [#25843](https://github.com/apache/superset/pull/25843) fix: remove `update_charts_owners` (@betodealmeida)

**Others**

- [#23862](https://github.com/apache/superset/pull/23862) chore: Use nh3 lib instead of bleach (@EugeneTorap)
- [#23965](https://github.com/apache/superset/pull/23965) chore: bump werkzeug and Flask (@dpgaspar)
- [#24033](https://github.com/apache/superset/pull/24033) chore: Update mypy and fix stubs issue (@EugeneTorap)
- [#24045](https://github.com/apache/superset/pull/24045) chore: Bump sqlparse to 0.4.4 (@EugeneTorap)
- [#24324](https://github.com/apache/superset/pull/24324) chore: rate limit requests (@betodealmeida)

### 2.1.2 (Wed Oct 18 16:59:30 2023 -0700)

**Database Migrations**

**Features**

**Fixes**

- [#25150](https://github.com/apache/superset/pull/25150) fix: Chart series limit doesn't work for some databases (@KSPT-taylorjohn)
- [#25014](https://github.com/apache/superset/pull/25014) fix: CTE queries with non-SELECT statements (@dpgaspar)
- [#24849](https://github.com/apache/superset/pull/24849) fix: validation errors appearing after ssh tunnel switch (@hughhhh)
- [#24196](https://github.com/apache/superset/pull/24196) fix: SSH Tunnel creation with dynamic form (@hughhhh)
- [#24821](https://github.com/apache/superset/pull/24821) fix: Allow chart import to update the dataset an existing chart points to (@jfrag1)
- [#24317](https://github.com/apache/superset/pull/24317) fix: update order of build for testing a release (@eschutho)

**Others**

- [#24826](https://github.com/apache/superset/pull/24826) chore: remove CssTemplate and Annotation access from gamma role (@lilykuang)
- [#23680](https://github.com/apache/superset/pull/23680) chore: bump wtforms and add missing flask-limiter (@dpgaspar)
- [#24758](https://github.com/apache/superset/pull/24758) chore(view_api): return application/json as content-type for api/v1/form_data endpoint (@zephyring)

### 2.1.1 (Sun Apr 23 15:44:21 2023 +0100)

**Database Migrations**

- [#23980](https://github.com/apache/superset/pull/23980) fix(migration): handle permalink edge cases correctly (@villebro)
- [#23888](https://github.com/apache/superset/pull/23888) chore(key-value): use json serialization for main resources (@villebro)

**Fixes**

- [#23723](https://github.com/apache/superset/pull/23723) fix: add enforce URI query params with a specific for MySQL (@dpgaspar)
- [#24970](https://github.com/apache/superset/pull/24970) fix: update permalink schema (@eschutho)
- [#24995](https://github.com/apache/superset/pull/24995) fix: Revert "fix(chart): Time Series set showMaxLabel as null for time xAxis (#20627) (@eschutho)
- [#24513](https://github.com/apache/superset/pull/24513) fix(sqllab): normalize changedOn timestamp (@villebro)
- [#23512](https://github.com/apache/superset/pull/23512) fix: Dashboard not loading with default first value in filter (@geido)
- [#24482](https://github.com/apache/superset/pull/24482) fix(permalink): Incorrect component schema reference (@Nisden)
- [#24166](https://github.com/apache/superset/pull/24166) fix(permalink): migrate to marshmallow codec (@villebro)
- [#24697](https://github.com/apache/superset/pull/24697) fix: import database engine validation (@dpgaspar)
- [#24390](https://github.com/apache/superset/pull/24390) fix: FAB CSS on Superset (@dpgaspar)
- [#24249](https://github.com/apache/superset/pull/24249) fix: dashboard ownership check (@betodealmeida)
- [#23801](https://github.com/apache/superset/pull/23801) fix(plugin-chart-handlebars): Fix TypeError when using handlebars columns raw mode (@fmannhardt)
- [#23566](https://github.com/apache/superset/pull/23566) fix: Filter values are not updating when dependencies are set (@michael-s-molina)
- [#23400](https://github.com/apache/superset/pull/23400) fix: Select all issue with "Dynamically search all filter values" in FilterBar (@geido)
- [#23865](https://github.com/apache/superset/pull/23865) fix: Native time range filter in legacy charts (@kgabryje)
- [#24054](https://github.com/apache/superset/pull/24054) fix: handle temporal columns in presto partitions (@giftig)
- [#23882](https://github.com/apache/superset/pull/23882) fix: handle comments in `has_table_query` (@betodealmeida)
- [#24137](https://github.com/apache/superset/pull/24137) fix: disable SHOW_STACKTRACE by default (@dpgaspar)
- [#24185](https://github.com/apache/superset/pull/24185) fix: db validate parameters permission (@dpgaspar)
- [#23769](https://github.com/apache/superset/pull/23769) fix: allow db driver distinction on enforced URI params (@dpgaspar)
- [#23600](https://github.com/apache/superset/pull/23600) fix: load examples as anon user (@betodealmeida)
- [#23200](https://github.com/apache/superset/pull/23200) fix: permission checks on import (@betodealmeida)
- [#23901](https://github.com/apache/superset/pull/23901) fix: check sqlalchemy_uri (@dpgaspar)
- [#23751](https://github.com/apache/superset/pull/23751) fix(mssql): apply top after distinct (@villebro)
- [#23586](https://github.com/apache/superset/pull/23586) fix(dashboard-rbac): use normal rbac when no roles chosen (@villebro)
- [#23582](https://github.com/apache/superset/pull/23582) fix(dash import): Ensure old datasource ids are not referenced in imported charts (@jfrag1)
- [#23506](https://github.com/apache/superset/pull/23506) fix(generic-x-axis): skip initial time filter for legacy charts (@villebro)
- [#23507](https://github.com/apache/superset/pull/23507) fix(legacy-plugin-chart-heatmap): fix adhoc column tooltip (@villebro)
- [#23441](https://github.com/apache/superset/pull/23441) fix(chart): non existent time grain no longer breaks the application (@rdubois)
- [#23393](https://github.com/apache/superset/pull/23393) fix(Pivot Table v2): resolved full width issue (@AkashBoora)
- [#22851](https://github.com/apache/superset/pull/22851) fix: Validate jinja rendered query (@geido)

**Others**

- [#24586](https://github.com/apache/superset/pull/24586) chore(metastore-cache): add codec support (@villebro)
- [#23113](https://github.com/apache/superset/pull/23113) chore(sqla): Address performance tradeoff with eager loading (@john-bodley)
- [#24294](https://github.com/apache/superset/pull/24294) chore: update UPDATING for 2.1.0 (@eschutho)
- [#24056](https://github.com/apache/superset/pull/24056) chore: Remove unnecessary information from response (@geido)

### 2.1.0 (Thu Mar 16 21:13:05 2023 -0700)

**Database Migrations**

- [#23139](https://github.com/apache/superset/pull/23139) fix: memoized decorator memory leak (@dpgaspar)
- [#19676](https://github.com/apache/superset/pull/19676) chore(frontend): Spelling (@jsoref)
- [#22852](https://github.com/apache/superset/pull/22852) chore: removing unnecessary double spaces, a.k.a. "shotgun holes" (@rusackas)
- [#21912](https://github.com/apache/superset/pull/21912) feat(ssh-tunnelling): Setup SSH Tunneling Commands for Database Connections (@hughhhh)
- [#22248](https://github.com/apache/superset/pull/22248) chore: Add a migration that removes filter_bar_orientation from dashboard's json_metadata (@kgabryje)
- [#21417](https://github.com/apache/superset/pull/21417) fix(db-migration): new_dataset_models_take_2 error on postgres (@micsbot)
- [#21778](https://github.com/apache/superset/pull/21778) fix(migration): Ensure the paginated update is deterministic (@john-bodley)
- [#21682](https://github.com/apache/superset/pull/21682) feat(sqllab): save query parameters in database (@mayurnewase)
- [#21679](https://github.com/apache/superset/pull/21679) fix(migration): Catch DatabaseError to avoid migration crash with MySQL 8.0 (@qlands)
- [#20892](https://github.com/apache/superset/pull/20892) feat: Add dataset tagging to the back-end (@cccs-Dustin)
- [#21284](https://github.com/apache/superset/pull/21284) chore(sqllab): Cleanup /tables/... endpoint (@john-bodley)
- [#21101](https://github.com/apache/superset/pull/21101) fix(plugin-chart-table): Upgrade old color formats (@kgabryje)
- [#20936](https://github.com/apache/superset/pull/20936) chore(db): ensure query_context is MediumText before viz migration (@ktmud)
- [#20939](https://github.com/apache/superset/pull/20939) fix: skip row if created_at_fk is null (@eschutho)
- [#20552](https://github.com/apache/superset/pull/20552) feat(report): allow capturing dashboard reports in specific state (@ktmud)
- [#20617](https://github.com/apache/superset/pull/20617) fix: Add migration to add created_by_fk as explicit owner for charts and datasets (@john-bodley)
- [#20779](https://github.com/apache/superset/pull/20779) fix(db): set slices.query_context to MEDIUMTEXT for mysql (@ktmud)
- [#20761](https://github.com/apache/superset/pull/20761) fix(db): use paginated_update for viz migration (@ktmud)
- [#19890](https://github.com/apache/superset/pull/19890) chore: upgrade SQLAlchemy to 1.4 (@betodealmeida)
- [#20359](https://github.com/apache/superset/pull/20359) feat: Area viz migration (@zhaoyongjie)
- [#20641](https://github.com/apache/superset/pull/20641) fix: migration revisions from #19532 (@dpgaspar)
- [#20346](https://github.com/apache/superset/pull/20346) feat: TreeMap migration (@zhaoyongjie)
- [#19532](https://github.com/apache/superset/pull/19532) feat(database): Add user_id and dttm composite index to Log model. (@xneg)
- [#19983](https://github.com/apache/superset/pull/19983) feat: save active tabs in dashboard permalink (@ktmud)
- [#20492](https://github.com/apache/superset/pull/20492) refactor: Cleanup user get_id/get_user_id (@john-bodley)
- [#20484](https://github.com/apache/superset/pull/20484) fix: migration revision order (@dpgaspar)
- [#20449](https://github.com/apache/superset/pull/20449) fix: RLS new db migration downgrade fails on SQLite (@dpgaspar)
- [#20432](https://github.com/apache/superset/pull/20432) feat: add name, description and non null tables to RLS (@dpgaspar)

**Features**

- [#22713](https://github.com/apache/superset/pull/22713) feat(helm): allow persisting nodePort for services (@rajan123456)
- [#23040](https://github.com/apache/superset/pull/23040) feat(sqllab): Add event logger (@justinpark)
- [#22670](https://github.com/apache/superset/pull/22670) feat(datasets): Populate Usage tab in Edit Dataset view (@codyml)
- [#22967](https://github.com/apache/superset/pull/22967) feat(ssh_tunnel): SSH Tunnel Switch extension (@Antonio-RiveroMartnez)
- [#22043](https://github.com/apache/superset/pull/22043) feat: add tabs to edit dataset page (@pkdotson)
- [#22835](https://github.com/apache/superset/pull/22835) feat: Enable new dataset creation flow II (@lyndsiWilliams)
- [#22854](https://github.com/apache/superset/pull/22854) feat(helm): Make Chart.AppVersion default value for image tag (@dnskr)
- [#22833](https://github.com/apache/superset/pull/22833) feat: Adds the ECharts Sunburst chart (@michael-s-molina)
- [#20291](https://github.com/apache/superset/pull/20291) feat: add pyproject.toml file to project (@leo-schick)
- [#22006](https://github.com/apache/superset/pull/22006) feat: Add excel export (@igorsinc)
- [#22805](https://github.com/apache/superset/pull/22805) feat(ssh_tunnel): Add feature flag to SSH Tunnel API (@Antonio-RiveroMartnez)
- [#22785](https://github.com/apache/superset/pull/22785) feat: Move cross filters to Dashboard (@geido)
- [#22806](https://github.com/apache/superset/pull/22806) feat: export/import `allow_dml` flag (@betodealmeida)
- [#22827](https://github.com/apache/superset/pull/22827) feat(helm): Add ability to customize affinity per deployment (@sergeyshevch)
- [#22770](https://github.com/apache/superset/pull/22770) feat(docker): Build multiple python version images (@Germandrummer92)
- [#22689](https://github.com/apache/superset/pull/22689) feat: add ssh tunneling to dynamic form for Database Connection UI (@hughhhh)
- [#22776](https://github.com/apache/superset/pull/22776) feat: Adds a separator to Select All option (@michael-s-molina)
- [#22707](https://github.com/apache/superset/pull/22707) feat: Generic X-axis improvements (@michael-s-molina)
- [#22084](https://github.com/apache/superset/pull/22084) feat: Select all for synchronous select (@cccs-RyanK)
- [#22723](https://github.com/apache/superset/pull/22723) feat(ssh_tunnel): Rename allow_ssh_tunneling and change the default value to False (@Antonio-RiveroMartnez)
- [#22610](https://github.com/apache/superset/pull/22610) feat: Enable new dataset creation flow (@lyndsiWilliams)
- [#21625](https://github.com/apache/superset/pull/21625) feat(plugin-chart-echarts): supports sunburst chart v2 [WIP] (@stephenLYZ)
- [#22737](https://github.com/apache/superset/pull/22737) feat: Updates button styles of Modal pre-defined functions (@michael-s-molina)
- [#22625](https://github.com/apache/superset/pull/22625) feat: Add logging for ssh tunneling test_connection attempts (@hughhhh)
- [#21645](https://github.com/apache/superset/pull/21645) feat(charts): allow query mutator to update queries after splitting original sql (@solanksh)
- [#22513](https://github.com/apache/superset/pull/22513) feat(ssh_tunnel): SQLAlchemy Form UI (@Antonio-RiveroMartnez)
- [#19779](https://github.com/apache/superset/pull/19779) feat: make CTA text in Alerts & Reports mails configurable (@cemremengu)
- [#22588](https://github.com/apache/superset/pull/22588) feat(dashboard): Display a loading spinner while dashboard is being saved (@kgabryje)
- [#22325](https://github.com/apache/superset/pull/22325) feat(RLS): RESTful apis and react view for RLS (@mayurnewase)
- [#21325](https://github.com/apache/superset/pull/21325) feat(db_engine_specs): big query cost estimation (@zamar-roura)
- [#22541](https://github.com/apache/superset/pull/22541) feat(helm): add deploymentLabels variable (@mathieuherbert)
- [#22526](https://github.com/apache/superset/pull/22526) feat(rbac): add customizable related filters (@villebro)
- [#22589](https://github.com/apache/superset/pull/22589) feat(chart): Added Papua New Guinea to countries map (@wilfred-wulbou)
- [#22498](https://github.com/apache/superset/pull/22498) feat(trino): support early cancellation of queries (@villebro)
- [#22458](https://github.com/apache/superset/pull/22458) feat: update time comparison choices (again) (@john-bodley)
- [#22302](https://github.com/apache/superset/pull/22302) feat(welcome): make examples tab customizable (@villebro)
- [#22328](https://github.com/apache/superset/pull/22328) feat(thumbnails): add support for user specific thumbs (@villebro)
- [#22379](https://github.com/apache/superset/pull/22379) feat: Add oneLine mode to AsyncSelect (@kgabryje)
- [#22364](https://github.com/apache/superset/pull/22364) feat(dashboard): Add edit button to dashboard native filters filter cards (@codyml)
- [#21318](https://github.com/apache/superset/pull/21318) feat(explore-popover): Show disabled 'Save' button in explore popover (@agl-developer)
- [#22136](https://github.com/apache/superset/pull/22136) feat: Flow for tables that already have a dataset (@lyndsiWilliams)
- [#22317](https://github.com/apache/superset/pull/22317) feat: New time range label (@kgabryje)
- [#21573](https://github.com/apache/superset/pull/21573) feat: add databricks form (@eschutho)
- [#22276](https://github.com/apache/superset/pull/22276) feat: Programmatically open "more filters" dropdown in Horizontal Filter Bar (@geido)
- [#22188](https://github.com/apache/superset/pull/22188) feat: root context provider extension point (@diegomedina248)
- [#22273](https://github.com/apache/superset/pull/22273) feat(native-filters): Adjust filter components for horizontal mode (@kgabryje)
- [#22287](https://github.com/apache/superset/pull/22287) feat: Automatically closes the DropdownContainer when scrolling outside of the component (@michael-s-molina)
- [#22250](https://github.com/apache/superset/pull/22250) feat: Adds overflow to the DropdownContainer popover (@michael-s-molina)
- [#22173](https://github.com/apache/superset/pull/22173) feat: Uses new table component in Drill to Detail (@michael-s-molina)
- [#22123](https://github.com/apache/superset/pull/22123) feat: add risingwave.py in db engine specs (@BowenXiao1999)
- [#21992](https://github.com/apache/superset/pull/21992) feat: CSV File Upload form updates (Grouping with Collapse/Expand) (@Antonio-RiveroMartnez)
- [#21993](https://github.com/apache/superset/pull/21993) feat: Axis sort in the Bar Chart V2 (@zhaoyongjie)
- [#22135](https://github.com/apache/superset/pull/22135) feat: Adds virtualization option to antd based Table component (@eric-briscoe)
- [#22220](https://github.com/apache/superset/pull/22220) feat(chart): Added Latvia to countries map (@maleksan)
- [#22169](https://github.com/apache/superset/pull/22169) feat: Make filters and dividers display horizontally in horizontal native filters filter bar (@codyml)
- [#21922](https://github.com/apache/superset/pull/21922) feat: CSV File Upload form updates (@Antonio-RiveroMartnez)
- [#22064](https://github.com/apache/superset/pull/22064) feat: Horizontal filter bar states (@geido)
- [#22160](https://github.com/apache/superset/pull/22160) feat: auto select schema (@betodealmeida)
- [#22039](https://github.com/apache/superset/pull/22039) feat: use a new official CH driver: clickhouse-connect (@EugeneTorap)
- [#21943](https://github.com/apache/superset/pull/21943) feat: refactor all `get_sqla_engine` to use contextmanager in codebase (@hughhhh)
- [#22077](https://github.com/apache/superset/pull/22077) feat: Add a new database driver for Amazon DynamoDB (@passren)
- [#21948](https://github.com/apache/superset/pull/21948) feat: Integrate ant d table component into DatasetPanel (@eric-briscoe)
- [#21520](https://github.com/apache/superset/pull/21520) feat: create table component based on ant design Table (@eric-briscoe)
- [#22020](https://github.com/apache/superset/pull/22020) feat(helm): add `metadata namespace` (@waynewenswag)
- [#21819](https://github.com/apache/superset/pull/21819) feat(dashboard): confirm overwrite to prevent unintended changes (@justinpark)
- [#22027](https://github.com/apache/superset/pull/22027) feat: Add 3 new extension points for inserting custom icons (@jfrag1)
- [#21895](https://github.com/apache/superset/pull/21895) feat: Improves SafeMarkdown HTML sanitization (@michael-s-molina)
- [#22031](https://github.com/apache/superset/pull/22031) feat: Adds more customization properties to DropdownContainer (@michael-s-molina)
- [#22004](https://github.com/apache/superset/pull/22004) feat(dashboard): Support changing filter bar location (@kgabryje)
- [#21974](https://github.com/apache/superset/pull/21974) feat: Adds the DropdownContainer component (@michael-s-molina)
- [#21767](https://github.com/apache/superset/pull/21767) feat: support mulitple temporal filters in AdhocFilter and move the Time Section away (@zhaoyongjie)
- [#21955](https://github.com/apache/superset/pull/21955) feat: Selectable dropdown triggered by icon component (@geido)
- [#21931](https://github.com/apache/superset/pull/21931) feat(reports): execute as other than selenium user (@villebro)
- [#21806](https://github.com/apache/superset/pull/21806) feat(helm): Support for flower and websocket containers (@Yann-J)
- [#21924](https://github.com/apache/superset/pull/21924) feat(dashboard): Move dashboard auto refresh intervals options to config (@zhaorui2022)
- [#21838](https://github.com/apache/superset/pull/21838) feat(bigquery): Custom message when Service Account doesnt have the correct Roles and Permissions (@Antonio-RiveroMartnez)
- [#21935](https://github.com/apache/superset/pull/21935) feat: Adds the HORIZONTAL_FILTER_BAR feature flag (@michael-s-molina)
- [#21790](https://github.com/apache/superset/pull/21790) feat: create function for get_sqla_engine with context (@hughhhh)
- [#21530](https://github.com/apache/superset/pull/21530) feat(rightmenu): Add Datasets to + Menu and Hide Databases when one has been connected (@Antonio-RiveroMartnez)
- [#21893](https://github.com/apache/superset/pull/21893) feat: Add dataset visuals for when a table is selected (@lyndsiWilliams)
- [#21879](https://github.com/apache/superset/pull/21879) feat(explore): add config for default time filter (@Usiel)
- [#21351](https://github.com/apache/superset/pull/21351) feat(dashboard): menu improvements, fallback support for Drill to Detail (@codyml)
- [#21840](https://github.com/apache/superset/pull/21840) feat(datasets): Change in API to create virtual datasets (@sinhashubham95)
- [#20934](https://github.com/apache/superset/pull/20934) feat(explore): Don't discard controls with custom sql when changing datasource (@kgabryje)
- [#21867](https://github.com/apache/superset/pull/21867) feat(select filter): add CRLF separator for Windows (@mapledan)
- [#21507](https://github.com/apache/superset/pull/21507) feat(color): color consistency enhancements (@stephenLYZ)
- [#21760](https://github.com/apache/superset/pull/21760) feat: Cross-referenced Dashboards in Chart list (Column + Filter) (@geido)
- [#21319](https://github.com/apache/superset/pull/21319) feat(embedded-dashboard): Share Switchboard State for Sending Events from Plugins (@sinhashubham95)
- [#21486](https://github.com/apache/superset/pull/21486) feat: add denylist for db engines (@eschutho)
- [#20312](https://github.com/apache/superset/pull/20312) feat(api): Add option to enable sync on import (@reesercollins)
- [#21685](https://github.com/apache/superset/pull/21685) feat: Shows related dashboards in Explore (@michael-s-molina)
- [#21708](https://github.com/apache/superset/pull/21708) feat: Adds the CROSS_REFERENCE feature flag (@michael-s-molina)
- [#21713](https://github.com/apache/superset/pull/21713) feat: support None operand in EQUAL operator (@zhaoyongjie)
- [#21649](https://github.com/apache/superset/pull/21649) feat(chart): add feature flag that displays the data pane closed by default (@Painyjames)
- [#21683](https://github.com/apache/superset/pull/21683) feat: Use SPA navigation between AddSlice and Dataset list pages (@kgabryje)
- [#21664](https://github.com/apache/superset/pull/21664) feat: deprecate created_slices API endpoint (@dpgaspar)
- [#21352](https://github.com/apache/superset/pull/21352) feat: Added latin america countries to country map (@bryanjtc)
- [#21560](https://github.com/apache/superset/pull/21560) feat: Adds the MetadataBar to the Explore header (@michael-s-molina)
- [#21515](https://github.com/apache/superset/pull/21515) feat: new config to filter specific users from dropdown lists (@dpgaspar)
- [#21444](https://github.com/apache/superset/pull/21444) feat(embedded): +2 functions: getDashboardPermalink, getActiveTabs (@jayakrishnankk)
- [#21593](https://github.com/apache/superset/pull/21593) feat: explicit distribute columns on BoxPlot and apply time grain (@zhaoyongjie)
- [#21577](https://github.com/apache/superset/pull/21577) feat: adding XAxis to BigNumberTrend (@zhaoyongjie)
- [#21241](https://github.com/apache/superset/pull/21241) feat: Dataset Creation Footer Component (@AAfghahi)
- [#21518](https://github.com/apache/superset/pull/21518) feat: Increments charts endpoint with related dashboards (@michael-s-molina)
- [#21547](https://github.com/apache/superset/pull/21547) feat: support multiple columns with time grain in Table Chart (@zhaoyongjie)
- [#20931](https://github.com/apache/superset/pull/20931) feat(helm): add RollingUpdate parameters (@gforien)
- [#21537](https://github.com/apache/superset/pull/21537) feat: support multiple time columns with time grain in Pivot Table v2 (@zhaoyongjie)
- [#21213](https://github.com/apache/superset/pull/21213) feat(nav): Update Tabbed Nav on CRUD Pages (@Antonio-RiveroMartnez)
- [#21536](https://github.com/apache/superset/pull/21536) feat(helm): add annotations on ServiceAccount (@gforien)
- [#21519](https://github.com/apache/superset/pull/21519) feat: generate consistent QueryObject whether GenericAxis is enabled or disabled (@zhaoyongjie)
- [#21482](https://github.com/apache/superset/pull/21482) feat: Making bar graphs in Table viz from fixed-size divs instead of calculated gradients (@rusackas)
- [#21443](https://github.com/apache/superset/pull/21443) feat(filters): add onFilterUpdate handler to list view filters (@riahk)
- [#21189](https://github.com/apache/superset/pull/21189) feat: Create dataset header component (@lyndsiWilliams)
- [#21356](https://github.com/apache/superset/pull/21356) feat(plugin-chart-echarts): able to sort bar on the bar chart V2 (@stephenLYZ)
- [#21322](https://github.com/apache/superset/pull/21322) feat: add snowflake keypair authentication (@xiayanzheng)
- [#21343](https://github.com/apache/superset/pull/21343) feat: Adds MetadataBar to Drill to Detail modal (@michael-s-molina)
- [#21245](https://github.com/apache/superset/pull/21245) feat: Update nav bar with new data information architecture for SQL Lab + SQL (@hughhhh)
- [#21075](https://github.com/apache/superset/pull/21075) feat: add tableselector to dataset creation page (@pkdotson)
- [#21163](https://github.com/apache/superset/pull/21163) feat: apply Time Grain to X-Axis column (@zhaoyongjie)
- [#20837](https://github.com/apache/superset/pull/20837) feat: only show active user for chart/dashboard/datasource owner drop… (@zephyring)
- [#21321](https://github.com/apache/superset/pull/21321) feat(explore): standardized controls for time pivot chart (@stephenLYZ)
- [#21248](https://github.com/apache/superset/pull/21248) feat: filter parameters from DB API (@betodealmeida)
- [#21269](https://github.com/apache/superset/pull/21269) feat: Adds a helper text option to the Select component (@michael-s-molina)
- [#21300](https://github.com/apache/superset/pull/21300) feat(sqllab): Make LeftBar width resizable (@justinpark)
- [#21070](https://github.com/apache/superset/pull/21070) feat(embedded): provides filter bar visibility setting on embedded dashboard (#21069) (@jileeon)
- [#21199](https://github.com/apache/superset/pull/21199) feat: filter with created_by for charts and dashboards (@lilykuang)
- [#21236](https://github.com/apache/superset/pull/21236) feat(helm): Added env variable SERVER_WORKER_AMOUNT (@rathberm)
- [#20295](https://github.com/apache/superset/pull/20295) feat: Environment tag (@reesercollins)
- [#20309](https://github.com/apache/superset/pull/20309) feat: Virtual dataset duplication (@reesercollins)
- [#21168](https://github.com/apache/superset/pull/21168) feat: Adds drill to detail context menu to Table (@michael-s-molina)
- [#21198](https://github.com/apache/superset/pull/21198) feat: Adds drill to detail context menu to Pivot Table (@michael-s-molina)
- [#21170](https://github.com/apache/superset/pull/21170) feat: print comment for chromatic storybook link (@hughhhh)
- [#21095](https://github.com/apache/superset/pull/21095) feat: Add Chromatic publishing to superset-frontend storybook (@eric-briscoe)
- [#21150](https://github.com/apache/superset/pull/21150) feat: Adds drill to detail context menu to World Map (@michael-s-molina)
- [#21058](https://github.com/apache/superset/pull/21058) feat: Create dataset blank state (@lyndsiWilliams)
- [#20728](https://github.com/apache/superset/pull/20728) feat(dashboard): Add Drill to Detail modal w/ chart menu + right-click support (@codyml)
- [#21124](https://github.com/apache/superset/pull/21124) feat: generate label map on the backend (@zhaoyongjie)
- [#21040](https://github.com/apache/superset/pull/21040) feat: Add label and tooltip for the color schemes control (@geido)
- [#21116](https://github.com/apache/superset/pull/21116) feat: Allow users to set Tab Title from superset_config.py (@hughhhh)
- [#20903](https://github.com/apache/superset/pull/20903) feat: add header_data into emails (@AAfghahi)
- [#21090](https://github.com/apache/superset/pull/21090) feat: Adds the MetadataBar component (@michael-s-molina)
- [#21102](https://github.com/apache/superset/pull/21102) feat: update makefile with reports and alerts (@hughhhh)
- [#21033](https://github.com/apache/superset/pull/21033) feat: add extension point for workspace home page (@riahk)
- [#21035](https://github.com/apache/superset/pull/21035) feat(trino): add query cancellation (@villebro)
- [#20891](https://github.com/apache/superset/pull/20891) feat: Adds drill to detail context menu for ECharts visualizations (@michael-s-molina)
- [#20567](https://github.com/apache/superset/pull/20567) feat(helm): add liveness and readiness for deployment webserver (@jplanckeel)
- [#20990](https://github.com/apache/superset/pull/20990) feat: per-db add metrics (@betodealmeida)
- [#21008](https://github.com/apache/superset/pull/21008) feat: supports mulitple filters in samples endpoint (@zhaoyongjie)
- [#20945](https://github.com/apache/superset/pull/20945) feat: useReducer for dataset creation (@AAfghahi)
- [#20835](https://github.com/apache/superset/pull/20835) feat: add 'dashboard.nav.right' extension to registry (@samtfm)
- [#20416](https://github.com/apache/superset/pull/20416) feat(embedded-SDK): enable CSV download (@lilykuang)
- [#20670](https://github.com/apache/superset/pull/20670) feat: Add resize drag handle to Dataset SQL fields (@diegomedina248)
- [#20869](https://github.com/apache/superset/pull/20869) feat: Creating dataset/add route (@AAfghahi)
- [#20852](https://github.com/apache/superset/pull/20852) feat(SqlLab): Change Save Dataset Button to Split Save Query Button IV (@lyndsiWilliams)
- [#20883](https://github.com/apache/superset/pull/20883) feat(helm): support different replicaCount (@gforien)
- [#20890](https://github.com/apache/superset/pull/20890) feat: Use SPA navigation from datasets list to Explore (@kgabryje)
- [#20908](https://github.com/apache/superset/pull/20908) feat: allow more HTML tags in report description (@ktmud)
- [#20528](https://github.com/apache/superset/pull/20528) feat(dashboard): Add thumbnails to dashboard edit draggable chart list (@codyml)
- [#20799](https://github.com/apache/superset/pull/20799) feat(sql lab): display presto and trino tracking url (@ktmud)
- [#20755](https://github.com/apache/superset/pull/20755) feat: blankstate metrics columns (@pkdotson)
- [#20842](https://github.com/apache/superset/pull/20842) feat: a simple LRUCache in frontend (@zhaoyongjie)
- [#20848](https://github.com/apache/superset/pull/20848) feat(explore): UX changes in fast viz switcher (@kgabryje)
- [#20743](https://github.com/apache/superset/pull/20743) feat: Pass dashboard context to explore through local storage (@kgabryje)
- [#20801](https://github.com/apache/superset/pull/20801) feat: Add Türkiye Map to Country Map (@rizacavus)
- [#20809](https://github.com/apache/superset/pull/20809) feat: Create Chart onClick Functionality (@AAfghahi)
- [#20683](https://github.com/apache/superset/pull/20683) feat: the samples endpoint supports filters and pagination (@zhaoyongjie)
- [#20778](https://github.com/apache/superset/pull/20778) feat(dashboard): Make FilterBar width resizable (@justinpark)
- [#20281](https://github.com/apache/superset/pull/20281) feat: Visualize SqlLab.Query model data in Explore 📈 (@hughhhh)
- [#20632](https://github.com/apache/superset/pull/20632) feat(dashboard): make permalinks stable (@ktmud)
- [#20668](https://github.com/apache/superset/pull/20668) feat: Reuse Dashboard redux data in Explore (@kgabryje)
- [#19965](https://github.com/apache/superset/pull/19965) feat: have user go to explore after dataset creation (@pkdotson)
- [#20666](https://github.com/apache/superset/pull/20666) feat(HelmChart): Add securityContext on pod level (@miloszbednarzak)
- [#20648](https://github.com/apache/superset/pull/20648) feat(handlebars plugin): adding handlebars helpers for common math/formatting operations (@rusackas)
- [#20606](https://github.com/apache/superset/pull/20606) feat(dashboard): Transition to Explore with React Router (@kgabryje)
- [#19383](https://github.com/apache/superset/pull/19383) feat: truncate long values in table viz, a per-column setting (@stevetracvc)
- [#20600](https://github.com/apache/superset/pull/20600) feat: add hooks on set_perm for new data permissions (@dpgaspar)
- [#20509](https://github.com/apache/superset/pull/20509) feat(HelmChart): Configurable securityContext in Pods (@miloszbednarzak)
- [#20017](https://github.com/apache/superset/pull/20017) feat: hack db connection modal ctabtns (@pkdotson)
- [#20586](https://github.com/apache/superset/pull/20586) feat: drop missing columns control (@zhaoyongjie)
- [#19520](https://github.com/apache/superset/pull/19520) feat(deck.gl): add color range for deck.gl 3D chart (@stephenLYZ)
- [#20512](https://github.com/apache/superset/pull/20512) feat(sql lab): Save Dataset Modal Autocomplete should display list when overwritting (@Antonio-RiveroMartnez)
- [#20575](https://github.com/apache/superset/pull/20575) feat: add extension point to the top of welcome page (@lilykuang)
- [#20579](https://github.com/apache/superset/pull/20579) feat: apply standardized form data to deckgl (@zhaoyongjie)
- [#20514](https://github.com/apache/superset/pull/20514) feat: add extension point to the right side of the menu bar (@samtfm)
- [#20530](https://github.com/apache/superset/pull/20530) feat: apply standardized form data to tier 2 charts (@zhaoyongjie)
- [#20524](https://github.com/apache/superset/pull/20524) feat(explore): Apply denormalization to tier 2 charts form data (@kgabryje)
- [#20513](https://github.com/apache/superset/pull/20513) feat(vizgallery): Double-click viz type to submit form (@codyml)
- [#20462](https://github.com/apache/superset/pull/20462) feat: add Spark Sql DB engine spec and support Spark 3.x (@SusurHe)
- [#20399](https://github.com/apache/superset/pull/20399) feat: Adds the /explore endpoint to the v1 API (@michael-s-molina)
- [#20056](https://github.com/apache/superset/pull/20056) feat(SQL Lab): Make SQL Lab explore use the default viz from the config file (@cccs-Dustin)
- [#20397](https://github.com/apache/superset/pull/20397) feat: Adds support for clearing the Select cache (@michael-s-molina)
- [#20251](https://github.com/apache/superset/pull/20251) feat(embedded): enforce allow domains (@lilykuang)
- [#20412](https://github.com/apache/superset/pull/20412) feat: allow setting db UUID (@betodealmeida)

**Fixes**

- [#23388](https://github.com/apache/superset/pull/23388) fix: update default WEBDRIVER_OPTION_ARGS and add Firefox libs to Dockerfile (@nytai)
- [#23299](https://github.com/apache/superset/pull/23299) fix(dashboard): Infinite load when filter with default first value is out of scope (@kgabryje)
- [#23238](https://github.com/apache/superset/pull/23238) fix(dashboard): Charts crashing when cross filter on adhoc column is applied (@kgabryje)
- [#23243](https://github.com/apache/superset/pull/23243) fix: customize tab on heatmap chart is blank (@lilykuang)
- [#23246](https://github.com/apache/superset/pull/23246) fix(dao): use explicit id filter (@villebro)
- [#23186](https://github.com/apache/superset/pull/23186) fix: refuse to start with default secret on non debug envs (@dpgaspar)
- [#23237](https://github.com/apache/superset/pull/23237) fix(dashboard): Don't show cross filters checkbox to users without write permissions (@kgabryje)
- [#23217](https://github.com/apache/superset/pull/23217) fix: add disallowed query params for engines specs (@dpgaspar)
- [#23190](https://github.com/apache/superset/pull/23190) fix(dashboard): Focusing charts and native filters from filters badge (@kgabryje)
- [#23192](https://github.com/apache/superset/pull/23192) fix(clickhouse): add missing default format (@villebro)
- [#23185](https://github.com/apache/superset/pull/23185) fix(clickhouse): add clickhouse connect driver (@villebro)
- [#23184](https://github.com/apache/superset/pull/23184) fix: bump FAB to 4.3.0 (@dpgaspar)
- [#23118](https://github.com/apache/superset/pull/23118) fix(rbac): show objects accessible by database access perm (@villebro)
- [#23175](https://github.com/apache/superset/pull/23175) fix(ssh-tunnel): add password to `from_private_key` function (@hughhhh)
- [#23195](https://github.com/apache/superset/pull/23195) fix(ssh_tunnel): Display SSHTunnel Switch when editing a DB that was created with the Dynamic Form (@Antonio-RiveroMartnez)
- [#23196](https://github.com/apache/superset/pull/23196) fix(sshtunnel): argument params to properly setting `server_port` (@hughhhh)
- [#23096](https://github.com/apache/superset/pull/23096) fix: reorganize role permissions (@dpgaspar)
- [#23107](https://github.com/apache/superset/pull/23107) fix: missing **init** on module sqllab commands (@dpgaspar)
- [#23101](https://github.com/apache/superset/pull/23101) fix: removing pyproject.toml (@zephyring)
- [#23093](https://github.com/apache/superset/pull/23093) fix: dict bug on QueryContextFactory (@okayhooni)
- [#23083](https://github.com/apache/superset/pull/23083) fix: css template permissions for gamma role (@dpgaspar)
- [#23012](https://github.com/apache/superset/pull/23012) fix: cache warmup solution non legacy charts. (@dheeraj-jaiswal-lowes)
- [#22968](https://github.com/apache/superset/pull/22968) fix(sqllab): Invalid schema fetch by deprecated value (@justinpark)
- [#22939](https://github.com/apache/superset/pull/22939) fix(i18n): improve Russian translation (@artemonsh)
- [#23039](https://github.com/apache/superset/pull/23039) fix: Menu items are not disappearing when deleting a dashboard (@michael-s-molina)
- [#23021](https://github.com/apache/superset/pull/23021) fix: Time Column on Generic X-axis (@michael-s-molina)
- [#21720](https://github.com/apache/superset/pull/21720) fix(dashboard): Stop updating chart owners for charts removed from dashboard (@codyml)
- [#22830](https://github.com/apache/superset/pull/22830) fix: Handles disabled options on Select All (@michael-s-molina)
- [#23006](https://github.com/apache/superset/pull/23006) fix(ssh_tunnel): Fix bug on database edition for databases with ssh tunnels (@Antonio-RiveroMartnez)
- [#23025](https://github.com/apache/superset/pull/23025) fix: dataset import error message (@dpgaspar)
- [#23020](https://github.com/apache/superset/pull/23020) fix(explore): Enable saving metric after changing title (@kgabryje)
- [#22990](https://github.com/apache/superset/pull/22990) fix(sqllab): clean unwanted scrollbar (@justinpark)
- [#22471](https://github.com/apache/superset/pull/22471) fix(dashboard): export & import chart description and certification details (@artemonsh)
- [#22991](https://github.com/apache/superset/pull/22991) fix(migrations): Flask-Migrate output is not logged during alembic migrations #17991 (@treygilliland)
- [#22947](https://github.com/apache/superset/pull/22947) fix: Make cte_alias a property of db engine spec (@alexclavel-ocient)
- [#23000](https://github.com/apache/superset/pull/23000) fix(explore): Save button incorrectly disabled when adding new metric with dnd (@kgabryje)
- [#22942](https://github.com/apache/superset/pull/22942) fix: add new config to allow for specific import data urls (@dpgaspar)
- [#22989](https://github.com/apache/superset/pull/22989) fix: Form data was not being passed to save/update slice (@michael-s-molina)
- [#22984](https://github.com/apache/superset/pull/22984) fix(explore): Mark time range dashboard filter with warning icon (@kgabryje)
- [#22982](https://github.com/apache/superset/pull/22982) fix: Prevents last temporal filter removal (@michael-s-molina)
- [#22941](https://github.com/apache/superset/pull/22941) fix(native-filters): Don't include description icon in truncation calc (@kgabryje)
- [#22943](https://github.com/apache/superset/pull/22943) fix(datasets): Include expression and description in duplicated dataset columns (@codyml)
- [#22896](https://github.com/apache/superset/pull/22896) fix(explore): unable to update linked charts (@justinpark)
- [#22945](https://github.com/apache/superset/pull/22945) fix(explore): Time comparison in Mixed Chart in GENERIC_CHART_AXES not working (@kgabryje)
- [#22929](https://github.com/apache/superset/pull/22929) fix: Improve performance of CSV download (@etr2460)
- [#22944](https://github.com/apache/superset/pull/22944) fix(datasets): Fix property selection on JSON response (@codyml)
- [#22940](https://github.com/apache/superset/pull/22940) fix: Remove button is broken for metrics on Explore (@michael-s-molina)
- [#22937](https://github.com/apache/superset/pull/22937) fix(native-filters): Ensure that time range filter loses focus after closing modal (@kgabryje)
- [#22912](https://github.com/apache/superset/pull/22912) fix: fix warning in ssh tunnel (@AAfghahi)
- [#22889](https://github.com/apache/superset/pull/22889) fix(fab): Fix regression on FAB dropdowns (@codyml)
- [#22920](https://github.com/apache/superset/pull/22920) fix: Time range filter applied on a dashboard is not persisting to the chart explore (@michael-s-molina)
- [#22744](https://github.com/apache/superset/pull/22744) fix(dependency): update cryptography import (@Germandrummer92)
- [#22036](https://github.com/apache/superset/pull/22036) fix(i18n): greatly optimize Chinese translation (@kpretty)
- [#21999](https://github.com/apache/superset/pull/21999) fix(sqllab): inconsistent addNewQueryEditor behavior (@justinpark)
- [#22881](https://github.com/apache/superset/pull/22881) fix: edit pyarrow stringify to better handle emojis and accents (@eschutho)
- [#22907](https://github.com/apache/superset/pull/22907) fix: bump isort to fix pre-commit CI (@EugeneTorap)
- [#22818](https://github.com/apache/superset/pull/22818) fix: revert RESTful apis and react view for RLS (@mayurnewase)
- [#22861](https://github.com/apache/superset/pull/22861) fix(sqllab): reverts #22695 (@justinpark)
- [#22872](https://github.com/apache/superset/pull/22872) fix: Convert TIMESTAMP\_\* to TIMESTAMP in Snowflake (@geido)
- [#22453](https://github.com/apache/superset/pull/22453) fix(Annotation Layers): Error when render options with renamed columns (@Always-prog)
- [#22791](https://github.com/apache/superset/pull/22791) fix(cpq): Add `schema` to Query.data() payload (@hughhhh)
- [#22813](https://github.com/apache/superset/pull/22813) fix(sqllab): type error on renderBigIntStr (@justinpark)
- [#22807](https://github.com/apache/superset/pull/22807) fix: allow CSV upload in Other db (@betodealmeida)
- [#22814](https://github.com/apache/superset/pull/22814) fix: Unexpected error on simple filter (@michael-s-molina)
- [#22794](https://github.com/apache/superset/pull/22794) fix(hive): Regression in #21794 (@john-bodley)
- [#22792](https://github.com/apache/superset/pull/22792) fix: better logic to extract errors on databricks (@eschutho)
- [#22695](https://github.com/apache/superset/pull/22695) fix(sqllab): Invalid schema fetch for deprecated value (@justinpark)
- [#22764](https://github.com/apache/superset/pull/22764) fix(ssh-tunnel): update fields for open tunnel with private + private key passwords (@hughhhh)
- [#16926](https://github.com/apache/superset/pull/16926) fix: Read MAPBOX_API_KEY from environment (@Lawful2002)
- [#22763](https://github.com/apache/superset/pull/22763) fix(ssh-tunnel): wrap pkey into StringIO buffer before creating the tunnel (@hughhhh)
- [#22727](https://github.com/apache/superset/pull/22727) fix: pass in slack error messages properly (@eschutho)
- [#22614](https://github.com/apache/superset/pull/22614) fix: Report screenshot cut off on left and right sides (@lyndsiWilliams)
- [#22698](https://github.com/apache/superset/pull/22698) fix: change order of webdriver timeout checks (@eschutho)
- [#21185](https://github.com/apache/superset/pull/21185) fix(async-queries): make global async. queries cookie SameSite option configurable (@rdubois)
- [#22671](https://github.com/apache/superset/pull/22671) fix: remove whitespace from http_path for databricks (@eschutho)
- [#22716](https://github.com/apache/superset/pull/22716) fix(helm): remove config overrides for CSRF (@reidab)
- [#22693](https://github.com/apache/superset/pull/22693) fix(explore): Restore missing dataset states (@codyml)
- [#22720](https://github.com/apache/superset/pull/22720) fix: bootstraping frontend (@cdreier)
- [#22709](https://github.com/apache/superset/pull/22709) fix: Spacing in alert modal (@lyndsiWilliams)
- [#22688](https://github.com/apache/superset/pull/22688) fix: alert modal bug fix (@AAfghahi)
- [#22462](https://github.com/apache/superset/pull/22462) fix(embed): fix server error due to breaking change on flask-login (@Usiel)
- [#22609](https://github.com/apache/superset/pull/22609) fix(sqllab): Overflow bigint in json-tree view (@justinpark)
- [#22682](https://github.com/apache/superset/pull/22682) fix(nav): make doc and bug buttons customizable (@villebro)
- [#22659](https://github.com/apache/superset/pull/22659) fix(bootstrap-data): always check flashes (@villebro)
- [#22658](https://github.com/apache/superset/pull/22658) fix(viz-gallery): respect denylist in viz gallery (@villebro)
- [#22663](https://github.com/apache/superset/pull/22663) fix(dockerfile): fix "unhealthy" container state (@artemonsh)
- [#22635](https://github.com/apache/superset/pull/22635) fix: Stop query in SQL Lab with impala engine (@wanghong1314)
- [#22648](https://github.com/apache/superset/pull/22648) fix(dashboard): Add safety checks to areas that throw runtime errors in dashboard filters (@eric-briscoe)
- [#22566](https://github.com/apache/superset/pull/22566) fix(sqllab): remove link to sqllab if missing perms (@villebro)
- [#22628](https://github.com/apache/superset/pull/22628) fix: stringify ValueErrors for NaT types (@eschutho)
- [#22443](https://github.com/apache/superset/pull/22443) fix: change type of slack error (@eschutho)
- [#22457](https://github.com/apache/superset/pull/22457) fix(dashboard): Add runtime safety checks and improved tests (@eric-briscoe)
- [#22581](https://github.com/apache/superset/pull/22581) fix(ssh-tunnel): fix dataset creation flow through modal for DB with tunnel (@hughhhh)
- [#21772](https://github.com/apache/superset/pull/21772) fix: change example comment to match type (@eschutho)
- [#22586](https://github.com/apache/superset/pull/22586) fix: adding extraConfig to celery beat deployment (@cdreier)
- [#22358](https://github.com/apache/superset/pull/22358) fix: dashboard get by id or slug access filter (@dpgaspar)
- [#22591](https://github.com/apache/superset/pull/22591) fix: Talisman configuration (@michael-s-molina)
- [#22590](https://github.com/apache/superset/pull/22590) fix(helm): Fixing up chart and linting (@craig-rueda)
- [#22565](https://github.com/apache/superset/pull/22565) fix(explore): support saving undefined time grain (@villebro)
- [#22567](https://github.com/apache/superset/pull/22567) fix(cypress): make test chart time range deterministic (@villebro)
- [#22563](https://github.com/apache/superset/pull/22563) fix(websocket): bump ts-node to fix startup error (@villebro)
- [#22507](https://github.com/apache/superset/pull/22507) fix(localization): pybabel doesn't extract plural forms from frontend (@artemonsh)
- [#22523](https://github.com/apache/superset/pull/22523) fix: adding missing examples for bubble chart, bullet chart, calendar heatmap chart and country map chart in the gallery (@yash-samsung)
- [#22543](https://github.com/apache/superset/pull/22543) fix(explore): datasource_type typo (@Musa10)
- [#22314](https://github.com/apache/superset/pull/22314) fix(init): Initialize \_jwt_cookie_name in AsyncQueryManager **init** (@xneg)
- [#22512](https://github.com/apache/superset/pull/22512) fix(cypress): disable flaky tests (@villebro)
- [#22208](https://github.com/apache/superset/pull/22208) fix(assets api): import replaces dashboard (@Stanhoucke)
- [#22475](https://github.com/apache/superset/pull/22475) fix(chart-list): Hide 'Dashboards added to' column. (@codyml)
- [#22066](https://github.com/apache/superset/pull/22066) fix: Fixed spacing in alert modal (@lyndsiWilliams)
- [#22262](https://github.com/apache/superset/pull/22262) fix: Create dataset polish/bug fix (@lyndsiWilliams)
- [#22421](https://github.com/apache/superset/pull/22421) fix: fix comment in Docker environment files (@aleksvujic)
- [#22460](https://github.com/apache/superset/pull/22460) fix(cypress): Fix failing/flaky E2E tests (@codyml)
- [#22440](https://github.com/apache/superset/pull/22440) fix: remove unsupported REST API search col with dotted notation on c… (@dpgaspar)
- [#21064](https://github.com/apache/superset/pull/21064) fix(chart-table): Scrollbar causing header + footer overflow (@reesercollins)
- [#22431](https://github.com/apache/superset/pull/22431) fix(hive): Fix regression from #21943 (@john-bodley)
- [#22383](https://github.com/apache/superset/pull/22383) fix(dashboard): Update owners of dashboard list after editing (@hiroki-sawano)
- [#22417](https://github.com/apache/superset/pull/22417) fix: Force configuration for SafeMarkdown component in Handlebars (@geido)
- [#21737](https://github.com/apache/superset/pull/21737) fix(trino): Fix Trino timestamp conversion (@mdesmet)
- [#22405](https://github.com/apache/superset/pull/22405) fix(sqla): copy temporal range logic to helper (@villebro)
- [#21724](https://github.com/apache/superset/pull/21724) fix(report): Capture unexpected errors in report screenshots. Fixes #21653 (@zhaorui2022)
- [#22350](https://github.com/apache/superset/pull/22350) fix: make database connection modal ace fields uncontrolled (@eschutho)
- [#22381](https://github.com/apache/superset/pull/22381) fix: correct exception level in log and add error message (@eschutho)
- [#21965](https://github.com/apache/superset/pull/21965) fix: Update typo in docker-add-drivers.mdx (@jankatins)
- [#22361](https://github.com/apache/superset/pull/22361) fix: make sure that gsheets db connection form loads properly (@eschutho)
- [#19576](https://github.com/apache/superset/pull/19576) fix(readme): link target and title (@mikkeschiren)
- [#21942](https://github.com/apache/superset/pull/21942) fix(translations): French translation (typo fixes) (@xavier-GitHub76)
- [#22357](https://github.com/apache/superset/pull/22357) fix(snowflake): Allow encrypted_extra field to be imported (@askldjd)
- [#22365](https://github.com/apache/superset/pull/22365) fix: Button resizing in horizontal filter bar (@michael-s-molina)
- [#22373](https://github.com/apache/superset/pull/22373) fix: Add tooltip to dropdown trigger in horizontal filter bar (@kgabryje)
- [#22371](https://github.com/apache/superset/pull/22371) fix: DropdownContainer items width calculation (@michael-s-molina)
- [#22338](https://github.com/apache/superset/pull/22338) fix: Time filter position and click in Horizontal FilterBar (@geido)
- [#22360](https://github.com/apache/superset/pull/22360) fix: Change dropdown in Alert/Report modal to use javascript for conditional rendering instead of css (@lyndsiWilliams)
- [#22362](https://github.com/apache/superset/pull/22362) fix: Reordering native filters ignored by filter bar (@kgabryje)
- [#22349](https://github.com/apache/superset/pull/22349) fix(bigquery): Properly display errors for BigQuery DBs (@Antonio-RiveroMartnez)
- [#22324](https://github.com/apache/superset/pull/22324) fix: Broken effect in useCSSTextTruncation hook (@codyml)
- [#22346](https://github.com/apache/superset/pull/22346) fix: Missing spacing in adhoc filters popover (@kgabryje)
- [#22337](https://github.com/apache/superset/pull/22337) fix: Styling fixes for horizontal filter bar (@kgabryje)
- [#22329](https://github.com/apache/superset/pull/22329) fix(sqllab): Fix autocomplete for SQL Lab (@Antonio-RiveroMartnez)
- [#22320](https://github.com/apache/superset/pull/22320) fix: add columns back into SQL Lab to Explore Flow (@AAfghahi)
- [#22200](https://github.com/apache/superset/pull/22200) fix: Display Error Messages in DB Connection Modal (@AAfghahi)
- [#22319](https://github.com/apache/superset/pull/22319) fix(dashboard): Fix dashboard's left side being cut off (@kgabryje)
- [#22323](https://github.com/apache/superset/pull/22323) fix(dashboard): dashboard actions fail when bad component id exists in children array (@eric-briscoe)
- [#22318](https://github.com/apache/superset/pull/22318) fix: DropdownContainer resize algorithm (@michael-s-molina)
- [#22280](https://github.com/apache/superset/pull/22280) fix(sqla): use same template processor in all methods (@villebro)
- [#22321](https://github.com/apache/superset/pull/22321) fix: convert `<NA>` values to None instead of stringifying (@eschutho)
- [#22274](https://github.com/apache/superset/pull/22274) fix(alerts): cron picker alignment issues (@diegomedina248)
- [#22303](https://github.com/apache/superset/pull/22303) fix(docker): Fixing ws docker push (@craig-rueda)
- [#22009](https://github.com/apache/superset/pull/22009) fix(dashboard): chart doesn't resize when tab switch (@stephenLYZ)
- [#22286](https://github.com/apache/superset/pull/22286) fix: Horizontal filter bar resizing (@michael-s-molina)
- [#22288](https://github.com/apache/superset/pull/22288) fix(native-filters): Misc spacing fixes for horizontal and horizontal overflow filter bar items (@codyml)
- [#22289](https://github.com/apache/superset/pull/22289) fix(native-filters): Add empty text node before OutPortal (@codyml)
- [#22264](https://github.com/apache/superset/pull/22264) fix: allow datasource imports on Windows (@BTatlock)
- [#22252](https://github.com/apache/superset/pull/22252) fix(dashboard): Change horizontal filter bar divider truncation logic (@codyml)
- [#22265](https://github.com/apache/superset/pull/22265) fix(dashboard): Force native filters into vertical orientation when FF off (@codyml)
- [#22260](https://github.com/apache/superset/pull/22260) fix(dashboard): Fix FilterWithDataMask typing and add null check (@codyml)
- [#22249](https://github.com/apache/superset/pull/22249) fix(file_upload): Fix columnar and Excel upload forms (@Antonio-RiveroMartnez)
- [#22010](https://github.com/apache/superset/pull/22010) fix: Apply border radius and fix height for MetadataBar (@kgabryje)
- [#22211](https://github.com/apache/superset/pull/22211) fix(dashboard): Add correct icon, label and badge to horizontal native filters dropdown button (@codyml)
- [#22210](https://github.com/apache/superset/pull/22210) fix(dashboard): Fix hover labels for horizontal overflow native filter dividers (@codyml)
- [#22212](https://github.com/apache/superset/pull/22212) fix(dashboard): Fix filter card positioning for horizontal native filters (@codyml)
- [#22238](https://github.com/apache/superset/pull/22238) fix(generic-chart-axes): apply time filter on all target column types (@villebro)
- [#22234](https://github.com/apache/superset/pull/22234) fix: the TimePicker overlay the AdhocFilter (@zhaoyongjie)
- [#22196](https://github.com/apache/superset/pull/22196) fix(reports): force data generation in csv reports (@mayurnewase)
- [#22219](https://github.com/apache/superset/pull/22219) fix(explore): Prevent infinite rerenders when editing dataset (@kgabryje)
- [#22213](https://github.com/apache/superset/pull/22213) fix: (dashboard) Adds optional chaining to avoid runtime error (@eric-briscoe)
- [#22218](https://github.com/apache/superset/pull/22218) fix(plugin-chart-echarts): tooltip overflow bug (@villebro)
- [#22082](https://github.com/apache/superset/pull/22082) fix: Drill to detail blocked by tooltip (@michael-s-molina)
- [#22207](https://github.com/apache/superset/pull/22207) fix(explore): Value undefined and Unhashable type errors (@kgabryje)
- [#22186](https://github.com/apache/superset/pull/22186) fix: Empty Error Alert Modal (@AAfghahi)
- [#22171](https://github.com/apache/superset/pull/22171) fix: don't stringify extraJson in form (@eschutho)
- [#22179](https://github.com/apache/superset/pull/22179) fix: chart id mapping in dashboard api (@villebro)
- [#22172](https://github.com/apache/superset/pull/22172) fix: SQL Lab QuerySource via referrer (@john-bodley)
- [#22147](https://github.com/apache/superset/pull/22147) fix: Unhandled exception Str Column Type (@sinhashubham95)
- [#22170](https://github.com/apache/superset/pull/22170) fix: Adds time grain to Pivot Table v2 (@michael-s-molina)
- [#22152](https://github.com/apache/superset/pull/22152) fix: Flaky E2E tests (@geido)
- [#22167](https://github.com/apache/superset/pull/22167) fix(alerts): execute query as report executor (@villebro)
- [#22115](https://github.com/apache/superset/pull/22115) fix: Add scrollTopOnPagination property to Table (@geido)
- [#22118](https://github.com/apache/superset/pull/22118) fix: slug is empty if filename is non-ASCII (@EugeneTorap)
- [#22137](https://github.com/apache/superset/pull/22137) fix: Missing applied filters indicator (@john-bodley)
- [#22129](https://github.com/apache/superset/pull/22129) fix: add back database lookup from sip 68 revert (@eschutho)
- [#22013](https://github.com/apache/superset/pull/22013) fix(sqllab): Add templateParams on kv store (@justinpark)
- [#22081](https://github.com/apache/superset/pull/22081) fix: Right click on country map with code filter (@michael-s-molina)
- [#21794](https://github.com/apache/superset/pull/21794) fix(presto/trino): Ensure get_table_names only returns real tables (@john-bodley)
- [#22040](https://github.com/apache/superset/pull/22040) fix: accept only JSON credentials (@betodealmeida)
- [#21976](https://github.com/apache/superset/pull/21976) fix(native-filters): panels are collapsed when switch native filters (@stephenLYZ)
- [#22029](https://github.com/apache/superset/pull/22029) fix: JSON serializers (@john-bodley)
- [#22014](https://github.com/apache/superset/pull/22014) fix: Revert shared controls typing change. (@codyml)
- [#22011](https://github.com/apache/superset/pull/22011) fix: Change downloadAsImage to use Superset theme (@lyndsiWilliams)
- [#21996](https://github.com/apache/superset/pull/21996) fix: invalid float number format by json-bigint (@justinpark)
- [#21995](https://github.com/apache/superset/pull/21995) fix: bump gecko and mozilla in Dockerfile (@AAfghahi)
- [#21959](https://github.com/apache/superset/pull/21959) fix: rename datasource->dataset in error message (@mistercrunch)
- [#21968](https://github.com/apache/superset/pull/21968) fix: invalid float number format by json-bigint (@justinpark)
- [#21973](https://github.com/apache/superset/pull/21973) fix: bump expected npm version in superset-websocket (@gebhardtr)
- [#21946](https://github.com/apache/superset/pull/21946) fix: error_parsing (@AAfghahi)
- [#21960](https://github.com/apache/superset/pull/21960) fix: Adds logging for SPA route navigation with React router (@eric-briscoe)
- [#21944](https://github.com/apache/superset/pull/21944) fix: add form data for empty state control to save dataset (@pkdotson)
- [#21952](https://github.com/apache/superset/pull/21952) fix(explore): Small changes in metadata bar copy and tooltip placement (@kgabryje)
- [#21953](https://github.com/apache/superset/pull/21953) fix: small bump to shillelagh (@AAfghahi)
- [#21920](https://github.com/apache/superset/pull/21920) fix(explore): Chart save modal displays error instead of failing silently (@kgabryje)
- [#21877](https://github.com/apache/superset/pull/21877) fix(sqllab): wiped out unsaved changes by delayed actions (@justinpark)
- [#21941](https://github.com/apache/superset/pull/21941) fix: Most common flaky Cypress tests (@geido)
- [#21807](https://github.com/apache/superset/pull/21807) fix(dashboard): Remove bar at bottom of dashboard edit sidebar (@codyml)
- [#21936](https://github.com/apache/superset/pull/21936) fix: Crash caused by numpy.vectorize (@john-bodley)
- [#21937](https://github.com/apache/superset/pull/21937) fix: BIGINT rendering regression in chartAction (@justinpark)
- [#21923](https://github.com/apache/superset/pull/21923) fix: accept old database payload (@betodealmeida)
- [#21857](https://github.com/apache/superset/pull/21857) fix: Default temporal column in Datasource (@geido)
- [#21919](https://github.com/apache/superset/pull/21919) fix: time grain key from P0.25Y to P3M (@zhaoyongjie)
- [#21771](https://github.com/apache/superset/pull/21771) fix(sqllab): remove set state on component update lifecycle (@justinpark)
- [#21899](https://github.com/apache/superset/pull/21899) fix(sqllab): fix control x to stop query (@pkdotson)
- [#21921](https://github.com/apache/superset/pull/21921) fix: Ensure data cleanup in Cypress (@geido)
- [#21911](https://github.com/apache/superset/pull/21911) fix(superset): Fixed API for bulk delete of embedded dashboards (@sinhashubham95)
- [#21894](https://github.com/apache/superset/pull/21894) fix(dashboard): Ensure correct positioning of "Drill to detail by" submenu (@codyml)
- [#21878](https://github.com/apache/superset/pull/21878) fix: type of AnnotationLayer (@justinpark)
- [#21892](https://github.com/apache/superset/pull/21892) fix: Mistaken use of BootstrapUser type (@codyml)
- [#21876](https://github.com/apache/superset/pull/21876) fix: Change timer font to monospace (@lyndsiWilliams)
- [#21797](https://github.com/apache/superset/pull/21797) fix: docker links (@lucapette)
- [#21822](https://github.com/apache/superset/pull/21822) fix(dashboard): Prevent XSS attack vector (@agl-developer)
- [#21869](https://github.com/apache/superset/pull/21869) fix: categorical x-axis can't apply the label of column (@zhaoyongjie)
- [#21847](https://github.com/apache/superset/pull/21847) fix: custom SQL in the XAxis (@zhaoyongjie)
- [#21845](https://github.com/apache/superset/pull/21845) fix: drilling on the categorical xaxis on the mixed chart (@zhaoyongjie)
- [#21844](https://github.com/apache/superset/pull/21844) fix: drilling on the categorical xaxis on the stacked barchart v2 (@zhaoyongjie)
- [#21817](https://github.com/apache/superset/pull/21817) fix: Allow comma in Number Format (@geido)
- [#21770](https://github.com/apache/superset/pull/21770) fix: Dataset left panel now uses client side search (@lyndsiWilliams)
- [#21832](https://github.com/apache/superset/pull/21832) fix(sqllab): Fix spacing on Schedule option in SqlEditor dropdown (@lyndsiWilliams)
- [#21641](https://github.com/apache/superset/pull/21641) fix(superset-embedded-sdk): Buffer is not defined (@doornot)
- [#21765](https://github.com/apache/superset/pull/21765) fix(alerts): restrict list view and gamma perms (@villebro)
- [#21557](https://github.com/apache/superset/pull/21557) fix: Dataset creation header is now uneditable and holds proper default values (@lyndsiWilliams)
- [#21792](https://github.com/apache/superset/pull/21792) fix(explore): Persist URL params to form-data (@john-bodley)
- [#21779](https://github.com/apache/superset/pull/21779) fix(plugin-chart-handlebars): Update webpack/babel config to fix build/runtime warnings/errors (@codyml)
- [#21743](https://github.com/apache/superset/pull/21743) fix: Fix regression introduced in #20893 (@john-bodley)
- [#21785](https://github.com/apache/superset/pull/21785) fix: Preserve unknown URL params (@michael-s-molina)
- [#21782](https://github.com/apache/superset/pull/21782) fix: regression in #21766 (@zhaoyongjie)
- [#21442](https://github.com/apache/superset/pull/21442) fix(datasets): Stop showing alert when saving from query (@Antonio-RiveroMartnez)
- [#21698](https://github.com/apache/superset/pull/21698) fix(sqllab): Async queries are now fetched properly (@lyndsiWilliams)
- [#21741](https://github.com/apache/superset/pull/21741) fix(sqllab): resultset disappeared on switching tabs (@justinpark)
- [#21740](https://github.com/apache/superset/pull/21740) fix: Gsheets takes 2 clicks to save (@hughhhh)
- [#21707](https://github.com/apache/superset/pull/21707) fix(explore): chart link is broken without localStorage (@justinpark)
- [#21722](https://github.com/apache/superset/pull/21722) fix: Null values on Treemap right-click (@michael-s-molina)
- [#21710](https://github.com/apache/superset/pull/21710) fix: gsheets editing with dynamic forms (@hughhhh)
- [#21709](https://github.com/apache/superset/pull/21709) fix(database): Handle String errors in DatabaseModal (@Antonio-RiveroMartnez)
- [#21719](https://github.com/apache/superset/pull/21719) fix: Drill to detail formatted val on TableChart (@michael-s-molina)
- [#21696](https://github.com/apache/superset/pull/21696) fix: Pass slice_id in Explore get (@michael-s-molina)
- [#21697](https://github.com/apache/superset/pull/21697) fix: Right-click on misconfigured World Map (@michael-s-molina)
- [#21691](https://github.com/apache/superset/pull/21691) fix: add `get_column` function for Query obj (@hughhhh)
- [#21647](https://github.com/apache/superset/pull/21647) fix: Race conditions with setupExtensions (@geido)
- [#21667](https://github.com/apache/superset/pull/21667) fix(sqllab): async query broken due to #21320 (@justinpark)
- [#21680](https://github.com/apache/superset/pull/21680) fix(native-filters): Range filter max/min default display value (@kgabryje)
- [#21684](https://github.com/apache/superset/pull/21684) fix: add logging to alerts and reports to find non-triggering issues (@pkdotson)
- [#21446](https://github.com/apache/superset/pull/21446) fix: Allow clickhouse dbs with timestamps to visualize queries (@hughhhh)
- [#21317](https://github.com/apache/superset/pull/21317) fix(explore): Dashboard list is unsorted in save modal (@agl-developer)
- [#21632](https://github.com/apache/superset/pull/21632) fix(sqllab): perf regression on #21532 refactor (@justinpark)
- [#21570](https://github.com/apache/superset/pull/21570) fix: catch error when masking encrypted extra is none (@eschutho)
- [#21661](https://github.com/apache/superset/pull/21661) fix(plugin-chart-echarts): boxplot throw error in the dashboard (@stephenLYZ)
- [#21644](https://github.com/apache/superset/pull/21644) fix: time grain can't be removed in explore (@zhaoyongjie)
- [#21305](https://github.com/apache/superset/pull/21305) fix(dashboard): Change text and icons in dashboard editmode (@agl-developer)
- [#21662](https://github.com/apache/superset/pull/21662) fix: new welcome new users action (@stephenLYZ)
- [#21648](https://github.com/apache/superset/pull/21648) fix: Switch tab on drag hover (@michael-s-molina)
- [#21630](https://github.com/apache/superset/pull/21630) fix: Selected tab after save and go to dashboard (@michael-s-molina)
- [#21628](https://github.com/apache/superset/pull/21628) fix(sqllab): SqlEditorLeftBar listening to database changes (@Antonio-RiveroMartnez)
- [#21539](https://github.com/apache/superset/pull/21539) fix(dashboard): fix Pivot Table V2 dragPreview in the dashboard (@stephenLYZ)
- [#21501](https://github.com/apache/superset/pull/21501) fix(table-chart): don't color empty cells in table chart with color formatters (@mayurnewase)
- [#21358](https://github.com/apache/superset/pull/21358) fix: Dataset duplication fatal error (@reesercollins)
- [#21591](https://github.com/apache/superset/pull/21591) fix(tags): Adding **init** to tags (@craig-rueda)
- [#21576](https://github.com/apache/superset/pull/21576) fix(dashboard): dashboard doesn't load properly if it has tabs (@stephenLYZ)
- [#21544](https://github.com/apache/superset/pull/21544) fix(explore): Fix datasource switch for table chart (@codyml)
- [#21065](https://github.com/apache/superset/pull/21065) fix(databases): GSheets and Clickhouse DBs are not allowed to upload files (@Antonio-RiveroMartnez)
- [#21549](https://github.com/apache/superset/pull/21549) fix(dashboard): show correct roles for dashboard access dropdown (@mayurnewase)
- [#21316](https://github.com/apache/superset/pull/21316) fix(sqllab): avoid unexpected re-rendering on DatabaseSelector (@justinpark)
- [#21529](https://github.com/apache/superset/pull/21529) fix: Reset dataset name after saving a new dataset in SQL Lab (@EugeneTorap)
- [#21542](https://github.com/apache/superset/pull/21542) fix(docs): added missing timescale.png (@noctarius)
- [#21514](https://github.com/apache/superset/pull/21514) fix: pie chart orientation description error (@LiuBodong)
- [#21497](https://github.com/apache/superset/pull/21497) fix(explore): fix chart save when dashboard deleted (@codyml)
- [#21516](https://github.com/apache/superset/pull/21516) fix: Dataset timeout (@geido)
- [#21495](https://github.com/apache/superset/pull/21495) fix: can't show duckdb table names in the "SEE TABLE SCHEMA" dropdown list (@forestlzj)
- [#21492](https://github.com/apache/superset/pull/21492) fix: dataset after insert when db relation does not exist (@dpgaspar)
- [#21470](https://github.com/apache/superset/pull/21470) fix: Address regression introduced in #21284 (@john-bodley)
- [#21480](https://github.com/apache/superset/pull/21480) fix: Duplicated numeric values in Select (@michael-s-molina)
- [#21489](https://github.com/apache/superset/pull/21489) fix: BigQuery cannot accept Time Grain (@zhaoyongjie)
- [#21484](https://github.com/apache/superset/pull/21484) fix(explore): Fix generic X-axis time grain disappearing (@codyml)
- [#21378](https://github.com/apache/superset/pull/21378) fix: Time Offset in SQLite and refine logic in Date Type conversion (@zhaoyongjie)
- [#21481](https://github.com/apache/superset/pull/21481) fix: revert #21356(able to sort bar on the bar chart V2) (@stephenLYZ)
- [#21469](https://github.com/apache/superset/pull/21469) fix: Supports form_data param in old Explore endpoint (@michael-s-molina)
- [#21315](https://github.com/apache/superset/pull/21315) fix(explore): Prevent shared controls from checking feature flags outside React render (@codyml)
- [#21461](https://github.com/apache/superset/pull/21461) fix: dashboard filter value is cleared when 2 similar dashboards opened in succession (@mayurnewase)
- [#21464](https://github.com/apache/superset/pull/21464) fix: hide time_grain when x_axis value is undefined (@zhaoyongjie)
- [#21454](https://github.com/apache/superset/pull/21454) fix: permission sqlalchemy events (@dpgaspar)
- [#21371](https://github.com/apache/superset/pull/21371) fix: should be able to remove selection from X-AXIS control (@zhaoyongjie)
- [#21450](https://github.com/apache/superset/pull/21450) fix: remove extras from all adhoc_filters controls (@villebro)
- [#21422](https://github.com/apache/superset/pull/21422) fix(dashboard): JS error when editing charts (@ktmud)
- [#21366](https://github.com/apache/superset/pull/21366) fix(explore): disable resize bar when the results area is collapsed (@stephenLYZ)
- [#21432](https://github.com/apache/superset/pull/21432) fix(dashboard): drag preview not working (@stephenLYZ)
- [#21399](https://github.com/apache/superset/pull/21399) fix(ui): Quick Fix for app_icon (@craig-rueda)
- [#21372](https://github.com/apache/superset/pull/21372) fix(big number): time grain control is useless in BigNumber Viz (@zhaoyongjie)
- [#21282](https://github.com/apache/superset/pull/21282) fix(dashboard): Fix scrolling on "View as table" modal (@codyml)
- [#21313](https://github.com/apache/superset/pull/21313) fix: revert permission refactoring PR (@zephyring)
- [#21311](https://github.com/apache/superset/pull/21311) fix(sqllab): Copy link doesn't apply the unsaved changes (@justinpark)
- [#21342](https://github.com/apache/superset/pull/21342) fix: database modal crashed when use SQLAlchemy URI string (@zhaoyongjie)
- [#21323](https://github.com/apache/superset/pull/21323) fix(dashboard): padding between rows within tabs (@gbusch)
- [#21243](https://github.com/apache/superset/pull/21243) fix(ViewQuery-Modal): Copy icon is out of box when resize query modal (@Paulo-Eduardo)
- [#21299](https://github.com/apache/superset/pull/21299) fix: DB connection modal connect bug (@AAfghahi)
- [#21306](https://github.com/apache/superset/pull/21306) fix: flaky test when sync metadata (@zhaoyongjie)
- [#21043](https://github.com/apache/superset/pull/21043) fix(utils): use getaddrinfo response to support dual-stack port checks (@vin01)
- [#21042](https://github.com/apache/superset/pull/21042) fix(utils): use getaddrinfo for hostname check to support ipv6 (@vin01)
- [#21304](https://github.com/apache/superset/pull/21304) fix(sqllab): invalid table metadata request (@justinpark)
- [#21275](https://github.com/apache/superset/pull/21275) fix: Fix console errors about feature flags when running tests (@codyml)
- [#21293](https://github.com/apache/superset/pull/21293) fix(explore): Incorrect conversion from simple bool filter to custom sql (@kgabryje)
- [#21277](https://github.com/apache/superset/pull/21277) fix: Revert "#20095 - fix(database): make to display validation error msg when all … (@sadpandajoe)
- [#21244](https://github.com/apache/superset/pull/21244) fix: dataset exists error in save Dataset modal (@AAfghahi)
- [#21274](https://github.com/apache/superset/pull/21274) fix: bump min version of elastic search (@AAfghahi)
- [#21161](https://github.com/apache/superset/pull/21161) fix: dataset name change and permission change (@dpgaspar)
- [#21251](https://github.com/apache/superset/pull/21251) fix: Table content disappears when switching between tabs (@EugeneTorap)
- [#21257](https://github.com/apache/superset/pull/21257) fix: SQLAlchemy coercing subquery warning on RLS (@dpgaspar)
- [#21260](https://github.com/apache/superset/pull/21260) fix(sqllab): unable to create new tabs (@justinpark)
- [#21246](https://github.com/apache/superset/pull/21246) fix(sqllab): sql editor's name has lost after reload (@justinpark)
- [#21247](https://github.com/apache/superset/pull/21247) fix: Revert "Update Tab Name via config (#21116)" (@hughhhh)
- [#21232](https://github.com/apache/superset/pull/21232) fix(dev-server run): Check for environment tag not being undefined (@sinhashubham95)
- [#21171](https://github.com/apache/superset/pull/21171) fix: improve get_db_engine_spec_for_backend (@betodealmeida)
- [#21066](https://github.com/apache/superset/pull/21066) fix(Trino): create `PrestoBaseEngineSpec` base class to share common code between Trino and Presto (@dungdm93)
- [#21226](https://github.com/apache/superset/pull/21226) fix: Fixes error caused by step id placed in wrong location (@eric-briscoe)
- [#21208](https://github.com/apache/superset/pull/21208) fix(embedded): Guest Role Permissions (@sinhashubham95)
- [#21190](https://github.com/apache/superset/pull/21190) fix: add back custom sql filtering with Query as source (@hughhhh)
- [#21224](https://github.com/apache/superset/pull/21224) fix: Update chromatic PR action to have access to Job outputs (@eric-briscoe)
- [#21222](https://github.com/apache/superset/pull/21222) fix: Removes if statement causing comment not to run in Chromatic PR action (@eric-briscoe)
- [#21217](https://github.com/apache/superset/pull/21217) fix: Update exception for DatasourceNotFound from `DatasourceDao.get_datasource()` (@hughhhh)
- [#21219](https://github.com/apache/superset/pull/21219) fix: Splitting into two separate chromatic jobs to reduce conditional logic causing run issues (@eric-briscoe)
- [#21209](https://github.com/apache/superset/pull/21209) fix: World Map right-click value (@michael-s-molina)
- [#21205](https://github.com/apache/superset/pull/21205) fix(readme): formatting in README.md (@yuzutas0)
- [#21181](https://github.com/apache/superset/pull/21181) fix: Typing of labelMap (@michael-s-molina)
- [#21201](https://github.com/apache/superset/pull/21201) fix: Add warnings if feature flags are read before initialization (@codyml)
- [#21167](https://github.com/apache/superset/pull/21167) fix(database-modal): Adjusting spacing on database connection form (@Paulo-Eduardo)
- [#21140](https://github.com/apache/superset/pull/21140) fix(alert-modal): Radio button is not vertically-aligned (@Paulo-Eduardo)
- [#21172](https://github.com/apache/superset/pull/21172) fix(database-modal): Show a different placeholder text in Snowflake connection form (@agl-developer)
- [#20095](https://github.com/apache/superset/pull/20095) fix(database): make to display validation error msg when all cases (@prosdev0107)
- [#21157](https://github.com/apache/superset/pull/21157) fix: Filter throwing an error on Embedded Dashboard (@lilykuang)
- [#21174](https://github.com/apache/superset/pull/21174) fix(sqllab): reverts #21141 (@justinpark)
- [#21151](https://github.com/apache/superset/pull/21151) fix: Drill to detail on values with comma (@michael-s-molina)
- [#21015](https://github.com/apache/superset/pull/21015) fix(charts): Hide Values greater than Max Y Axis Bound on Mixed Time Series with Bar series (@Antonio-RiveroMartnez)
- [#21141](https://github.com/apache/superset/pull/21141) fix(sqllab): avoid unexpected re-rendering on DatabaseSelector (@justinpark)
- [#21135](https://github.com/apache/superset/pull/21135) fix: resample method shouldn't be freeform (@zhaoyongjie)
- [#21130](https://github.com/apache/superset/pull/21130) fix: timestamp bug for chart-powered-query (@AAfghahi)
- [#21006](https://github.com/apache/superset/pull/21006) fix: Use Home page in SPA (@EugeneTorap)
- [#21113](https://github.com/apache/superset/pull/21113) fix: datetime value should be seconds in sqlite (@zhaoyongjie)
- [#21114](https://github.com/apache/superset/pull/21114) fix(explore): Filters with custom SQL disappearing (@kgabryje)
- [#21100](https://github.com/apache/superset/pull/21100) fix(dashboard): Dashboard header overflowing in edit mode (@kgabryje)
- [#21019](https://github.com/apache/superset/pull/21019) fix: Unable to sync columns when dataset name has '+' (@diegomedina248)
- [#21004](https://github.com/apache/superset/pull/21004) fix(database-modal): 'CTAS & CVAS SCHEMA' getting cut off (@stephenLYZ)
- [#21029](https://github.com/apache/superset/pull/21029) fix: take form_data reference for metrics for pivot_v2 table reports (@hughhhh)
- [#21003](https://github.com/apache/superset/pull/21003) fix: Validate required fields in sql_json API (@EugeneTorap)
- [#21045](https://github.com/apache/superset/pull/21045) fix: add plain postgres alias (@betodealmeida)
- [#21034](https://github.com/apache/superset/pull/21034) fix: [sc-54864] Adds safety check to provide near term fix to save query (@eric-briscoe)
- [#21025](https://github.com/apache/superset/pull/21025) fix: unable to show view as table modal (@zhaoyongjie)
- [#21030](https://github.com/apache/superset/pull/21030) fix: making crossFilter.chartsInScope optional (@rusackas)
- [#20970](https://github.com/apache/superset/pull/20970) fix: forwardRef warnings in selects (@michael-s-molina)
- [#21017](https://github.com/apache/superset/pull/21017) fix(plugin-echart-timeseries): legend trancated on show extra controls (@justinpark)
- [#21016](https://github.com/apache/superset/pull/21016) fix(sqllab): result set min-height (@ktmud)
- [#20999](https://github.com/apache/superset/pull/20999) fix: quick fix to rows returned in results (@AAfghahi)
- [#20965](https://github.com/apache/superset/pull/20965) fix: save dataset and repopulate state (@eschutho)
- [#20972](https://github.com/apache/superset/pull/20972) fix(explore): Replace url search params only if current page is Explore (@kgabryje)
- [#20989](https://github.com/apache/superset/pull/20989) fix: for series limit comparison on explore with chart = Query (@hughhhh)
- [#20977](https://github.com/apache/superset/pull/20977) fix: series limit solution for source is query (@AAfghahi)
- [#20975](https://github.com/apache/superset/pull/20975) fix: Columns not passing properly from SQL Lab to Explore (@lyndsiWilliams)
- [#20959](https://github.com/apache/superset/pull/20959) fix: remove extra line for link (@pkdotson)
- [#20938](https://github.com/apache/superset/pull/20938) fix: add timegrains to data payload (@hughhhh)
- [#20964](https://github.com/apache/superset/pull/20964) fix: No back button in save dataset modal (@AAfghahi)
- [#20966](https://github.com/apache/superset/pull/20966) fix: BigQuery get_parameters_from_uri (@betodealmeida)
- [#20941](https://github.com/apache/superset/pull/20941) fix: Use SPA Dataset link in Chart and Dashboard (@EugeneTorap)
- [#20947](https://github.com/apache/superset/pull/20947) fix(sqllab): Fix tab state (@lyndsiWilliams)
- [#20937](https://github.com/apache/superset/pull/20937) fix(sqllab): tracking url and error alert padding (@ktmud)
- [#20627](https://github.com/apache/superset/pull/20627) fix(chart): Time Series set showMaxLabel as null for time xAxis (@Antonio-RiveroMartnez)
- [#20720](https://github.com/apache/superset/pull/20720) fix(charts): Scrollbar after removing an annotation (@Antonio-RiveroMartnez)
- [#20933](https://github.com/apache/superset/pull/20933) fix: adjust timeseries grid right offset to match the rest (@diegomedina248)
- [#20932](https://github.com/apache/superset/pull/20932) fix(import): error with disable_data_preview field (@diegomedina248)
- [#20574](https://github.com/apache/superset/pull/20574) fix: Change dataset name affect data access role set to this dataset (@diegomedina248)
- [#20081](https://github.com/apache/superset/pull/20081) fix: database permissions on update and delete (avoid orphaned perms) (@dpgaspar)
- [#20927](https://github.com/apache/superset/pull/20927) fix(dashboard): Incorrect scopes of cross filters (@kgabryje)
- [#20862](https://github.com/apache/superset/pull/20862) fix: overwrite update override columns on PUT /dataset (@hughhhh)
- [#20924](https://github.com/apache/superset/pull/20924) fix: hide modal after overwrite (@hughhhh)
- [#20923](https://github.com/apache/superset/pull/20923) fix(explore): Time controls not showing for Queries (@eric-briscoe)
- [#20880](https://github.com/apache/superset/pull/20880) fix: Save dataset + chart when Chart source is Query (@hughhhh)
- [#20895](https://github.com/apache/superset/pull/20895) fix: make a new entrypoint for deprecated postgres dialect (@eschutho)
- [#20905](https://github.com/apache/superset/pull/20905) fix(sqllab): hide tracking url when fetching (@ktmud)
- [#20893](https://github.com/apache/superset/pull/20893) fix: Address performance regression introduced in #11785 (@john-bodley)
- [#20909](https://github.com/apache/superset/pull/20909) fix(plugin-chart-pivot-table): Invalid Formats Date Fields (@justinpark)
- [#20882](https://github.com/apache/superset/pull/20882) fix: invalid metric should raise an exception (@zhaoyongjie)
- [#20491](https://github.com/apache/superset/pull/20491) fix(sql lab): Syntax errors should return with 422 status (@diegomedina248)
- [#20638](https://github.com/apache/superset/pull/20638) fix: Published Dashboard without charts don't show up for non admin users (@diegomedina248)
- [#20753](https://github.com/apache/superset/pull/20753) fix(reports): Confirmation message after deleting reports (@Antonio-RiveroMartnez)
- [#20833](https://github.com/apache/superset/pull/20833) fix(charts): Table Chart doesn't twitch when resizing (@Antonio-RiveroMartnez)
- [#20874](https://github.com/apache/superset/pull/20874) fix(viz): Header scrolling for Time Table in dashboard (@Antonio-RiveroMartnez)
- [#20871](https://github.com/apache/superset/pull/20871) fix: create property for schema_perm for `Query` (@hughhhh)
- [#20879](https://github.com/apache/superset/pull/20879) fix: add having_druid back into the chart schema (@eschutho)
- [#20867](https://github.com/apache/superset/pull/20867) fix: switch form_data between different datasource (@zhaoyongjie)
- [#20847](https://github.com/apache/superset/pull/20847) fix: Fix chart title truncating when Chrome is zoomed out (@kgabryje)
- [#20864](https://github.com/apache/superset/pull/20864) fix: explore warnings cleanup (@diegomedina248)
- [#20851](https://github.com/apache/superset/pull/20851) fix: change buttons to be only save and overwrite (@hughhhh)
- [#20829](https://github.com/apache/superset/pull/20829) fix: adding extraConfig to worker deployment #20828 (@cdreier)
- [#20834](https://github.com/apache/superset/pull/20834) fix: add complex type to pydruid (@betodealmeida)
- [#20726](https://github.com/apache/superset/pull/20726) fix: Use cache_manager.cache rather than cache_manager.data_cache for caching table metadata (@john-bodley)
- [#20811](https://github.com/apache/superset/pull/20811) fix: Ensure consistent rollback logic for failed SQL operations (@john-bodley)
- [#20805](https://github.com/apache/superset/pull/20805) fix(plugin-chart-echarts): xAxis of bar chart overflow (@stephenLYZ)
- [#20823](https://github.com/apache/superset/pull/20823) fix(dashboard): add toast if JSON metadata is invalid (@stephenLYZ)
- [#20826](https://github.com/apache/superset/pull/20826) fix: invalid dataset schema (@zhaoyongjie)
- [#20795](https://github.com/apache/superset/pull/20795) fix: Timeseries visualization with Chart Source = Query (@hughhhh)
- [#20750](https://github.com/apache/superset/pull/20750) fix: [explore][mixed time series chart] when user change size of view query window, query B part will disappear (@diegomedina248)
- [#20816](https://github.com/apache/superset/pull/20816) fix: chart empty state & result panel when multiple queries are executed display incorrectly (@diegomedina248)
- [#20812](https://github.com/apache/superset/pull/20812) fix: Redirects old Explore URLs to the new ones (@michael-s-molina)
- [#20802](https://github.com/apache/superset/pull/20802) fix(explore): Adhoc columns don't display correctly (@kgabryje)
- [#20780](https://github.com/apache/superset/pull/20780) fix: unexpected commit causes pytest failure (@zhaoyongjie)
- [#20796](https://github.com/apache/superset/pull/20796) fix: Reverts #20749 and #20645 (@michael-s-molina)
- [#20794](https://github.com/apache/superset/pull/20794) fix: properly set `owners` to Sqlatable.owners_data inside payload (@hughhhh)
- [#20674](https://github.com/apache/superset/pull/20674) fix: Databricks views showing up as tables (@betodealmeida)
- [#20783](https://github.com/apache/superset/pull/20783) fix(plugin-chart-echarts): layout broken when resizing (@stephenLYZ)
- [#20566](https://github.com/apache/superset/pull/20566) fix(heatmap): add detail descriptions for heatmap 'normalize across' (@stephenLYZ)
- [#20754](https://github.com/apache/superset/pull/20754) fix: set allow `filter_select` for Query objects in Explore (@hughhhh)
- [#20784](https://github.com/apache/superset/pull/20784) fix: core coverage and add a coverage step in workflow (@zhaoyongjie)
- [#20684](https://github.com/apache/superset/pull/20684) fix(dashboard): Fix missing metadata on draggable dashboard edit chart cards (@codyml)
- [#20725](https://github.com/apache/superset/pull/20725) fix: datasourcedao datasource not found error (@pkdotson)
- [#20673](https://github.com/apache/superset/pull/20673) fix(explore): Fix chart standalone URL for report/thumbnail generation (@codyml)
- [#20760](https://github.com/apache/superset/pull/20760) fix(csv): Do not coerce persisted data integer columns to float (@john-bodley)
- [#20757](https://github.com/apache/superset/pull/20757) fix: PrestoEngineSpec.\_show_columns return type (@john-bodley)
- [#20706](https://github.com/apache/superset/pull/20706) fix(sql lab): MultiSelector component render twice (@diegomedina248)
- [#20727](https://github.com/apache/superset/pull/20727) fix(docker): Fixing broken node build (@craig-rueda)
- [#20751](https://github.com/apache/superset/pull/20751) fix: change dataset functionality in Explore (@hughhhh)
- [#20749](https://github.com/apache/superset/pull/20749) fix: Error when saving datasource from Explore (@michael-s-molina)
- [#20747](https://github.com/apache/superset/pull/20747) fix: set reference to columns properly for sqllab -> explore (@hughhhh)
- [#20661](https://github.com/apache/superset/pull/20661) fix: reuse existing row on dual write if available (@eschutho)
- [#20710](https://github.com/apache/superset/pull/20710) fix: Fixes the instructions to publish to PyPI (@michael-s-molina)
- [#20712](https://github.com/apache/superset/pull/20712) fix: Ensure main_dttm_col is adhered to for non-drag-and-drop (@john-bodley)
- [#20711](https://github.com/apache/superset/pull/20711) fix: Re-add schema as a searchable field for the datasets v1 API (@john-bodley)
- [#20699](https://github.com/apache/superset/pull/20699) fix: columns are lost when dashboard to explore (@zhaoyongjie)
- [#20688](https://github.com/apache/superset/pull/20688) fix: "Refresh Dashboard" only refreshes active tab (@diegomedina248)
- [#20700](https://github.com/apache/superset/pull/20700) fix(releases): docker build on M1 npm run build fails (@dpgaspar)
- [#20691](https://github.com/apache/superset/pull/20691) fix(sqllab): Save Dataset Modal Multiple overwrites (@Antonio-RiveroMartnez)
- [#20687](https://github.com/apache/superset/pull/20687) fix(line-chart): Formula Annotations on Line Charts are broken (@stephenLYZ)
- [#20671](https://github.com/apache/superset/pull/20671) fix(treemap-v2): color scheme not work when there is only one dimension (@stephenLYZ)
- [#20693](https://github.com/apache/superset/pull/20693) fix(dashboard): Native filter on the dashboard with multiple tabs is displayed as out of scope (@diegomedina248)
- [#20680](https://github.com/apache/superset/pull/20680) fix(explore): datatable crash when dimension is empty (@Usiel)
- [#20689](https://github.com/apache/superset/pull/20689) fix: Revert "feat: Reuse Dashboard redux data in Explore (#20668)" (@kgabryje)
- [#20676](https://github.com/apache/superset/pull/20676) fix: superset-ui/core code coverage (@zhaoyongjie)
- [#20659](https://github.com/apache/superset/pull/20659) fix: X Axis should be called Y Axis when using the Bar Chart V2 on Horizontal mode (@diegomedina248)
- [#20629](https://github.com/apache/superset/pull/20629) fix: pandas bug when data is blank on post-processing (@eschutho)
- [#20647](https://github.com/apache/superset/pull/20647) fix(embedded): Ensure guest token is passed to log endpoint (@jfrag1)
- [#20613](https://github.com/apache/superset/pull/20613) fix: enable admin to edit dataset in explore (@pkdotson)
- [#20637](https://github.com/apache/superset/pull/20637) fix(databases): Display for credentials input (@Antonio-RiveroMartnez)
- [#20499](https://github.com/apache/superset/pull/20499) fix: Refactor ownership checks (@john-bodley)
- [#20119](https://github.com/apache/superset/pull/20119) fix: Bad date type in email text report for table chart (@codemaster08240328)
- [#19244](https://github.com/apache/superset/pull/19244) fix: Add database search in available charts on dashboard. (@codemaster08240328)
- [#20623](https://github.com/apache/superset/pull/20623) fix: controls validator glitch (@zhaoyongjie)
- [#20618](https://github.com/apache/superset/pull/20618) fix: datetime.data in series (@zhaoyongjie)
- [#20573](https://github.com/apache/superset/pull/20573) fix(import): Show the error message with db install guide when exist the importing db issue (@prosdev0107)
- [#20605](https://github.com/apache/superset/pull/20605) fix: welcome page user authentication check (@dpgaspar)
- [#20256](https://github.com/apache/superset/pull/20256) fix(schedule-query): getUISchema function called in SchemaForm component (@RahulRaj97)
- [#20523](https://github.com/apache/superset/pull/20523) fix(database-modal): Refresh Data when importing (@Antonio-RiveroMartnez)
- [#20496](https://github.com/apache/superset/pull/20496) fix: change permissions on action (@eschutho)

**Others**

- [#23325](https://github.com/apache/superset/pull/23325) chore: use util test env for init check (@eschutho)
- [#23298](https://github.com/apache/superset/pull/23298) docs: improve API v1 migration documentation (@dpgaspar)
- [#23199](https://github.com/apache/superset/pull/23199) docs: update installation docs to include frontend asset build (@eschutho)
- [#23131](https://github.com/apache/superset/pull/23131) chore: Add docs for ssh tunneling (@hughhhh)
- [#23102](https://github.com/apache/superset/pull/23102) chore: change AlertQueryError to 400 (@eschutho)
- [#23041](https://github.com/apache/superset/pull/23041) chore: increment statsd as warn (@eschutho)
- [#22903](https://github.com/apache/superset/pull/22903) chore: Updating connection URI for MS SQL Server (@kuruv)
- [#23077](https://github.com/apache/superset/pull/23077) chore: Improve greeting message (@tisonkun)
- [#23003](https://github.com/apache/superset/pull/23003) chore: move dashboard screenshot standalone logic (@eschutho)
- [#22969](https://github.com/apache/superset/pull/22969) test: Clean up SelectAsyncControl test warnings (@lyndsiWilliams)
- [#22971](https://github.com/apache/superset/pull/22971) test: Convert DatasetList test from jsx to tsx (@lyndsiWilliams)
- [#22973](https://github.com/apache/superset/pull/22973) chore: Remove dependency warnings from DatasetList.tsx (@lyndsiWilliams)
- [#22974](https://github.com/apache/superset/pull/22974) chore: Remove dependency warnings from SqlEditor/index.jsx (@lyndsiWilliams)
- [#22975](https://github.com/apache/superset/pull/22975) chore: Remove dependency warnings from SqlEditorLeftBar/index.tsx (@lyndsiWilliams)
- [#23081](https://github.com/apache/superset/pull/23081) chore(style): make brand icon max width customizable (@villebro)
- [#23079](https://github.com/apache/superset/pull/23079) build(deps-dev): bump eslint from 8.33.0 to 8.34.0 in /superset-websocket (@dependabot[bot])
- [#23080](https://github.com/apache/superset/pull/23080) build(deps): bump ws from 8.12.0 to 8.12.1 in /superset-websocket (@dependabot[bot])
- [#22913](https://github.com/apache/superset/pull/22913) chore: Migrate /superset/csv/`<client_id>` to API v1 (@diegomedina248)
- [#22931](https://github.com/apache/superset/pull/22931) chore: Migrate get_or_create_table endpoint to api v1 (@jfrag1)
- [#22486](https://github.com/apache/superset/pull/22486) docs: remove duplicate navbar item (@tisonkun)
- [#23029](https://github.com/apache/superset/pull/23029) build(deps-dev): bump @types/node from 18.11.19 to 18.13.0 in /superset-websocket (@dependabot[bot])
- [#23030](https://github.com/apache/superset/pull/23030) build(deps-dev): bump prettier from 2.8.3 to 2.8.4 in /superset-websocket (@dependabot[bot])
- [#23031](https://github.com/apache/superset/pull/23031) build(deps): bump hot-shots from 9.3.0 to 10.0.0 in /superset-websocket (@dependabot[bot])
- [#23073](https://github.com/apache/superset/pull/23073) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.49.0 to 5.52.0 in /superset-websocket (@dependabot[bot])
- [#22444](https://github.com/apache/superset/pull/22444) chore: remove db_engines (@betodealmeida)
- [#22957](https://github.com/apache/superset/pull/22957) chore(datasets): Refactor DatasetDAO update to leverage bulk logic for create, update, and delete operations (@john-bodley)
- [#23054](https://github.com/apache/superset/pull/23054) chore: Removes icon warnings from tests (@michael-s-molina)
- [#23051](https://github.com/apache/superset/pull/23051) docs(teradata): fix connection string (@villebro)
- [#23009](https://github.com/apache/superset/pull/23009) chore: refactor SliceAdder for react 17 and react 18 (@lilykuang)
- [#23023](https://github.com/apache/superset/pull/23023) chore(tests): Cypress optimizations to help with fails (@codyml)
- [#22933](https://github.com/apache/superset/pull/22933) build(deps-dev): bump typescript from 4.9.4 to 4.9.5 in /superset-websocket (@dependabot[bot])
- [#23013](https://github.com/apache/superset/pull/23013) build(deps-dev): bump @typescript-eslint/parser from 5.48.1 to 5.51.0 in /superset-websocket (@dependabot[bot])
- [#22997](https://github.com/apache/superset/pull/22997) build(deps-dev): bump @types/node from 18.11.13 to 18.11.19 in /superset-websocket (@dependabot[bot])
- [#22955](https://github.com/apache/superset/pull/22955) build(deps): bump http-cache-semantics from 4.1.0 to 4.1.1 in /superset-frontend/cypress-base (@dependabot[bot])
- [#22767](https://github.com/apache/superset/pull/22767) build(deps-dev): bump eslint-config-prettier from 7.2.0 to 8.6.0 in /superset-websocket (@dependabot[bot])
- [#21809](https://github.com/apache/superset/pull/21809) chore(deps): bump ajv and react-jsonschema-form in /superset-frontend (@dependabot[bot])
- [#22938](https://github.com/apache/superset/pull/22938) chore: Localization of Superset pt. 3 (@artemonsh)
- [#23005](https://github.com/apache/superset/pull/23005) chore: updating link to sandbox.js (@rusackas)
- [#22956](https://github.com/apache/superset/pull/22956) build(deps): bump http-cache-semantics from 4.1.0 to 4.1.1 in /docs (@dependabot[bot])
- [#22996](https://github.com/apache/superset/pull/22996) build(deps): bump pre-commit from 2.20.0 to 3.0.4 in /requirements (@dependabot[bot])
- [#22986](https://github.com/apache/superset/pull/22986) docs: added Orange inside the inthewild.md doc (@icsu)
- [#22831](https://github.com/apache/superset/pull/22831) chore: Fix grammar (@john-bodley)
- [#22934](https://github.com/apache/superset/pull/22934) chore: bump python version to 3.8.16 in Dockerfile (@EugeneTorap)
- [#22988](https://github.com/apache/superset/pull/22988) docs(alerts & reports): clarify nature of "-dev" labeled container images (@sfirke)
- [#22972](https://github.com/apache/superset/pull/22972) test: Clean up QueryList test warnings (@lyndsiWilliams)
- [#22970](https://github.com/apache/superset/pull/22970) test: Fix act errors in DatabaseList test (@lyndsiWilliams)
- [#22961](https://github.com/apache/superset/pull/22961) docs: add Caizin to the user list (@tejaskatariya)
- [#22935](https://github.com/apache/superset/pull/22935) chore: add waitress for win32 platform (@EugeneTorap)
- [#22958](https://github.com/apache/superset/pull/22958) build(deps): bump http-cache-semantics from 4.1.0 to 4.1.1 in /superset-frontend (@dependabot[bot])
- [#22963](https://github.com/apache/superset/pull/22963) chore(superset-ui-chart-controls): refactor pivot and rename operator (@villebro)
- [#22798](https://github.com/apache/superset/pull/22798) chore(welcome): change default last tab to "all" (@villebro)
- [#22927](https://github.com/apache/superset/pull/22927) chore: Bump Flask-AppBuilder constraints (@john-bodley)
- [#22915](https://github.com/apache/superset/pull/22915) test: Clean up AdhocFilterOption test warnings (@lyndsiWilliams)
- [#22501](https://github.com/apache/superset/pull/22501) chore: Migrate /superset/tables/\* to API v1 (@diegomedina248)
- [#22902](https://github.com/apache/superset/pull/22902) build(deps-dev): bump eslint from 8.32.0 to 8.33.0 in /superset-websocket (@dependabot[bot])
- [#22878](https://github.com/apache/superset/pull/22878) chore: upgrade react-router-dom to 5.3.4 (@lilykuang)
- [#22914](https://github.com/apache/superset/pull/22914) chore: upgrade packages for react v17 upgrade (@lilykuang)
- [#22815](https://github.com/apache/superset/pull/22815) chore: migrate @vx/responsive to @visx/responsive for react 18 upgrade (@lilykuang)
- [#22871](https://github.com/apache/superset/pull/22871) chore(db_engine_specs): clean up column spec logic and add tests (@villebro)
- [#22623](https://github.com/apache/superset/pull/22623) chore: skip puppeteer chromium download (@nisheldo)
- [#22772](https://github.com/apache/superset/pull/22772) chore: Localization of Superset pt. 2 (@artemonsh)
- [#22809](https://github.com/apache/superset/pull/22809) chore: migrate /sql_json and /results to apiv1 (@diegomedina248)
- [#22882](https://github.com/apache/superset/pull/22882) chore: deprecate /superset/filter/... endpoint, migrate to apiv1 (@jfrag1)
- [#22892](https://github.com/apache/superset/pull/22892) build(deps): bump underscore from 1.12.0 to 1.12.1 in /superset-frontend (@dependabot[bot])
- [#22891](https://github.com/apache/superset/pull/22891) build(deps): bump moment from 2.29.2 to 2.29.4 in /docs (@dependabot[bot])
- [#22888](https://github.com/apache/superset/pull/22888) docs: add Skyscanner to users list (@cleslie)
- [#22611](https://github.com/apache/superset/pull/22611) chore: Migrate /superset/queries/`<last_updated_ms>` to API v1 (@diegomedina248)
- [#22887](https://github.com/apache/superset/pull/22887) chore: add statsd support to base API and refactor (@dpgaspar)
- [#22496](https://github.com/apache/superset/pull/22496) chore: deprecate /superset/slice_json/`<int:slice_id>` and /superset/annotation_json/`<int:layer_id>` (@diegomedina248)
- [#22779](https://github.com/apache/superset/pull/22779) chore: upgrade react-reverse-portal for react upgrade (@lilykuang)
- [#22780](https://github.com/apache/superset/pull/22780) chore: upgrade react-table for react 18 upgrade (@lilykuang)
- [#22834](https://github.com/apache/superset/pull/22834) chore: migrate react-diff-viewer to react-diff-viewer-continued for react 18 upgrade (@lilykuang)
- [#22865](https://github.com/apache/superset/pull/22865) docs(cache): update doc strings (@cemremengu)
- [#22858](https://github.com/apache/superset/pull/22858) build(deps): bump ua-parser-js from 0.7.31 to 0.7.33 in /docs (@dependabot[bot])
- [#19678](https://github.com/apache/superset/pull/19678) chore(misc): Spelling (@jsoref)
- [#22838](https://github.com/apache/superset/pull/22838) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.48.2 to 5.49.0 in /superset-websocket (@dependabot[bot])
- [#22846](https://github.com/apache/superset/pull/22846) test: Fix act errors in DatabaseModal test (@lyndsiWilliams)
- [#22845](https://github.com/apache/superset/pull/22845) test: Fix act errors in DatasourceControl test (@lyndsiWilliams)
- [#22789](https://github.com/apache/superset/pull/22789) chore: Migrate /superset/recent_activity/`<user_id>`/ to /api/v1/ (@jfrag1)
- [#22844](https://github.com/apache/superset/pull/22844) chore(tests): Streamline Cypress login to fix fails/flakes (@codyml)
- [#20872](https://github.com/apache/superset/pull/20872) docs(alerts & reports): add, prune, reorganize (@sfirke)
- [#22617](https://github.com/apache/superset/pull/22617) chore(issue templates): discouraging Issues for feature requests (@rusackas)
- [#22585](https://github.com/apache/superset/pull/22585) chore: upgrade react-datetime, react-intersection-observer and react-checkbox-tree (@lilykuang)
- [#22516](https://github.com/apache/superset/pull/22516) chore: Convert direct uses of antd icons to 'Icons' component (@codyml)
- [#22413](https://github.com/apache/superset/pull/22413) chore(sqla): Add explicit bidirectional performant relationships for SQLA model (@john-bodley)
- [#22796](https://github.com/apache/superset/pull/22796) docs: link docker readme in docker config section (@nytai)
- [#22793](https://github.com/apache/superset/pull/22793) chore(dashboard): Log events for download as image (@justinpark)
- [#22771](https://github.com/apache/superset/pull/22771) chore(logging): add health checks to statsd (@villebro)
- [#22782](https://github.com/apache/superset/pull/22782) chore(ci): fix numpy type errors and revert #22610 (@villebro)
- [#22474](https://github.com/apache/superset/pull/22474) chore: Migrate .less styles to Emotion (@kgabryje)
- [#22415](https://github.com/apache/superset/pull/22415) chore(translation): add missing Russian translation, add plural forms (@artemonsh)
- [#22766](https://github.com/apache/superset/pull/22766) chore: adding missing examples in the gallery for some chart types (@yash-samsung)
- [#22592](https://github.com/apache/superset/pull/22592) chore: upgrade react-resize-detector (@lilykuang)
- [#22753](https://github.com/apache/superset/pull/22753) chore: re add upload tests (@dpgaspar)
- [#22748](https://github.com/apache/superset/pull/22748) build(deps): bump minimatch from 3.0.4 to 3.1.2 in /superset-embedded-sdk (@dependabot[bot])
- [#22750](https://github.com/apache/superset/pull/22750) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.48.1 to 5.48.2 in /superset-websocket (@dependabot[bot])
- [#22751](https://github.com/apache/superset/pull/22751) build(deps-dev): bump eslint from 8.29.0 to 8.32.0 in /superset-websocket (@dependabot[bot])
- [#22752](https://github.com/apache/superset/pull/22752) build(deps-dev): bump @types/jsonwebtoken from 8.5.9 to 9.0.1 in /superset-websocket (@dependabot[bot])
- [#22745](https://github.com/apache/superset/pull/22745) build(deps): bump minimatch from 3.0.4 to 3.1.2 in /superset-frontend/cypress-base (@dependabot[bot])
- [#22738](https://github.com/apache/superset/pull/22738) build(deps): bump ws and @types/ws in /superset-websocket (@dependabot[bot])
- [#22740](https://github.com/apache/superset/pull/22740) build(deps-dev): bump prettier from 2.8.2 to 2.8.3 in /superset-websocket (@dependabot[bot])
- [#22731](https://github.com/apache/superset/pull/22731) build(deps): bump express and @applitools/eyes-storybook in /superset-frontend (@dependabot[bot])
- [#22739](https://github.com/apache/superset/pull/22739) build(deps-dev): bump @typescript-eslint/parser from 5.47.0 to 5.48.1 in /superset-websocket (@dependabot[bot])
- [#22138](https://github.com/apache/superset/pull/22138) build(deps): bump loader-utils from 1.4.0 to 1.4.2 in /superset-frontend (@dependabot[bot])
- [#22742](https://github.com/apache/superset/pull/22742) chore: Use redis 7 on tests and pin on local dev and non-dev (@dpgaspar)
- [#22624](https://github.com/apache/superset/pull/22624) chore: Migrate /superset/stop_query/ to API v1 (@diegomedina248)
- [#22504](https://github.com/apache/superset/pull/22504) build(deps): bump jsonwebtoken from 8.5.1 to 9.0.0 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#22515](https://github.com/apache/superset/pull/22515) build(deps): bump jsonwebtoken from 8.5.1 to 9.0.0 in /superset-websocket (@dependabot[bot])
- [#22575](https://github.com/apache/superset/pull/22575) build(deps): bump json5 from 1.0.1 to 1.0.2 in /superset-embedded-sdk (@dependabot[bot])
- [#22577](https://github.com/apache/superset/pull/22577) build(deps): bump json5 from 2.1.3 to 2.2.3 in /superset-frontend/cypress-base (@dependabot[bot])
- [#22578](https://github.com/apache/superset/pull/22578) build(deps): bump json5 from 1.0.1 to 1.0.2 in /superset-frontend (@dependabot[bot])
- [#22711](https://github.com/apache/superset/pull/22711) docs(security): clarify CSP requirements and provide example TALISMAN_CONFIG (@reidab)
- [#22721](https://github.com/apache/superset/pull/22721) chore: Adds 1.5.3 release to CHANGELOG.md and UPDATING.md (@michael-s-molina)
- [#22499](https://github.com/apache/superset/pull/22499) chore(celery) & docs(celery): update celery config variables names (@artemonsh)
- [#22706](https://github.com/apache/superset/pull/22706) docs: add Swile to users list (@PaoloTerzi)
- [#21612](https://github.com/apache/superset/pull/21612) chore(deps): bump parse-path and lerna in /superset-frontend (@dependabot[bot])
- [#20820](https://github.com/apache/superset/pull/20820) chore(deps): bump pre-commit from 2.14.0 to 2.20.0 in /requirements (@dependabot[bot])
- [#22655](https://github.com/apache/superset/pull/22655) build(deps): bump winston from 3.3.3 to 3.8.2 in /superset-websocket (@dependabot[bot])
- [#22576](https://github.com/apache/superset/pull/22576) build(deps): bump json5 from 2.2.0 to 2.2.3 in /superset-websocket (@dependabot[bot])
- [#22656](https://github.com/apache/superset/pull/22656) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.45.0 to 5.48.1 in /superset-websocket (@dependabot[bot])
- [#22718](https://github.com/apache/superset/pull/22718) docs: add Mainstrat to INTHEWILD.md (@itziarmj)
- [#22712](https://github.com/apache/superset/pull/22712) docs(k8s): add note about database driver dependencies to k8s setup (@reidab)
- [#22710](https://github.com/apache/superset/pull/22710) docs(k8s): add note about authlib requirement to oauth setup example (@reidab)
- [#22687](https://github.com/apache/superset/pull/22687) docs(caching): Restructure and improve caching docs (@reidab)
- [#22631](https://github.com/apache/superset/pull/22631) chore: using bitly to manage expiring Slack invitation links (@rusackas)
- [#22668](https://github.com/apache/superset/pull/22668) chore: Swapping main superset images for more current versions (@rusackas)
- [#22230](https://github.com/apache/superset/pull/22230) chore: Move charts to src/pages folder (@EugeneTorap)
- [#22692](https://github.com/apache/superset/pull/22692) docs: add city of Ann Arbor to INTHEWILD (@sfirke)
- [#22694](https://github.com/apache/superset/pull/22694) chore(superset-ui): bump superset-ui-chart-controls and plugin-chart-handlebars back to version 0.18.25 (@lilykuang)
- [#22596](https://github.com/apache/superset/pull/22596) chore: upgrade react-redux (@lilykuang)
- [#22580](https://github.com/apache/superset/pull/22580) chore: Bump Flask-AppBuilder to 4.2.0 (@john-bodley)
- [#22150](https://github.com/apache/superset/pull/22150) chore: Localization of Superset pt. 1 (@artemonsh)
- [#22579](https://github.com/apache/superset/pull/22579) chore: Migrate /superset/search_queries to API v1 (@diegomedina248)
- [#22666](https://github.com/apache/superset/pull/22666) chore: Add KarrotPay in INTHEWILD.md (@posquit0)
- [#22669](https://github.com/apache/superset/pull/22669) docs: Add Careem to the user's list (@SamraHanifCareem)
- [#22676](https://github.com/apache/superset/pull/22676) chore(embedded): bump package versions (@villebro)
- [#22645](https://github.com/apache/superset/pull/22645) chore: upgrade react-window (@lilykuang)
- [#22646](https://github.com/apache/superset/pull/22646) chore: upgrade use-immer (@lilykuang)
- [#22638](https://github.com/apache/superset/pull/22638) build(deps-dev): bump prettier from 2.4.1 to 2.8.2 in /superset-websocket (@dependabot[bot])
- [#22355](https://github.com/apache/superset/pull/22355) chore: Bump flask libs (@EugeneTorap)
- [#22615](https://github.com/apache/superset/pull/22615) chore: bump sqloxide to 0.1.30 (@nisheldo)
- [#22517](https://github.com/apache/superset/pull/22517) chore: adjusting Alerts & reports docs to use the latest chromedriver (@rusackas)
- [#22597](https://github.com/apache/superset/pull/22597) chore: adding missing examples in the gallery for several chart types (@yash-samsung)
- [#22583](https://github.com/apache/superset/pull/22583) chore: upgrade react-json-tree (@lilykuang)
- [#22573](https://github.com/apache/superset/pull/22573) chore: upgrade react-ace (@lilykuang)
- [#22572](https://github.com/apache/superset/pull/22572) chore: upgrade interweave (@lilykuang)
- [#22363](https://github.com/apache/superset/pull/22363) chore: Use visibilityToggle prop to control password input visibility (@lyndsiWilliams)
- [#22561](https://github.com/apache/superset/pull/22561) build(deps): bump json5 from 2.2.1 to 2.2.2 in /docs (@dependabot[bot])
- [#22533](https://github.com/apache/superset/pull/22533) build(deps): bump wheel from 0.37.0 to 0.38.1 in /requirements (@dependabot[bot])
- [#22557](https://github.com/apache/superset/pull/22557) build(deps): bump fast-json-patch from 3.1.0 to 3.1.1 in /docs (@dependabot[bot])
- [#22366](https://github.com/apache/superset/pull/22366) chore(ssh-tunnel): Refactor establishing raw connection with contextmanger (@hughhhh)
- [#22508](https://github.com/apache/superset/pull/22508) refactor: rename filter_rel_fields to base_related_field_filters (@dpgaspar)
- [#22489](https://github.com/apache/superset/pull/22489) chore: Bump Pillow to 9.3.0 (@EugeneTorap)
- [#22461](https://github.com/apache/superset/pull/22461) chore: Update dataset_id & dataset_type datasource_id & datasource_type for SPA explore (@hughhhh)
- [#22142](https://github.com/apache/superset/pull/22142) build(deps): bump loader-utils from 1.4.0 to 1.4.2 in /superset-embedded-sdk (@dependabot[bot])
- [#22216](https://github.com/apache/superset/pull/22216) build(deps): bump pip-compile-multi from 2.4.1 to 2.6.1 in /requirements (@dependabot[bot])
- [#22465](https://github.com/apache/superset/pull/22465) chore(deps-dev): bump @typescript-eslint/parser from 5.45.0 to 5.47.0 in /superset-websocket (@dependabot[bot])
- [#22479](https://github.com/apache/superset/pull/22479) chore: updating changelog and updating (@AAfghahi)
- [#22340](https://github.com/apache/superset/pull/22340) build(deps): bump qs from 6.5.2 to 6.5.3 in /superset-frontend/cypress-base (@dependabot[bot])
- [#22476](https://github.com/apache/superset/pull/22476) chore: adding additional code owners for cypress tests (@rusackas)
- [#22158](https://github.com/apache/superset/pull/22158) build(deps): bump @ant-design/icons from 4.2.2 to 4.8.0 in /superset-frontend (@dependabot[bot])
- [#22430](https://github.com/apache/superset/pull/22430) chore(viz): Rename legacy non-time-series Bar Chart (@codyml)
- [#22435](https://github.com/apache/superset/pull/22435) chore: Re-add inheritance of Presto macros for Trino et al. (@john-bodley)
- [#21754](https://github.com/apache/superset/pull/21754) chore(deps): bump express from 4.18.1 to 4.18.2 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#22412](https://github.com/apache/superset/pull/22412) build(deps): bump uuid and @types/uuid in /superset-websocket (@dependabot[bot])
- [#22414](https://github.com/apache/superset/pull/22414) build(deps-dev): bump typescript from 4.2.3 to 4.9.4 in /superset-websocket (@dependabot[bot])
- [#22343](https://github.com/apache/superset/pull/22343) build(deps): bump qs from 6.5.2 to 6.5.3 in /superset-frontend (@dependabot[bot])
- [#22432](https://github.com/apache/superset/pull/22432) chore: set Snowflake user agent (@betodealmeida)
- [#22424](https://github.com/apache/superset/pull/22424) test: Fix act errors in VizTypeControl test (@lyndsiWilliams)
- [#22134](https://github.com/apache/superset/pull/22134) build(deps): bump loader-utils from 2.0.2 to 2.0.4 in /docs (@dependabot[bot])
- [#22411](https://github.com/apache/superset/pull/22411) chore: show database UUID in API (@betodealmeida)
- [#21712](https://github.com/apache/superset/pull/21712) chore(deps): bump css-what from 2.1.2 to 2.1.3 in /superset-frontend (@dependabot[bot])
- [#22341](https://github.com/apache/superset/pull/22341) build(deps): bump express from 4.17.1 to 4.18.2 in /docs (@dependabot[bot])
- [#22322](https://github.com/apache/superset/pull/22322) build(deps-dev): bump eslint from 7.32.0 to 8.29.0 in /superset-websocket (@dependabot[bot])
- [#22386](https://github.com/apache/superset/pull/22386) build(deps-dev): bump @types/node from 18.11.10 to 18.11.13 in /superset-websocket (@dependabot[bot])
- [#22389](https://github.com/apache/superset/pull/22389) perf: Prevent rerendering and re-querying metadata of filters in horizontal bar (@kgabryje)
- [#22382](https://github.com/apache/superset/pull/22382) chore(plugin-chart-echarts): upgrade to echarts 5.4.1 (@villebro)
- [#22369](https://github.com/apache/superset/pull/22369) chore(viz): rename v1 and v2 charts (@villebro)
- [#22347](https://github.com/apache/superset/pull/22347) chore(docs): adding community calendar link to the community page (@rusackas)
- [#19721](https://github.com/apache/superset/pull/19721) refactor(frontend): Make dashboard search box the first filter (@cemremengu)
- [#22354](https://github.com/apache/superset/pull/22354) chore: Bump holidays to 0.17.2 (@EugeneTorap)
- [#22335](https://github.com/apache/superset/pull/22335) chore: Refactor python libs (@EugeneTorap)
- [#22327](https://github.com/apache/superset/pull/22327) build(deps): bump ws and @types/ws in /superset-websocket (@dependabot[bot])
- [#22334](https://github.com/apache/superset/pull/22334) test: Fix act errors in FixedOrMetricControl test (@lyndsiWilliams)
- [#22305](https://github.com/apache/superset/pull/22305) chore: Add Horizontal FilterBar e2e tests (@geido)
- [#22333](https://github.com/apache/superset/pull/22333) chore: return 404 instead of 500 for datasource not found (@hughhhh)
- [#22231](https://github.com/apache/superset/pull/22231) chore: Remove actions prop and refactor code in SQL Lab (@EugeneTorap)
- [#22217](https://github.com/apache/superset/pull/22217) chore: Support Python 3.11 (@EugeneTorap)
- [#22309](https://github.com/apache/superset/pull/22309) build(deps-dev): bump @typescript-eslint/eslint-plugin from 4.19.0 to 5.45.0 in /superset-websocket (@dependabot[bot])
- [#22023](https://github.com/apache/superset/pull/22023) docs: update Flask-Babel links (@haocheng6)
- [#22315](https://github.com/apache/superset/pull/22315) build(deps): bump decode-uri-component from 0.2.0 to 0.2.2 in /superset-frontend (@dependabot[bot])
- [#22307](https://github.com/apache/superset/pull/22307) chore(native-filters): Grid units, type guard, feature flag guard (@codyml)
- [#21466](https://github.com/apache/superset/pull/21466) chore: Bump bigquery libs (@EugeneTorap)
- [#22313](https://github.com/apache/superset/pull/22313) docs: Add REDCap Cloud to superset users (@EugeneTorap)
- [#22297](https://github.com/apache/superset/pull/22297) build(deps-dev): bump @types/node from 16.11.6 to 18.11.10 in /superset-websocket (@dependabot[bot])
- [#22296](https://github.com/apache/superset/pull/22296) build(deps-dev): bump @types/cookie from 0.4.1 to 0.5.1 in /superset-websocket (@dependabot[bot])
- [#22295](https://github.com/apache/superset/pull/22295) build(deps): bump hot-shots from 9.0.0 to 9.3.0 in /superset-websocket (@dependabot[bot])
- [#22242](https://github.com/apache/superset/pull/22242) docs: Add Oslandia to superset users (@vpicavet)
- [#22279](https://github.com/apache/superset/pull/22279) chore: bump clickhouse to 0.4.6 (@betodealmeida)
- [#22255](https://github.com/apache/superset/pull/22255) build(deps-dev): bump @typescript-eslint/parser from 4.19.0 to 5.45.0 in /superset-websocket (@dependabot[bot])
- [#22272](https://github.com/apache/superset/pull/22272) chore(superset-ui): remove deprecated fields from QueryObject (@villebro)
- [#22266](https://github.com/apache/superset/pull/22266) chore(dashboard): Fix missing React key errors (@codyml)
- [#22214](https://github.com/apache/superset/pull/22214) chore(dashboard): Ignore empty json value for overwrite confirm (@justinpark)
- [#22224](https://github.com/apache/superset/pull/22224) refactor: restructure shared-contrls modules (@zhaoyongjie)
- [#22181](https://github.com/apache/superset/pull/22181) build(docker): Push websocket image (@Yann-J)
- [#22197](https://github.com/apache/superset/pull/22197) chore: rename 'Change dataset' action to 'Swap dataset' (@mistercrunch)
- [#22178](https://github.com/apache/superset/pull/22178) chore: remove annotation layer FAB CRUD model view (@dpgaspar)
- [#22187](https://github.com/apache/superset/pull/22187) docs: add AI inside to users list (@kamalkeshavani-aiinside)
- [#22157](https://github.com/apache/superset/pull/22157) docs: installing database drivers - trino (@wrb2)
- [#22085](https://github.com/apache/superset/pull/22085) chore: Change get_table_names/get_view_names return type (@john-bodley)
- [#22145](https://github.com/apache/superset/pull/22145) docs: Add docs for Amazon Dynamodb database driver (@passren)
- [#22007](https://github.com/apache/superset/pull/22007) chore: Upgrade antd@4.10.3 (@geido)
- [#22093](https://github.com/apache/superset/pull/22093) test(sqllab): Convert tests to RTL for SqlEditor (@corbinrobb)
- [#22130](https://github.com/apache/superset/pull/22130) docs: Add potential downtime line item to UPDATING.md (@john-bodley)
- [#21650](https://github.com/apache/superset/pull/21650) chore: Use queryEditorId in SqlEditor child components (@EugeneTorap)
- [#22121](https://github.com/apache/superset/pull/22121) chore(docs): update slack invite url (@kamalkeshavani-aiinside)
- [#22050](https://github.com/apache/superset/pull/22050) chore(sqllab): Change icon color for running sql (@justinpark)
- [#22116](https://github.com/apache/superset/pull/22116) chore: deprecate /superset/datasources/ (@dpgaspar)
- [#21971](https://github.com/apache/superset/pull/21971) refactor: use exception status for logging (@eschutho)
- [#21986](https://github.com/apache/superset/pull/21986) chore: remove shadow write of new sip 68 dataset models (@eschutho)
- [#22113](https://github.com/apache/superset/pull/22113) refactor: add deprecated decorator for old SupersetView's (@dpgaspar)
- [#22102](https://github.com/apache/superset/pull/22102) chore: deprecate /superset/fetch_datasource_metadata mig to API v1 (@dpgaspar)
- [#22074](https://github.com/apache/superset/pull/22074) refactor: update documents and rename variables (@zhaoyongjie)
- [#22083](https://github.com/apache/superset/pull/22083) chore: improve performance on bootstrap permissions (@dpgaspar)
- [#22024](https://github.com/apache/superset/pull/22024) chore(bigquery): Add extra logging for BigQuery exceptions so we can have better insight on exceptions (@Antonio-RiveroMartnez)
- [#22067](https://github.com/apache/superset/pull/22067) chore: update Druid (@betodealmeida)
- [#22068](https://github.com/apache/superset/pull/22068) test: Fix act errors in DndColumnSelectControl tests (@corbinrobb)
- [#22048](https://github.com/apache/superset/pull/22048) test: Fix act errors in DndMetricSelect test (@lyndsiWilliams)
- [#22041](https://github.com/apache/superset/pull/22041) chore: Adds RTL tests to DropdownContainer (@michael-s-molina)
- [#21954](https://github.com/apache/superset/pull/21954) build: Mutli-stage build and slim image for websocket container (@Yann-J)
- [#22032](https://github.com/apache/superset/pull/22032) chore(dataset): enable reload for schema and table (@justinpark)
- [#22015](https://github.com/apache/superset/pull/22015) refactor: Feature flags getter (@zhaoyongjie)
- [#22002](https://github.com/apache/superset/pull/22002) refactor: clean up codes (@zhaoyongjie)
- [#21990](https://github.com/apache/superset/pull/21990) chore: Verify edit permission for Horizontal filter bar (@geido)
- [#21938](https://github.com/apache/superset/pull/21938) chore: Refactor ownership (@john-bodley)
- [#21982](https://github.com/apache/superset/pull/21982) chore: bubble up more db error messages (@villebro)
- [#21836](https://github.com/apache/superset/pull/21836) refactor: return initial exception and check if it's user error (@hughhhh)
- [#21781](https://github.com/apache/superset/pull/21781) perf(native-filters): reduce the re-rendering of native filter modal (@stephenLYZ)
- [#21821](https://github.com/apache/superset/pull/21821) perf(native-filters): improve native filter modal form performance (@stephenLYZ)
- [#21963](https://github.com/apache/superset/pull/21963) build(helm): Helm-docs + fix Helm chart release (@Yann-J)
- [#21958](https://github.com/apache/superset/pull/21958) chore: bump pyathena and related packages (@eschutho)
- [#21725](https://github.com/apache/superset/pull/21725) chore: Remove several React app console warnings and errors v2 (@agl-developer)
- [#21951](https://github.com/apache/superset/pull/21951) docs(athena): add assuming IAM role with PyAthena (@gforien)
- [#21802](https://github.com/apache/superset/pull/21802) chore: additional logging in alerts and reports (@AAfghahi)
- [#21916](https://github.com/apache/superset/pull/21916) chore(plugin-chart-echarts): bump ECharts to 5.4.0 (@villebro)
- [#21908](https://github.com/apache/superset/pull/21908) chore: Improves D2D loading indicator (@michael-s-molina)
- [#21896](https://github.com/apache/superset/pull/21896) chore: Updating SIP issue template to boost the link, and (hopefully) reduce duplicate-numbered SIP issues. (@rusackas)
- [#21815](https://github.com/apache/superset/pull/21815) chore: Remove CROSS_REFERENCES feature flag (@geido)
- [#21805](https://github.com/apache/superset/pull/21805) chore: E2E Dashboards Cross-references (@geido)
- [#21622](https://github.com/apache/superset/pull/21622) chore: Color consistency E2E tests (@geido)
- [#21849](https://github.com/apache/superset/pull/21849) docs: 414 (@Onroe)
- [#21816](https://github.com/apache/superset/pull/21816) chore: Added translate functions (@AndVK)
- [#21818](https://github.com/apache/superset/pull/21818) chore: Add `USER_CLIENT_ERRORS` to stop logging exceptions that are user driven (@hughhhh)
- [#21523](https://github.com/apache/superset/pull/21523) refactor: serialize extra json in state (@eschutho)
- [#21714](https://github.com/apache/superset/pull/21714) chore: add more logging for alerts and reports (@pkdotson)
- [#21787](https://github.com/apache/superset/pull/21787) chore: stop logging "SyntaxError" as exceptions (@hughhhh)
- [#21766](https://github.com/apache/superset/pull/21766) refactor: preparation for time section migration (@zhaoyongjie)
- [#21738](https://github.com/apache/superset/pull/21738) chore: cleanup on catalog check for Gsheets (@hughhhh)
- [#21438](https://github.com/apache/superset/pull/21438) perf(dashboard): Virtualization POC (@kgabryje)
- [#21744](https://github.com/apache/superset/pull/21744) chore(explore): Add tests for getControlValuesCompatibleWithDatasource (@codyml)
- [#21748](https://github.com/apache/superset/pull/21748) chore(deps): bump react-map-gl from 4.0.10 to 6.1.19 (@stephenLYZ)
- [#21711](https://github.com/apache/superset/pull/21711) chore(sqllab): refactor addQueryEditor for new tab (@justinpark)
- [#20435](https://github.com/apache/superset/pull/20435) chore: Slovenian translation update (@dkrat7)
- [#21024](https://github.com/apache/superset/pull/21024) docs(snowflake): Remove wrong version info for snowflake (@dingobar)
- [#21491](https://github.com/apache/superset/pull/21491) docs: wording in template (@JakobMiksch)
- [#21583](https://github.com/apache/superset/pull/21583) build: optimize docker build by better utilizing build cache (@pwang2)
- [#21670](https://github.com/apache/superset/pull/21670) docs(cache): update datasource -> dataset (@nytai)
- [#21681](https://github.com/apache/superset/pull/21681) chore: E2E tests for Drill to Detail supported Charts (@geido)
- [#21702](https://github.com/apache/superset/pull/21702) chore(key-value): remove redundant exception logging (@villebro)
- [#17320](https://github.com/apache/superset/pull/17320) other: Improve health check for docker-compose. (@PMExtra)
- [#21474](https://github.com/apache/superset/pull/21474) chore: Adding/categorizing missing flags in `FEATURE_FLAGS.md` (@rusackas)
- [#21586](https://github.com/apache/superset/pull/21586) chore(dep): Unpin slackclient dependency (@ecederstrand)
- [#21687](https://github.com/apache/superset/pull/21687) docs: add Wise to users list (@koszti)
- [#21487](https://github.com/apache/superset/pull/21487) refactor: pass all properties to validate_parameters (@eschutho)
- [#21627](https://github.com/apache/superset/pull/21627) chore: add 4xx error codes where applicable (@eschutho)
- [#21614](https://github.com/apache/superset/pull/21614) chore(style): Enforce optional chaining (@rusackas)
- [#21459](https://github.com/apache/superset/pull/21459) chore(tags): Refactor logic to leverage Flask-SQLAlchemy extension (@john-bodley)
- [#21631](https://github.com/apache/superset/pull/21631) chore: avoid undefined property on `Global` type (@justinpark)
- [#21660](https://github.com/apache/superset/pull/21660) docs: add organization that uses superset (@zamar-roura)
- [#21551](https://github.com/apache/superset/pull/21551) chore: Create dashboard with tier 1 and tier 2 charts (@kgabryje)
- [#21643](https://github.com/apache/superset/pull/21643) refactor: remove useless groupby from QueryObject (@zhaoyongjie)
- [#21654](https://github.com/apache/superset/pull/21654) chore(deps): bump minimist from 0.0.5 to 1.2.6 in /superset-frontend (@dependabot[bot])
- [#21611](https://github.com/apache/superset/pull/21611) chore: removing '.git' from web url references in Yeoman generator's package.json (@rusackas)
- [#21532](https://github.com/apache/superset/pull/21532) chore: refactor AceEditorWrapper to functional component (@EugeneTorap)
- [#20958](https://github.com/apache/superset/pull/20958) docs: update installing-superset-using-docker-compose.mdx (@avlihachev)
- [#20853](https://github.com/apache/superset/pull/20853) docs: Removing erroneous FAQ timeout message (@john-bodley)
- [#21169](https://github.com/apache/superset/pull/21169) chore(deps): bump node-forge and webpack-dev-server in /superset-frontend (@dependabot[bot])
- [#21602](https://github.com/apache/superset/pull/21602) chore(deps-dev): bump @types/jsonwebtoken from 8.5.5 to 8.5.9 in /superset-websocket (@dependabot[bot])
- [#20978](https://github.com/apache/superset/pull/20978) chore(deps): bump http-errors from 1.8.0 to 2.0.0 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#20983](https://github.com/apache/superset/pull/20983) chore(deps): bump cookie from 0.4.1 to 0.5.0 in /superset-websocket (@dependabot[bot])
- [#20785](https://github.com/apache/superset/pull/20785) chore(deps): bump terser from 5.10.0 to 5.14.2 in /superset-embedded-sdk (@dependabot[bot])
- [#21601](https://github.com/apache/superset/pull/21601) chore: Updates CHANGELOG.md and UPDATING.md with 1.5.2 changes (@michael-s-molina)
- [#21589](https://github.com/apache/superset/pull/21589) refactor: Organizes the Select files (@michael-s-molina)
- [#21543](https://github.com/apache/superset/pull/21543) chore(dashboard): Add filter_scopes warning message for json metadata editor (@justinpark)
- [#21581](https://github.com/apache/superset/pull/21581) chore(deps): Unpin sqlparse dependency (@ecederstrand)
- [#21566](https://github.com/apache/superset/pull/21566) docs: Turkey map already added (@rizacavus)
- [#21565](https://github.com/apache/superset/pull/21565) chore(deps): bump moment-timezone from 0.5.33 to 0.5.37 in /superset-frontend (@dependabot[bot])
- [#21553](https://github.com/apache/superset/pull/21553) chore: Remove chromatic job per PR as it has errors (@eric-briscoe)
- [#21496](https://github.com/apache/superset/pull/21496) refactor: Rewrites ColorSchemeControl with Typescript (@michael-s-molina)
- [#21320](https://github.com/apache/superset/pull/21320) chore: refactor SqlEditor to functional component (@EugeneTorap)
- [#21510](https://github.com/apache/superset/pull/21510) refactor: refine timestamp expr function (@zhaoyongjie)
- [#21524](https://github.com/apache/superset/pull/21524) chore: should return if get a exception in Dashboard edit modal (@zhaoyongjie)
- [#21504](https://github.com/apache/superset/pull/21504) perf(word-cloud): reduce render to improve performance (@stephenLYZ)
- [#21326](https://github.com/apache/superset/pull/21326) chore: Use slim image in Dockerfile (@EugeneTorap)
- [#21445](https://github.com/apache/superset/pull/21445) refactor: Moves the DeprecatedSelect to its own folder (@michael-s-molina)
- [#21449](https://github.com/apache/superset/pull/21449) refactor: get Axis from a helper function (@zhaoyongjie)
- [#21094](https://github.com/apache/superset/pull/21094) chore: Extract common select component code (@cccs-RyanK)
- [#21346](https://github.com/apache/superset/pull/21346) chore: remove blank space from users filters (@lilykuang)
- [#21456](https://github.com/apache/superset/pull/21456) test: Fix act errors in ExploreChartPanel test (@lyndsiWilliams)
- [#21439](https://github.com/apache/superset/pull/21439) perf: Memoize the common_bootstrap_payload and include user param (#21018) (@bkyryliuk)
- [#21414](https://github.com/apache/superset/pull/21414) test: Fixes act errors in ErrorMessage tests (@michael-s-molina)
- [#21332](https://github.com/apache/superset/pull/21332) chore: Cypress runtime enhancements (@geido)
- [#21427](https://github.com/apache/superset/pull/21427) test: Fix act errors in CustomFrame test (@lyndsiWilliams)
- [#21415](https://github.com/apache/superset/pull/21415) test: Fixes act errors in LastUpdated test (@michael-s-molina)
- [#21413](https://github.com/apache/superset/pull/21413) chore: Bump sqlalchemy-utils to 0.38.3 (@EugeneTorap)
- [#21429](https://github.com/apache/superset/pull/21429) test: Fix act errors in DndFilterSelect test (@lyndsiWilliams)
- [#21428](https://github.com/apache/superset/pull/21428) test: Fix act errors in DndColumnSelect test (@lyndsiWilliams)
- [#21426](https://github.com/apache/superset/pull/21426) test: Fix act errors in DatasourceControl test (@lyndsiWilliams)
- [#21423](https://github.com/apache/superset/pull/21423) test: Fix act errors in AnnotationLayer test (@lyndsiWilliams)
- [#21421](https://github.com/apache/superset/pull/21421) test: Fix act errors in CollectionControl test (@lyndsiWilliams)
- [#21424](https://github.com/apache/superset/pull/21424) test: Fixes act errors in DatasourceEditor test (@michael-s-molina)
- [#21420](https://github.com/apache/superset/pull/21420) test: Fixes act errors in ReportModal test (@michael-s-molina)
- [#21418](https://github.com/apache/superset/pull/21418) test: Fixes act errors in ListView test (@michael-s-molina)
- [#21416](https://github.com/apache/superset/pull/21416) test: Fixes act errors in PopoverSection test (@michael-s-molina)
- [#21412](https://github.com/apache/superset/pull/21412) test: Fixes act errors in ErrorBoundary test (@michael-s-molina)
- [#21303](https://github.com/apache/superset/pull/21303) chore: add test for SPA explore endpoints around missing datasets (@hughhhh)
- [#21410](https://github.com/apache/superset/pull/21410) test: Fix act errors in DatasourcePanelDragOption test (@lyndsiWilliams)
- [#21407](https://github.com/apache/superset/pull/21407) test: Fix act error in FilterInput test (@lyndsiWilliams)
- [#21409](https://github.com/apache/superset/pull/21409) test: Fix act errors in DatasourcePanel test (@lyndsiWilliams)
- [#21406](https://github.com/apache/superset/pull/21406) test: Fix act errors in SamplesPane test (@lyndsiWilliams)
- [#21404](https://github.com/apache/superset/pull/21404) test: Fix act errors in ResultsPaneOnDashboard test (@lyndsiWilliams)
- [#21403](https://github.com/apache/superset/pull/21403) test: Fix act error in DataTablesPane test (@lyndsiWilliams)
- [#21402](https://github.com/apache/superset/pull/21402) test: Fix act errors in ExploreChartHeader test (@lyndsiWilliams)
- [#21401](https://github.com/apache/superset/pull/21401) test: Fix act error in ExportToCVSDropdown test (@lyndsiWilliams)
- [#21400](https://github.com/apache/superset/pull/21400) test: Fix act error in PropertyModal test (@lyndsiWilliams)
- [#21398](https://github.com/apache/superset/pull/21398) test: Fix act errors in ControlPanelsContainer test (@lyndsiWilliams)
- [#21397](https://github.com/apache/superset/pull/21397) test: Fix act errors in ExploreChartPanel test (@lyndsiWilliams)
- [#21396](https://github.com/apache/superset/pull/21396) test: Fix act errors in SelectFilterPlugin test (@lyndsiWilliams)
- [#21395](https://github.com/apache/superset/pull/21395) test: Fix act errors in LanguagePicker test (@lyndsiWilliams)
- [#21370](https://github.com/apache/superset/pull/21370) chore(database): raised version of sqlalchemy-kusto (@xneg)
- [#21393](https://github.com/apache/superset/pull/21393) test: Fixes act errors in Toast test (@michael-s-molina)
- [#21391](https://github.com/apache/superset/pull/21391) test: Fix act errors in Menu test (@lyndsiWilliams)
- [#21390](https://github.com/apache/superset/pull/21390) test: Fixes act errors in RefreshLabel test (@michael-s-molina)
- [#21394](https://github.com/apache/superset/pull/21394) test: Fixes act errors in ErrorAlert test (@michael-s-molina)
- [#21383](https://github.com/apache/superset/pull/21383) test: Fix act errors in LeftPanel test (@lyndsiWilliams)
- [#21389](https://github.com/apache/superset/pull/21389) test: Fixes act errors in PageHeaderWithActions test (@michael-s-molina)
- [#21392](https://github.com/apache/superset/pull/21392) test: Fixes act errors in AlteredSliceTag test (@michael-s-molina)
- [#21384](https://github.com/apache/superset/pull/21384) test: Fixes act errors in CertifiedBadge test (@michael-s-molina)
- [#21386](https://github.com/apache/superset/pull/21386) test: Fixes act errors in Alert test (@michael-s-molina)
- [#21387](https://github.com/apache/superset/pull/21387) test: Fix act errors in SubMenu test (@lyndsiWilliams)
- [#21381](https://github.com/apache/superset/pull/21381) test: Fix act errors in AddDataset test (@lyndsiWilliams)
- [#21374](https://github.com/apache/superset/pull/21374) test: Fixes act errors in IndeterminateCheckbox test (@michael-s-molina)
- [#21376](https://github.com/apache/superset/pull/21376) test: Fixes act errors in HeaderReportDropdown test (@michael-s-molina)
- [#21375](https://github.com/apache/superset/pull/21375) test: Fixes act errors in TableView test (@michael-s-molina)
- [#21377](https://github.com/apache/superset/pull/21377) test: Fixes act errors in TimezoneSelector test (@michael-s-molina)
- [#21367](https://github.com/apache/superset/pull/21367) test: Fix act errors in DatasetLayout test (@lyndsiWilliams)
- [#21363](https://github.com/apache/superset/pull/21363) test: Fix act errors in SqlEditorLeftBar test (@lyndsiWilliams)
- [#21361](https://github.com/apache/superset/pull/21361) test: Fix act errors in PopoverDropdown test (@lyndsiWilliams)
- [#21360](https://github.com/apache/superset/pull/21360) test: Fix act errors in FaveStar test (@lyndsiWilliams)
- [#21365](https://github.com/apache/superset/pull/21365) test: Fix act errors in DatabaseModal test (@lyndsiWilliams)
- [#21362](https://github.com/apache/superset/pull/21362) test: Fix act errors in SaveDatasetActionButton test (@lyndsiWilliams)
- [#21309](https://github.com/apache/superset/pull/21309) docs: correct location of existing time grain definition (@sfirke)
- [#21186](https://github.com/apache/superset/pull/21186) chore: refactor ResultSet to functional component (@EugeneTorap)
- [#21329](https://github.com/apache/superset/pull/21329) chore: bump FAB to 4.1.4 (@dpgaspar)
- [#21324](https://github.com/apache/superset/pull/21324) chore: upgrade yeoman-generator to fix security warnings (@stephenLYZ)
- [#20910](https://github.com/apache/superset/pull/20910) chore: refactor ChartHolder to typescript + tests (@diegomedina248)
- [#21285](https://github.com/apache/superset/pull/21285) chore: Bump pandas to 1.4.4 (@EugeneTorap)
- [#21240](https://github.com/apache/superset/pull/21240) refactor: introduce react-query on api resource hook (@justinpark)
- [#21173](https://github.com/apache/superset/pull/21173) chore: migrate available_domains to api/v1 (@zephyring)
- [#21270](https://github.com/apache/superset/pull/21270) chore: update release docs (@michael-s-molina)
- [#21278](https://github.com/apache/superset/pull/21278) chore: Renaming Line Chart to Line Chart v2 (@lauderbaugh)
- [#20776](https://github.com/apache/superset/pull/20776) chore: updating thrift (@nisheldo)
- [#21280](https://github.com/apache/superset/pull/21280) chore(sqllab): Remove max-width on side panel (@justinpark)
- [#21218](https://github.com/apache/superset/pull/21218) chore: missing IconType on Icons (@justinpark)
- [#21239](https://github.com/apache/superset/pull/21239) chore: Minor Applitools enhancements (@geido)
- [#21148](https://github.com/apache/superset/pull/21148) chore: Drill to detail Modal tests (@geido)
- [#21212](https://github.com/apache/superset/pull/21212) chore: Keeps context menu in viewport (@michael-s-molina)
- [#21187](https://github.com/apache/superset/pull/21187) chore: E2E tests for the Drill to detail modal (@geido)
- [#21184](https://github.com/apache/superset/pull/21184) chore: Add new e2e tests for Explore (@kgabryje)
- [#21195](https://github.com/apache/superset/pull/21195) chore: Dump clickhouse-sqlalchemy 0.2.2 (@EugeneTorap)
- [#21156](https://github.com/apache/superset/pull/21156) perf: Reimplement permissions fetching to do it in a single transaction (@bkyryliuk)
- [#20877](https://github.com/apache/superset/pull/20877) perf(sqllab): Rendering perf improvement using immutable state (@justinpark)
- [#21062](https://github.com/apache/superset/pull/21062) chore(deps): bump async from 2.6.3 to 2.6.4 in /superset-frontend (@dependabot[bot])
- [#21037](https://github.com/apache/superset/pull/21037) docs: Format the same size of picture for better part of "Supported Databases" document (@zhouyao1994)
- [#21128](https://github.com/apache/superset/pull/21128) docs: added timescaledb (@Rajakavitha1)
- [#21123](https://github.com/apache/superset/pull/21123) chore: support trailing slashes in database api (@diegomedina248)
- [#21136](https://github.com/apache/superset/pull/21136) chore: refactor FilterableTable to functional component (@EugeneTorap)
- [#21104](https://github.com/apache/superset/pull/21104) chore(deps): bump jsprim to 1.4.2 (@diegomedina248)
- [#21142](https://github.com/apache/superset/pull/21142) chore(fab): Expose the TableColumnInlineView extra column listed in the legacy FAB API (@john-bodley)
- [#21121](https://github.com/apache/superset/pull/21121) chore: Dump all babel libs (@EugeneTorap)
- [#21020](https://github.com/apache/superset/pull/21020) test: Fix async tests in SaveDatasetModal and complete overwrite screen test (@lyndsiWilliams)
- [#21118](https://github.com/apache/superset/pull/21118) chore(fab): Expose the SqlMetricInlineView extra column listed in the legacy FAB API (@john-bodley)
- [#21111](https://github.com/apache/superset/pull/21111) docs: improve encrypted field adapter docs (@dpgaspar)
- [#21002](https://github.com/apache/superset/pull/21002) chore: Support Python 3.10 and bump pandas 1.4 and pyarrow 6 (@EugeneTorap)
- [#21052](https://github.com/apache/superset/pull/21052) chore: Add embedded docs configuration details to extensions registry (@jfrag1)
- [#21046](https://github.com/apache/superset/pull/21046) chore(deps): bump ejs from 2.7.4 to 3.1.8 in /superset-frontend (@dependabot[bot])
- [#21047](https://github.com/apache/superset/pull/21047) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /superset-frontend (@dependabot[bot])
- [#20949](https://github.com/apache/superset/pull/20949) chore: add test for tab state (@eschutho)
- [#20974](https://github.com/apache/superset/pull/20974) perf: Implement model specific lookups by id to improve performance (@bkyryliuk)
- [#20807](https://github.com/apache/superset/pull/20807) chore: Audit E2E tests for color schemes in Dashboard and Explore (@geido)
- [#20773](https://github.com/apache/superset/pull/20773) chore: update text for dbconn modal (@pkdotson)
- [#20979](https://github.com/apache/superset/pull/20979) chore(deps): bump express from 4.17.1 to 4.18.1 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#20980](https://github.com/apache/superset/pull/20980) chore(deps): bump debug from 4.3.2 to 4.3.4 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#20976](https://github.com/apache/superset/pull/20976) chore(requirements): Bump trino-python-client (@john-bodley)
- [#20982](https://github.com/apache/superset/pull/20982) chore(deps): bump cookie-parser from 1.4.5 to 1.4.6 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#20920](https://github.com/apache/superset/pull/20920) chore: make dependabot upgrade package.json + add more package.json files (@rusackas)
- [#20894](https://github.com/apache/superset/pull/20894) chore: always get dashboard_id on dashboard API get endpoint (@lilykuang)
- [#20948](https://github.com/apache/superset/pull/20948) chore: unpin snowflake (@betodealmeida)
- [#20911](https://github.com/apache/superset/pull/20911) test: autouse app_context in unit tests (@ktmud)
- [#20868](https://github.com/apache/superset/pull/20868) chore: change Sort-by and Sort-Descending controls for Bar Chart v2 (@stephenLYZ)
- [#20921](https://github.com/apache/superset/pull/20921) chore: add cypress codeowners to e2e tests (@eschutho)
- [#20922](https://github.com/apache/superset/pull/20922) chore: Update Makefile to use `npm ci` (@hughhhh)
- [#20917](https://github.com/apache/superset/pull/20917) chore: Add Applitools logo to the docs homepage (@geido)
- [#20787](https://github.com/apache/superset/pull/20787) chore(deps): bump terser from 4.6.3 to 4.8.1 in /superset-frontend (@dependabot[bot])
- [#20822](https://github.com/apache/superset/pull/20822) chore(deps): bump tox from 3.24.1 to 3.25.1 in /requirements (@dependabot[bot])
- [#20612](https://github.com/apache/superset/pull/20612) chore(explore): update Explore icons and icon colors (@codyml)
- [#20915](https://github.com/apache/superset/pull/20915) chore(test): Unskip Cypress test (@codyml)
- [#20884](https://github.com/apache/superset/pull/20884) other(mypy): Enable warn_unused_ignores (@john-bodley)
- [#20690](https://github.com/apache/superset/pull/20690) chore: Remove unecessary code from async and sync select components (@cccs-RyanK)
- [#20669](https://github.com/apache/superset/pull/20669) chore: adding Bazaar Technologies to Superset Users (@umair-abro)
- [#20786](https://github.com/apache/superset/pull/20786) chore(deps): bump terser from 5.9.0 to 5.14.2 in /docs (@dependabot[bot])
- [#20810](https://github.com/apache/superset/pull/20810) refactor: Improve performance regression introduced in #20473 (@john-bodley)
- [#20858](https://github.com/apache/superset/pull/20858) chore: updated resources with newer blogs and events (@srinify)
- [#20870](https://github.com/apache/superset/pull/20870) test: suppress flask_appbuilder logs in CI (@ktmud)
- [#20804](https://github.com/apache/superset/pull/20804) chore: Feature flag for embedding charts (@geido)
- [#20789](https://github.com/apache/superset/pull/20789) chore: Ignore Applitools by default when running Cypress tests (@geido)
- [#20856](https://github.com/apache/superset/pull/20856) docs: fix alt image issue (@srinify)
- [#20589](https://github.com/apache/superset/pull/20589) chore: Update color scheme when deleted or changed (@geido)
- [#20849](https://github.com/apache/superset/pull/20849) chore: add databricks logo (@srinify)
- [#20846](https://github.com/apache/superset/pull/20846) chore: Change Button background color from primary.dark1 to primary.base (@kgabryje)
- [#20841](https://github.com/apache/superset/pull/20841) chore: add SAMPLES_ROW_LIMIT in frontend conf (@zhaoyongjie)
- [#20775](https://github.com/apache/superset/pull/20775) chore: update Pillow (@nisheldo)
- [#20813](https://github.com/apache/superset/pull/20813) chore: bumps the handlebars plugin package version to match the family. (@rusackas)
- [#20732](https://github.com/apache/superset/pull/20732) other: Blossom metric fields for dataset API column selection (@john-bodley)
- [#20660](https://github.com/apache/superset/pull/20660) chore: add user agent to Databricks requests (@betodealmeida)
- [#20769](https://github.com/apache/superset/pull/20769) chore: add coverage command in package.json (@zhaoyongjie)
- [#20705](https://github.com/apache/superset/pull/20705) docs: add Platzi.com to users list (@ernestoruiz89)
- [#20713](https://github.com/apache/superset/pull/20713) chore: add apache header for 2.0 changelog (@ktmud)
- [#20703](https://github.com/apache/superset/pull/20703) refactor(test): add login_as_admin to global conftest (@ktmud)
- [#20490](https://github.com/apache/superset/pull/20490) docs: WIP release notes for 2.0 (@srinify)
- [#20709](https://github.com/apache/superset/pull/20709) chore: Updates CHANGELOG.md and UPDATING.md with 2.0.0 changes (@michael-s-molina)
- [#20557](https://github.com/apache/superset/pull/20557) docs: update intro.mdx (@ciusji)
- [#20598](https://github.com/apache/superset/pull/20598) docs: add pyodbc (@vladik-hbinov)
- [#20695](https://github.com/apache/superset/pull/20695) docs: update elasticsearch.mdx (@lguillaud)
- [#20645](https://github.com/apache/superset/pull/20645) refactor: Unify shared datasources reducers and actions (@michael-s-molina)
- [#20675](https://github.com/apache/superset/pull/20675) refactor: Renders addSlice in SPA (@michael-s-molina)
- [#20498](https://github.com/apache/superset/pull/20498) chore(explore): Update chart save to use API endpoints (@codyml)
- [#20098](https://github.com/apache/superset/pull/20098) chore(docs): custom and built-in event logging class at the same time (@wiktor2200)
- [#20649](https://github.com/apache/superset/pull/20649) chore(deps-dev): bump jsdom from 16.4.0 to 20.0.0 in /superset-frontend (@dependabot[bot])
- [#20622](https://github.com/apache/superset/pull/20622) chore(docs): enhanced docs for feature flags setting to make it more clear (@wiktor2200)
- [#20657](https://github.com/apache/superset/pull/20657) docs: Remove unnecessary line item (@john-bodley)
- [#20338](https://github.com/apache/superset/pull/20338) chore: removing Druid from front- and back- end (@AAfghahi)
- [#20466](https://github.com/apache/superset/pull/20466) chore: Split Select component into Async and Sync components (@cccs-RyanK)
- [#20578](https://github.com/apache/superset/pull/20578) docs: add WikiMedia Foundation to users list (@vg)
- [#20643](https://github.com/apache/superset/pull/20643) chore(deps): bump moment from 2.29.2 to 2.29.4 in /docs (@dependabot[bot])
- [#20469](https://github.com/apache/superset/pull/20469) chore(deps): bump got from 11.8.3 to 11.8.5 in /superset-frontend/cypress-base (@dependabot[bot])
- [#20614](https://github.com/apache/superset/pull/20614) chore(deps): bump parse-url from 6.0.0 to 6.0.2 in /superset-frontend (@dependabot[bot])
- [#20640](https://github.com/apache/superset/pull/20640) docs: small fixes for OAuth (@dpgaspar)
- [#20475](https://github.com/apache/superset/pull/20475) chore: Set table viz default row limit to 1000 (@diegomedina248)
- [#20628](https://github.com/apache/superset/pull/20628) chore: rename "uiOverrideRegistry" -> "extensionsRegistry" (@suddjian)
- [#20572](https://github.com/apache/superset/pull/20572) refactor: Renders Explore in SPA (@michael-s-molina)
- [#20502](https://github.com/apache/superset/pull/20502) refactor: Deprecate ensure_user_is_set in favor of override_user (@john-bodley)
- [#20344](https://github.com/apache/superset/pull/20344) chore(rls): Remove passing global username (@john-bodley)
- [#20602](https://github.com/apache/superset/pull/20602) chore: rename drop missing columns to show empty columns (@zhaoyongjie)
- [#20554](https://github.com/apache/superset/pull/20554) chore: organize github actions (@suddjian)
- [#20550](https://github.com/apache/superset/pull/20550) chore: updating python docker image to 3.8.13 (@nisheldo)
- [#20582](https://github.com/apache/superset/pull/20582) refactor: remove unused flatten function (@zhaoyongjie)
- [#20568](https://github.com/apache/superset/pull/20568) test: Improve & un-skip flaky Cypress test (@codyml)
- [#20519](https://github.com/apache/superset/pull/20519) chore(explore): Get Explore data from endpoint instead of bootstrap_data (@kgabryje)
- [#20526](https://github.com/apache/superset/pull/20526) chore: Updates Metrics and Columns font-size (@michael-s-molina)
- [#20529](https://github.com/apache/superset/pull/20529) chore: move isAdhocColumn from controls to core (@zhaoyongjie)
- [#20518](https://github.com/apache/superset/pull/20518) refactor(standardized form data): refine interface and improve code smells (@zhaoyongjie)
- [#20427](https://github.com/apache/superset/pull/20427) chore: added new translations to the spanish language (@cdpazos27)
- [#20510](https://github.com/apache/superset/pull/20510) chore: Updates control panel font size in Explore (@michael-s-molina)
- [#20473](https://github.com/apache/superset/pull/20473) refactor: Minor optimization for updating DatasetDAO columns and metrics (@john-bodley)
- [#20260](https://github.com/apache/superset/pull/20260) docs(contribute): update compatible Python versions in local environment setup instructions (@diegoauad)
- [#20448](https://github.com/apache/superset/pull/20448) chore: Restructure explore redux state (@kgabryje)
- [#20179](https://github.com/apache/superset/pull/20179) chore: Convert QueryAutoRefresh to TypeScript functional React component [sc-48362] (@eric-briscoe)
- [#20429](https://github.com/apache/superset/pull/20429) chore: remove label for new user (@eschutho)
- [#20446](https://github.com/apache/superset/pull/20446) docs(featureflags): add GENERIC_CHART_AXES flag (@novemberde)
- [#20369](https://github.com/apache/superset/pull/20369) chore(newchart): update chart creation dataset selection help text, styles (@codyml)
- [#20380](https://github.com/apache/superset/pull/20380) chore: switching out ConnectorRegistry references for DatasourceDAO (@hughhhh)
- [#20445](https://github.com/apache/superset/pull/20445) refactor: create echarts query section (@zhaoyongjie)
- [#20438](https://github.com/apache/superset/pull/20438) chore: move xaxis to superset-ui (@zhaoyongjie)
- [#20417](https://github.com/apache/superset/pull/20417) test: Skip flaky Cypress test (@codyml)
- [#20264](https://github.com/apache/superset/pull/20264) docs: Added details to Druid connection string (@Neeraj-2307)
- [#20400](https://github.com/apache/superset/pull/20400) docs: Update docs on contributing to docs (@codyml)
- [#20398](https://github.com/apache/superset/pull/20398) docs: add Matomo tracking to docs (@codyml)

### 2.0.1 (Fri Nov 4 10:34:02 2022 -0400)

**Database Migrations**

**Features**

**Fixes**

- [#22417](https://github.com/apache/superset/pull/22417) fix: fix: Force configuration for SafeMarkdown component in Handlebars(@geido)
- [#21895](https://github.com/apache/superset/pull/21895) feat: Improves SafeMarkdown HTML sanitization (@michael-s-molina) (security-improvement)
- [#21874](https://github.com/apache/superset/pull/21874) feat: Adds a Content Security Policy (CSP) check for production environments (@michael-s-molina)(security-improvement)
- [#21853](https://github.com/apache/superset/pull/21853) feat: Disables HTML rendering in Toast by default (@michael-s-molina)(security-improvement)
- [#21776](https://github.com/apache/superset/pull/21776) fix(CustomFrame): Resolves issue #21731 where date range in explore throws runtime error (@eric-briscoe)
- [#21637](https://github.com/apache/superset/pull/21637) fix: respect chart cache timeout setting (@mayurnewase)
- [#21729](https://github.com/apache/superset/pull/21729) fix: allow adhoc columns in non-aggregate query (@mayurnewase)
- [#21441](https://github.com/apache/superset/pull/21441) fix(cache): respect default cache timeout on v1 chart data requests (@villebro)
- [#22038](https://github.com/apache/superset/pull/22038) fix: datasource save, improve data validation (@dpgaspar)
- [#22022](https://github.com/apache/superset/pull/22022) fix: deprecate approve and request_access endpoint (@dpgaspar)
- [#21964](https://github.com/apache/superset/pull/21964) fix: dashboard api cache decorator (@dpgaspar)
- [#21875](https://github.com/apache/superset/pull/21875) fix: check that imports are ZIPs (@betodealmeida)
- [#21761](https://github.com/apache/superset/pull/21761) fix: flash message on database data upload forms (@dpgaspar)
- [#21759](https://github.com/apache/superset/pull/21759) fix: database schema selector on import data (@dpgaspar)
- [#21729](https://github.com/apache/superset/pull/21729) fix: allow adhoc columns in non-aggregate query (@mayurnewase)
- [#21773](https://github.com/apache/superset/pull/21773) fix: remove deprecated ETagResponseMixin (@eschutho)
- [#21561](https://github.com/apache/superset/pull/21561) fix(report): Fix permission check for set up email report on charts/dashboards. Fixes #21559 (@zhaorui2022)
- [#20651](https://github.com/apache/superset/pull/20651) fix: annotation broken (@zhaoyongjie)
- [#20830](https://github.com/apache/superset/pull/20830) fix: remove element reference in alerts report fetchs (@hughhhh)
- [#20063](https://github.com/apache/superset/pull/20063) fix: Add locale for DatePicker component (@aehanno)
- [#21302](https://github.com/apache/superset/pull/21302) fix: disallow users from viewing other user's profile on config (@dpgaspar)
- [#21154](https://github.com/apache/superset/pull/21154) fix(explore): Prevent unnecessary series limit subquery (@codyml)
- [#21498](https://github.com/apache/superset/pull/21498) fix: set correct favicon from config for login and FAB list views (@mayurnewase)
- [#21380](https://github.com/apache/superset/pull/21380) fix(sqllab): Fix cursor alignment in SQL lab editor by avoiding Lucida Console font on Windows (@MichaelHintz)
- [#20061](https://github.com/apache/superset/pull/20061) fix: Add french translation missing (@aehanno)
- [#21044](https://github.com/apache/superset/pull/21044) fix(plugin-chart-echarts): missing value format in mixed timeseries (@justinpark)
- [#21419](https://github.com/apache/superset/pull/21419) fix: cached common bootstrap Revert (#21018) (@dpgaspar)
- [#21296](https://github.com/apache/superset/pull/21296) fix(plugin-chart-echarts): show zero value in tooltip (@villebro)
- [#21294](https://github.com/apache/superset/pull/21294) fix(explore): Time column label not formatted when GENERIC_X_AXES enabled (@kgabryje)
- [#21272](https://github.com/apache/superset/pull/21272) fix: adds TLS certificate validation option for SMTP (@dpgaspar)
- [#21076](https://github.com/apache/superset/pull/21076) fix(celery cache warmup): add auth and use warm_up_cache endpoint (@nytai)
- [#21216](https://github.com/apache/superset/pull/21216) fix(database-list): hide upload file button if no permission (@stephenLYZ)
- [#21153](https://github.com/apache/superset/pull/21153) fix(sqllab): missing zero values while copy-to-clipboard (@justinpark)
- [#21084](https://github.com/apache/superset/pull/21084) fix(native filters): groupby filter issue (@stevetracvc)
- [#21005](https://github.com/apache/superset/pull/21005) fix(plugin-chart-handlebars): Sort-By and Sort-By-Descending control not work (@stephenLYZ)
- [#20969](https://github.com/apache/superset/pull/20969) fix(dashboard): Fix scroll behaviour in DashboardBuilderSidepane (@EugeneTorap)
- [#21007](https://github.com/apache/superset/pull/21007) fix(plugin-chart-echarts): gauge chart enhancements and fixes (@stephenLYZ)
- [#21032](https://github.com/apache/superset/pull/21032) fix(plugin-chart-echarts): invalid total label location for negative values in stacked bar chart (@justinpark)
- [#20962](https://github.com/apache/superset/pull/20962) fix: Explore scrolled down when navigating from dashboard (@kgabryje)
- [#20946](https://github.com/apache/superset/pull/20946) fix(viz): Show zero percent changes in Big Number Viz (@Antonio-RiveroMartnez)
- [#20819](https://github.com/apache/superset/pull/20819) fix: Temporal X Axis values are not properly displayed if the time column has a custom label defined (@diegomedina248)
- [#20736](https://github.com/apache/superset/pull/20736) fix: getting default value in run-server.sh (@zhaoyongjie)
- [#20733](https://github.com/apache/superset/pull/20733) fix(docker): Make Gunicorn max_requests and max_requests_jitter adjustable (@mdeshmu)
- [#20714](https://github.com/apache/superset/pull/20714) fix: logger message (@betodealmeida)

**Others**

- [#21811](https://github.com/apache/superset/pull/21811) chore(sqla): refactor query utils (@villebro)
- [#21811](https://github.com/apache/superset/pull/21811) chore(sqla): refactor query utils (@villebro)
- [#20644](https://github.com/apache/superset/pull/20644) chore(deps): bump moment from 2.29.2 to 2.29.4 in /superset-frontend (@dependabot[bot])
- [#21721](https://github.com/apache/superset/pull/21721) build: changelog for 2.0.1 (@AAfghahi)
- [#21018](https://github.com/apache/superset/pull/21018) perf: Memoize the common_bootstrap_payload (@bkyryliuk)
- [#21091](https://github.com/apache/superset/pull/21091) chore(deps): unpin holidays dependency version (@ecederstrand)

### 2.0.0 (Tue Jun 28 08:53:02 2022 -0400)

**Database Migrations**

- [#20385](https://github.com/apache/superset/pull/20385) fix(migration): Ensure key_value LargeBinary is encoded as a MEDIUMBLOB as opposed to BLOB for MySQL (@john-bodley)
- [#20284](https://github.com/apache/superset/pull/20284) chore(migrations): Renaming migration files so that they're easier to keep track of (@craig-rueda)
- [#20108](https://github.com/apache/superset/pull/20108) fix: None dataset and schema permissions (@dpgaspar)
- [#18794](https://github.com/apache/superset/pull/18794) feat(business-types): initial implementation of SIP-78 (@cccs-RyanS)
- [#20073](https://github.com/apache/superset/pull/20073) fix(dataset): handle missing sqla uri in migration (@villebro)
- [#19941](https://github.com/apache/superset/pull/19941) fix(reports): Clear last value when state is WORKING (@john-bodley)
- [#19675](https://github.com/apache/superset/pull/19675) chore(docs): Spelling (@jsoref)
- [#19793](https://github.com/apache/superset/pull/19793) fix(SIP-68): handle empty table name during migration (@ktmud)
- [#19786](https://github.com/apache/superset/pull/19786) fix(migrations): coalesce is_temporal when inserting into sl_columns (@cemremengu)
- [#19421](https://github.com/apache/superset/pull/19421) perf: refactor SIP-68 db migrations with INSERT SELECT FROM (@ktmud)
- [#19767](https://github.com/apache/superset/pull/19767) fix: Fix migration for removing time_range_endpoints 3 (@hughhhh)
- [#19728](https://github.com/apache/superset/pull/19728) fix: Removetime_range_endpoints from query context object pt 2 (@hughhhh)
- [#19630](https://github.com/apache/superset/pull/19630) chore: clean up unused imports in db migration scripts (@ktmud)
- [#19577](https://github.com/apache/superset/pull/19577) fix: merge multiple db heads (@eschutho)
- [#19243](https://github.com/apache/superset/pull/19243) fix: cannot delete a database if team member has SQL editor tab that uses that db (@diegomedina248)
- [#19537](https://github.com/apache/superset/pull/19537) chore: block unsafe functions (@betodealmeida)
- [#19513](https://github.com/apache/superset/pull/19513) chore: postpone timerange endpoint removal (@villebro)
- [#19495](https://github.com/apache/superset/pull/19495) perf: speed up db migration for deprecating time_range_endpoints (@ktmud)
- [#19474](https://github.com/apache/superset/pull/19474) fix: handle null params in #18936 migration (@serenajiang)
- [#19423](https://github.com/apache/superset/pull/19423) fix: Remove`time_range_endpoints` from query context object (@hughhhh)
- [#18936](https://github.com/apache/superset/pull/18936) chore: Remove legacy SIP-15 interim logic/flags (@john-bodley)

**Features**

- [#20377](https://github.com/apache/superset/pull/20377) feat(standardized form data): keep all columns and metrics (@zhaoyongjie)
- [#20114](https://github.com/apache/superset/pull/20114) feat(chart): Enable caching per user when user impersonation is enabled (@Samira-El)
- [#20408](https://github.com/apache/superset/pull/20408) feat(plugin-chart-echarts): Support stacking negative and positive values (@kgabryje)
- [#20278](https://github.com/apache/superset/pull/20278) feat: Prevent dataset edit modal closing on click-away in edit mode (@reesercollins)
- [#20392](https://github.com/apache/superset/pull/20392) feat: setting limit value when Pie chart switches (@zhaoyongjie)
- [#20373](https://github.com/apache/superset/pull/20373) feat: adding truncate metric control on timeseries charts (@zhaoyongjie)
- [#20248](https://github.com/apache/superset/pull/20248) feat(explore): Implement viz switcher redesign (@kgabryje)
- [#20113](https://github.com/apache/superset/pull/20113) feat(api): Added "kind" to dataset/<pk> endpoint (@reesercollins)
- [#20299](https://github.com/apache/superset/pull/20299) feat(explore): Dataset Panel Options when Source = Query II (@lyndsiWilliams)
- [#20320](https://github.com/apache/superset/pull/20320) feat: Databricks native driver (@betodealmeida)
- [#20313](https://github.com/apache/superset/pull/20313) feat(explore): Denormalize form data in echarts, world map and nvd3 bar and line charts (@kgabryje)
- [#20277](https://github.com/apache/superset/pull/20277) feat: multiple results pane on explore and dashboard (@zhaoyongjie)
- [#19898](https://github.com/apache/superset/pull/19898) feat: When editing the label/title in the Metrics popover, hitting Enter should save what you've typed (@diegomedina248)
- [#16493](https://github.com/apache/superset/pull/16493) feat(plugin-chart-echarts): [feature-parity] support extra control for the area chart V2 (@stephenLYZ)
- [#19855](https://github.com/apache/superset/pull/19855) feat(explore): Frontend implementation of dataset creation from infobox (@lyndsiWilliams)
- [#20165](https://github.com/apache/superset/pull/20165) feat: add modfied col and timezone info to schedule col (@pkdotson)
- [#20144](https://github.com/apache/superset/pull/20144) feat: showing results pane in dashboard (@zhaoyongjie)
- [#20242](https://github.com/apache/superset/pull/20242) feat: derived metrics use different line style (@zhaoyongjie)
- [#20010](https://github.com/apache/superset/pull/20010) feat: standardized form_data (@zhaoyongjie)
- [#19987](https://github.com/apache/superset/pull/19987) feat(superset-ui-core): add feature flag for the analogous colors (@stephenLYZ)
- [#19881](https://github.com/apache/superset/pull/19881) feat(world-map): support color by metric or country column (@stephenLYZ)
- [#19981](https://github.com/apache/superset/pull/19981) feat!: pass datasource_type and datasource_id to form_data (@eschutho)
- [#15241](https://github.com/apache/superset/pull/15241) feat: query datasets from SQL Lab (@betodealmeida)
- [#20129](https://github.com/apache/superset/pull/20129) feat(explore): Fill dashboard name when adding new chart from dashboard view (@kgabryje)
- [#20160](https://github.com/apache/superset/pull/20160) feat(explore): Add empty state to annotations (@kgabryje)
- [#20134](https://github.com/apache/superset/pull/20134) feat: add Query.columns for bootstrap_data (@hughhhh)
- [#20158](https://github.com/apache/superset/pull/20158) feat: add statsd metrics for notifications (@dpgaspar)
- [#20052](https://github.com/apache/superset/pull/20052) feat(Helm Chart): Support resource limits and requests for each component (@rathberm)
- [#20170](https://github.com/apache/superset/pull/20170) feat: add samples endpoint (@zhaoyongjie)
- [#19381](https://github.com/apache/superset/pull/19381) feat: add drag and drop column rearrangement for table viz (@stevetracvc)
- [#20136](https://github.com/apache/superset/pull/20136) feat: Add Certified filter to Datasets (@hughhhh)
- [#20111](https://github.com/apache/superset/pull/20111) feat(dashboard): Chart title click redirects to Explore in new tab (@kgabryje)
- [#20097](https://github.com/apache/superset/pull/20097) feat(plugin-chart-echarts): add support for generic axis to mixed chart (@villebro)
- [#20126](https://github.com/apache/superset/pull/20126) feat(dashboard): Add create chart button in dashboard edit mode (@kgabryje)
- [#20059](https://github.com/apache/superset/pull/20059) feat: Save column data into json_metadata for all Query executions (@hughhhh)
- [#19918](https://github.com/apache/superset/pull/19918) feat(plugin-chart-echarts): support horizontal bar chart (@stephenLYZ)
- [#19902](https://github.com/apache/superset/pull/19902) feat: Explore popovers should close on escape (@diegomedina248)
- [#20049](https://github.com/apache/superset/pull/20049) feat(dashboard): Rearrange items in chart header controls dropdown (@kgabryje)
- [#20030](https://github.com/apache/superset/pull/20030) feat(sip-68): Add DatasourceDAO class to manage querying different datasources easier (@hughhhh)
- [#19581](https://github.com/apache/superset/pull/19581) feat(viz-gallery): add search weight for viz-name (@stephenLYZ)
- [#19999](https://github.com/apache/superset/pull/19999) feat: RLS for SQL Lab (@betodealmeida)
- [#19993](https://github.com/apache/superset/pull/19993) feat(explore): Show confirmation modal if user exits Explore without saving changes (@kgabryje)
- [#19873](https://github.com/apache/superset/pull/19873) feat(css): adds `chartId`-based class to dashboard chart holder (@rusackas)
- [#20002](https://github.com/apache/superset/pull/20002) feat: deprecate /superset/testconn and migrate to api v1 (@zephyring)
- [#19935](https://github.com/apache/superset/pull/19935) feat: deprecate /superset/validate_sql_json migrate to api v1 (@dpgaspar)
- [#20015](https://github.com/apache/superset/pull/20015) feat: add new enums for datasource types (@hughhhh)
- [#19956](https://github.com/apache/superset/pull/19956) feat: Applitools Cypress workflow (@geido)
- [#19852](https://github.com/apache/superset/pull/19852) feat: Run Applitools on public Storybook (@geido)
- [#19963](https://github.com/apache/superset/pull/19963) feat: Add cypress test for downloading chart as image (@codemaster08240328)
- [#19957](https://github.com/apache/superset/pull/19957) feat: switch from `sqlalchemy-trino` to `trino-python-client` (@dungdm93)
- [#19921](https://github.com/apache/superset/pull/19921) feat: deprecate /superset/extra_table_metadata migrate to api v1 (@dpgaspar)
- [#19745](https://github.com/apache/superset/pull/19745) feat: simplify SQLite time grain (@betodealmeida)
- [#19927](https://github.com/apache/superset/pull/19927) feat(chart & legend): make to enable show legend by default (@prosdev0107)
- [#19754](https://github.com/apache/superset/pull/19754) feat: deprecate old API on core superset fave_dashboards (@dpgaspar)
- [#19905](https://github.com/apache/superset/pull/19905) feat: simplify `memoized_func` (@betodealmeida)
- [#19871](https://github.com/apache/superset/pull/19871) feat(filter): make to hide sort filter when time range (@prosdev0107)
- [#19851](https://github.com/apache/superset/pull/19851) feat: add Advanced Analytics into mixed time series chart (@zhaoyongjie)
- [#19692](https://github.com/apache/superset/pull/19692) feat: Update ShortKey for stop query running in SqlLab editor (@codemaster08240328)
- [#17903](https://github.com/apache/superset/pull/17903) feat: Adds plugin-chart-handlebars (@jdbranham)
- [#19748](https://github.com/apache/superset/pull/19748) feat(explore): improve UI in the control panel (@stephenLYZ)
- [#19724](https://github.com/apache/superset/pull/19724) feat: 10/15/30 min grain to Pinot (@hughhhh)
- [#19696](https://github.com/apache/superset/pull/19696) feat(explore): Replace overlay with alert banner when chart controls change (@kgabryje)
- [#19751](https://github.com/apache/superset/pull/19751) feat(explore): Implement data panel redesign (@kgabryje)
- [#19598](https://github.com/apache/superset/pull/19598) feat: add empty states to sqlab editor and select (@pkdotson)
- [#19450](https://github.com/apache/superset/pull/19450) feat: Remove legacy sql alchemy db connection link from G Sheet connection (@codemaster08240328)
- [#19710](https://github.com/apache/superset/pull/19710) feat: Enabling source maps full time (@rusackas)
- [#19671](https://github.com/apache/superset/pull/19671) feat: UI override registry (@suddjian)
- [#19691](https://github.com/apache/superset/pull/19691) feat(explore): More explicit labels of adhoc filter operators (@kgabryje)
- [#19558](https://github.com/apache/superset/pull/19558) feat(explore): Redesign of Run/Save buttons (@kgabryje)
- [#19650](https://github.com/apache/superset/pull/19650) feat(embedded): API get embedded dashboard config by uuid (@lilykuang)
- [#19310](https://github.com/apache/superset/pull/19310) feat(CRUD): add new empty state (@stephenLYZ)
- [#19622](https://github.com/apache/superset/pull/19622) feat(plugin-chart-echarts): add aggregate total for the Pie/Donuct chart (@stephenLYZ)
- [#19314](https://github.com/apache/superset/pull/19314) feat: Move Database Import option into DB Connection modal (@lyndsiWilliams)
- [#19434](https://github.com/apache/superset/pull/19434) feat: deprecate old API and create new API for dashes created by me (@dpgaspar)
- [#19482](https://github.com/apache/superset/pull/19482) feat: add success toast to alerts and reports (@pkdotson)
- [#19574](https://github.com/apache/superset/pull/19574) feat: add a `where_in` filter for Jinja2 (@betodealmeida)
- [#19458](https://github.com/apache/superset/pull/19458) feat(explore): Move timer, row counter and cached pills to chart container (@kgabryje)
- [#19529](https://github.com/apache/superset/pull/19529) feat(explore): Move chart header to top of the page (@kgabryje)
- [#19489](https://github.com/apache/superset/pull/19489) feat(CI): clean up Python tests output (@ktmud)
- [#19308](https://github.com/apache/superset/pull/19308) feat(explore): SQL popover in datasource panel (@kgabryje)
- [#19325](https://github.com/apache/superset/pull/19325) feat(color): support analogous colors to prevent color conflict (@stephenLYZ)
- [#19408](https://github.com/apache/superset/pull/19408) feat(dashboard): Implement empty states for empty tabs (@kgabryje)
- [#19446](https://github.com/apache/superset/pull/19446) feat(explore): Move chart actions into dropdown (@kgabryje)
- [#19394](https://github.com/apache/superset/pull/19394) feat(explore): UI changes in dataset panel on Explore page (@kgabryje)

**Fixes**

- [#20382](https://github.com/apache/superset/pull/20382) fix: Allow dataset owners to explore their datasets (@reesercollins)
- [#20419](https://github.com/apache/superset/pull/20419) fix(embedded): Retry when executing alert queries to avoid sending transient errors to users as alert failure notifications (@zhaorui2022)
- [#20555](https://github.com/apache/superset/pull/20555) fix: Respecting max/min opacities, and adding tests. (@rusackas)
- [#20571](https://github.com/apache/superset/pull/20571) fix: Revert #20408 (stacking negative values in echarts bar chart) (@rusackas)
- [#20487](https://github.com/apache/superset/pull/20487) fix(database-modal): form in database model effects results of the database list (@stephenLYZ)
- [#20488](https://github.com/apache/superset/pull/20488) fix(big-number): big number gets cut off on a Dashboard (@stephenLYZ)
- [#16326](https://github.com/apache/superset/pull/16326) fix: SQL Lab cancel query in Redshift database connection does not wo… (@yourssvk)
- [#20362](https://github.com/apache/superset/pull/20362) fix: Unable to download the Dashboard as image in case there's an image added through Markdown (@diegomedina248)
- [#20543](https://github.com/apache/superset/pull/20543) fix: Removes psycopg2 as a required dependency
- [#20442](https://github.com/apache/superset/pull/20442) fix(db): Show the only db install guide when the db is already installed and error is existed while importing file. (@prosdev0107)
- [#20483](https://github.com/apache/superset/pull/20483) fix: bump FAB to 4.1.2 (@dpgaspar)
- [#20493](https://github.com/apache/superset/pull/20493) fix: correction from mmsql to mssql in setup.py (@mdeshmu)
- [#20460](https://github.com/apache/superset/pull/20460) fix: new column UUID conflicts in dual write (@eschutho)
- [#20485](https://github.com/apache/superset/pull/20485) fix: Re-add filter-box time granularity/column (@john-bodley)
- [#20480](https://github.com/apache/superset/pull/20480) fix(docs): prevent some symbols from being copied in docs (@stephenLYZ)
- [#19920](https://github.com/apache/superset/pull/19920) fix(table viz): correctly sort by multiple columns in a table (@stevetracvc)
- [#20402](https://github.com/apache/superset/pull/20402) fix: alert & reports active toggle optimistic update (@diegomedina248)
- [#20472](https://github.com/apache/superset/pull/20472) fix: Changes the return type of get_permissions to be JSON friendly (@michael-s-molina)
- [#20468](https://github.com/apache/superset/pull/20468) fix: async queries limit bug (@AAfghahi)
- [#20257](https://github.com/apache/superset/pull/20257) fix(home): Show home page tabs as pills instead of links (@prosdev0107)
- [#20340](https://github.com/apache/superset/pull/20340) fix: ensure column name in description is string (@betodealmeida)
- [#20350](https://github.com/apache/superset/pull/20350) fix(viz): BigQuery time grain 'minute'/'second' throws an error (@diegomedina248)
- [#20384](https://github.com/apache/superset/pull/20384) fix(chart & table): Prevent the dates from wrapping in table chart (@prosdev0107)
- [#20404](https://github.com/apache/superset/pull/20404) fix: suppress translation warning in jest (@zhaoyongjie)
- [#20451](https://github.com/apache/superset/pull/20451) fix: should raise exception when apply a categorical axis (@zhaoyongjie)
- [#20447](https://github.com/apache/superset/pull/20447) fix: table viz sort icon bottom aligned (@diegomedina248)
- [#20326](https://github.com/apache/superset/pull/20326) fix(fbprophet): Fix weekly frequencies (@john-bodley)
- [#20434](https://github.com/apache/superset/pull/20434) fix(20428): Address-Presto/Trino-Poll-Issue-Refactor (@Thelin90)
- [#20411](https://github.com/apache/superset/pull/20411) fix(dashboard): new created chart did not have high lighted effect when using the permalink of chart share in dashboard (@diegomedina248)
- [#20261](https://github.com/apache/superset/pull/20261) fix(embedded): CSV download for chart (@lilykuang)
- [#20276](https://github.com/apache/superset/pull/20276) fix(cosmetic): cannot find m-r-10 class in superset.less (@Renderz)
- [#20420](https://github.com/apache/superset/pull/20420) fix: rm eslint-plugin-translation-vars engines requirement (@stephenLYZ)
- [#20409](https://github.com/apache/superset/pull/20409) fix(bar-chart-v2): remove marker control from bar chart V2 (@stephenLYZ)
- [#20333](https://github.com/apache/superset/pull/20333) fix(presto): use milliseconds timespec for presto (@mohittt8)
- [#20414](https://github.com/apache/superset/pull/20414) fix: key error on permalink fetch for old permalinks (@eschutho)
- [#20410](https://github.com/apache/superset/pull/20410) fix: Adding extra metrics issue after chart configuration (@codemaster08240328)
- [#20405](https://github.com/apache/superset/pull/20405) fix: Incorrect translations in Chinese in messages.po (@chuancyzhang)
- [#20396](https://github.com/apache/superset/pull/20396) fix(plugin-chart-pivot-table): color weight of Conditional formatting metrics not work (@stephenLYZ)
- [#20361](https://github.com/apache/superset/pull/20361) fix(fonts): Show the all the A's in our workspace correctly, not funky (@prosdev0107)
- [#20383](https://github.com/apache/superset/pull/20383) fix: Unable to export multiple Dashboards with the same name (@diegomedina248)
- [#20363](https://github.com/apache/superset/pull/20363) fix: A newly connected database doesn't appear in the databases list if user connected database using the 'plus' button (@diegomedina248)
- [#20372](https://github.com/apache/superset/pull/20372) fix: update connection modal to use existing catalog (@pkdotson)
- [#20368](https://github.com/apache/superset/pull/20368) fix(VERSIONED_EXPORTS): Ensure dashboards and charts adhere to the VERSIONED_EXPORTS feature flag (@john-bodley)
- [#20351](https://github.com/apache/superset/pull/20351) fix: catch some potential errors on dual write (@eschutho)
- [#20364](https://github.com/apache/superset/pull/20364) fix: query execution time is not fully displayed in bubble icon (@diegomedina248)
- [#20365](https://github.com/apache/superset/pull/20365) fix: Fix typo in Error handling message (@codemaster08240328)
- [#19967](https://github.com/apache/superset/pull/19967) fix: A newly connected database doesn't appear in the databases list if user connected database using the 'plus' button (@diegomedina248)
- [#20348](https://github.com/apache/superset/pull/20348) fix(docker): Make Gunicorn Keepalive Adjustable (@mdeshmu)
- [#19670](https://github.com/apache/superset/pull/19670) fix: Add serviceAccountName to celerybeat pods (@paulinjo)
- [#20315](https://github.com/apache/superset/pull/20315) fix(chart): chart gets cut off on the dashboard (@stephenLYZ)
- [#20324](https://github.com/apache/superset/pull/20324) fix: superset-ui/core coverage (@zhaoyongjie)
- [#20282](https://github.com/apache/superset/pull/20282) fix(explore): Make that see more/see less works correctly with scrolling when error msg is long text. (@prosdev0107)
- [#20296](https://github.com/apache/superset/pull/20296) fix: Alpha are unable to perform a second modification to a Dataset when in Explore (@hughhhh)
- [#20290](https://github.com/apache/superset/pull/20290) fix: Faulty datetime parser regex (@reesercollins)
- [#19761](https://github.com/apache/superset/pull/19761) fix(plugin-chart-echarts): [feature-parity] apply button of annotation layer doesn't work as expected (@stephenLYZ)
- [#20263](https://github.com/apache/superset/pull/20263) fix(embedded): accessing variable response before initialization (@zhaorui2022)
- [#20274](https://github.com/apache/superset/pull/20274) fix(codecov): improve core code coverage (@stephenLYZ)
- [#20187](https://github.com/apache/superset/pull/20187) fix: Database import with cancel_query.. extra field (@codemaster08240328)
- [#20237](https://github.com/apache/superset/pull/20237) fix(cosmetic): Fix Datasource Modal Out Of Box (@Renderz)
- [#20058](https://github.com/apache/superset/pull/20058) fix: Support the Clipboard API in modern browsers (@diegomedina248)
- [#20164](https://github.com/apache/superset/pull/20164) fix(sql lab): View result button is not showing consistently (@diegomedina248)
- [#20171](https://github.com/apache/superset/pull/20171) fix(charts list): do not trigger ListViewError exception for anonymous user (@trepmag)
- [#20178](https://github.com/apache/superset/pull/20178) fix: While exporting CSV , only the entries on first page are getting downloaded even when user is on other pages #17861 (@LahmerIlyas)
- [#20204](https://github.com/apache/superset/pull/20204) fix: Fixes issue where results panel height was incorrect [sc-49045] (@eric-briscoe)
- [#20235](https://github.com/apache/superset/pull/20235) fix: Box Plot Chart throws an error when the average (AVG) / SUM is being calculated on the Metrics (@diegomedina248)
- [#20088](https://github.com/apache/superset/pull/20088) fix: datatype tracking issue on virtual dataset (@codemaster08240328)
- [#20220](https://github.com/apache/superset/pull/20220) fix: dashbaord unable to refresh (@zhaoyongjie)
- [#20228](https://github.com/apache/superset/pull/20228) fix: failed samples should throw exception (@zhaoyongjie)
- [#20203](https://github.com/apache/superset/pull/20203) fix: move columns to datasource object for bootstrap data (@hughhhh)
- [#20151](https://github.com/apache/superset/pull/20151) fix(csv): Ensure df_to_escaped_csv does not coerce integer columns to float (@john-bodley)
- [#20221](https://github.com/apache/superset/pull/20221) fix(legacy-plugin-chart-sunburst): linear color scheme not work when secondary metric is provided (@stephenLYZ)
- [#20223](https://github.com/apache/superset/pull/20223) fix(legacy-plugin-chart-sunburst): chart broken when secondary metric is removed (@stephenLYZ)
- [#20147](https://github.com/apache/superset/pull/20147) fix(cosmetic): Limiting modal height (@rusackas)
- [#20206](https://github.com/apache/superset/pull/20206) fix(sql lab): SQL Lab Compile Query Delay (@diegomedina248)
- [#20201](https://github.com/apache/superset/pull/20201) fix: unable to set destroyOnClose on ModalTrigger (@zhaoyongjie)
- [#20186](https://github.com/apache/superset/pull/20186) fix(db): make to allow to show/hide the password when only creating (@prosdev0107)
- [#20127](https://github.com/apache/superset/pull/20127) fix(database): retrival of tables and views from schema for exasol backend (@Nicoretti)
- [#19899](https://github.com/apache/superset/pull/19899) fix: always create parameter json field (@pkdotson)
- [#20173](https://github.com/apache/superset/pull/20173) fix: avoid while cycle in computeMaxFontSize for big Number run forever when css rule applied (@diegomedina248)
- [#20086](https://github.com/apache/superset/pull/20086) fix(css): transparent linear gradient not working in safari (@stephenLYZ)
- [#19102](https://github.com/apache/superset/pull/19102) fix: string aggregation is incorrect in PivotTableV2 (@diegomedina248)
- [#20011](https://github.com/apache/superset/pull/20011) fix(chart & heatmap): make to fix that y label is rendering out of bounds (@prosdev0107)
- [#20142](https://github.com/apache/superset/pull/20142) fix(explore): handle null control sections (@villebro)
- [#20128](https://github.com/apache/superset/pull/20128) fix: advanced data type API spec and permission name (@dpgaspar)
- [#20107](https://github.com/apache/superset/pull/20107) fix(generic-chart-axes): set x-axis if unset and ff is enabled (@villebro)
- [#20018](https://github.com/apache/superset/pull/20018) fix(modal): add primary button loading state to modals (@kgopal492)
- [#20099](https://github.com/apache/superset/pull/20099) fix: Add cypress test for report page direct link issue (@codemaster08240328)
- [#20068](https://github.com/apache/superset/pull/20068) fix: dbmodal test connection error timeout (@pkdotson)
- [#20092](https://github.com/apache/superset/pull/20092) fix: Revert "feat(explore): Show confirmation modal if user exits Explore without saving changes (#19993) (@kgabryje)
- [#19939](https://github.com/apache/superset/pull/19939) fix(chart & alert): make to show metrics properly (@prosdev0107)
- [#20085](https://github.com/apache/superset/pull/20085) fix: typo in `importexport/api.py` OpenAPI (@betodealmeida)
- [#20051](https://github.com/apache/superset/pull/20051) fix(CRUD): make to fix the dancing when crud view is on hover (@prosdev0107)
- [#20064](https://github.com/apache/superset/pull/20064) fix(chart & gallery): make to add mixed time-series into recommended charts (@prosdev0107)
- [#20013](https://github.com/apache/superset/pull/20013) fix: The dynamic form to connect to Snowflake DB is not returning any errors (@diegomedina248)
- [#20029](https://github.com/apache/superset/pull/20029) fix(plugin-chart-echarts): tooltip of big number truncated at then bottom (@stephenLYZ)
- [#19914](https://github.com/apache/superset/pull/19914) fix: Refactor SQL engine username logic (@john-bodley)
- [#20050](https://github.com/apache/superset/pull/20050) fix: Fixes Tabs style (@michael-s-molina)
- [#20048](https://github.com/apache/superset/pull/20048) fix(homepage): make to show indicator when tab is chosen (@prosdev0107)
- [#20026](https://github.com/apache/superset/pull/20026) fix(chart & filters): make to padding between textarea and buttons (@prosdev0107)
- [#20019](https://github.com/apache/superset/pull/20019) fix(embedded): third party cookies (@lilykuang)
- [#20033](https://github.com/apache/superset/pull/20033) fix: Direct Linking issue on report list: 404 status code. (@codemaster08240328)
- [#19977](https://github.com/apache/superset/pull/19977) fix(word-cloud): fix randomness of each word's rotation (@ebaratte)
- [#20021](https://github.com/apache/superset/pull/20021) fix: native filter truncation rerendering loop on hover (@diegomedina248)
- [#20004](https://github.com/apache/superset/pull/20004) fix: URI form is blank when trying to connect from sql lab (@diegomedina248)
- [#19841](https://github.com/apache/superset/pull/19841) fix: Table chart column config issue (@codemaster08240328)
- [#19877](https://github.com/apache/superset/pull/19877) fix: Making chart update more truthful (@Gwitchr)
- [#19996](https://github.com/apache/superset/pull/19996) fix: Use pull_request_target in Cypress Applitools workflow (@geido)
- [#19972](https://github.com/apache/superset/pull/19972) fix: revert chore(deps): bump d3-svg-legend in /superset-frontend (#19846) (@villebro)
- [#19889](https://github.com/apache/superset/pull/19889) fix: Fix auto-reversion of label/title in the Metrics popover (@diegomedina248)
- [#19903](https://github.com/apache/superset/pull/19903) fix(explore): Explore data table tooltip (@Gwitchr)
- [#19938](https://github.com/apache/superset/pull/19938) fix(chart & table): make to allow highlight in case of numeric column (@prosdev0107)
- [#19839](https://github.com/apache/superset/pull/19839) fix(dashboard): allow users to resize the markdown widget easier (@cccs-Dustin)
- [#19887](https://github.com/apache/superset/pull/19887) fix(hive): Workaround for Python 3.9 s3 transfer issue (@john-bodley)
- [#19936](https://github.com/apache/superset/pull/19936) fix: OpenAPI docs small fixes (@dpgaspar)
- [#19932](https://github.com/apache/superset/pull/19932) fix: can not correctly set force in store (@zhaoyongjie)
- [#19930](https://github.com/apache/superset/pull/19930) fix: memoize primitives (@betodealmeida)
- [#19926](https://github.com/apache/superset/pull/19926) fix(dataset): DAO update (@betodealmeida)
- [#19826](https://github.com/apache/superset/pull/19826) fix: Missing `f` prefix on f-strings (@code-review-doctor)
- [#18988](https://github.com/apache/superset/pull/18988) fix(column-header-tooltip): make that hide the tooltip when the cloum… (@prosdev0107)
- [#19782](https://github.com/apache/superset/pull/19782) fix: chart import error with virtual dataset (@codemaster08240328)
- [#19485](https://github.com/apache/superset/pull/19485) fix: Set fixed maxWidth of the cron schedule modal (@codemaster08240328)
- [#19885](https://github.com/apache/superset/pull/19885) fix: Chart download as image issue (@codemaster08240328)
- [#19883](https://github.com/apache/superset/pull/19883) fix(allow-db-explore): make to check the allow virtual table explore option by default (@prosdev0107)
- [#19835](https://github.com/apache/superset/pull/19835) fix(helm): fix postgresql values (@benjamin-texier)
- [#19758](https://github.com/apache/superset/pull/19758) fix(plugin-chart-echarts): [feature parity] annotation line chart color does not work (@stephenLYZ)
- [#19879](https://github.com/apache/superset/pull/19879) fix(plugin-chart-handlebars): fix overflow, debounce and control reset (@villebro)
- [#19668](https://github.com/apache/superset/pull/19668) fix: Dates alignment in Table viz (@geido)
- [#19876](https://github.com/apache/superset/pull/19876) fix: Cannot re-order metrics by drag and drop (@diegomedina248)
- [#19840](https://github.com/apache/superset/pull/19840) fix(dashboard-css): make to load saved css template (@prosdev0107)
- [#19859](https://github.com/apache/superset/pull/19859) fix: Dashboard report creation error handling (@etr2460)
- [#19857](https://github.com/apache/superset/pull/19857) fix: Update eslint error message to reflect location of antd components (@etr2460)
- [#19605](https://github.com/apache/superset/pull/19605) fix: Query execution time is displayed as invalid date (@diegomedina248)
- [#19694](https://github.com/apache/superset/pull/19694) fix(db & connection): make to show/hide the password when only creating db connection (@prosdev0107)
- [#19778](https://github.com/apache/superset/pull/19778) fix: deck.gl GeoJsonLayer Autozoom & fill/stroke options (@diegomedina248)
- [#19850](https://github.com/apache/superset/pull/19850) fix: Regression on Data and Alerts & Reports Headers (@diegomedina248)
- [#19842](https://github.com/apache/superset/pull/19842) fix: count(distinct column_name) in metrics (@zhaoyongjie)
- [#19843](https://github.com/apache/superset/pull/19843) fix(explore): ignore temporary controls in altered pill (@villebro)
- [#19800](https://github.com/apache/superset/pull/19800) fix: Cypress tests reliability improvements (@diegomedina248)
- [#19575](https://github.com/apache/superset/pull/19575) fix: Show full long number in text email report for table chart. (@codemaster08240328)
- [#19429](https://github.com/apache/superset/pull/19429) fix(dashboard): make to filter the correct certified or non-certified… (@prosdev0107)
- [#13082](https://github.com/apache/superset/pull/13082) fix(sql_lab): Add custom timestamp type for literal casting for presto timestamps (@kekwan)
- [#19797](https://github.com/apache/superset/pull/19797) fix: add missing init files (@suddjian)
- [#19672](https://github.com/apache/superset/pull/19672) fix: trap SQLAlchemy common exceptions & throw 422 error instead (@diegomedina248)
- [#19288](https://github.com/apache/superset/pull/19288) fix: AlertReportCronScheduler tests (@diegomedina248)
- [#19781](https://github.com/apache/superset/pull/19781) fix(world-map): remove categorical color control (@serenajiang)
- [#19792](https://github.com/apache/superset/pull/19792) fix(plugin-chart-table): Resetting controls when switching query mode (@kgabryje)
- [#19755](https://github.com/apache/superset/pull/19755) fix: small cleanup for created by me dashboards API (@dpgaspar)
- [#19784](https://github.com/apache/superset/pull/19784) fix(readme): Remove broken link to legacy gallery (@drluckyspin)
- [#19722](https://github.com/apache/superset/pull/19722) fix: dashboard top level tabs edit (@diegomedina248)
- [#19777](https://github.com/apache/superset/pull/19777) fix(explore): Double divider if no permissions for adding reports (@kgabryje)
- [#19673](https://github.com/apache/superset/pull/19673) fix(import): Add the error alert on failed database import (@prosdev0107)
- [#19518](https://github.com/apache/superset/pull/19518) fix: alert/report created by filter inconsistency with table display (@diegomedina248)
- [#19700](https://github.com/apache/superset/pull/19700) fix: remove expose (@AAfghahi)
- [#19626](https://github.com/apache/superset/pull/19626) fix: deactivate embedding on a dashboard (@suddjian)
- [#19472](https://github.com/apache/superset/pull/19472) fix: Dashboard Edit View Tab Headers Hidden when Dashboard Name is Long (@diegomedina248)
- [#19311](https://github.com/apache/superset/pull/19311) fix(sql lab): add quotes when autocompleting table names with spaces in the editor (@diegomedina248)
- [#19290](https://github.com/apache/superset/pull/19290) fix(sql lab): select edit on query from history doesn't upload editor properly (@diegomedina248)
- [#19420](https://github.com/apache/superset/pull/19420) fix: sql lab ctrl t behaved differently from clicking (@Gwitchr)
- [#19357](https://github.com/apache/superset/pull/19357) fix: Redirect to full url on 401 (@geido)
- [#19001](https://github.com/apache/superset/pull/19001) fix: Line Chart Annotation Info Update (@codemaster08240328)
- [#19714](https://github.com/apache/superset/pull/19714) fix: create virtual table with exotic type (@villebro)
- [#19708](https://github.com/apache/superset/pull/19708) fix(nav): infinite redirect and upload dataset nav permissions (@ktmud)
- [#19430](https://github.com/apache/superset/pull/19430) fix(data-upload): make to change err message (@prosdev0107)
- [#19419](https://github.com/apache/superset/pull/19419) fix(alert & report): make to fix the issue when recreate report (@prosdev0107)
- [#19371](https://github.com/apache/superset/pull/19371) fix: Reset sorting bar issue in Barchart (@codemaster08240328)
- [#19362](https://github.com/apache/superset/pull/19362) fix(sql lab): display the 'View Results' button consistently in the history tab on sync mode (@diegomedina248)
- [#19294](https://github.com/apache/superset/pull/19294) fix: improve alerts & reports modal on small devices (@diegomedina248)
- [#19257](https://github.com/apache/superset/pull/19257) fix(sql lab): table selector should display all the selected tables (@diegomedina248)
- [#19686](https://github.com/apache/superset/pull/19686) fix(plugin-chart-echarts): xAxis scale is not correct when time grain is quarter (@stephenLYZ)
- [#19646](https://github.com/apache/superset/pull/19646) fix(explore): Change copy of cross filters checkbox (@kgabryje)
- [#19586](https://github.com/apache/superset/pull/19586) fix: Navbar styles and Welcome page text (@geido)
- [#19662](https://github.com/apache/superset/pull/19662) fix(database-api): allow search for all columns (@villebro)
- [#19656](https://github.com/apache/superset/pull/19656) fix: allow_browser_login in import/export API (@betodealmeida)
- [#19628](https://github.com/apache/superset/pull/19628) fix: Table Autosizing Has Unnecessary Horizontal Scroll Bars (@diegomedina248)
- [#19573](https://github.com/apache/superset/pull/19573) fix(chart & polygon): make to fix the issue the polygon chart (@prosdev0107)
- [#19051](https://github.com/apache/superset/pull/19051) fix: update Permissions for right nav (@AAfghahi)
- [#19625](https://github.com/apache/superset/pull/19625) fix(test): make test_clean_requests_after_schema_grant more idempotent (@ktmud)
- [#19571](https://github.com/apache/superset/pull/19571) fix: Catch literal colors when theme top level (@geido)
- [#19594](https://github.com/apache/superset/pull/19594) fix: spelling of following (@lzm0)
- [#19569](https://github.com/apache/superset/pull/19569) fix: check type of url before performing string actions (@eschutho)
- [#19570](https://github.com/apache/superset/pull/19570) fix: sqloxide optional (@betodealmeida)
- [#19397](https://github.com/apache/superset/pull/19397) fix: weight tooltip issue (@codemaster08240328)
- [#19313](https://github.com/apache/superset/pull/19313) fix(sql lab): increase the size of the action icons in the history tab (@diegomedina248)
- [#19039](https://github.com/apache/superset/pull/19039) fix(explore): clean data when hidding control (@stephenLYZ)
- [#19444](https://github.com/apache/superset/pull/19444) fix: Error Message is cut off in alerts & reports log page (@codemaster08240328)
- [#19312](https://github.com/apache/superset/pull/19312) fix: adaptive formatting typo in explore dropdowns (@diegomedina248)
- [#19534](https://github.com/apache/superset/pull/19534) fix(explore): Chart header icon paddings (@kgabryje)
- [#19399](https://github.com/apache/superset/pull/19399) fix: native filter dropdown not attached to parent node (@diegomedina248)
- [#19112](https://github.com/apache/superset/pull/19112) fix: Dashboard import holding issue (@codemaster08240328)
- [#19342](https://github.com/apache/superset/pull/19342) fix: Clean up custom css when dashboard unmounted (@codemaster08240328)
- [#19491](https://github.com/apache/superset/pull/19491) fix: Dynamic form to connect to Snowflake DB is not displaying authentication errors (@diegomedina248)
- [#19528](https://github.com/apache/superset/pull/19528) fix: Correct Ukraine map (@wacken89)
- [#19522](https://github.com/apache/superset/pull/19522) fix: add back view for report reload error (@pkdotson)
- [#19519](https://github.com/apache/superset/pull/19519) fix: GSheets rendering from global nav (@hughhhh)
- [#19358](https://github.com/apache/superset/pull/19358) fix(sqllab): make to hide the delete button of most recent query history (@prosdev0107)
- [#19307](https://github.com/apache/superset/pull/19307) fix: Logo resizing on page load (@geido)
- [#19166](https://github.com/apache/superset/pull/19166) fix: time filter should be [start, end) (@zhaoyongjie)

**Others**

- [#20620](https://github.com/apache/superset/pull/20620) docs: fix link for Apache Superset source code (@dpgaspar)
- [#20621](https://github.com/apache/superset/pull/20621) chore: bump FAB to 4.1.3 (@dpgaspar)
- [#20486](https://github.com/apache/superset/pull/20486) chore: Updated copy in chart drop down to "View as table" (@lauderbaugh)
- [#20116](https://github.com/apache/superset/pull/20116) style(typo): occured -> occurred (@sfirke)
- [#20401](https://github.com/apache/superset/pull/20401) chore: add action to welcome new users (@eschutho)
- [#20269](https://github.com/apache/superset/pull/20269) chore(docs): Remove cache warming documentation (@ajwhite)
- [#20194](https://github.com/apache/superset/pull/20194) chore: Removes unused vars (@michael-s-molina)
- [#20321](https://github.com/apache/superset/pull/20321) chore: add breaking change information about form_data datasource_type (@eschutho)
- [#20298](https://github.com/apache/superset/pull/20298) chore: Removes no-use-before-define warnings (@michael-s-molina)
- [#20337](https://github.com/apache/superset/pull/20337) chore(dashboard): update Edit Dashboard side panel tabs (@codyml)
- [#20318](https://github.com/apache/superset/pull/20318) chore: Updates the final steps of the release README (@michael-s-molina)
- [#20307](https://github.com/apache/superset/pull/20307) docs: Updates CHANGELOG.md with 1.5.1 fixes (@michael-s-molina)
- [#20308](https://github.com/apache/superset/pull/20308) docs(jinja): Detail how to use Jinja parameters (@EBoisseauSierra)
- [#20304](https://github.com/apache/superset/pull/20304) chore: superset-ui/core code coverage (@zhaoyongjie)
- [#20297](https://github.com/apache/superset/pull/20297) chore(deps): pinning pyjwt to 2.4.0 (@sadpandajoe)
- [#20287](https://github.com/apache/superset/pull/20287) chore(deps): bump numpy 1.22.1 and PyJWT to 2.4.0 (@sadpandajoe)
- [#20272](https://github.com/apache/superset/pull/20272) chore: remove unused codes for samples (@zhaoyongjie)
- [#20289](https://github.com/apache/superset/pull/20289) chore: Adjusts release emails (@michael-s-molina)
- [#20180](https://github.com/apache/superset/pull/20180) docs: facelift the docs (@mistercrunch)
- [#20249](https://github.com/apache/superset/pull/20249) chore: add event logger to reports/alerts CRUD (@AAfghahi)
- [#20273](https://github.com/apache/superset/pull/20273) chore: adjust the psycopg2 version of k8s installation guide (@ensky)
- [#20152](https://github.com/apache/superset/pull/20152) refactor(trino): Handful of updates for the Trino engine (@john-bodley)
- [#20252](https://github.com/apache/superset/pull/20252) chore: use exc_info to pass errors to log warnings (@eschutho)
- [#20154](https://github.com/apache/superset/pull/20154) chore(requirements): Cleanup of Python requirements (@john-bodley)
- [#20226](https://github.com/apache/superset/pull/20226) refactor: decouple DataTableControl (@zhaoyongjie)
- [#20243](https://github.com/apache/superset/pull/20243) docs: Add beans to users list (@kakoni)
- [#20231](https://github.com/apache/superset/pull/20231) docs: Updates release scripts and docs (@michael-s-molina)
- [#20196](https://github.com/apache/superset/pull/20196) chore: bumping min version of shillelagh (@AAfghahi)
- [#20192](https://github.com/apache/superset/pull/20192) chore: Moves date utils to utils folder (@michael-s-molina)
- [#20210](https://github.com/apache/superset/pull/20210) docs: update release instructions (@villebro)
- [#20205](https://github.com/apache/superset/pull/20205) chore(deps): bump swagger-ui-react from 4.1.2 to 4.1.3 in /docs (@dependabot[bot])
- [#20195](https://github.com/apache/superset/pull/20195) docs: correct case of ClickHouse (@DanRoscigno)
- [#20109](https://github.com/apache/superset/pull/20109) refactor: decouple DataTablesPane (@zhaoyongjie)
- [#20193](https://github.com/apache/superset/pull/20193) refactor: Removes embedded/index.tsx warnings (@michael-s-molina)
- [#20185](https://github.com/apache/superset/pull/20185) docs(security): a typo: Gamma should be in quotes (@jimmytheneutrino)
- [#20146](https://github.com/apache/superset/pull/20146) chore: Implement global header in Dashboard (@geido)
- [#20174](https://github.com/apache/superset/pull/20174) chore: Disable flaky assert in reports cypress test (@kgabryje)
- [#20163](https://github.com/apache/superset/pull/20163) chore: change button name in Sql Lab (@AAfghahi)
- [#20157](https://github.com/apache/superset/pull/20157) chore: filter undefined operators (@zhaoyongjie)
- [#20140](https://github.com/apache/superset/pull/20140) chore(data-table): make formatted dttm the default (@villebro)
- [#20104](https://github.com/apache/superset/pull/20104) chore: fix INTHEWILD sort order and indentation (@villebro)
- [#20093](https://github.com/apache/superset/pull/20093) chore: Add the tnum font property to Table components (@geido)
- [#20103](https://github.com/apache/superset/pull/20103) docs: Update INTHEWILD.md (@fccoelho)
- [#20102](https://github.com/apache/superset/pull/20102) chore: Update aiohttp to 3.8.1 (@diegomedina248)
- [#20066](https://github.com/apache/superset/pull/20066) chore: Set limit for a query in execute_sql_statement (@AAfghahi)
- [#20032](https://github.com/apache/superset/pull/20032) chore: Change copy to Edit chart in Dashboard dropdown (@geido)
- [#20071](https://github.com/apache/superset/pull/20071) chore: Fix and enhance Applitools workflows (@geido)
- [#19966](https://github.com/apache/superset/pull/19966) test: make tabbed dashboard a little more complex (@ktmud)
- [#19976](https://github.com/apache/superset/pull/19976) perf(plugin-chart-table): Add memoization to avoid rerenders (@kgabryje)
- [#20044](https://github.com/apache/superset/pull/20044) chore: Create a generic header component for Explore and Dashboard (@kgabryje)
- [#20046](https://github.com/apache/superset/pull/20046) docs: add changelog and updating entries for 1.5.0 (@villebro)
- [#19962](https://github.com/apache/superset/pull/19962) chore: add doc link for db migration conflict warning (@ktmud)
- [#20034](https://github.com/apache/superset/pull/20034) chore: Changes the no-literal-colors lint rule to throw errors instead of warnings (@michael-s-molina)
- [#20031](https://github.com/apache/superset/pull/20031) chore: Run Applitools + Cypress nightly (@geido)
- [#20006](https://github.com/apache/superset/pull/20006) chore: Removes hard-coded colors from the plugins - iteration 2 (@michael-s-molina)
- [#19130](https://github.com/apache/superset/pull/19130) refactor: Refactor reports for Charts and Dashboards (@AAfghahi)
- [#20016](https://github.com/apache/superset/pull/20016) chore: Removes hard-coded colors - iteration 3 (@michael-s-molina)
- [#19870](https://github.com/apache/superset/pull/19870) docs: Detail front-end development instructions (@EBoisseauSierra)
- [#19971](https://github.com/apache/superset/pull/19971) docs: Add config for running on a WSGI HTTP server (@thinhnd2104)
- [#20008](https://github.com/apache/superset/pull/20008) chore: Upgrades Storybook from 6.4.19 to 6.4.22 (@michael-s-molina)
- [#20009](https://github.com/apache/superset/pull/20009) docs: typo in chart-params markdown file (@JakobMiksch)
- [#19923](https://github.com/apache/superset/pull/19923) chore: Removes hard-coded colors from the plugins - iteration 1 (@michael-s-molina)
- [#19954](https://github.com/apache/superset/pull/19954) chore: convert URLShortLinkButton to typescript (@ktmud)
- [#19929](https://github.com/apache/superset/pull/19929) chore: change subject name from no_name to named for PNGs in (@AAfghahi)
- [#19942](https://github.com/apache/superset/pull/19942) refactor(ReportModal): simplify state reducer and improve error handling (@ktmud)
- [#19770](https://github.com/apache/superset/pull/19770) chore: remove druid datasource from the config (@eschutho)
- [#19911](https://github.com/apache/superset/pull/19911) chore: Fix broken link for DouroECI (@mavimo)
- [#19951](https://github.com/apache/superset/pull/19951) chore: Adds the theme object to chart properties (@michael-s-molina)
- [#19813](https://github.com/apache/superset/pull/19813) chore: get embedded user with roles and permissions (@suddjian)
- [#19897](https://github.com/apache/superset/pull/19897) chore: Adds a storybook to FilterableTable (@michael-s-molina)
- [#19924](https://github.com/apache/superset/pull/19924) chore(reports): Improving logging around failed scheduled reports (@craig-rueda)
- [#19906](https://github.com/apache/superset/pull/19906) revert: "fix(sql lab): display the 'View Results' button consistently in the history tab on sync mode" (@Gwitchr)
- [#19916](https://github.com/apache/superset/pull/19916) chore(deps): bump react-virtualized-auto-sizer from 1.0.2 to 1.0.6 in /superset-frontend (@dependabot[bot])
- [#19888](https://github.com/apache/superset/pull/19888) chore(deps): bump cross-fetch from 3.1.4 to 3.1.5 in /docs (@dependabot[bot])
- [#19894](https://github.com/apache/superset/pull/19894) chore(deps-dev): bump eslint-plugin-prettier from 3.3.1 to 4.0.0 in /superset-frontend (@dependabot[bot])
- [#19602](https://github.com/apache/superset/pull/19602) docs: Added gtag to docusaurus (@AAfghahi)
- [#19878](https://github.com/apache/superset/pull/19878) chore(deps-dev): bump @storybook/client-api from 6.4.19 to 6.4.22 in /superset-frontend (@dependabot[bot])
- [#19821](https://github.com/apache/superset/pull/19821) test(native filter): refactor and add new test (@jinghua-qa)
- [#19613](https://github.com/apache/superset/pull/19613) chore: Update line-height in SliceHeaderControl (@geido)
- [#19616](https://github.com/apache/superset/pull/19616) chore: Update font-sizes in DatabaseModal (@geido)
- [#19866](https://github.com/apache/superset/pull/19866) chore: fix explore pills (@villebro)
- [#19872](https://github.com/apache/superset/pull/19872) chore: Update aiohttp>=3.7.4 in requirements (@hughhhh)
- [#19874](https://github.com/apache/superset/pull/19874) chore: bump rockset>=0.8.10, <0.9 (@hughhhh)
- [#19864](https://github.com/apache/superset/pull/19864) chore(deps): bump react-syntax-highlighter from 15.4.5 to 15.5.0 in /superset-frontend (@dependabot[bot])
- [#19828](https://github.com/apache/superset/pull/19828) chore: add custom eslint plugin to prevent translation variables (@stephenLYZ)
- [#19845](https://github.com/apache/superset/pull/19845) chore(deps): bump react-split from 2.0.9 to 2.0.14 in /superset-frontend (@dependabot[bot])
- [#19846](https://github.com/apache/superset/pull/19846) chore(deps): bump d3-svg-legend from 1.13.0 to 2.25.6 in /superset-frontend (@dependabot[bot])
- [#19847](https://github.com/apache/superset/pull/19847) chore(deps-dev): bump eslint-plugin-jsx-a11y from 6.4.1 to 6.5.1 in /superset-frontend (@dependabot[bot])
- [#19853](https://github.com/apache/superset/pull/19853) chore(frontend-tests): Spelling (@jsoref)
- [#19823](https://github.com/apache/superset/pull/19823) docs: updated links for country map scripts (@ktmud)
- [#19829](https://github.com/apache/superset/pull/19829) chore(deps-dev): bump babel-loader from 8.2.4 to 8.2.5 in /superset-frontend (@dependabot[bot])
- [#19830](https://github.com/apache/superset/pull/19830) chore(deps): bump react-hot-loader from 4.12.20 to 4.13.0 in /superset-frontend (@dependabot[bot])
- [#19403](https://github.com/apache/superset/pull/19403) chore(deps-dev): bump babel-loader from 8.2.2 to 8.2.4 in /superset-frontend (@dependabot[bot])
- [#19637](https://github.com/apache/superset/pull/19637) chore(deps): bump moment from 2.29.1 to 2.29.2 in /superset-frontend (@dependabot[bot])
- [#19681](https://github.com/apache/superset/pull/19681) chore(deps): bump async from 3.2.0 to 3.2.3 in /superset-frontend/cypress-base (@dependabot[bot])
- [#19680](https://github.com/apache/superset/pull/19680) chore(deps): bump async from 3.2.0 to 3.2.3 in /superset-websocket (@dependabot[bot])
- [#19020](https://github.com/apache/superset/pull/19020) chore(deps): bump url-parse from 1.5.7 to 1.5.10 in /superset-frontend (@dependabot[bot])
- [#17978](https://github.com/apache/superset/pull/17978) chore(deps): bump @types/d3-time from 1.1.1 to 3.0.0 in /superset-frontend (@dependabot[bot])
- [#19727](https://github.com/apache/superset/pull/19727) chore(deps): bump async from 2.6.3 to 2.6.4 in /docs (@dependabot[bot])
- [#19551](https://github.com/apache/superset/pull/19551) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /superset-websocket (@dependabot[bot])
- [#19165](https://github.com/apache/superset/pull/19165) chore: simplify error messaging in database modal (@pkdotson)
- [#19790](https://github.com/apache/superset/pull/19790) chore: bump postgres from 10 to 14 (@dpgaspar)
- [#19480](https://github.com/apache/superset/pull/19480) chore: Update UPDATING.md (@john-bodley)
- [#19740](https://github.com/apache/superset/pull/19740) chore: fix grammar error (@zhaoyongjie)
- [#19703](https://github.com/apache/superset/pull/19703) chore(build): upgrade less-loader (@ktmud)
- [#19736](https://github.com/apache/superset/pull/19736) chore: Updates the Select code owners (@michael-s-molina)
- [#19715](https://github.com/apache/superset/pull/19715) docs(install): ubuntu default-libmysqlclient-dev (@cemremengu)
- [#19726](https://github.com/apache/superset/pull/19726) chore: bumping shillelagh (@AAfghahi)
- [#19699](https://github.com/apache/superset/pull/19699) chore: fix typo (@betodealmeida)
- [#19674](https://github.com/apache/superset/pull/19674) chore: upgrade Pillow (@betodealmeida)
- [#19647](https://github.com/apache/superset/pull/19647) chore(explore): Change labels "Group by"/"Series" to "Dimensions" (@kgabryje)
- [#19679](https://github.com/apache/superset/pull/19679) chore(deps): bump urijs from 1.19.8 to 1.19.11 in /superset-frontend (@dependabot[bot])
- [#19638](https://github.com/apache/superset/pull/19638) chore(deps): bump moment from 2.29.1 to 2.29.2 in /docs (@dependabot[bot])
- [#19617](https://github.com/apache/superset/pull/19617) chore: updated two github issue templates (@srinify)
- [#19666](https://github.com/apache/superset/pull/19666) chore: Remove TwoTone icons (@geido)
- [#19614](https://github.com/apache/superset/pull/19614) chore: Remove wrong usage of font-size in ExploreViewContainer (@geido)
- [#19593](https://github.com/apache/superset/pull/19593) chore: Update font-sizes in ReportModal (@geido)
- [#19611](https://github.com/apache/superset/pull/19611) chore: Update font-sizes in ImportModal (@geido)
- [#19615](https://github.com/apache/superset/pull/19615) chore: Update font-sizes in AlertReportModal (@geido)
- [#19620](https://github.com/apache/superset/pull/19620) chore: Update font-sizes in QueryPreviewModal (@geido)
- [#19641](https://github.com/apache/superset/pull/19641) chore: clean up dynamic translation strings (@villebro)
- [#19635](https://github.com/apache/superset/pull/19635) refactor: consistent migration tests organization (@ktmud)
- [#19634](https://github.com/apache/superset/pull/19634) test: freeze time for dashboard export test (@ktmud)
- [#19606](https://github.com/apache/superset/pull/19606) test(jinja): refactor to functional tests (@villebro)
- [#19587](https://github.com/apache/superset/pull/19587) chore: cleanup as unknown conversion (@zhaoyongjie)
- [#19562](https://github.com/apache/superset/pull/19562) refactor: Removes the CSS files from the Horizon plugin (@michael-s-molina)
- [#19563](https://github.com/apache/superset/pull/19563) refactor: Removes the CSS files from the Paired T-Test plugin (@michael-s-molina)
- [#19539](https://github.com/apache/superset/pull/19539) refactor: Removes the CSS files from the Parallel Coordinates plugin (@michael-s-molina)
- [#19521](https://github.com/apache/superset/pull/19521) refactor: Removes the CSS files from the Partition plugin (@michael-s-molina)
- [#19493](https://github.com/apache/superset/pull/19493) chore: Removes hard-coded colors from legacy-plugin-chart-sankey (@michael-s-molina)
- [#19462](https://github.com/apache/superset/pull/19462) chore: Remove FilterBox.less (@geido)
- [#19438](https://github.com/apache/superset/pull/19438) chore: Remove crud.less from Datasource (@geido)
- [#19517](https://github.com/apache/superset/pull/19517) chore: Enhance ReactChord style with theme vars (@geido)
- [#19463](https://github.com/apache/superset/pull/19463) chore: Remove TimeTable.less (@geido)
- [#19550](https://github.com/apache/superset/pull/19550) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /superset-embedded-sdk (@dependabot[bot])
- [#19566](https://github.com/apache/superset/pull/19566) chore(deps): bump node-forge from 1.2.1 to 1.3.1 in /docs (@dependabot[bot])
- [#19552](https://github.com/apache/superset/pull/19552) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /docs (@dependabot[bot])
- [#19549](https://github.com/apache/superset/pull/19549) chore(deps): bump minimist from 1.2.5 to 1.2.6 in /superset-frontend/cypress-base (@dependabot[bot])
- [#19559](https://github.com/apache/superset/pull/19559) docs: update the typo in the documentation (@fatosmorina)
- [#19538](https://github.com/apache/superset/pull/19538) refactor: Removes the CSS files from the Country Map plugin (@michael-s-molina)
- [#19536](https://github.com/apache/superset/pull/19536) chore: Removes hard-coded opacity and spacing from the BigNumber plugin (@michael-s-molina)
- [#19494](https://github.com/apache/superset/pull/19494) refactor: Removes the CSS files from the Sankey Loop plugin (@michael-s-molina)
- [#19492](https://github.com/apache/superset/pull/19492) chore: Remove Legacy Force Directed viz plugin (@geido)
- [#19524](https://github.com/apache/superset/pull/19524) chore: Deprecating /my_queries endpoint (@AAfghahi)
- [#19467](https://github.com/apache/superset/pull/19467) chore(Explore): Change text when saving a chart in a new dashboard (@geido)
- [#19526](https://github.com/apache/superset/pull/19526) chore(database): Creating helper make_url_safe to wrap potential errors (@craig-rueda)
- [#19415](https://github.com/apache/superset/pull/19415) chore: Remove Control.less in Explore (@geido)
- [#19413](https://github.com/apache/superset/pull/19413) chore: Remove unused less file from profile (@geido)
- [#19460](https://github.com/apache/superset/pull/19460) chore: Switch to gender neutral terms (@inclusive-coding-bot)
- [#19486](https://github.com/apache/superset/pull/19486) refactor: Removes the CSS files from the Treemap plugin (@michael-s-molina)
- [#19488](https://github.com/apache/superset/pull/19488) refactor: Removes the CSS files from the Sunburst plugin (@michael-s-molina)
- [#19490](https://github.com/apache/superset/pull/19490) chore: Add theme color to ParallelCoordinates (@geido)
- [#19442](https://github.com/apache/superset/pull/19442) chore: Remove FilterbaleTableStyles.less (@geido)
- [#19441](https://github.com/apache/superset/pull/19441) chore: Remove StyledQueryButton.less (@geido)
- [#19473](https://github.com/apache/superset/pull/19473) refactor: Removes the CSS files from the Rose plugin (@michael-s-molina)
- [#19466](https://github.com/apache/superset/pull/19466) chore: Removes hard-coded colors from legacy-plugin-chart-world-map (@michael-s-molina)
- [#19465](https://github.com/apache/superset/pull/19465) refactor: Removes the CSS files from the DeckGL plugin (@michael-s-molina)
- [#19440](https://github.com/apache/superset/pull/19440) chore: Remove index.less from showSavedQuery (@geido)
- [#19230](https://github.com/apache/superset/pull/19230) chore!: remove `ROW_LEVEL_SECURITY` feature flag (permanently enable) (@suddjian)
- [#19361](https://github.com/apache/superset/pull/19361) chore: remove deprecated config keys and endpoints code 2.0 (@pkdotson)
- [#19261](https://github.com/apache/superset/pull/19261) chore: remove old alerts and configs keys (@pkdotson)
- [#19168](https://github.com/apache/superset/pull/19168) chore: bump celery and Flask (@dpgaspar)
- [#19049](https://github.com/apache/superset/pull/19049) chore: Remove logo forced width (@geido)
- [#19274](https://github.com/apache/superset/pull/19274) chore: remove PUBLIC_ROLE_LIKE_GAMMA deprecated config key (@dpgaspar)
- [#19273](https://github.com/apache/superset/pull/19273) chore: remove deprecated celery cli (@dpgaspar)
- [#19262](https://github.com/apache/superset/pull/19262) chore: update updating with druid no sql deprecation (@eschutho)
- [#19083](https://github.com/apache/superset/pull/19083) chore!: update mutator to take kwargs (@eschutho)
- [#19231](https://github.com/apache/superset/pull/19231) chore!: remove `ENABLE_REACT_CRUD_VIEWS` feature flag (permanently enable) (@suddjian)
- [#19241](https://github.com/apache/superset/pull/19241) chore(superset 2.0): remove front-end deprecated code (@graceguo-supercat)
- [#19107](https://github.com/apache/superset/pull/19107) chore: turn on SQLLAB_BACKEND_PERSISTENCE by default (@ktmud)
- [#19142](https://github.com/apache/superset/pull/19142) chore!: turn on Versioned Export in config.py (@AAfghahi)
- [#19108](https://github.com/apache/superset/pull/19108) chore: Update UPDATING.md with info about flipping dnd feature flag (@kgabryje)
- [#19146](https://github.com/apache/superset/pull/19146) chore!: Remove remove SQLALCHEMY_DOCS_URL and SQLALCHEMY_DISPLAY_TEXT from the config from the config (@hughhhh)
- [#19017](https://github.com/apache/superset/pull/19017) chore: Deprecate Python 3.7 (@john-bodley)
- [#19113](https://github.com/apache/superset/pull/19113) chore(config): Migrating `ENABLE_JAVASCRIPT_CONTROLS` from app config to a feature flag (@rusackas)
- [#19046](https://github.com/apache/superset/pull/19046) chore(explore): Set Drag&Drop feature flags to True by default (@kgabryje)
- [#19016](https://github.com/apache/superset/pull/19016) chore: Adding PR to Updating.md (@AAfghahi)
- [#18970](https://github.com/apache/superset/pull/18970) chore: Change Dataset legacy editor flag to true (@AAfghahi)

### 1.5.3 (Thu Jan 5 15:05:44 2023 -0500)

**Database Migrations**

**Features**

**Fixes**

- [#21895](https://github.com/apache/superset/pull/21895) fix: Improves SafeMarkdown HTML sanitization (@michael-s-molina)
- [#21874](https://github.com/apache/superset/pull/21874) fix: Adds a Content Security Policy (CSP) check for production environments (@michael-s-molina)
- [#21853](https://github.com/apache/superset/pull/21853) fix: Disables HTML rendering in Toast by default (@michael-s-molina)
- [#22591](https://github.com/apache/superset/pull/22591) fix: Talisman configuration (@michael-s-molina)
- [#22196](https://github.com/apache/superset/pull/22196) fix(reports): force data generation in csv reports (@mayurnewase)
- [#22038](https://github.com/apache/superset/pull/22038) fix: datasource save, improve data validation (@dpgaspar)
- [#22022](https://github.com/apache/superset/pull/22022) fix: deprecate approve and request_access endpoint (@dpgaspar)
- [#21964](https://github.com/apache/superset/pull/21964) fix: dashboard api cache decorator (@dpgaspar)
- [#21875](https://github.com/apache/superset/pull/21875) fix: check that imports are ZIPs (@betodealmeida)
- [#21761](https://github.com/apache/superset/pull/21761) fix: flash message on database data upload forms (@dpgaspar)
- [#21759](https://github.com/apache/superset/pull/21759) fix: database schema selector on import data (@dpgaspar)
- [#21729](https://github.com/apache/superset/pull/21729) fix: allow adhoc columns in non-aggregate query (@mayurnewase)
- [#21216](https://github.com/apache/superset/pull/21216) fix(database-list): hide upload file button if no permission (@stephenLYZ)

**Others**

- [#21811](https://github.com/apache/superset/pull/21811) chore(sqla): refactor query utils (@villebro)

### 1.5.2 (Wed Sep 14 17:11:51 2022 +0530)

**Fixes**

- [#21461](https://github.com/apache/superset/pull/21461) fix: dashboard filter value is cleared when 2 similar dashboards opened in succession (@mayurnewase)
- [#21419](https://github.com/apache/superset/pull/21419) fix: cached common bootstrap Revert (#21018) (@dpgaspar)
- [#21302](https://github.com/apache/superset/pull/21302) fix: disallow users from viewing other user's profile on config (@dpgaspar)
- [#21272](https://github.com/apache/superset/pull/21272) fix: adds TLS certificate validation option for SMTP (@dpgaspar)
- [#21076](https://github.com/apache/superset/pull/21076) fix(celery cache warmup): add auth and use warm_up_cache endpoint (@nytai)
- [#20178](https://github.com/apache/superset/pull/20178) fix: While exporting CSV , only the entries on first page are getting downloaded even when user is on other pages #17861 (@LahmerIlyas)
- [#20058](https://github.com/apache/superset/pull/20058) fix: Support the Clipboard API in modern browsers (@diegomedina248)
- [#20434](https://github.com/apache/superset/pull/20434) fix(20428): Address-Presto/Trino-Poll-Issue-Refactor (@Thelin90)
- [#20348](https://github.com/apache/superset/pull/20348) fix(docker): Make Gunicorn Keepalive Adjustable (@mdeshmu)
- [#20315](https://github.com/apache/superset/pull/20315) fix(chart): chart gets cut off on the dashboard (@stephenLYZ)
- [#20235](https://github.com/apache/superset/pull/20235) fix: Box Plot Chart throws an error when the average (AVG) / SUM is being calculated on the Metrics (@diegomedina248)
- [#20151](https://github.com/apache/superset/pull/20151) fix(csv): Ensure df_to_escaped_csv does not coerce integer columns to float (@john-bodley)
- [#20173](https://github.com/apache/superset/pull/20173) fix: avoid while cycle in computeMaxFontSize for big Number run forever when css rule applied (@diegomedina248)
- [#19570](https://github.com/apache/superset/pull/19570) fix: sqloxide optional (@betodealmeida)

**Others**

- [#21439](https://github.com/apache/superset/pull/21439) perf: Memoize the common_bootstrap_payload and include user param (#21018) (@bkyryliuk)
- [#19703](https://github.com/apache/superset/pull/19703) chore(build): upgrade less-loader (@ktmud)
- [#20550](https://github.com/apache/superset/pull/20550) chore: updating python docker image to 3.8.13 (@nisheldo)
- [#21018](https://github.com/apache/superset/pull/21018) perf: Memoize the common_bootstrap_payload (@bkyryliuk)
- [#20974](https://github.com/apache/superset/pull/20974) perf: Implement model specific lookups by id to improve performance (@bkyryliuk)
- [#20273](https://github.com/apache/superset/pull/20273) chore: adjust the psycopg2 version of k8s installation guide (@ensky)

### 1.5.1 (Thu May 26 14:45:20 2022 +0300)

**Fixes**

- [#19685](https://github.com/apache/superset/pull/19685) fix: login button does not render (@villebro)
- [#20181](https://github.com/apache/superset/pull/20181) fix(temporary-cache): when user is anonymous (@villebro)
- [#20091](https://github.com/apache/superset/pull/20091) fix: "Week Staring Monday" time grain for BigQuery (@ramunas-omnisend)
- [#20135](https://github.com/apache/superset/pull/20135) fix: Allow dataset owners to see their datasets (@cccs-tom)
- [#20123](https://github.com/apache/superset/pull/20123) fix(presto,trino): use correct literal dttm separator (@villebro)
- [#20077](https://github.com/apache/superset/pull/20077) fix(generic-axes): apply contribution before flatten (@villebro)
- [#19970](https://github.com/apache/superset/pull/19970) fix: Athena timestamp literal format (@thinhnd2104)
- [#20055](https://github.com/apache/superset/pull/20055) fix(plugin-chart-echarts): support adhoc x-axis (@villebro)
- [#18873](https://github.com/apache/superset/pull/18873) fix(sqllab/charts): casting from timestamp[us] to timestamp[ns] would result in out of bounds timestamp (@yeachan153)
- [#19917](https://github.com/apache/superset/pull/19917) fix(sqla): replace custom dttm type with literal_column (@villebro)
- [#19854](https://github.com/apache/superset/pull/19854) fix: Alpha should not be able to edit datasets that they don't own (@hughhhh)

### 1.5.0 (Fri Apr 22 17:23:30 2022 -0400)

- **Database Migrations**
- [#19805](https://github.com/apache/superset/pull/19805) fix(key_value): use longblob on mysql (@villebro)
- [#19543](https://github.com/apache/superset/pull/19543) fix(migrations): reorder skipped 1.4 migrations (@villebro)
- [#19416](https://github.com/apache/superset/pull/19416) perf: improve perf in SIP-68 migration (@betodealmeida)
- [#19225](https://github.com/apache/superset/pull/19225) fix(sql lab): deleting the last saved query or the last executed from history (@diegomedina248)
- [#19078](https://github.com/apache/superset/pull/19078) feat: add permalink to dashboard and explore (@villebro)
- [#18998](https://github.com/apache/superset/pull/18998) fix(plugin-chart-echarts): Apply temporary filters to Query B in explore (@kgabryje)
- [#19022](https://github.com/apache/superset/pull/19022) fix: remove unneeded complexity in migration (@betodealmeida)
- [#18992](https://github.com/apache/superset/pull/18992) fix(sqllab): Replace stringified 'null' schema column values with NULL (@john-bodley)
- [#18948](https://github.com/apache/superset/pull/18948) fix(dataset): handle missing database in migration (@villebro)
- [#17543](https://github.com/apache/superset/pull/17543) feat: new dataset/table/column models (@betodealmeida)
- [#18561](https://github.com/apache/superset/pull/18561) feat: embedded dashboard (@lilykuang)
- [#18093](https://github.com/apache/superset/pull/18093) feat: allow assets to be managed externally (@betodealmeida)
- [#17925](https://github.com/apache/superset/pull/17925) refactor: Migration for Tabbed Sql Editor (@AAfghahi)
- [#17928](https://github.com/apache/superset/pull/17928) fix: force_screenshot migration (@betodealmeida)
- [#17853](https://github.com/apache/superset/pull/17853) feat: add force option to report screenshots (@betodealmeida)
- [#17803](https://github.com/apache/superset/pull/17803) feat(plugin-chart-pivot-table): support series limit (@kgabryje)
- [#17587](https://github.com/apache/superset/pull/17587) chore(explore): Migrate BigNumber to v1 api [ID-28][id-55] (@kgabryje)
- [#17360](https://github.com/apache/superset/pull/17360) fix: Change datatype of column type in BaseColumn to allow larger datatype names for complexed columns (@cccs-joel)
- [#17728](https://github.com/apache/superset/pull/17728) fix: migration out-of-scope bind (@betodealmeida)
- [#17604](https://github.com/apache/superset/pull/17604) feat(alerts): Column for select tabs to send (@m-ajay)
- [#17323](https://github.com/apache/superset/pull/17323) fix: rename to schemas_allowed_for_file_upload in dbs.extra (@exemplary-citizen)
- [#17275](https://github.com/apache/superset/pull/17275) fix: drop check constraint on dbs to rename column (@betodealmeida)
- [#16756](https://github.com/apache/superset/pull/16756) refactor: Repeated boilerplate code between upload to database forms (@exemplary-citizen)

**Features**

- [#19776](https://github.com/apache/superset/pull/19776) feat: add renameOperator (@zhaoyongjie)
- [#19328](https://github.com/apache/superset/pull/19328) feat(sql lab): enable ACE editor search in SQL editors (@diegomedina248)
- [#19454](https://github.com/apache/superset/pull/19454) feat: improve adhoc SQL validation (@betodealmeida)
- [#19364](https://github.com/apache/superset/pull/19364) feat: Embedded dashboard configuration (@suddjian)
- [#19344](https://github.com/apache/superset/pull/19344) feat: disable edits on external assets (@betodealmeida)
- [#19393](https://github.com/apache/superset/pull/19393) feat: linear imputation in Resample (@zhaoyongjie)
- [#19259](https://github.com/apache/superset/pull/19259) feat(explore): Dataset panel option tooltips (@kgabryje)
- [#19324](https://github.com/apache/superset/pull/19324) feat: introduce hashids permalink keys (@villebro)
- [#19315](https://github.com/apache/superset/pull/19315) feat: import external management columns (@betodealmeida)
- [#19317](https://github.com/apache/superset/pull/19317) feat: add duckdb as DataSource - Fixes #14563 (@rwhaling)
- [#19318](https://github.com/apache/superset/pull/19318) feat: external management flags in CRUD (@betodealmeida)
- [#19116](https://github.com/apache/superset/pull/19116) feat(advanced analysis): support MultiIndex column in post processing stage (@zhaoyongjie)
- [#19289](https://github.com/apache/superset/pull/19289) feat: Implements Docusearch into docusaurus docs (@AAfghahi)
- [#19220](https://github.com/apache/superset/pull/19220) feat: API for asset sync (@betodealmeida)
- [#18953](https://github.com/apache/superset/pull/18953) feat: allow uploads in crud view (@pkdotson)
- [#19232](https://github.com/apache/superset/pull/19232) feat(key-value): add superset metastore cache (@villebro)
- [#19144](https://github.com/apache/superset/pull/19144) feat: SupersetClient config to override 401 behavior (@suddjian)
- [#19038](https://github.com/apache/superset/pull/19038) feat: improve color consistency (save all labels) (@stephenLYZ)
- [#19248](https://github.com/apache/superset/pull/19248) feat: add support for comments in adhoc clauses (@villebro)
- [#19217](https://github.com/apache/superset/pull/19217) feat: import/export assets commands (@betodealmeida)
- [#19141](https://github.com/apache/superset/pull/19141) feat(ui): Adding manifest prefix config (@craig-rueda)
- [#19104](https://github.com/apache/superset/pull/19104) feat(sqllab): Add a configuration option to disable data preview (@cccs-Dustin)
- [#19053](https://github.com/apache/superset/pull/19053) feat: scroll to bottom when adding a new native filter and the page is filled (@diegomedina248)
- [#19215](https://github.com/apache/superset/pull/19215) feat: add export_related flag (@betodealmeida)
- [#19055](https://github.com/apache/superset/pull/19055) feat: helper functions for RLS (@betodealmeida)
- [#19085](https://github.com/apache/superset/pull/19085) feat(select): keep options order when not in async mode (@ktmud)
- [#19031](https://github.com/apache/superset/pull/19031) feat(embedded): add optional dashboard ui configuration (@lilykuang)
- [#18662](https://github.com/apache/superset/pull/18662) feat(viz-gallery): add 'feature' tag and fuzzy search weighting (@stephenLYZ)
- [#18856](https://github.com/apache/superset/pull/18856) feat(select): sort exact and startsWith match to first (@ktmud)
- [#18795](https://github.com/apache/superset/pull/18795) feat: Allow users to bust cache in report dashboard + alerts charts + alert dashboards (@hughhhh)
- [#18793](https://github.com/apache/superset/pull/18793) feat: Adds support to multiple dependencies to the native filters (@michael-s-molina)
- [#18799](https://github.com/apache/superset/pull/18799) feat: remove loading indicator when typing in select (@ktmud)
- [#19004](https://github.com/apache/superset/pull/19004) feat: show user email in dashboard API (@betodealmeida)
- [#18896](https://github.com/apache/superset/pull/18896) feat(TimeTableViz): sort by first metric (@serenajiang)
- [#18945](https://github.com/apache/superset/pull/18945) feat(legacy-preset-chart-deckgl): Add ,.1f and ,.2f value formats to deckgl charts (@kgabryje)
- [#18722](https://github.com/apache/superset/pull/18722) feat: DBC-UI Globally available across the app 🌎 (@hughhhh)
- [#18773](https://github.com/apache/superset/pull/18773) feat: On window focus, redirect to login if the user has been logged out (@suddjian)
- [#18848](https://github.com/apache/superset/pull/18848) feat(helm): allow adding pod labels (@vuongxuongminh)
- [#18874](https://github.com/apache/superset/pull/18874) feat(native-filters): Implement filter cards (@kgabryje)
- [#18876](https://github.com/apache/superset/pull/18876) feat(native-filters): Don't scroll main window when scrolling filter bar (@kgabryje)
- [#18784](https://github.com/apache/superset/pull/18784) feat(native-filters): Re-arrange controls in FilterBar (@kgabryje)
- [#18745](https://github.com/apache/superset/pull/18745) feat(maps): Adding country maps: BI/ET/RW/TZ/UG (+updated NG) (@Yann-J)
- [#18748](https://github.com/apache/superset/pull/18748) feat(embedded): make guest token JWT audience callable or str (@lilykuang)
- [#18576](https://github.com/apache/superset/pull/18576) feat: Improve state key generation for dashboards and charts (@michael-s-molina)
- [#18651](https://github.com/apache/superset/pull/18651) feat(embedded): aud claim and type for guest token (@lilykuang)
- [#18678](https://github.com/apache/superset/pull/18678) feat(explore): Implement chart empty states (@kgabryje)
- [#18681](https://github.com/apache/superset/pull/18681) feat(explore): Implement metrics and columns popovers empty states (@kgabryje)
- [#18712](https://github.com/apache/superset/pull/18712) feat(dashboard): Implement empty states for dashboard (@kgabryje)
- [#18679](https://github.com/apache/superset/pull/18679) feat(explore): Implement data table empty states (@kgabryje)
- [#18652](https://github.com/apache/superset/pull/18652) feat: Introduce a library for embedded iframe <-> host communication (@suddjian)
- [#18676](https://github.com/apache/superset/pull/18676) feat: Implement EmptyState components (@kgabryje)
- [#18653](https://github.com/apache/superset/pull/18653) feat: add prop to `setDBEngine` in DatabaseModal (@hughhhh)
- [#18642](https://github.com/apache/superset/pull/18642) feat(Helm): Redis with password supported in helm charts and redis chart version updated (@wiktor2200)
- [#18649](https://github.com/apache/superset/pull/18649) feat(helm): allow to customize init image (@avakarev)
- [#18626](https://github.com/apache/superset/pull/18626) feat: editable title xl certified badge (@opus-42)
- [#18624](https://github.com/apache/superset/pull/18624) feat: Improves key expiration handling in Explore (@michael-s-molina)
- [#17208](https://github.com/apache/superset/pull/17208) feat: Dynamic dashboard component (@simcha90)
- [#18064](https://github.com/apache/superset/pull/18064) feat: datasource access to allow more granular access to tables on SQL Lab (@Painyjames)
- [#18569](https://github.com/apache/superset/pull/18569) feat(explore): Allow using time formatter on temporal columns in data table (@kgabryje)
- [#18618](https://github.com/apache/superset/pull/18618) feat(chart-data-api): download multiple csvs as zip (@villebro)
- [#18620](https://github.com/apache/superset/pull/18620) feat: log decorator util - adding automatic logs out of the box (@ofekisr)
- [#18080](https://github.com/apache/superset/pull/18080) feat: smart tooltip in datasourcepanel (@zhaoyongjie)
- [#18250](https://github.com/apache/superset/pull/18250) feat: Embedded SDK (@suddjian)
- [#18560](https://github.com/apache/superset/pull/18560) feat: 🚀 Docs V2 CI Script (@hughhhh)
- [#18215](https://github.com/apache/superset/pull/18215) feat(explore): Keep or reset chart config after datasource change (@kgabryje)
- [#18190](https://github.com/apache/superset/pull/18190) feat: Added success toasts for database, dataset, chart, dashboard, and query imports (@lyndsiWilliams)
- [#18214](https://github.com/apache/superset/pull/18214) feat(docker-compose): add TAG option (@villebro)
- [#17411](https://github.com/apache/superset/pull/17411) feat: Upgrade documentation V2 (@hughhhh)
- [#18169](https://github.com/apache/superset/pull/18169) feat: Add toast for successful table or schema refreshes in Sqllab (@hughhhh)
- [#18183](https://github.com/apache/superset/pull/18183) feat: add success message for database modal (@pkdotson)
- [#17530](https://github.com/apache/superset/pull/17530) feat: embedded dashboard core (@suddjian)
- [#18161](https://github.com/apache/superset/pull/18161) feat(helm): Add schema of values in Helm Chart (@ad-m)
- [#18108](https://github.com/apache/superset/pull/18108) feat(explore): more toast feedback on user actions in Explore (@kgabryje)
- [#18114](https://github.com/apache/superset/pull/18114) feat(dashboard): add toast feedback to dashboard actions (@kgabryje)
- [#18116](https://github.com/apache/superset/pull/18116) feat: add toast feedback to annotation templates (@kgabryje)
- [#18081](https://github.com/apache/superset/pull/18081) feat(country-map): added new countries in country-chart-map (@Hammad-Raza)
- [#17917](https://github.com/apache/superset/pull/17917) feat(plugin-chart-echarts): support non-timeseries x-axis (@villebro)
- [#17882](https://github.com/apache/superset/pull/17882) feat: Adds a key-value endpoint to store charts form data (@michael-s-molina)
- [#17207](https://github.com/apache/superset/pull/17207) feat: add chart description in info tooltip (@stephenLYZ)
- [#18045](https://github.com/apache/superset/pull/18045) feat(advanced analytics): support groupby in resample (@zhaoyongjie)
- [#17593](https://github.com/apache/superset/pull/17593) feat: Trino Authentications (@dungdm93)
- [#18041](https://github.com/apache/superset/pull/18041) feat: stop running CI on doc updates (@hughhhh)
- [#18001](https://github.com/apache/superset/pull/18001) feat: shorter timeout on test_connection (@betodealmeida)
- [#17758](https://github.com/apache/superset/pull/17758) feat(timeseries-chart): add percentage threshold input control (@corbinrobb)
- [#18007](https://github.com/apache/superset/pull/18007) feat(chart): add Mexico to country map viz (@ktmud)
- [#17749](https://github.com/apache/superset/pull/17749) feat(alerts): Select tabs to send backend (@m-ajay)
- [#17968](https://github.com/apache/superset/pull/17968) feat: update time comparison choices (again) (@serenajiang)
- [#17898](https://github.com/apache/superset/pull/17898) feat: Add support for Azure Data Explorer (Kusto) db engine spec (@Ceridan)
- [#17804](https://github.com/apache/superset/pull/17804) feat: Update query states to use spinner vs. progress bar (@hughhhh)
- [#17880](https://github.com/apache/superset/pull/17880) feat: Helm - custom service account creation and management (@wiktor2200)
- [#17855](https://github.com/apache/superset/pull/17855) feat: configure force_screenshot (@betodealmeida)
- [#17695](https://github.com/apache/superset/pull/17695) feat: bypass cache on screenshots for alerts (@betodealmeida)
- [#17708](https://github.com/apache/superset/pull/17708) feat: Persist SQL Lab autocomplete setting across tabs and visits (@etr2460)
- [#17776](https://github.com/apache/superset/pull/17776) feat: don't ask for password when DB exists (@betodealmeida)
- [#17739](https://github.com/apache/superset/pull/17739) feat: add main datetime column to dataset editor (@betodealmeida)
- [#17734](https://github.com/apache/superset/pull/17734) feat: Update makefile with frontend build (@hughhhh)
- [#17655](https://github.com/apache/superset/pull/17655) feat: convert dataframe tests (@betodealmeida)
- [#17589](https://github.com/apache/superset/pull/17589) feat: customize recent activity access (@villebro)
- [#17658](https://github.com/apache/superset/pull/17658) feat(prophet): enable confidence intervals and y_hat without forecast (@exemplary-citizen)
- [#17657](https://github.com/apache/superset/pull/17657) feat(viz): export csv with verbose_name (@chuancyzhang)
- [#17512](https://github.com/apache/superset/pull/17512) feat(explore): export csv data pivoted for Pivot Table [ID-9] (@kgabryje)
- [#17307](https://github.com/apache/superset/pull/17307) feat(explore): support show annotation label [ID-8] (@stephenLYZ)
- [#17615](https://github.com/apache/superset/pull/17615) feat(legacy-preset-chart-nvd3): add richtooltip in nvd3 bar chart (@stephenLYZ)
- [#17372](https://github.com/apache/superset/pull/17372) feat: Add single select and inverse selection to numeric range (#16722) (@mhoustonataegis)
- [#17536](https://github.com/apache/superset/pull/17536) feat: Adds a key-value endpoint to store the state of dashboard filters (@michael-s-molina)
- [#17581](https://github.com/apache/superset/pull/17581) feat: added option to set pod annotations on init-db pod to Helm chart. (@caviliar)
- [#17554](https://github.com/apache/superset/pull/17554) feat: add classNames for apply and clearAll buttons for superset filters (@Nithin-George-Philips)
- [#16346](https://github.com/apache/superset/pull/16346) feat: trino support server-cert (@dungdm93)
- [#17410](https://github.com/apache/superset/pull/17410) feat(dashboard): Add divider component in native filters (@m-ajay)
- [#17409](https://github.com/apache/superset/pull/17409) feat: add a config to enable retina quality images in screenshots (@eschutho)
- [#17379](https://github.com/apache/superset/pull/17379) feat(explore): adhoc column expressions [ID-3] (@villebro)
- [#17416](https://github.com/apache/superset/pull/17416) feat: Add quarter unit to datetrunc (@john-bodley)
- [#16992](https://github.com/apache/superset/pull/16992) feat(native_filter_migration): add transition mode (@graceguo-supercat)
- [#17202](https://github.com/apache/superset/pull/17202) feat(metrics): Provide override for disabling ad-hoc metrics (@john-bodley)
- [#17336](https://github.com/apache/superset/pull/17336) feat: apply d3NumberFormat to table reports (@betodealmeida)
- [#17329](https://github.com/apache/superset/pull/17329) feat: improve logic in is_select (@betodealmeida)
- [#17252](https://github.com/apache/superset/pull/17252) feat: add possibility to set ingress class name in Helm chart (@Jolcik)
- [#17237](https://github.com/apache/superset/pull/17237) feat: Make Jinja template applied in timestamp columns (@xingyc15)
- [#17025](https://github.com/apache/superset/pull/17025) feat(dashboard): Add description to the native filter (@m-ajay)
- [#17157](https://github.com/apache/superset/pull/17157) feat: Hide nav create with RBAC (@hughhhh)
- [#17177](https://github.com/apache/superset/pull/17177) feat: support disabling domain sharding with a query param (@etr2460)
- [#17134](https://github.com/apache/superset/pull/17134) feat: Add prettier to pre-commit workflow (@hughhhh)
- [#17055](https://github.com/apache/superset/pull/17055) feat(Filter-sets): connect to api (@simcha90)
- [#16856](https://github.com/apache/superset/pull/16856) feat: DBC UI Snowflake Form (@hughhhh)
- [#16154](https://github.com/apache/superset/pull/16154) feat(dashboard): Let users re-arrange native filters (@m-ajay)
- [#17039](https://github.com/apache/superset/pull/17039) feat(config): Add none force-refresh option for auto refresh (@yongchand)
- [#17001](https://github.com/apache/superset/pull/17001) feat(linting): restrict direct use of supersetTheme in favor of ThemeProvider (@rusackas)

**Fixes**

- [#19448](https://github.com/apache/superset/pull/19448) fix(sql lab): when editing a saved query, the status is lost when switching tabs (@diegomedina248)
- [#19806](https://github.com/apache/superset/pull/19806) fix(plugin-chart-table): Fix display of column config in table chart (@kgabryje)
- [#19802](https://github.com/apache/superset/pull/19802) fix: lost renameOperator in mixed timeseries chart (@zhaoyongjie)
- [#19765](https://github.com/apache/superset/pull/19765) fix(chart & explore): Show labels for `SliderControl` (@prosdev0107)
- [#16619](https://github.com/apache/superset/pull/16619) fix: dashboard standalone class not added when parameter set (@trepmag)
- [#19783](https://github.com/apache/superset/pull/19783) fix: SQL Lab UI Error: Objects are not valid as a React child (@diegomedina248)
- [#19370](https://github.com/apache/superset/pull/19370) fix(sql lab): replace the output column in the query history table (@diegomedina248)
- [#19772](https://github.com/apache/superset/pull/19772) fix(dashboard): copy permalink to dashboard chart (@villebro)
- [#19603](https://github.com/apache/superset/pull/19603) fix(explore): make to show the null value as N/A in view result (@prosdev0107)
- [#19749](https://github.com/apache/superset/pull/19749) fix(permalink): remove memoize on get salt func (@villebro)
- [#19698](https://github.com/apache/superset/pull/19698) fix: Filter dependencies are not being applied in default values (@michael-s-molina)
- [#19651](https://github.com/apache/superset/pull/19651) fix(dnd&column): make to fix the blank state issue when only one column select (@prosdev0107)
- [#19716](https://github.com/apache/superset/pull/19716) fix: drop the first level of MultiIndex (@zhaoyongjie)
- [#19688](https://github.com/apache/superset/pull/19688) fix(dashboard): Fix BigNumber causing dashboard to crash when overflowing (@kgabryje)
- [#19664](https://github.com/apache/superset/pull/19664) fix(sql-lab): do not replace undefined schema with empty object (@villebro)
- [#19659](https://github.com/apache/superset/pull/19659) fix: time comparision (@zhaoyongjie)
- [#19553](https://github.com/apache/superset/pull/19553) fix(dataset): handle missing python_type gracefully (@villebro)
- [#19612](https://github.com/apache/superset/pull/19612) fix(select): render when empty multiselect (@villebro)
- [#19565](https://github.com/apache/superset/pull/19565) fix(sqla): apply jinja to metrics (@villebro)
- [#19582](https://github.com/apache/superset/pull/19582) fix(dataset): avoid crash if database missing (@villebro)
- [#19542](https://github.com/apache/superset/pull/19542) fix: big number with trendline can't calculate cumsum (@zhaoyongjie)
- [#19548](https://github.com/apache/superset/pull/19548) fix(sqllab): null database with backend persistence (@villebro)
- [#19409](https://github.com/apache/superset/pull/19409) fix(dashboard list): do not show favorite star for anonymous users #18210 (@dudasaron)
- [#19483](https://github.com/apache/superset/pull/19483) fix: flaky test for charts changed on (@zhaoyongjie)
- [#19366](https://github.com/apache/superset/pull/19366) fix: can't sync temporal flag on virtual table (@zhaoyongjie)
- [#19456](https://github.com/apache/superset/pull/19456) fix: request samples with default row limit (@villebro)
- [#19252](https://github.com/apache/superset/pull/19252) fix(drill): specify an SA URL parm of `impersonation_target` for drill+sadrill (@jnturton)
- [#19372](https://github.com/apache/superset/pull/19372) fix(dashboard): make to show the correct owned objects (@prosdev0107)
- [#19452](https://github.com/apache/superset/pull/19452) fix: can't save dataset modal (@zhaoyongjie)
- [#19435](https://github.com/apache/superset/pull/19435) fix: missing init on importexport pkg (@dpgaspar)
- [#19428](https://github.com/apache/superset/pull/19428) fix: add missing init on python pkg key_value (@dpgaspar)
- [#19337](https://github.com/apache/superset/pull/19337) fix(database): make to allow the expose db as default in sqlalchemy form db (@prosdev0107)
- [#19321](https://github.com/apache/superset/pull/19321) fix(readme): fix add-driver-docker url in Readme (@jqueguiner)
- [#19369](https://github.com/apache/superset/pull/19369) fix(caching): support metastore cache for non-required caches (@villebro)
- [#19010](https://github.com/apache/superset/pull/19010) fix(explore-sqllab): make that Timestamp column keep the Is temporal … (@prosdev0107)
- [#19351](https://github.com/apache/superset/pull/19351) fix: number format should editable in time comparison (@zhaoyongjie)
- [#19122](https://github.com/apache/superset/pull/19122) fix(report-add): make to add error toast message when already attached report is added again into dashboard or chart (@prosdev0107)
- [#19138](https://github.com/apache/superset/pull/19138) fix: Remove gap from SQLLab results bottom (@codemaster08240328)
- [#19355](https://github.com/apache/superset/pull/19355) fix: Fix NoAuthorizationError in /me endpoint (@geido)
- [#19359](https://github.com/apache/superset/pull/19359) fix: [Explore] Adaptive formatting spelling (@kasiazjc)
- [#19346](https://github.com/apache/superset/pull/19346) fix: typo (@etr2460)
- [#19341](https://github.com/apache/superset/pull/19341) fix: Null values on Explore filter (@michael-s-molina)
- [#19338](https://github.com/apache/superset/pull/19338) fix(docs): spelling (@ndbu)
- [#19339](https://github.com/apache/superset/pull/19339) fix(embedded): download chart as image (@lilykuang)
- [#19327](https://github.com/apache/superset/pull/19327) fix(dashboard): Chart stuck in loading state when when datasets request and chart request fail (@kgabryje)
- [#19316](https://github.com/apache/superset/pull/19316) fix(explore): make to convert null to N/A in view results (@prosdev0107)
- [#19326](https://github.com/apache/superset/pull/19326) fix: regression on Select component when handling null values (@diegomedina248)
- [#18741](https://github.com/apache/superset/pull/18741) fix(dashboard): fix default filter bar visibility + add docs (@villebro)
- [#19305](https://github.com/apache/superset/pull/19305) fix(cache): only warn about fallback cache for non-debug mode (@villebro)
- [#19283](https://github.com/apache/superset/pull/19283) fix: Don't allow duplicated tag values in the Select (@michael-s-molina)
- [#19296](https://github.com/apache/superset/pull/19296) fix: default toast position (@suddjian)
- [#19258](https://github.com/apache/superset/pull/19258) fix(sql lab): most recently selected table should appear at the top of the list on the left panel (@diegomedina248)
- [#19223](https://github.com/apache/superset/pull/19223) fix(dashboard): make to show the correct owned objects (@prosdev0107)
- [#19263](https://github.com/apache/superset/pull/19263) fix(presto/trino): Add TIME/TIMESTAMP WITH TIME ZONE (@john-bodley)
- [#19269](https://github.com/apache/superset/pull/19269) fix: write new dataset on update table if it doesn't exist (@eschutho)
- [#19069](https://github.com/apache/superset/pull/19069) fix: custom SQL in Sort By Breaks Bar Chart (@diegomedina248)
- [#19140](https://github.com/apache/superset/pull/19140) fix(chart-crud): make to update Viz type Filter label to Chart type (@prosdev0107)
- [#19242](https://github.com/apache/superset/pull/19242) fix: allow subquery in ad-hoc SQL (@lilykuang)
- [#18926](https://github.com/apache/superset/pull/18926) fix(explore comma): make that the comma can be added by removing it from token separators… (@prosdev0107)
- [#19234](https://github.com/apache/superset/pull/19234) fix: adhoc column in legacy chart (@zhaoyongjie)
- [#19076](https://github.com/apache/superset/pull/19076) fix: allow to select <NULL> in a native filter single mode (@diegomedina248)
- [#19159](https://github.com/apache/superset/pull/19159) fix(select): make to consider the case sensitive in case of d3 format selector (@prosdev0107)
- [#19139](https://github.com/apache/superset/pull/19139) fix: Popovers in Explore not attached to the fields they are triggered by (@diegomedina248)
- [#19152](https://github.com/apache/superset/pull/19152) fix: auto-complete of tables and names are not working in SQL lab (@diegomedina248)
- [#19226](https://github.com/apache/superset/pull/19226) fix: Revert "refactor: converted QueryAutoRefresh to functional component … (@hughhhh)
- [#19158](https://github.com/apache/superset/pull/19158) fix: Logic for showing extension in Global Nav (@hughhhh)
- [#19111](https://github.com/apache/superset/pull/19111) fix(sqllab): Updated blank states for query results and query history (@lyndsiWilliams)
- [#19143](https://github.com/apache/superset/pull/19143) fix: clean up chart metadata config (@suddjian)
- [#19084](https://github.com/apache/superset/pull/19084) fix(dashboard-css): make to stay custom css when reload (@prosdev0107)
- [#19125](https://github.com/apache/superset/pull/19125) fix(dbs-dropdown): make to allow the search in supported db dropdown (@prosdev0107)
- [#19121](https://github.com/apache/superset/pull/19121) fix(dashboard): scrolling table viz overlaps next chart (@diegomedina248)
- [#19023](https://github.com/apache/superset/pull/19023) fix: Add perm for showing DBC-UI in Global Nav (@hughhhh)
- [#19080](https://github.com/apache/superset/pull/19080) fix(dashboard-edge-cutting): make to be not cut without Filter (@prosdev0107)
- [#19110](https://github.com/apache/superset/pull/19110) fix: cache key with guest token rls (@lilykuang)
- [#19095](https://github.com/apache/superset/pull/19095) fix(dashboard): Empty states overflowing small chart containers (@kgabryje)
- [#18947](https://github.com/apache/superset/pull/18947) fix(plugin-chart-echarts): make to allow the custome of x & y axis title margin i… (@prosdev0107)
- [#19088](https://github.com/apache/superset/pull/19088) fix(dashboard): import handle missing excluded charts (@villebro)
- [#19072](https://github.com/apache/superset/pull/19072) fix: Show Totals error with sort and group by together (@codemaster08240328)
- [#19037](https://github.com/apache/superset/pull/19037) fix: Database import error with a new field (@codemaster08240328)
- [#19047](https://github.com/apache/superset/pull/19047) fix: SQL Lab autocomplete for selected tables (@hughhhh)
- [#19071](https://github.com/apache/superset/pull/19071) fix: Pivot Table Conditional Formatting Doesn't Show All Options (@diegomedina248)
- [#19030](https://github.com/apache/superset/pull/19030) fix(allow-db-explore): make that the set the allow-db-explore option (@prosdev0107)
- [#18822](https://github.com/apache/superset/pull/18822) fix(altered-modal): make specified text fields wrap in table (@prosdev0107)
- [#19061](https://github.com/apache/superset/pull/19061) fix: enable find text browser functionality inside SQL Lab editor (@diegomedina248)
- [#19054](https://github.com/apache/superset/pull/19054) fix: show the total row count in the SQL Lab Query History tab when limited by DISPLAY_MAX_ROW (@diegomedina248)
- [#19070](https://github.com/apache/superset/pull/19070) fix: Select clear and loading icons overlap (@michael-s-molina)
- [#19065](https://github.com/apache/superset/pull/19065) fix: Dataset search when creating a chart (@michael-s-molina)
- [#19024](https://github.com/apache/superset/pull/19024) fix(time-series table): display null values in time-series table and sortable (@graceguo-supercat)
- [#19018](https://github.com/apache/superset/pull/19018) fix: ensure validation for db modal for googlesheets (@pkdotson)
- [#19052](https://github.com/apache/superset/pull/19052) fix: add previous line hotkey to SQL Lab for macOS (@diegomedina248)
- [#18690](https://github.com/apache/superset/pull/18690) fix: Update time grain expressions for Spark >= 3.x (@thomasdesr)
- [#19048](https://github.com/apache/superset/pull/19048) fix: remove unnecessary divider (@pkdotson)
- [#19059](https://github.com/apache/superset/pull/19059) fix(deck.gl): make Deck.gl Javascript tooltip generator works correctly (@chanyou0311)
- [#19044](https://github.com/apache/superset/pull/19044) fix: improve cypress flakiness (@etr2460)
- [#19043](https://github.com/apache/superset/pull/19043) fix(big-number): Big Number with Trendline Chart is not working if Time Grain is set to Month (@stephenLYZ)
- [#19040](https://github.com/apache/superset/pull/19040) fix(docs): update impala.mdx with correct product name (@DLT1412)
- [#18951](https://github.com/apache/superset/pull/18951) fix(SQL Editor): names new query tabs correctly (@cccs-Dustin)
- [#18877](https://github.com/apache/superset/pull/18877) fix(nested-tab-available): make the another tabs into one tabs available (@prosdev0107)
- [#18960](https://github.com/apache/superset/pull/18960) fix(chart): deprecate persisting url_params (@villebro)
- [#18973](https://github.com/apache/superset/pull/18973) fix(packages): Fixing users packages (@craig-rueda)
- [#18892](https://github.com/apache/superset/pull/18892) fix(tooltip-not-dissapeared): make the tooltip disappear when mouse away (@prosdev0107)
- [#18982](https://github.com/apache/superset/pull/18982) fix(external-link): change the external link in creating chart dashboard (@prosdev0107)
- [#18963](https://github.com/apache/superset/pull/18963) fix(native-filters): Default value not shown in native filters (@kgabryje)
- [#18958](https://github.com/apache/superset/pull/18958) fix(plugin-chart-echarts): fix customize margin (@stephenLYZ)
- [#18971](https://github.com/apache/superset/pull/18971) fix: add/find owners from report/alert modal (@graceguo-supercat)
- [#18835](https://github.com/apache/superset/pull/18835) fix(Explore): Pivot table V2 sort by failure with D&D enabled (@geido)
- [#18817](https://github.com/apache/superset/pull/18817) fix(sql Lab tabs): Empty SQL Lab tabs (@AAfghahi)
- [#18758](https://github.com/apache/superset/pull/18758) fix: CSV upload with overprescribed table/schema (@john-bodley)
- [#18849](https://github.com/apache/superset/pull/18849) fix: Null schema issue in the list of saved queries. (@codemaster08240328)
- [#18939](https://github.com/apache/superset/pull/18939) fix(deck.gl): multiple layers map size is shrunk (@stephenLYZ)
- [#18695](https://github.com/apache/superset/pull/18695) fix(native-filter): fix required filters of a dashboard won't load properly (@stephenLYZ)
- [#18796](https://github.com/apache/superset/pull/18796) fix: Monospacing errors in dashboards & charts (@codemaster08240328)
- [#18855](https://github.com/apache/superset/pull/18855) fix: Metadata browser in SQL not render nicely in Safari (@codemaster08240328)
- [#18934](https://github.com/apache/superset/pull/18934) fix(sqllab): Un-render deselected tabs (@etr2460)
- [#18853](https://github.com/apache/superset/pull/18853) fix: filter indicator pointing issue on popover (@codemaster08240328)
- [#18911](https://github.com/apache/superset/pull/18911) fix: Set force=true for exporting CSV on dashboard charts (@hughhhh)
- [#18920](https://github.com/apache/superset/pull/18920) fix(docs): add missing static files to build (@villebro)
- [#18894](https://github.com/apache/superset/pull/18894) fix: Source from Apache Foundation's website link (@paulocauca)
- [#18852](https://github.com/apache/superset/pull/18852) fix(dashboard): incorrect chart error with slow dataset api request (@ktmud)
- [#18886](https://github.com/apache/superset/pull/18886) fix: Database list in Docusaurus (@geido)
- [#18857](https://github.com/apache/superset/pull/18857) fix: FilterBox date endpoints to use [inclusive, exclusive) (@etr2460)
- [#18846](https://github.com/apache/superset/pull/18846) fix(key-value): lost url_params after long-url feature (@zhaoyongjie)
- [#18739](https://github.com/apache/superset/pull/18739) fix: Position of arrows in Table chart (@geido)
- [#18789](https://github.com/apache/superset/pull/18789) fix(hive): stop query on the processing engine when user clicks STOP on SQL Lab (@saurabh3091)
- [#18788](https://github.com/apache/superset/pull/18788) fix(Explore): Annotation cache should be ignore when adding new / updated annotation (@geido)
- [#18746](https://github.com/apache/superset/pull/18746) fix(mssql): support top syntax for limiting queries (@sujiplr)
- [#18813](https://github.com/apache/superset/pull/18813) fix(altered-modal): displayed the metric value in altered modal correctly (@prosdev0107)
- [#18749](https://github.com/apache/superset/pull/18749) fix(sqllab): Removed the tooltip from CopyToClipboard button in sqllab (@prosdev0107)
- [#18782](https://github.com/apache/superset/pull/18782) fix: contribution operator meets nan value (@zhaoyongjie)
- [#18756](https://github.com/apache/superset/pull/18756) fix: update standalone url for slack reports (@hughhhh)
- [#18786](https://github.com/apache/superset/pull/18786) fix(delete-modal): Changed the color of the help text with grayScale.dark1 in DeleteModal (@prosdev0107)
- [#18717](https://github.com/apache/superset/pull/18717) fix(Dashboard): Fix blinking native filters on zoom (@geido)
- [#18751](https://github.com/apache/superset/pull/18751) fix(helm): bump Helm chart release version (@wiktor2200)
- [#18738](https://github.com/apache/superset/pull/18738) fix(Explore): Fix cache timeout field not being saved and unit tests (@geido)
- [#18725](https://github.com/apache/superset/pull/18725) fix: report list search by created_by (@graceguo-supercat)
- [#18056](https://github.com/apache/superset/pull/18056) fix(CRUD/listviews): Errors with rison and search strings using special characters (@corbinrobb)
- [#18714](https://github.com/apache/superset/pull/18714) fix: Only redirect to relative paths when authentication expires (@geido)
- [#15246](https://github.com/apache/superset/pull/15246) fix: passing url params in sqllab (@maltoze)
- [#18666](https://github.com/apache/superset/pull/18666) fix(sqllab): fix query results sorting (@corbinrobb)
- [#18686](https://github.com/apache/superset/pull/18686) fix: Fixed dancing tooltip in database list action buttons (@lyndsiWilliams)
- [#18683](https://github.com/apache/superset/pull/18683) fix: unambiguous trino driver (@betodealmeida)
- [#18685](https://github.com/apache/superset/pull/18685) fix(build): update webpack jsx paths (@anoojkinaginlsn)
- [#18684](https://github.com/apache/superset/pull/18684) fix: revert handle null values in time-series table (@graceguo-supercat)
- [#17826](https://github.com/apache/superset/pull/17826) fix(deck.gl): update view state on property changes (#17720) (@hbruch)
- [#18603](https://github.com/apache/superset/pull/18603) fix(Explore): Force different color for same metrics in Mixed Time-Series (@geido)
- [#18658](https://github.com/apache/superset/pull/18658) fix: dataset modal doesn't work in dev mode (@stephenLYZ)
- [#18567](https://github.com/apache/superset/pull/18567) fix(mssql): support cte in virtual tables (@sujiplr)
- [#18633](https://github.com/apache/superset/pull/18633) fix(csv-export): pivot v2 with verbose names (@villebro)
- [#18084](https://github.com/apache/superset/pull/18084) fix(histogram): display correct percentile value instead of formula (@hoangminhquan-lhsdt)
- [#18628](https://github.com/apache/superset/pull/18628) fix: check embedded feature flag in request loader (@lilykuang)
- [#18562](https://github.com/apache/superset/pull/18562) fix: user UUIDs on export for Native Filter Configuration (@hughhhh)
- [#18619](https://github.com/apache/superset/pull/18619) fix(helm): Fix support for ingress.ingressClassName (@ad-m)
- [#18609](https://github.com/apache/superset/pull/18609) fix: change database database selector (@pkdotson)
- [#18601](https://github.com/apache/superset/pull/18601) fix(jest): add superset-frontend to testRegex (@villebro)
- [#18564](https://github.com/apache/superset/pull/18564) fix: sqllab schema select error msg (@pkdotson)
- [#18579](https://github.com/apache/superset/pull/18579) fix(sqla): avoid unnecessary groupby in samples request (@villebro)
- [#18246](https://github.com/apache/superset/pull/18246) fix(listview): add nowrap to view mode container (@villebro)
- [#18577](https://github.com/apache/superset/pull/18577) fix: Update docusaurus.config.js (@hughhhh)
- [#18575](https://github.com/apache/superset/pull/18575) fix: superset-doc.yaml workflow to not be immutable on deploy (@hughhhh)
- [#18182](https://github.com/apache/superset/pull/18182) fix: new alert should have force_screenshot be true (@graceguo-supercat)
- [#18252](https://github.com/apache/superset/pull/18252) fix(plugin-chart-echarts): fix forecasts on verbose metrics (@villebro)
- [#18240](https://github.com/apache/superset/pull/18240) fix(teradata): LIMIT syntax (@dmcnulla)
- [#18224](https://github.com/apache/superset/pull/18224) fix(alert): remove extra < character in email report (@graceguo-supercat)
- [#18201](https://github.com/apache/superset/pull/18201) fix: Build scripts (@geido)
- [#18219](https://github.com/apache/superset/pull/18219) fix: Add mexico back to country map (@etr2460)
- [#18181](https://github.com/apache/superset/pull/18181) fix: Explore long URL problem (@michael-s-molina)
- [#18217](https://github.com/apache/superset/pull/18217) fix(plugin-chart-echarts): use verbose x-axis name when defined (@villebro)
- [#18216](https://github.com/apache/superset/pull/18216) fix(explore): Pie chart label formatting when series is temporal (@kgabryje)
- [#17881](https://github.com/apache/superset/pull/17881) fix(sql): unable to filter text with quotes (@stephenLYZ)
- [#18205](https://github.com/apache/superset/pull/18205) fix(tests): Remove walrus operator for Python 3.7 compatiblity (@ad-m)
- [#18145](https://github.com/apache/superset/pull/18145) fix(native-filters): values is not sorted when setting sort option (@stephenLYZ)
- [#18174](https://github.com/apache/superset/pull/18174) fix(helm): allows extra top-level properties (@ad-m)
- [#18180](https://github.com/apache/superset/pull/18180) fix: Default values getting cleared in native filters form (@geido)
- [#17986](https://github.com/apache/superset/pull/17986) fix: Assign an owner when creating a dataset from a csv, excel or tabular (@cccs-joel)
- [#18171](https://github.com/apache/superset/pull/18171) fix: null value and empty string in filter (@zhaoyongjie)
- [#18137](https://github.com/apache/superset/pull/18137) fix(dashboard): support input undo when editing chart title (@stephenLYZ)
- [#18157](https://github.com/apache/superset/pull/18157) fix: remove standalone (@AAfghahi)
- [#18164](https://github.com/apache/superset/pull/18164) fix: Dataset column names are no longer editable (@lyndsiWilliams)
- [#18117](https://github.com/apache/superset/pull/18117) fix: exclude node_modules from ts tracking (@etr2460)
- [#18146](https://github.com/apache/superset/pull/18146) fix(textarea-control): ace editor input exception (@stephenLYZ)
- [#18046](https://github.com/apache/superset/pull/18046) fix(import_datasources): --sync flag works correctly (@cccs-Dustin)
- [#18152](https://github.com/apache/superset/pull/18152) fix: undefined error when adding extra sequential color scheme (@kgabryje)
- [#17843](https://github.com/apache/superset/pull/17843) fix(explore): fix chart embed code modal glitch (@stephenLYZ)
- [#18111](https://github.com/apache/superset/pull/18111) fix: logging warning on dataframe (don't use python's warnings) (@dpgaspar)
- [#18089](https://github.com/apache/superset/pull/18089) fix(docs): load correctly image for "Create New Chart" (@ad-m)
- [#18097](https://github.com/apache/superset/pull/18097) fix: contributing misspelling (@em0227)
- [#18086](https://github.com/apache/superset/pull/18086) fix: can't use examples helpers on non app context based environment (@ofekisr)
- [#18087](https://github.com/apache/superset/pull/18087) fix(docs): Correction of proper names format in README (@ad-m)
- [#18073](https://github.com/apache/superset/pull/18073) fix(generator): add lockfile and fix styling issues (@villebro)
- [#18027](https://github.com/apache/superset/pull/18027) fix(generator): more cleanup to plugin framework (@villebro)
- [#18051](https://github.com/apache/superset/pull/18051) fix: revert "feat: stop running CI on doc updates" (@hughhhh)
- [#18039](https://github.com/apache/superset/pull/18039) fix: handle null values in time-series table (@graceguo-supercat)
- [#18021](https://github.com/apache/superset/pull/18021) fix: Disable filtering on wide result sets (@etr2460)
- [#18017](https://github.com/apache/superset/pull/18017) fix: revert #17654 to fix subselect table name parsing (@etr2460)
- [#17995](https://github.com/apache/superset/pull/17995) fix: Workaround for sqlparse issue #652 (@john-bodley)
- [#17388](https://github.com/apache/superset/pull/17388) fix(sqla): Adhere to series limit ordering for pre-query (@john-bodley)
- [#17999](https://github.com/apache/superset/pull/17999) fix(helm): pin correct psycopg2 version (@villebro)
- [#17988](https://github.com/apache/superset/pull/17988) fix: Keep Report modal open when there's an error (@lyndsiWilliams)
- [#17985](https://github.com/apache/superset/pull/17985) fix: dashboard full screen layout (@pkdotson)
- [#17931](https://github.com/apache/superset/pull/17931) fix(sqllab): Dancing Tooltip in SQL editor dropdown (@lyndsiWilliams)
- [#17974](https://github.com/apache/superset/pull/17974) fix: null dates in table chart (@etr2460)
- [#17878](https://github.com/apache/superset/pull/17878) fix: Returns 404 instead of 500 for unknown dashboard filter state keys (@michael-s-molina)
- [#17982](https://github.com/apache/superset/pull/17982) fix(native-filters): apply default value correctly when it's set (@kgabryje)
- [#17937](https://github.com/apache/superset/pull/17937) fix(docs): update clickhouse.mdx (@rfraposa)
- [#17951](https://github.com/apache/superset/pull/17951) fix(Select): options in the select component will be overwritten due to timing of React.setState (@stephenLYZ)
- [#17957](https://github.com/apache/superset/pull/17957) fix: package.json local file dependencies (@etr2460)
- [#17786](https://github.com/apache/superset/pull/17786) fix: process color scheme configs correctly (@suddjian)
- [#17918](https://github.com/apache/superset/pull/17918) fix(cypress): flake cypress test case (@zhaoyongjie)
- [#17920](https://github.com/apache/superset/pull/17920) fix(helm): service account apiVersion indentation (@wiktor2200)
- [#17877](https://github.com/apache/superset/pull/17877) fix(translation): include babel-compile in Dockerfile (#17876) (@hbruch)
- [#17872](https://github.com/apache/superset/pull/17872) fix(explore): simple tab content input problem in the filter control (@stephenLYZ)
- [#17887](https://github.com/apache/superset/pull/17887) fix: Removes duplicated import in dashboard filter state tests (@michael-s-molina)
- [#17885](https://github.com/apache/superset/pull/17885) fix: tests can failed on different order executions (@ofekisr)
- [#17886](https://github.com/apache/superset/pull/17886) fix: failed mypy in master branch (@ofekisr)
- [#17854](https://github.com/apache/superset/pull/17854) fix(ui): show SCHEDULED_QUERIES template in SqlLab (@cemremengu)
- [#17851](https://github.com/apache/superset/pull/17851) fix(deckgl): deckgl unable to load map (@zhaoyongjie)
- [#17856](https://github.com/apache/superset/pull/17856) fix: corrected misspelling in percent_metrics (@briannguyen4)
- [#17784](https://github.com/apache/superset/pull/17784) fix: extra column in metrics (@betodealmeida)
- [#17740](https://github.com/apache/superset/pull/17740) fix: dataset extra import/export (@betodealmeida)
- [#17680](https://github.com/apache/superset/pull/17680) fix: replace datamask with key from new key value api (@pkdotson)
- [#17726](https://github.com/apache/superset/pull/17726) fix(explore): make SORT DESCENDING visible if SORT BY has value (@stephenLYZ)
- [#17823](https://github.com/apache/superset/pull/17823) fix: import typeddict from extensions (@villebro)
- [#17813](https://github.com/apache/superset/pull/17813) fix: map schemes json to SequentialScheme (#17812) (@hbruch)
- [#17788](https://github.com/apache/superset/pull/17788) fix: accept null params for validation (@eschutho)
- [#17800](https://github.com/apache/superset/pull/17800) fix(docs): bump broken packages (@villebro)
- [#17751](https://github.com/apache/superset/pull/17751) fix: [alert] allow decimal for alert threshold value (@graceguo-supercat)
- [#17783](https://github.com/apache/superset/pull/17783) fix: New Members per Month time range (@betodealmeida)
- [#17775](https://github.com/apache/superset/pull/17775) fix: running dev-server on a different port (@betodealmeida)
- [#17499](https://github.com/apache/superset/pull/17499) fix: [alert] should run alert query from report account (@graceguo-supercat)
- [#17777](https://github.com/apache/superset/pull/17777) fix(filter-sets): 404 on dashboard load (@villebro)
- [#17774](https://github.com/apache/superset/pull/17774) fix(alembic): Making Alembic logger config optional (@craig-rueda)
- [#17768](https://github.com/apache/superset/pull/17768) fix: change 401 response to a 403 for Security Exceptions (@rusackas)
- [#17760](https://github.com/apache/superset/pull/17760) fix: miss-spelling on CONTRIBUTING.md line 1351 (@MayUWish)
- [#17765](https://github.com/apache/superset/pull/17765) fix(plugin-chart-table): sort alphanumeric columns case insensitive (@kgabryje)
- [#17730](https://github.com/apache/superset/pull/17730) fix: add **init**.py to key_value (@bkyryliuk)
- [#17727](https://github.com/apache/superset/pull/17727) fix: local warning in the frontend development (@stephenLYZ)
- [#17738](https://github.com/apache/superset/pull/17738) fix: column extra in import/export (@betodealmeida)
- [#17748](https://github.com/apache/superset/pull/17748) fix: import DB errors (@betodealmeida)
- [#17741](https://github.com/apache/superset/pull/17741) fix: import dashboard stale filter_scopes (@betodealmeida)
- [#17649](https://github.com/apache/superset/pull/17649) fix(Mixed Timeseries Chart): Custom Metric Label (@Yahyakiani)
- [#17732](https://github.com/apache/superset/pull/17732) fix: import dash with missing immune ID (@betodealmeida)
- [#17713](https://github.com/apache/superset/pull/17713) fix(postgres): remove redundant tz factory (@villebro)
- [#17711](https://github.com/apache/superset/pull/17711) fix(explore): don't apply time range filter to Samples table (@kgabryje)
- [#17690](https://github.com/apache/superset/pull/17690) fix: Dashboard header negative margin on save (@geido)
- [#17703](https://github.com/apache/superset/pull/17703) fix(explore): deck.gl Multiple chart broken (@stephenLYZ)
- [#17638](https://github.com/apache/superset/pull/17638) fix(select): select component sort functionality on certain options (@corbinrobb)
- [#17692](https://github.com/apache/superset/pull/17692) fix(Dashboard): Undefined error in default value in Native Filters (@geido)
- [#17597](https://github.com/apache/superset/pull/17597) fix: Redirect on 401 (@geido)
- [#17654](https://github.com/apache/superset/pull/17654) fix: extract tables doesn't work with reserved keywords (@betodealmeida)
- [#17673](https://github.com/apache/superset/pull/17673) fix(translations): extract messages from js and ts files (@hbruch)
- [#17664](https://github.com/apache/superset/pull/17664) fix(legacy-plugin-chart-calendar): fix timestamp timezone in Calendar (@kgabryje)
- [#17644](https://github.com/apache/superset/pull/17644) fix: Allows PUT and DELETE only for owners of dashboard filter state (@michael-s-molina)
- [#17641](https://github.com/apache/superset/pull/17641) fix(sqla): make text clause escaping optional (@villebro)
- [#17636](https://github.com/apache/superset/pull/17636) fix: allow for multiple columns in pivot table report (@eschutho)
- [#17612](https://github.com/apache/superset/pull/17612) fix(dataset): modal sql editor error (@stephenLYZ)
- [#17620](https://github.com/apache/superset/pull/17620) fix(api): add missing fields to dataset schemas (@villebro)
- [#17618](https://github.com/apache/superset/pull/17618) fix: Revert "fix(Dashboard): Only apply changes when editing properties" (@geido)
- [#17613](https://github.com/apache/superset/pull/17613) fix: Dashboard export loading indicator (@michael-s-molina)
- [#17611](https://github.com/apache/superset/pull/17611) fix: Dashboard API flaky test (@michael-s-molina)
- [#17600](https://github.com/apache/superset/pull/17600) fix: Ch31968query context (@AAfghahi)
- [#17547](https://github.com/apache/superset/pull/17547) fix: fix text overflow in toast (@pkdotson)
- [#17542](https://github.com/apache/superset/pull/17542) fix: Visualizations don't load when using keyboard shortcuts (@michael-s-molina)
- [#17539](https://github.com/apache/superset/pull/17539) fix(superset.cli): superset cli group doesn't support superset extension app (@ofekisr)
- [#14512](https://github.com/apache/superset/pull/14512) fix: update kubernetes.mdx (@shicholas)
- [#17527](https://github.com/apache/superset/pull/17527) fix: RBAC for `can_export` for any resource (@hughhhh)
- [#17555](https://github.com/apache/superset/pull/17555) fix(lint): remove redis xadd type ignore (@villebro)
- [#17048](https://github.com/apache/superset/pull/17048) fix(elasticsearch): time_zone setting does not work for cast datetime expressions (@aniaan)
- [#17503](https://github.com/apache/superset/pull/17503) fix(explore): Metric control breaks when saved metric deleted from dataset (@kgabryje)
- [#17515](https://github.com/apache/superset/pull/17515) fix(CRUD views): change empty rows layout in TableCollection to be consistent with its headers (@corbinrobb)
- [#15182](https://github.com/apache/superset/pull/15182) fix: hiding HiddenControl inputs for real, so they don't add height (@rusackas)
- [#17511](https://github.com/apache/superset/pull/17511) fix: Dashboard access when DASHBOARD_RBAC is disabled (@michael-s-molina)
- [#16799](https://github.com/apache/superset/pull/16799) fix: Bulk update Spanish translations (@dreglad)
- [#14302](https://github.com/apache/superset/pull/14302) fix(hive): Update \_latest_partition_from_df in HiveEngineSpec to work on tables with multiple indexes (@codenamelxl)
- [#17458](https://github.com/apache/superset/pull/17458) fix: Always use temporal type for dttm columns [ID-2] (@kgabryje)
- [#17470](https://github.com/apache/superset/pull/17470) fix(presto): expand data with null item (@ganczarek)
- [#15254](https://github.com/apache/superset/pull/15254) fix: feature flags typing (@dpgaspar)
- [#17480](https://github.com/apache/superset/pull/17480) fix: Update Makefile (@hughhhh)
- [#17471](https://github.com/apache/superset/pull/17471) fix: create-admin command in Makefile (@hughhhh)
- [#17462](https://github.com/apache/superset/pull/17462) fix(Dashboard): Save empty label_colors in json_metadata (@geido)
- [#14305](https://github.com/apache/superset/pull/14305) fix(views/core): iteration over None type (@rasta-rocket)
- [#16566](https://github.com/apache/superset/pull/16566) fix(docker): add ecpg to docker image (@villebro)
- [#10811](https://github.com/apache/superset/pull/10811) fix(mssql): week time grain should respect datefirst setting (@binome74)
- [#17440](https://github.com/apache/superset/pull/17440) fix: should not show migration toast if user not enable dashboard filter components (@graceguo-supercat)
- [#17385](https://github.com/apache/superset/pull/17385) fix(sql lab): NULL styling in grid cell (@lyndsiWilliams)
- [#12092](https://github.com/apache/superset/pull/12092) fix: 'DataFrame' object has no attribute 'ix' (@minzhang2110)
- [#17429](https://github.com/apache/superset/pull/17429) fix: allow POST chart/data request without CSRF token (@etr2460)
- [#16900](https://github.com/apache/superset/pull/16900) fix(chart): ensure samples data is displayed (@pkdotson)
- [#17426](https://github.com/apache/superset/pull/17426) fix: Workaround for Pandas Timestamp.isoformat issue (@john-bodley)
- [#17392](https://github.com/apache/superset/pull/17392) fix(Dashboard): Only apply changes when editing properties (@geido)
- [#17380](https://github.com/apache/superset/pull/17380) fix(Dashboard): Missing dashboardId when refreshing Explore (@geido)
- [#17106](https://github.com/apache/superset/pull/17106) fix(dashboard): don't show report modal for anonymous user (@Mayur)
- [#17135](https://github.com/apache/superset/pull/17135) fix: title case in menus (@Maxime Beauchemin)
- [#17383](https://github.com/apache/superset/pull/17383) fix: Partial revert of 17236 (@john-bodley)
- [#17348](https://github.com/apache/superset/pull/17348) fix: Users being able to update datasets across DBs (@hughhhh)
- [#17382](https://github.com/apache/superset/pull/17382) fix(sqllab): Query limit dropdown number breaks to separate lines (@lyndsiWilliams)
- [#17309](https://github.com/apache/superset/pull/17309) fix: various typo fixes in MD files (@PApostol)
- [#17370](https://github.com/apache/superset/pull/17370) fix: failed timezone selector UT (@zhaoyongjie)
- [#17369](https://github.com/apache/superset/pull/17369) fix: Database selector overflow (@michael-s-molina)
- [#17356](https://github.com/apache/superset/pull/17356) fix: Remove horizontal scroll navigation from SQL Lab (@etr2460)
- [#17357](https://github.com/apache/superset/pull/17357) fix(Dashboard): Make color scheme optional (@geido)
- [#17287](https://github.com/apache/superset/pull/17287) fix(dashboard): Return columns and verbose_map for groupby values of Pivot Table v2 [ID-7] (@kgabryje)
- [#17331](https://github.com/apache/superset/pull/17331) fix: Show sqllab state when deleting databases (@hughhhh)
- [#17289](https://github.com/apache/superset/pull/17289) fix: removed redundant logger definition (@gnought)
- [#17236](https://github.com/apache/superset/pull/17236) fix: revert default series sort-by metric (@john-bodley)
- [#17312](https://github.com/apache/superset/pull/17312) fix(sqla): Normalize prequery result type (@john-bodley)
- [#17268](https://github.com/apache/superset/pull/17268) fix: Unable to select None for Alert's log retention (@michael-s-molina)
- [#17228](https://github.com/apache/superset/pull/17228) fix: remove variables from styled component (@pkdotson)
- [#17200](https://github.com/apache/superset/pull/17200) fix(Dashboard): Sidepanel positioning (@geido)
- [#17184](https://github.com/apache/superset/pull/17184) fix(Explore): Remove changes to the properties on cancel (@geido)
- [#17314](https://github.com/apache/superset/pull/17314) fix: run npm install to fix a bad package version (@eschutho)
- [#17303](https://github.com/apache/superset/pull/17303) fix: datatable crash when column is empty string [ID-59] (@zhaoyongjie)
- [#17292](https://github.com/apache/superset/pull/17292) fix: Change 500 error to 422 in Sql Lab (@AAfghahi)
- [#17239](https://github.com/apache/superset/pull/17239) fix: revert "feat(sqla): apply time grain to all temporal groupbys" (@john-bodley)
- [#17223](https://github.com/apache/superset/pull/17223) fix(reports): Owners no longer showing undefined in reports (@lyndsiWilliams)
- [#17242](https://github.com/apache/superset/pull/17242) fix: Updated connection string for Firebolt (@raghavSharmaCode)
- [#17234](https://github.com/apache/superset/pull/17234) fix(annotations): handle required fields properly (@villebro)
- [#17217](https://github.com/apache/superset/pull/17217) fix(dashboard): Fix issue #17144 - Resetting native filter form does not clear the values. (@m-ajay)
- [#17221](https://github.com/apache/superset/pull/17221) fix(Dashboard): Position of the tools of the Tabs component in Edit Dashboard (@geido)
- [#17047](https://github.com/apache/superset/pull/17047) fix: Allow chart owners to edit title (@belgren)
- [#17205](https://github.com/apache/superset/pull/17205) fix: reenabling terser plugin for webpack (@rusackas)
- [#17194](https://github.com/apache/superset/pull/17194) fix: use cache for csv download (@eschutho)
- [#17169](https://github.com/apache/superset/pull/17169) fix: Order of Select items when unselecting (@michael-s-molina)
- [#17213](https://github.com/apache/superset/pull/17213) fix: CI is blocked by mypy checking (@zhaoyongjie)
- [#17196](https://github.com/apache/superset/pull/17196) fix(bigquery): calculated column cannot orderby in BigQuery (@zhaoyongjie)
- [#17195](https://github.com/apache/superset/pull/17195) fix(sqla): convert prequery results to native python types (@villebro)
- [#17112](https://github.com/apache/superset/pull/17112) fix: auto refresh interval won't be updated (@yougyoung94)
- [#17046](https://github.com/apache/superset/pull/17046) fix: dropdown placement for cascading filters popover (@pkdotson)
- [#17166](https://github.com/apache/superset/pull/17166) fix(explore): timestamp format when copy datatable to clipboard (@kgabryje)
- [#17168](https://github.com/apache/superset/pull/17168) fix: avoid filters containing null value (@zhaoyongjie)
- [#17155](https://github.com/apache/superset/pull/17155) fix: preventing sql lab None limit value (@amitmiran137)
- [#17147](https://github.com/apache/superset/pull/17147) fix: Remove title from the Cancel SVG (@AAfghahi)
- [#17125](https://github.com/apache/superset/pull/17125) fix: Update package-lock.json of superset-frontend and cypress-base (@lyndsiWilliams)
- [#17079](https://github.com/apache/superset/pull/17079) fix(druid): Fix regression with ISO 8601 format (@john-bodley)
- [#17024](https://github.com/apache/superset/pull/17024) fix(DB Connections): removing paramProperties (@AAfghahi)
- [#17008](https://github.com/apache/superset/pull/17008) fix: Strict check to allow null values in the SelectControl component (@geido)
- [#16838](https://github.com/apache/superset/pull/16838) fix: remove duplicate line in docstring (@exemplary-citizen)

**Others**

- [#19732](https://github.com/apache/superset/pull/19732) chore: Clean redundant dependency from useMemo dep array (@kgabryje)
- [#19636](https://github.com/apache/superset/pull/19636) chore: skip SIP-68 shadow writing for LTS (@ktmud)
- [#19530](https://github.com/apache/superset/pull/19530) docs: release notes for 1.5 (@villebro)
- [#19557](https://github.com/apache/superset/pull/19557) chore: remove redundant adodbapi warning (@villebro)
- [#19481](https://github.com/apache/superset/pull/19481) chore(plugin-chart-echarts): upgrade echarts 5.3.2 (@villebro)
- [#19392](https://github.com/apache/superset/pull/19392) test(native filter): add new test for dependent filter (@jinghua-qa)
- [#19417](https://github.com/apache/superset/pull/19417) refactor: Removes the CSS files from the Heatmap plugin (@michael-s-molina)
- [#19436](https://github.com/apache/superset/pull/19436) refactor: Removes the CSS files from the Calendar Heatmap plugin (@michael-s-molina)
- [#19439](https://github.com/apache/superset/pull/19439) chore: Removes hard-coded colors from plugin-chart-pivot-table (@michael-s-molina)
- [#19443](https://github.com/apache/superset/pull/19443) chore: Removes hard-coded colors from legacy-preset-chart-nvd3 (@michael-s-molina)
- [#19411](https://github.com/apache/superset/pull/19411) docs: add 1.4.2 changelog entries (@villebro)
- [#19437](https://github.com/apache/superset/pull/19437) chore: Disables no-literal-colors for the theme configuration (@michael-s-molina)
- [#19424](https://github.com/apache/superset/pull/19424) chore: attempt to force docs deploy (@srinify)
- [#19412](https://github.com/apache/superset/pull/19412) chore: update slack invite url (@srinify)
- [#19368](https://github.com/apache/superset/pull/19368) chore: Removes direct theme imports (@michael-s-molina)
- [#19245](https://github.com/apache/superset/pull/19245) chore: bump storybook to 6.4.19, migrating config, and linting storybook config (@rusackas)
- [#19239](https://github.com/apache/superset/pull/19239) chore: Eslint custom plugin to warn about hex and literal colors (@geido)
- [#19390](https://github.com/apache/superset/pull/19390) docs: Correcting the document font size (@sujiplr)
- [#19387](https://github.com/apache/superset/pull/19387) chore: add type checking in plugin's test directory (@stephenLYZ)
- [#19365](https://github.com/apache/superset/pull/19365) chore: add support for npm8 (@villebro)
- [#19350](https://github.com/apache/superset/pull/19350) docs: update lock + general cleanup (@villebro)
- [#19331](https://github.com/apache/superset/pull/19331) docs: fix: Use three backticks for code blocks (@kaapstorm)
- [#19320](https://github.com/apache/superset/pull/19320) chore: add type checking in package tests directory (@stephenLYZ)
- [#19233](https://github.com/apache/superset/pull/19233) docs: SECRET_KEY Rotation Documentation (@sujiplr)
- [#19323](https://github.com/apache/superset/pull/19323) chore: bump FAB to 3.4.5 (@dpgaspar)
- [#19322](https://github.com/apache/superset/pull/19322) ci: add more code owners to helm chart source (@dpgaspar)
- [#19295](https://github.com/apache/superset/pull/19295) chore: fixing a pluralization typo (@rusackas)
- [#19236](https://github.com/apache/superset/pull/19236) chore: Make font-weights themable, fix font faces (@kgabryje)
- [#19293](https://github.com/apache/superset/pull/19293) chore: allow overriding the guest token pyjwt instance (@suddjian)
- [#19161](https://github.com/apache/superset/pull/19161) chore: add missing keys in components inside lists (@diegomedina248)
- [#18221](https://github.com/apache/superset/pull/18221) chore: Various docstring fixes (@PApostol)
- [#19270](https://github.com/apache/superset/pull/19270) docs: update readme.md (@prassanna-helixsense-com)
- [#18648](https://github.com/apache/superset/pull/18648) chore: update changelog and updating files from 1.4.1 (@eschutho)
- [#19235](https://github.com/apache/superset/pull/19235) docs: fix broken links in the documentation (@vchrombie)
- [#19172](https://github.com/apache/superset/pull/19172) chore: use order_desc shared control consistently (@stephenLYZ)
- [#19227](https://github.com/apache/superset/pull/19227) chore: upgrade mypy check in pre-commit (@ktmud)
- [#19216](https://github.com/apache/superset/pull/19216) chore: refactor import command (@betodealmeida)
- [#19156](https://github.com/apache/superset/pull/19156) test: fix TimezoneSelector tests on daylight saving time (@ktmud)
- [#19115](https://github.com/apache/superset/pull/19115) test(native filter): add new native filter test (@jinghua-qa)
- [#19132](https://github.com/apache/superset/pull/19132) chore(embedded): refresh the guest token (@suddjian)
- [#19090](https://github.com/apache/superset/pull/19090) refactor(TimezoneSelector): simplify override logics and tests (@ktmud)
- [#19091](https://github.com/apache/superset/pull/19091) docs: Modified alerts and reports docs for clarity (@7vikpeculiar)
- [#19077](https://github.com/apache/superset/pull/19077) perf(dashboard): Send chart requests before native filter requests (@kgabryje)
- [#19064](https://github.com/apache/superset/pull/19064) perf(dashboard): Improve performance of complex dashboards (@kgabryje)
- [#18950](https://github.com/apache/superset/pull/18950) chore: Change Sort by and Sort descending controls for Time-series Bar Chart (@geido)
- [#14064](https://github.com/apache/superset/pull/14064) chore: log multiple errors (@eschutho)
- [#19068](https://github.com/apache/superset/pull/19068) docs: renamed yugabyte to yugabytedb (@srinify)
- [#19029](https://github.com/apache/superset/pull/19029) chore: Moves Chart components to src/components folder (@michael-s-molina)
- [#19050](https://github.com/apache/superset/pull/19050) docs(building): link frontend asset instructions correctly (@cancan101)
- [#19041](https://github.com/apache/superset/pull/19041) chore(plugin-chart-echarts): bump echarts 5.3.1 (@villebro)
- [#18965](https://github.com/apache/superset/pull/18965) chore: adding Dutch language translations (NL) (@pablo-guerra)
- [#19032](https://github.com/apache/superset/pull/19032) chore: Moves CRUD components to the Datasource component (@michael-s-molina)
- [#19042](https://github.com/apache/superset/pull/19042) chore: Fix deprecated unittest aliases. (@tirkarthi)
- [#18999](https://github.com/apache/superset/pull/18999) refactor: Deletes the common/components folder (@michael-s-molina)
- [#19021](https://github.com/apache/superset/pull/19021) chore: change case for upload selection (@pkdotson)
- [#19019](https://github.com/apache/superset/pull/19019) chore(deps): bump url-parse from 1.5.7 to 1.5.10 in /docs (@dependabot[bot])
- [#18976](https://github.com/apache/superset/pull/18976) chore(cache): default to SimpleCache in debug mode (@villebro)
- [#18983](https://github.com/apache/superset/pull/18983) docs: renamed yugabytedb to yugabyte as per request by Yugabyte team (@srinify)
- [#18179](https://github.com/apache/superset/pull/18179) refactor: converted QueryAutoRefresh to functional component (@briannguyen4)
- [#18922](https://github.com/apache/superset/pull/18922) chore(deps): bump urijs and xss (@villebro)
- [#18967](https://github.com/apache/superset/pull/18967) chore(native-filters): Add unit tests for filter cards (@kgabryje)
- [#16860](https://github.com/apache/superset/pull/16860) chore(security): Remove obsolete FAB metric_access permission (@john-bodley)
- [#18955](https://github.com/apache/superset/pull/18955) docs: fix sql templating typos (@garyng)
- [#18931](https://github.com/apache/superset/pull/18931) chore: Moves components out of the commons folder (@michael-s-molina)
- [#18915](https://github.com/apache/superset/pull/18915) test(Native Filter): User can create parent filters using "Filter is hierarchical (@jinghua-qa)
- [#18811](https://github.com/apache/superset/pull/18811) chore: add intersect method from backend to fontend for upload extensions (@pkdotson)
- [#18935](https://github.com/apache/superset/pull/18935) chore: update `UPDATING.md` re: SIP-68 (@betodealmeida)
- [#18866](https://github.com/apache/superset/pull/18866) refactor(ImportModelsCommand): clean code, extract logic into methods (@michael-hoffman-26)
- [#18850](https://github.com/apache/superset/pull/18850) test(native filter): add new native filter test for time column filter (@jinghua-qa)
- [#18923](https://github.com/apache/superset/pull/18923) refactor(docs): clean up deploy of static files (@villebro)
- [#18914](https://github.com/apache/superset/pull/18914) docs: remove old viz plugin docs (@villebro)
- [#17977](https://github.com/apache/superset/pull/17977) chore(deps-dev): bump css-loader from 6.2.0 to 6.5.1 in /superset-frontend (@dependabot[bot])
- [#18882](https://github.com/apache/superset/pull/18882) docs(Import API): update function description, overwrite real meaning (@michael-hoffman-26)
- [#18854](https://github.com/apache/superset/pull/18854) chore(tests-backend): migrate snowflake and sqlite to unit tests (@corbinrobb)
- [#18878](https://github.com/apache/superset/pull/18878) docs: fix toc position scroll bug (#18868) (@michaelzusev)
- [#18861](https://github.com/apache/superset/pull/18861) docs: add GA conf to config (@villebro)
- [#18820](https://github.com/apache/superset/pull/18820) chore: npm audit fix in cypress-base (@rusackas)
- [#18828](https://github.com/apache/superset/pull/18828) chore: unify usages of nvd3 library (@stephenLYZ)
- [#18819](https://github.com/apache/superset/pull/18819) docs: fix typo in configuring-superset.mdx (@ardeego)
- [#18824](https://github.com/apache/superset/pull/18824) docs: add Unvired to INTHEWILD.md (@srinisubramanian)
- [#18818](https://github.com/apache/superset/pull/18818) docs: add_db_logos (@srinify)
- [#18815](https://github.com/apache/superset/pull/18815) docs: Added reference and link to configure instructions for docker-compose… (@jacobcroope)
- [#18810](https://github.com/apache/superset/pull/18810) refactor: move date_parser to unittest (@zhaoyongjie)
- [#18798](https://github.com/apache/superset/pull/18798) chore(readme): Adding pinot logo into Readme Supported Databases Section (@xiangfu0)
- [#18800](https://github.com/apache/superset/pull/18800) docs(pinot): Update pinot docs with fixed pinot connection (@xiangfu0)
- [#18805](https://github.com/apache/superset/pull/18805) chore(deps): bump hosted-git-info from 2.7.1 to 2.8.9 in /superset-frontend (@dependabot[bot])
- [#18804](https://github.com/apache/superset/pull/18804) chore(deps): bump url-parse from 1.5.3 to 1.5.7 in /docs (@dependabot[bot])
- [#18801](https://github.com/apache/superset/pull/18801) chore(FF): adding generic X axis Feature Flag (default: False) (@rusackas)
- [#18142](https://github.com/apache/superset/pull/18142) refactor: migrate ExploreCtasResultsButton component to typescript (@EugeneTorap)
- [#18761](https://github.com/apache/superset/pull/18761) chore(deps): bump cached-path-relative from 1.0.2 to 1.1.0 in /superset-frontend/cypress-base (@dependabot[bot])
- [#18765](https://github.com/apache/superset/pull/18765) chore(deps): bump y18n from 4.0.0 to 4.0.3 in /superset-frontend (@dependabot[bot])
- [#18769](https://github.com/apache/superset/pull/18769) chore(deps): bump ws from 5.2.2 to 5.2.3 in /superset-frontend (@dependabot[bot])
- [#18779](https://github.com/apache/superset/pull/18779) refactor: move post_processing to unittest (@zhaoyongjie)
- [#18767](https://github.com/apache/superset/pull/18767) chore(deps): bump shelljs from 0.8.4 to 0.8.5 in /superset-frontend (@dependabot[bot])
- [#18764](https://github.com/apache/superset/pull/18764) chore(deps): bump follow-redirects from 1.14.3 to 1.14.8 in /superset-frontend (@dependabot[bot])
- [#18762](https://github.com/apache/superset/pull/18762) chore(deps): bump underscore from 1.12.0 to 1.12.1 in /superset-frontend (@dependabot[bot])
- [#18772](https://github.com/apache/superset/pull/18772) chore(deps): bump path-parse from 1.0.6 to 1.0.7 in /superset-frontend (@dependabot[bot])
- [#18759](https://github.com/apache/superset/pull/18759) chore(deps): bump shelljs from 0.8.4 to 0.8.5 in /docs (@dependabot[bot])
- [#18760](https://github.com/apache/superset/pull/18760) chore(deps): bump follow-redirects from 1.14.5 to 1.14.8 in /docs (@dependabot[bot])
- [#18763](https://github.com/apache/superset/pull/18763) chore(deps): bump nanoid from 3.1.30 to 3.3.1 in /docs (@dependabot[bot])
- [#18766](https://github.com/apache/superset/pull/18766) chore(deps-dev): bump node-fetch from 2.6.1 to 2.6.7 in /superset-frontend (@dependabot[bot])
- [#18768](https://github.com/apache/superset/pull/18768) chore(deps): bump tmpl from 1.0.4 to 1.0.5 in /superset-frontend (@dependabot[bot])
- [#18770](https://github.com/apache/superset/pull/18770) chore(deps): bump dns-packet from 1.3.1 to 1.3.4 in /superset-frontend (@dependabot[bot])
- [#18771](https://github.com/apache/superset/pull/18771) chore(deps): bump url-parse from 1.4.7 to 1.5.7 in /superset-frontend (@dependabot[bot])
- [#18629](https://github.com/apache/superset/pull/18629) chore: move data nav menu to plus menu (@pkdotson)
- [#18705](https://github.com/apache/superset/pull/18705) chore: bumping caniuse-lite from 1.0.30001257 to 1.0.30001312 (@rusackas)
- [#18728](https://github.com/apache/superset/pull/18728) chore: use switchboard as dependency for embedded sdk (@suddjian)
- [#18121](https://github.com/apache/superset/pull/18121) refactor: migrate QueryAndSaveBtns to TypeScript and add stories (@ad-m)
- [#18664](https://github.com/apache/superset/pull/18664) chore: Remove non-breaking changes from UPDATING.md (@john-bodley)
- [#18707](https://github.com/apache/superset/pull/18707) chore: updating link to newer viz plugin blog post (@rusackas)
- [#18710](https://github.com/apache/superset/pull/18710) refactor: decouple pandas postprocessing operator (@zhaoyongjie)
- [#18708](https://github.com/apache/superset/pull/18708) chore: remove config of temporary_superset_ui (@zhaoyongjie)
- [#18709](https://github.com/apache/superset/pull/18709) docs: add docs for viz plugin development (@villebro)
- [#18706](https://github.com/apache/superset/pull/18706) chore: removing temporary_superset_ui folder (no longer needed) (@rusackas)
- [#18669](https://github.com/apache/superset/pull/18669) test(Native filter): add cypress test user can add time grain filter (@jinghua-qa)
- [#18621](https://github.com/apache/superset/pull/18621) chore: Add craig-rueda as codeowner of Helm Chart (@ad-m)
- [#18136](https://github.com/apache/superset/pull/18136) refactor: migrate DeleteComponentButton to TypeScript (@Scrip7)
- [#17944](https://github.com/apache/superset/pull/17944) chore: migrate QueryTable component from jsx to tsx (@MayUWish)
- [#18608](https://github.com/apache/superset/pull/18608) chore: improve React.useRef etc. import consistency (@ad-m)
- [#18647](https://github.com/apache/superset/pull/18647) test(native filter): add test for time range filter (@jinghua-qa)
- [#18581](https://github.com/apache/superset/pull/18581) chore: Update Docusaurus links (@geido)
- [#18120](https://github.com/apache/superset/pull/18120) refactor: migrate SliderControl to TypeScript & added story (@ad-m)
- [#18657](https://github.com/apache/superset/pull/18657) chore(docs): add note about quote handling in filters (@villebro)
- [#17939](https://github.com/apache/superset/pull/17939) refactor(ExploreCtasResultsButton): convert to functional component (@ChristopherCFleming)
- [#18558](https://github.com/apache/superset/pull/18558) chore: Rename and reposition native filter modal fields (@michael-s-molina)
- [#18143](https://github.com/apache/superset/pull/18143) refactor: migrate ExploreResultsButton component to FC & tsx (@EugeneTorap)
- [#18200](https://github.com/apache/superset/pull/18200) chore: upgrade BoundsControl to TS (@ad-m)
- [#18585](https://github.com/apache/superset/pull/18585) chore: allow sqla docs to use supersettext (@pkdotson)
- [#18144](https://github.com/apache/superset/pull/18144) refactor: remove redundant propTypes in ColumnElement (@EugeneTorap)
- [#18600](https://github.com/apache/superset/pull/18600) docs: fixed URL for contributing landing page (@srinify)
- [#18580](https://github.com/apache/superset/pull/18580) docs: add password example to dataset import API (@villebro)
- [#17921](https://github.com/apache/superset/pull/17921) chore(explore): make adhoc columns available without UX BETA ff (@kgabryje)
- [#18574](https://github.com/apache/superset/pull/18574) chore: update gitignore in the main folder, to hide PyCharm configuration (@michael-hoffman-26)
- [#18568](https://github.com/apache/superset/pull/18568) chore: Remove outdated roadmap page from Docusaurus (@geido)
- [#18254](https://github.com/apache/superset/pull/18254) docs(i18n): make translation guide more explicit (@villebro)
- [#18231](https://github.com/apache/superset/pull/18231) chore: add ci for docs-v2 (@ad-m)
- [#18559](https://github.com/apache/superset/pull/18559) chore: Update Docusaurus dependencies (@geido)
- [#18229](https://github.com/apache/superset/pull/18229) chore: Reference Github code in Docusaurus (@geido)
- [#18251](https://github.com/apache/superset/pull/18251) chore(tests): migrate mssql tests to pytest (@villebro)
- [#18188](https://github.com/apache/superset/pull/18188) refactor: upgrade ControlHeader to TSX & FC and add storybook (@ad-m)
- [#18230](https://github.com/apache/superset/pull/18230) chore: Docusaurus throw on broken links (@geido)
- [#18170](https://github.com/apache/superset/pull/18170) refactor: extract json_required view decorator (@ad-m)
- [#17926](https://github.com/apache/superset/pull/17926) refactor: sqleditorleftbar to typescript (@JosueLugaro)
- [#18199](https://github.com/apache/superset/pull/18199) chore: Update links and navigation in Docusaurus (@geido)
- [#18206](https://github.com/apache/superset/pull/18206) chore: added release notes for 1.4 (@srinify)
- [#18196](https://github.com/apache/superset/pull/18196) docs(docker compose installation): add pull command to avoid errors when installing superset using docker compose (@ancasarb)
- [#18160](https://github.com/apache/superset/pull/18160) chore: move controlPanel into time_table (@zhaoyongjie)
- [#18162](https://github.com/apache/superset/pull/18162) chore: bump echarts to 5.3.0 (@villebro)
- [#18134](https://github.com/apache/superset/pull/18134) chore: bump pillow to major version (@eschutho)
- [#18151](https://github.com/apache/superset/pull/18151) refactor: Moves the Explore form_data endpoint (@michael-s-molina)
- [#18130](https://github.com/apache/superset/pull/18130) chore: use pkg_resources for cleaner config (@betodealmeida)
- [#18125](https://github.com/apache/superset/pull/18125) docs: fix typo on security page (@proteusvacuum)
- [#18133](https://github.com/apache/superset/pull/18133) chore: migrating storybook jsx to typescript #18100 (@jayakrishnankk)
- [#18083](https://github.com/apache/superset/pull/18083) chore: update changelog and updating for 1.4.0 (@eschutho)
- [#18105](https://github.com/apache/superset/pull/18105) refactor: migrate RowCountLabel to TypeScript & added story (@ad-m)
- [#18101](https://github.com/apache/superset/pull/18101) refactor: migrate Checkbox story to TypeScript - see #18100 (@ad-m)
- [#17807](https://github.com/apache/superset/pull/17807) refactor: sqleditorleftbar to functional (@JosueLugaro)
- [#18082](https://github.com/apache/superset/pull/18082) chore: split CLI into multiple files (@betodealmeida)
- [#18060](https://github.com/apache/superset/pull/18060) refactor(example_data): replace the way the birth_names data is loaded to DB (@ofekisr)
- [#17771](https://github.com/apache/superset/pull/17771) refactor(sql_lab): SQL Lab Persistent Saved State (@AAfghahi)
- [#18059](https://github.com/apache/superset/pull/18059) chore(plugin-chart-echarts): add types to controls (@villebro)
- [#18058](https://github.com/apache/superset/pull/18058) chore(supeset.utils.core): move all database utils to database utils module (@ofekisr)
- [#18037](https://github.com/apache/superset/pull/18037) chore: important change to MakeFile (@AAfghahi)
- [#17569](https://github.com/apache/superset/pull/17569) chore: column_type_mappings (@dungdm93)
- [#18003](https://github.com/apache/superset/pull/18003) chore(DatasourceEditor): Create Datasource Legacy Editor Feature Flag (@AAfghahi)
- [#17996](https://github.com/apache/superset/pull/17996) refactor: remove unused ts-jest (@zhaoyongjie)
- [#17893](https://github.com/apache/superset/pull/17893) refactor: examples data loading for tests (@ofekisr)
- [#17967](https://github.com/apache/superset/pull/17967) chore: use new FAB functionality for component schemas update OAS (@dpgaspar)
- [#17979](https://github.com/apache/superset/pull/17979) chore: reenable lint for test files (@zhaoyongjie)
- [#17965](https://github.com/apache/superset/pull/17965) refactor: move superset-ui dependencies to peerDependencies (@zhaoyongjie)
- [#17930](https://github.com/apache/superset/pull/17930) chore: Move edit dataset lock (@lyndsiWilliams)
- [#17718](https://github.com/apache/superset/pull/17718) docs(contributing): update contributing section on docs page to match CONTRIBUTING.md (@riahk)
- [#17975](https://github.com/apache/superset/pull/17975) docs: close bracket on helm chart reference (@brnnnfx)
- [#17971](https://github.com/apache/superset/pull/17971) chore: bump typescript to 4.5.4, and adjust storybook story. (@rusackas)
- [#17972](https://github.com/apache/superset/pull/17972) chore: fixing annoying warning about escaping in Emotion styling (@rusackas)
- [#17947](https://github.com/apache/superset/pull/17947) refactor: import value name from root of superset-ui/core (@zhaoyongjie)
- [#17959](https://github.com/apache/superset/pull/17959) chore(deps): bump underscore from 1.12.0 to 1.12.1 in /superset-frontend (@dependabot[bot])
- [#17958](https://github.com/apache/superset/pull/17958) chore(deps): bump babel from 2.5.3 to 2.9.1 in /superset/translations (@dependabot[bot])
- [#17904](https://github.com/apache/superset/pull/17904) chore(deps): bump @storybook/addon-actions from 6.3.12 to 6.4.9 in /superset-frontend (@dependabot[bot])
- [#17902](https://github.com/apache/superset/pull/17902) chore: Moves spec files to the src folder - iteration 10 (@michael-s-molina)
- [#17901](https://github.com/apache/superset/pull/17901) chore: Moves spec files to the src folder - iteration 9 (@michael-s-molina)
- [#17956](https://github.com/apache/superset/pull/17956) chore: Adding more viz category mappings for viz picker (@rusackas)
- [#17963](https://github.com/apache/superset/pull/17963) chore: unbreak pip-compile-multi (@villebro)
- [#17899](https://github.com/apache/superset/pull/17899) chore: Moves spec files to the src folder - iteration 8 (@michael-s-molina)
- [#17897](https://github.com/apache/superset/pull/17897) chore: Moves the Menu to views/components folder (@michael-s-molina)
- [#17896](https://github.com/apache/superset/pull/17896) chore: Moves the hooks folder to the src folder (@michael-s-molina)
- [#17962](https://github.com/apache/superset/pull/17962) chore(deps): bump urijs from 1.19.6 to 1.19.7 in /superset-frontend (@dependabot[bot])
- [#17942](https://github.com/apache/superset/pull/17942) chore: Fix 'button' misspelling in list_with_checkboxes (@acrks)
- [#17860](https://github.com/apache/superset/pull/17860) chore: remove unused eslintrc (@zhaoyongjie)
- [#17909](https://github.com/apache/superset/pull/17909) refactor(storybok): upgrade to webpack5 in storybook of plugins (@zhaoyongjie)
- [#17924](https://github.com/apache/superset/pull/17924) chore: fix misspelling of button (@DavidWoolner)
- [#17782](https://github.com/apache/superset/pull/17782) ci: make presto hive tests to cover only chartData and sqljson (@amitmiran137)
- [#17717](https://github.com/apache/superset/pull/17717) chore: Fix UPDATING.md (@john-bodley)
- [#17824](https://github.com/apache/superset/pull/17824) chore: Help user to find the input fields in the dataset editor (@lyndsiWilliams)
- [#17837](https://github.com/apache/superset/pull/17837) refactor(monorepo): update plugin dependencies (@zhaoyongjie)
- [#17829](https://github.com/apache/superset/pull/17829) chore(generator-superset): migrate to monorepo (@villebro)
- [#17832](https://github.com/apache/superset/pull/17832) chore: Refactor localstorage into typesafe version (@etr2460)
- [#17811](https://github.com/apache/superset/pull/17811) other: Add Helm chart option for configOverrides through file (@dd-willgan)
- [#17828](https://github.com/apache/superset/pull/17828) chore: add lerna version (@zhaoyongjie)
- [#17827](https://github.com/apache/superset/pull/17827) refactor(monorepo): migrate plugins release workflow (@zhaoyongjie)
- [#17754](https://github.com/apache/superset/pull/17754) docs: update contribuing docs (@zhaoyongjie)
- [#17650](https://github.com/apache/superset/pull/17650) chore: updated screenshots in README.md and added recent events (@srinify)
- [#17797](https://github.com/apache/superset/pull/17797) chore(plugin-chart-table): move adhoc filters control closer to the metrics (@kgabryje)
- [#17798](https://github.com/apache/superset/pull/17798) chore(plugin-chart-pivot-table): change order of Columns and Rows controls (@kgabryje)
- [#17769](https://github.com/apache/superset/pull/17769) chore(plugin-chart-pivot-table): migrate react-pivottable into superset codebase (@kgabryje)
- [#17785](https://github.com/apache/superset/pull/17785) docs: Fix typo on line 967 (@ChristopherCFleming)
- [#17780](https://github.com/apache/superset/pull/17780) chore: update fixtures scope that are loading data into the analytical db (@bkyryliuk)
- [#17770](https://github.com/apache/superset/pull/17770) chore: print test runtime (@bkyryliuk)
- [#17772](https://github.com/apache/superset/pull/17772) chore: skip flaky tests (@betodealmeida)
- [#17764](https://github.com/apache/superset/pull/17764) chore: bump react-resize-detector (@villebro)
- [#17723](https://github.com/apache/superset/pull/17723) chore: bump FAB to 3.4.1 (@dpgaspar)
- [#17698](https://github.com/apache/superset/pull/17698) refactor(monorepo): change coverage of core to 100% (@zhaoyongjie)
- [#17737](https://github.com/apache/superset/pull/17737) chore: fixed spelling error on line 1342 of CONTRIBUTING.md (@JosueLugaro)
- [#17735](https://github.com/apache/superset/pull/17735) chore: fix misspelling of apprear to appear (@jcahela)
- [#17693](https://github.com/apache/superset/pull/17693) chore(de-translations): Add missing German translations (@hbruch)
- [#17715](https://github.com/apache/superset/pull/17715) chore: Rename CertifiedIcon to CertifiedBadge (@geido)
- [#17691](https://github.com/apache/superset/pull/17691) chore: Update TS tasklist script (@etr2460)
- [#17705](https://github.com/apache/superset/pull/17705) chore: unblock ci on postgres lint (@villebro)
- [#17596](https://github.com/apache/superset/pull/17596) refactor(monorepo): relocate deckgl to Superset (@zhaoyongjie)
- [#17689](https://github.com/apache/superset/pull/17689) chore: convert feature flag tests to unit tests (@betodealmeida)
- [#17687](https://github.com/apache/superset/pull/17687) chore: removing redundant docker-entrypoint (@ofekisr)
- [#17679](https://github.com/apache/superset/pull/17679) chore: update babel doc (@zhaoyongjie)
- [#17622](https://github.com/apache/superset/pull/17622) chore: Remove unreachable return statements (@PApostol)
- [#17605](https://github.com/apache/superset/pull/17605) docs(exploring-data): add a native filters section to the exploring data docs (@riahk)
- [#17639](https://github.com/apache/superset/pull/17639) refactor(monorepo): frontend code cleanup after monorepo (@zhaoyongjie)
- [#17631](https://github.com/apache/superset/pull/17631) chore(de-translations): Add and fix German translations (@hbruch)
- [#17626](https://github.com/apache/superset/pull/17626) chore(superset-ui): clean up legacy-plugin-chart-time-table (@ktmud)
- [#17634](https://github.com/apache/superset/pull/17634) chore(plugin-chart-pivot-table): Add more descriptive tooltips for sorting [ID-29] (@kgabryje)
- [#17606](https://github.com/apache/superset/pull/17606) refactor: Add AutoSizer to react-virtualized `Grid` (@hughhhh)
- [#17624](https://github.com/apache/superset/pull/17624) chore: Added unit test to query context change (@AAfghahi)
- [#17623](https://github.com/apache/superset/pull/17623) chore: Update docstrings in presto.py (@PApostol)
- [#17575](https://github.com/apache/superset/pull/17575) chore: bumping `polished` package (@rusackas)
- [#17603](https://github.com/apache/superset/pull/17603) chore: migrate EstimateQueryCostButton component from jsx to tsx (@Damans227)
- [#17516](https://github.com/apache/superset/pull/17516) docs(exploring-data): various updates to match latest superset version (@riahk)
- [#17577](https://github.com/apache/superset/pull/17577) chore: auditing cypress-base dependencies (@rusackas)
- [#17533](https://github.com/apache/superset/pull/17533) chore(deps-dev): bump @types/jquery from 3.5.8 to 3.5.9 in /superset-frontend (@dependabot[bot])
- [#17534](https://github.com/apache/superset/pull/17534) chore(deps-dev): bump @types/enzyme from 3.10.5 to 3.10.10 in /superset-frontend (@dependabot[bot])
- [#17535](https://github.com/apache/superset/pull/17535) chore(deps-dev): bump mini-css-extract-plugin from 2.3.0 to 2.4.5 in /superset-frontend (@dependabot[bot])
- [#17585](https://github.com/apache/superset/pull/17585) chore: disable merge button (@zhaoyongjie)
- [#17584](https://github.com/apache/superset/pull/17584) chore: temporarily update .asf.yml (@zhaoyongjie)
- [#17552](https://github.com/apache/superset/pull/17552) refactor(monorepo): move superset-ui to superset(stage 2) (@zhaoyongjie)
- [#17474](https://github.com/apache/superset/pull/17474) chore: migrate Fieldset component from jsx to tsx (@Damans227)
- [#17556](https://github.com/apache/superset/pull/17556) chore: bump mysqlclient version (@gnought)
- [#17525](https://github.com/apache/superset/pull/17525) chore(translations): Add missing i18n (@hbruch)
- [#17562](https://github.com/apache/superset/pull/17562) chore: Fix deprecated unittest aliases for Python 3.11 compatibility. (@tirkarthi)
- [#17561](https://github.com/apache/superset/pull/17561) chore: disable merge commit option (@villebro)
- [#17560](https://github.com/apache/superset/pull/17560) chore: temporarily enable merge in .asf.yml (@zhaoyongjie)
- [#17326](https://github.com/apache/superset/pull/17326) chore: migrate DragHandle component from jsx to tsx (@Damans227)
- [#17521](https://github.com/apache/superset/pull/17521) chore: bump major on Pillow, optional dependency (@dpgaspar)
- [#17452](https://github.com/apache/superset/pull/17452) chore(deps-dev): bump @types/jquery from 3.3.32 to 3.5.8 in /superset-frontend (@dependabot[bot])
- [#14783](https://github.com/apache/superset/pull/14783) chore: Slovak translation, enabling language and adding first translations (@minho95)
- [#17453](https://github.com/apache/superset/pull/17453) chore(deps-dev): bump eslint-import-resolver-webpack from 0.13.1 to 0.13.2 in /superset-frontend (@dependabot[bot])
- [#17502](https://github.com/apache/superset/pull/17502) docs(exploring-data): Add upload excel notes (@aniaan)
- [#17522](https://github.com/apache/superset/pull/17522) chore: remove deprecated selects and deps (@villebro)
- [#17492](https://github.com/apache/superset/pull/17492) chore: update node version in nvmrc to v16 (@ktmud)
- [#17500](https://github.com/apache/superset/pull/17500) chore(deps-dev): bump @babel/cli from 7.15.7 to 7.16.0 in /superset-frontend (@dependabot[bot])
- [#17478](https://github.com/apache/superset/pull/17478) chore(de-translation): update German translations (based on master) (#17441) (@hbruch)
- [#17501](https://github.com/apache/superset/pull/17501) chore(translations): fix translation literals (@villebro)
- [#17504](https://github.com/apache/superset/pull/17504) docs: add dropbox to users list (@exemplary-citizen)
- [#17361](https://github.com/apache/superset/pull/17361) chore: migrate FormattedNumber component from jsx to tsx (@Damans227)
- [#17509](https://github.com/apache/superset/pull/17509) refactor(chart.commands): separate commands into two different modules (@ofekisr)
- [#17434](https://github.com/apache/superset/pull/17434) chore: Slovenian translation update (@dkrat7)
- [#17497](https://github.com/apache/superset/pull/17497) refactor(QueryContext): separate all processing concerns into QueryContextProcessor (@ofekisr)
- [#17484](https://github.com/apache/superset/pull/17484) docs: mention that username should be admin to load examples in superset docs (@jayakrishnankk)
- [#14837](https://github.com/apache/superset/pull/14837) docs: Update frequently-asked-questions-page.mdx (@kurtiswen)
- [#17496](https://github.com/apache/superset/pull/17496) refactor(QueryContext): move df methods utils to utils package (@ofekisr)
- [#17495](https://github.com/apache/superset/pull/17495) refactor(QueryContext): add QueryContextFactory to meet SRP (@ofekisr)
- [#17482](https://github.com/apache/superset/pull/17482) chore(deps): bump cachelib from 0.1.1 to 0.4.1 (@villebro)
- [#17464](https://github.com/apache/superset/pull/17464) chore(sql_lab): Added Unit Test for stop query exception (@AAfghahi)
- [#17454](https://github.com/apache/superset/pull/17454) chore(deps-dev): bump @types/react-loadable from 5.5.4 to 5.5.6 in /superset-frontend (@dependabot[bot])
- [#17479](https://github.com/apache/superset/pull/17479) refactor(QueryObject): decouple from superset (@ofekisr)
- [#17466](https://github.com/apache/superset/pull/17466) refactor(QueryObject): add QueryObjectFactory to meet SRP (@ofekisr)
- [#17465](https://github.com/apache/superset/pull/17465) refactor(QueryObject): decouple from queryContext and clean code (@ofekisr)
- [#16868](https://github.com/apache/superset/pull/16868) chore(fr-translation): update whole French translation (based on 1.3.0 release) (@audour)
- [#17461](https://github.com/apache/superset/pull/17461) refactor(ChartDataCommand): remove create queryContext command's responsibly (@ofekisr)
- [#17427](https://github.com/apache/superset/pull/17427) refactor(monorepo): stage 1 (@zhaoyongjie)
- [#17451](https://github.com/apache/superset/pull/17451) chore: Ignore docs directory for dependabot (@hughhhh)
- [#17398](https://github.com/apache/superset/pull/17398) test: add native filter default value e2e (@jinghua-qa)
- [#17439](https://github.com/apache/superset/pull/17439) chore: bumping react syntax highlighter and thusly prismjs (@rusackas)
- [#17422](https://github.com/apache/superset/pull/17422) chore: Notify user of custom label colors and related Dashboard color scheme (@geido)
- [#14576](https://github.com/apache/superset/pull/14576) chore(deps): bump hosted-git-info from 2.8.8 to 2.8.9 in /docs (@dependabot[bot])
- [#17438](https://github.com/apache/superset/pull/17438) chore: bump superset-ui 0.18.25 (@zhaoyongjie)
- [#17425](https://github.com/apache/superset/pull/17425) refactor(ChartDataCommand): into two separate commands (@ofekisr)
- [#17407](https://github.com/apache/superset/pull/17407) refactor(TestChartApi): move chart data api tests into TestChartDataApi (@ofekisr)
- [#17405](https://github.com/apache/superset/pull/17405) refactor(ChartDataCommand): separate loading query_context form cache into different module (@ofekisr)
- [#17403](https://github.com/apache/superset/pull/17403) chore: add dependencies for monorepo (@zhaoyongjie)
- [#17400](https://github.com/apache/superset/pull/17400) refactor(ChartData): move chart_data_apis from ChartRestApi ChartDataRestApi (@ofekisr)
- [#17399](https://github.com/apache/superset/pull/17399) refactor(ChartData): move ChartDataResult enums to common (@ofekisr)
- [#17350](https://github.com/apache/superset/pull/17350) docs: add mishmash io to users list (@ntsvetanov)
- [#17387](https://github.com/apache/superset/pull/17387) docs: Reorder install instructions in CONTRIBUTING.md (@willbarrett)
- [#17367](https://github.com/apache/superset/pull/17367) chore: bump @typescript-eslint/eslint-plugin to 5.3.0 (@zhaoyongjie)
- [#17362](https://github.com/apache/superset/pull/17362) chore: bump superset-ui 0.18.20 (@zhaoyongjie)
- [#17343](https://github.com/apache/superset/pull/17343) test: add native filter e2e test part3 (@jinghua-qa)
- [#17325](https://github.com/apache/superset/pull/17325) chore(websocket): bump dependencies (@villebro)
- [#17246](https://github.com/apache/superset/pull/17246) chore: Test cases for annotations and annotation layers incorrect creation through API (@geido)
- [#17306](https://github.com/apache/superset/pull/17306) docs: fix numbering on getting started with kubernetes section (@jameskim0987)
- [#17315](https://github.com/apache/superset/pull/17315) chore: migrate HiddenControl component from jsx to tsx (@Damans227)
- [#17310](https://github.com/apache/superset/pull/17310) chore: bump superset-ui to 0.18.18 (@villebro)
- [#17284](https://github.com/apache/superset/pull/17284) style: remove redundant parentheses from setup.py (@PApostol)
- [#17283](https://github.com/apache/superset/pull/17283) test: add native filter part2 (@jinghua-qa)
- [#17290](https://github.com/apache/superset/pull/17290) chore: Bumping pyarrow / pandas (@craig-rueda)
- [#17293](https://github.com/apache/superset/pull/17293) docs(UPDATING): Adding downtime for #16756 (@exemplary-citizen)
- [#17191](https://github.com/apache/superset/pull/17191) chore(doc): Update BigQuery Connection database connection UI into doc (@rosemarie-chiu)
- [#17231](https://github.com/apache/superset/pull/17231) test: added some sanity test for native filter (@jinghua-qa)
- [#17270](https://github.com/apache/superset/pull/17270) chore: bump superset-ui to 0.18.17 (@john-bodley)
- [#17266](https://github.com/apache/superset/pull/17266) chore: bump deckgl 0.4.13 (@zhaoyongjie)
- [#17069](https://github.com/apache/superset/pull/17069) chore: remove supersetTheme with withTheme (@pkdotson)
- [#17251](https://github.com/apache/superset/pull/17251) chore: bump superset-ui v0.18.16 (@zhaoyongjie)
- [#16950](https://github.com/apache/superset/pull/16950) other(revert): "fix: the calculated columns explicit type convert into date" (@john-bodley)
- [#17220](https://github.com/apache/superset/pull/17220) chore: bump Dremio to 1.2.1 (@hughhhh)
- [#17216](https://github.com/apache/superset/pull/17216) chore: Removes the ChartIcon component (@michael-s-molina)
- [#17232](https://github.com/apache/superset/pull/17232) chore: bump to superset-ui 0.18.15 (@zhaoyongjie)
- [#17171](https://github.com/apache/superset/pull/17171) chore: Add docs to the Select component props (@geido)
- [#17132](https://github.com/apache/superset/pull/17132) chore: Breaks the dataViewCommon folder into TableCollection and Pagination folders (@michael-s-molina)
- [#17215](https://github.com/apache/superset/pull/17215) chore: use official isort in pre-commmit (@zhaoyongjie)
- [#17145](https://github.com/apache/superset/pull/17145) refactor: dashboard->explore url generation (@suddjian)
- [#17130](https://github.com/apache/superset/pull/17130) chore: Moves the datasource components to the components folder (@michael-s-molina)
- [#17028](https://github.com/apache/superset/pull/17028) docs: add Symmetrics to users list (@symmetricsfyi)
- [#17151](https://github.com/apache/superset/pull/17151) chore: update ui packages to 18.14 (@pkdotson)
- [#17146](https://github.com/apache/superset/pull/17146) chore(druid): No transform without time granularity for consistency (@john-bodley)
- [#17101](https://github.com/apache/superset/pull/17101) chore(druid): Explicitly cast col to TIMESTAMP (@john-bodley)
- [#17115](https://github.com/apache/superset/pull/17115) perf(native-filters): Decrease number of unnecessary rerenders in native filters (@kgabryje)
- [#17067](https://github.com/apache/superset/pull/17067) chore: upgrade highlight.js (@suddjian)
- [#17121](https://github.com/apache/superset/pull/17121) chore: bump superset-ui packages to 18.3 (@pkdotson)
- [#17129](https://github.com/apache/superset/pull/17129) chore: remove redundant po2json dev dependency (@villebro)
- [#17102](https://github.com/apache/superset/pull/17102) chore: Include codeowners for the Select component (@michael-s-molina)
- [#16911](https://github.com/apache/superset/pull/16911) test: Cypress 7.0.0 migration (@lyndsiWilliams)
- [#17017](https://github.com/apache/superset/pull/17017) chore: enable BQ tests (@betodealmeida)
- [#14577](https://github.com/apache/superset/pull/14577) build(deps): bump lodash from 4.17.19 to 4.17.21 in /docs (@dependabot[bot])
- [#17050](https://github.com/apache/superset/pull/17050) chore(druid): Standardizing time grain transformations (@john-bodley)
- [#17045](https://github.com/apache/superset/pull/17045) docs: add vscode linter instructions to CONTRIBUTING.md (@suddjian)
- [#16993](https://github.com/apache/superset/pull/16993) style: Update text for SLL Tooltip (@gabester78)
- [#16959](https://github.com/apache/superset/pull/16959) chore(Dashboard): Implement dedicated message for missing dataset (@geido)
- [#17016](https://github.com/apache/superset/pull/17016) docs(pylint): Add context about disablement of Pylint messages (@john-bodley)
- [#17009](https://github.com/apache/superset/pull/17009) chore: bump superset-ui 0.18.10 (@zhaoyongjie)
- [#16974](https://github.com/apache/superset/pull/16974) refactor(filterset): improve response body (@ofekisr)
- [#16999](https://github.com/apache/superset/pull/16999) chore: no direct use of supersetTheme (or bad LESS vars) in SqlEditor (@rusackas)
- [#17000](https://github.com/apache/superset/pull/17000) chore: removing use of supersetTheme in favor of ThemeProvider (@rusackas)
- [#16885](https://github.com/apache/superset/pull/16885) chore: upgrade babel (@suddjian)
- [#16973](https://github.com/apache/superset/pull/16973) test: update required tests to python 3.8 (@villebro)
- [#16689](https://github.com/apache/superset/pull/16689) chore: refactor header menu to show in header grid component (@pkdotson)

### 1.4.2 (Sat Mar 19 00:08:06 2022 +0200)

**Features**

- [#19248](https://github.com/apache/superset/pull/19248) feat: add support for comments in adhoc clauses (@villebro)
- [#18214](https://github.com/apache/superset/pull/18214) feat(docker-compose): add TAG option (@villebro)

**Fixes**

- [#17641](https://github.com/apache/superset/pull/17641) fix(sqla): make text clause escaping optional (@villebro)
- [#18566](https://github.com/apache/superset/pull/18566) fix(plugin-chart-echarts): area chart opacity bug (@villebro)

### 1.4.1

**Database Migrations**

**Features**

**Fixes**

- [#17980](https://github.com/apache/superset/pull/17980) fix: css template API response, less data (@dpgaspar)
- [#17984](https://github.com/apache/superset/pull/17984) fix: Change default SECRET_KEY, improve docs and banner warning on de… (@dpgaspar)
- [#17981](https://github.com/apache/superset/pull/17981) fix: API logger output (@dpgaspar)
- [#18006](https://github.com/apache/superset/pull/18006) fix: SQL Lab sorting of non-numbers (@etr2460)
- [#17573](https://github.com/apache/superset/pull/17573) fix(sqllab): Floating numbers not sorting correctly in result column (@lyndsiWilliams)
- [#17961](https://github.com/apache/superset/pull/17961) fix: update slug name (@pkdotson)
- [#17992](https://github.com/apache/superset/pull/17992) fix: dashboard reload crash (@pkdotson)
- [#18048](https://github.com/apache/superset/pull/18048) fix(dashboard): scope status of native filter not update (@stephenLYZ)
- [#16869](https://github.com/apache/superset/pull/16869) fix: handle TIME column serialization (@frafra)

**Others**
