/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.HarFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

/*
 * Exception performing whole class analysis ignored.
 */
public class HarFileSystem
extends FileSystem {
    private static final Log LOG = LogFactory.getLog(HarFileSystem.class);
    public static final String METADATA_CACHE_ENTRIES_KEY = "fs.har.metadatacache.entries";
    public static final int METADATA_CACHE_ENTRIES_DEFAULT = 10;
    public static final int VERSION = 3;
    private static Map<URI, HarMetaData> harMetaCache;
    private URI uri;
    private Path archivePath;
    private String harAuth;
    private HarMetaData metadata;
    private FileSystem fs;

    public HarFileSystem() {
    }

    @Override
    public String getScheme() {
        return "har";
    }

    public HarFileSystem(FileSystem fs) {
        this.fs = fs;
        this.statistics = fs.statistics;
    }

    private synchronized void initializeMetadataCache(Configuration conf) {
        if (harMetaCache == null) {
            int cacheSize = conf.getInt("fs.har.metadatacache.entries", 10);
            harMetaCache = Collections.synchronizedMap(new LruCache(cacheSize));
        }
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        this.initializeMetadataCache(conf);
        URI underLyingURI = this.decodeHarURI(name, conf);
        Path harPath = this.archivePath(new Path(name.getScheme(), name.getAuthority(), name.getPath()));
        if (harPath == null) {
            throw new IOException("Invalid path for the Har Filesystem. " + name.toString());
        }
        if (this.fs == null) {
            this.fs = FileSystem.get(underLyingURI, conf);
        }
        this.uri = harPath.toUri();
        this.archivePath = new Path(this.uri.getPath());
        this.harAuth = this.getHarAuth(underLyingURI);
        Path masterIndexPath = new Path(this.archivePath, "_masterindex");
        Path archiveIndexPath = new Path(this.archivePath, "_index");
        if (!this.fs.exists(masterIndexPath) || !this.fs.exists(archiveIndexPath)) {
            throw new IOException("Invalid path for the Har Filesystem. No index file in " + harPath);
        }
        this.metadata = harMetaCache.get(this.uri);
        if (this.metadata != null) {
            FileStatus mStat = this.fs.getFileStatus(masterIndexPath);
            FileStatus aStat = this.fs.getFileStatus(archiveIndexPath);
            if (mStat.getModificationTime() != this.metadata.getMasterIndexTimestamp() || aStat.getModificationTime() != this.metadata.getArchiveIndexTimestamp()) {
                this.metadata = null;
                harMetaCache.remove(this.uri);
            }
        }
        if (this.metadata == null) {
            this.metadata = new HarMetaData(this, this.fs, masterIndexPath, archiveIndexPath);
            HarMetaData.access$000((HarMetaData)this.metadata);
            harMetaCache.put(this.uri, this.metadata);
        }
    }

    @Override
    public Configuration getConf() {
        return this.fs.getConf();
    }

    public int getHarVersion() throws IOException {
        if (this.metadata != null) {
            return HarMetaData.access$100((HarMetaData)this.metadata);
        }
        throw new IOException("Invalid meta data for the Har Filesystem");
    }

    private Path archivePath(Path p) {
        Path retPath = null;
        Path tmp = p;
        for (int i = 0; i < p.depth(); ++i) {
            if (tmp.toString().endsWith(".har")) {
                retPath = tmp;
                break;
            }
            tmp = tmp.getParent();
        }
        return retPath;
    }

    private URI decodeHarURI(URI rawURI, Configuration conf) throws IOException {
        URI tmp;
        String tmpAuth = rawURI.getAuthority();
        if (tmpAuth == null) {
            return FileSystem.getDefaultUri(conf);
        }
        String authority = rawURI.getAuthority();
        if (authority == null) {
            throw new IOException("URI: " + rawURI + " is an invalid Har URI since authority==null." + "  Expecting har://<scheme>-<host>/<path>.");
        }
        int i = authority.indexOf(45);
        if (i < 0) {
            throw new IOException("URI: " + rawURI + " is an invalid Har URI since '-' not found." + "  Expecting har://<scheme>-<host>/<path>.");
        }
        if (rawURI.getQuery() != null) {
            throw new IOException("query component in Path not supported  " + rawURI);
        }
        try {
            URI baseUri = new URI(authority.replaceFirst("-", "://"));
            tmp = new URI(baseUri.getScheme(), baseUri.getAuthority(), rawURI.getPath(), rawURI.getQuery(), rawURI.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IOException("URI: " + rawURI + " is an invalid Har URI. Expecting har://<scheme>-<host>/<path>.");
        }
        return tmp;
    }

    private static String decodeString(String str) throws UnsupportedEncodingException {
        return URLDecoder.decode(str, "UTF-8");
    }

    private String decodeFileName(String fname) throws UnsupportedEncodingException {
        int version = HarMetaData.access$100((HarMetaData)this.metadata);
        if (version == 2 || version == 3) {
            return HarFileSystem.decodeString(fname);
        }
        return fname;
    }

    @Override
    public Path getWorkingDirectory() {
        return new Path(this.uri.toString());
    }

    @Override
    public Path getInitialWorkingDirectory() {
        return this.getWorkingDirectory();
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        return this.fs.getStatus(p);
    }

    private String getHarAuth(URI underLyingUri) {
        String auth = underLyingUri.getScheme() + "-";
        if (underLyingUri.getHost() != null) {
            if (underLyingUri.getUserInfo() != null) {
                auth = auth + underLyingUri.getUserInfo();
                auth = auth + "@";
            }
            auth = auth + underLyingUri.getHost();
            if (underLyingUri.getPort() != -1) {
                auth = auth + ":";
                auth = auth + underLyingUri.getPort();
            }
        } else {
            auth = auth + ":";
        }
        return auth;
    }

    @Override
    protected URI getCanonicalUri() {
        return this.fs.getCanonicalUri();
    }

    @Override
    protected URI canonicalizeUri(URI uri) {
        return this.fs.canonicalizeUri(uri);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    protected void checkPath(Path path) {
        this.fs.checkPath(path);
    }

    @Override
    public Path resolvePath(Path p) throws IOException {
        return this.fs.resolvePath(p);
    }

    private Path getPathInHar(Path path) {
        Path harPath = new Path(path.toUri().getPath());
        if (this.archivePath.compareTo(harPath) == 0) {
            return new Path("/");
        }
        Path tmp = new Path(harPath.getName());
        Path parent = harPath.getParent();
        while (parent.compareTo(this.archivePath) != 0) {
            if (parent.toString().equals("/")) {
                tmp = null;
                break;
            }
            tmp = new Path(parent.getName(), tmp);
            parent = parent.getParent();
        }
        if (tmp != null) {
            tmp = new Path("/", tmp);
        }
        return tmp;
    }

    private Path makeRelative(String initial, Path p) {
        String scheme = this.uri.getScheme();
        String authority = this.uri.getAuthority();
        Path root = new Path("/");
        if (root.compareTo(p) == 0) {
            return new Path(scheme, authority, initial);
        }
        Path retPath = new Path(p.getName());
        Path parent = p.getParent();
        for (int i = 0; i < p.depth() - 1; ++i) {
            retPath = new Path(parent.getName(), retPath);
            parent = parent.getParent();
        }
        return new Path(new Path(scheme, authority, initial), retPath.toString());
    }

    @Override
    public Path makeQualified(Path path) {
        Path fsPath = path;
        if (!path.isAbsolute()) {
            fsPath = new Path(this.archivePath, path);
        }
        URI tmpURI = fsPath.toUri();
        return new Path(this.uri.getScheme(), this.harAuth, tmpURI.getPath());
    }

    static BlockLocation[] fixBlockLocations(BlockLocation[] locations, long start, long len, long fileOffsetInHar) {
        long end = start + len;
        for (BlockLocation location : locations) {
            long harBlockStart = location.getOffset() - fileOffsetInHar;
            long harBlockEnd = harBlockStart + location.getLength();
            if (start > harBlockStart) {
                location.setOffset(start);
                location.setLength(location.getLength() - (start - harBlockStart));
            } else {
                location.setOffset(harBlockStart);
            }
            if (harBlockEnd <= end) continue;
            location.setLength(location.getLength() - (harBlockEnd - end));
        }
        return locations;
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        HarStatus hstatus = this.getFileHarStatus(file.getPath());
        Path partPath = new Path(this.archivePath, hstatus.getPartName());
        FileStatus partStatus = this.metadata.getPartFileStatus(partPath);
        BlockLocation[] locations = this.fs.getFileBlockLocations(partStatus, hstatus.getStartIndex() + start, len);
        return HarFileSystem.fixBlockLocations(locations, start, len, hstatus.getStartIndex());
    }

    public static int getHarHash(Path p) {
        return p.toString().hashCode() & Integer.MAX_VALUE;
    }

    private void fileStatusesInIndex(HarStatus parent, List<FileStatus> statuses) throws IOException {
        String parentString = parent.getName();
        if (!parentString.endsWith("/")) {
            parentString = parentString + "/";
        }
        Path harPath = new Path(parentString);
        int harlen = harPath.depth();
        TreeMap<String, FileStatus> cache = new TreeMap<String, FileStatus>();
        for (HarStatus hstatus : this.metadata.archive.values()) {
            Path thisPath;
            String child = hstatus.getName();
            if (!child.startsWith(parentString) || (thisPath = new Path(child)).depth() != harlen + 1) continue;
            statuses.add(this.toFileStatus(hstatus, cache));
        }
    }

    private FileStatus toFileStatus(HarStatus h, Map<String, FileStatus> cache) throws IOException {
        FileStatus underlying = null;
        if (cache != null) {
            underlying = cache.get(h.partName);
        }
        if (underlying == null) {
            Path p = h.isDir ? this.archivePath : new Path(this.archivePath, h.partName);
            underlying = this.fs.getFileStatus(p);
            if (cache != null) {
                cache.put(h.partName, underlying);
            }
        }
        long modTime = 0L;
        int version = HarMetaData.access$100((HarMetaData)this.metadata);
        if (version < 3) {
            modTime = underlying.getModificationTime();
        } else if (version == 3) {
            modTime = h.getModificationTime();
        }
        return new FileStatus(h.isDir() ? 0L : h.getLength(), h.isDir(), underlying.getReplication(), underlying.getBlockSize(), modTime, underlying.getAccessTime(), underlying.getPermission(), underlying.getOwner(), underlying.getGroup(), this.makeRelative(this.uri.getPath(), new Path(h.name)));
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        HarStatus hstatus = this.getFileHarStatus(f);
        return this.toFileStatus(hstatus, null);
    }

    private HarStatus getFileHarStatus(Path f) throws IOException {
        Path p = this.makeQualified(f);
        Path harPath = this.getPathInHar(p);
        if (harPath == null) {
            throw new IOException("Invalid file name: " + f + " in " + this.uri);
        }
        HarStatus hstatus = (HarStatus)this.metadata.archive.get(harPath);
        if (hstatus == null) {
            throw new FileNotFoundException("File: " + f + " does not exist in " + this.uri);
        }
        return hstatus;
    }

    @Override
    public FileChecksum getFileChecksum(Path f, long length) {
        return null;
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        HarStatus hstatus = this.getFileHarStatus(f);
        if (hstatus.isDir()) {
            throw new FileNotFoundException(f + " : not a file in " + this.archivePath);
        }
        return new HarFSDataInputStream(this.fs, new Path(this.archivePath, hstatus.getPartName()), hstatus.getStartIndex(), hstatus.getLength(), bufferSize);
    }

    @Override
    public FileSystem[] getChildFileSystems() {
        return new FileSystem[]{this.fs};
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Har: create not allowed.");
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Har: create not allowed.");
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Har: append not allowed.");
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean setReplication(Path src, short replication) throws IOException {
        throw new IOException("Har: setReplication not allowed");
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        throw new IOException("Har: rename not allowed");
    }

    @Override
    public FSDataOutputStream append(Path f) throws IOException {
        throw new IOException("Har: append not allowed");
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Har: delete not allowed");
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        Path tmpPath = this.makeQualified(f);
        Path harPath = this.getPathInHar(tmpPath);
        HarStatus hstatus = (HarStatus)this.metadata.archive.get(harPath);
        if (hstatus == null) {
            throw new FileNotFoundException("File " + f + " not found in " + this.archivePath);
        }
        if (hstatus.isDir()) {
            this.fileStatusesInIndex(hstatus, statuses);
        } else {
            statuses.add(this.toFileStatus(hstatus, null));
        }
        return statuses.toArray(new FileStatus[statuses.size()]);
    }

    @Override
    public Path getHomeDirectory() {
        return new Path(this.uri.toString());
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Har: mkdirs not allowed");
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        throw new IOException("Har: copyfromlocalfile not allowed");
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        throw new IOException("Har: copyfromlocalfile not allowed");
    }

    @Override
    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, HarFileSystem.getLocal(this.getConf()), dst, false, this.getConf());
    }

    @Override
    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        throw new IOException("Har: startLocalOutput not allowed");
    }

    @Override
    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        throw new IOException("Har: completeLocalOutput not allowed");
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        throw new IOException("Har: setowner not allowed");
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        throw new IOException("Har: setTimes not allowed");
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        throw new IOException("Har: setPermission not allowed");
    }

    HarMetaData getMetadata() {
        return this.metadata;
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.fs.getServerDefaults();
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        return this.fs.getServerDefaults(f);
    }

    @Override
    public long getUsed() throws IOException {
        return this.fs.getUsed();
    }

    @Override
    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        return this.fs.getDefaultBlockSize(f);
    }

    @Override
    public short getDefaultReplication() {
        return this.fs.getDefaultReplication();
    }

    @Override
    public short getDefaultReplication(Path f) {
        return this.fs.getDefaultReplication(f);
    }

    static /* synthetic */ String access$200(HarFileSystem x0, String x1) throws UnsupportedEncodingException {
        return x0.decodeFileName(x1);
    }

    static /* synthetic */ HarMetaData access$300(HarFileSystem x0) {
        return x0.metadata;
    }

    static /* synthetic */ String access$400(String x0) throws UnsupportedEncodingException {
        return HarFileSystem.decodeString(x0);
    }

    static /* synthetic */ Log access$500() {
        return LOG;
    }

    private static class HarFSDataInputStream
    extends FSDataInputStream {
        public HarFSDataInputStream(FileSystem fs, Path p, long start, long length, int bufsize) throws IOException {
            super((InputStream)new HarFsInputStream(fs, p, start, length, bufsize));
        }
    }
}

