/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.Options;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFile {
    private static final Log LOG = LogFactory.getLog(SequenceFile.class);
    private static final byte BLOCK_COMPRESS_VERSION = 4;
    private static final byte CUSTOM_COMPRESS_VERSION = 5;
    private static final byte VERSION_WITH_METADATA = 6;
    private static byte[] VERSION = new byte[]{83, 69, 81, 6};
    private static final int SYNC_ESCAPE = -1;
    private static final int SYNC_HASH_SIZE = 16;
    private static final int SYNC_SIZE = 20;
    public static final int SYNC_INTERVAL = 2000;

    private SequenceFile() {
    }

    public static CompressionType getDefaultCompressionType(Configuration job) {
        String name = job.get("io.seqfile.compression.type");
        return name == null ? CompressionType.RECORD : CompressionType.valueOf(name);
    }

    public static void setDefaultCompressionType(Configuration job, CompressionType val) {
        job.set("io.seqfile.compression.type", val.toString());
    }

    public static Writer createWriter(Configuration conf, Writer.Option ... opts) throws IOException {
        CompressionType kind;
        Writer.CompressionOption compressionOption = (Writer.CompressionOption)Options.getOption(Writer.CompressionOption.class, (Object[])opts);
        if (compressionOption != null) {
            kind = compressionOption.getValue();
        } else {
            kind = SequenceFile.getDefaultCompressionType(conf);
            opts = (Writer.Option[])Options.prependOptions((Object[])opts, (Object[])new Writer.Option[]{Writer.compression(kind)});
        }
        switch (1.$SwitchMap$org$apache$hadoop$io$SequenceFile$CompressionType[kind.ordinal()]) {
            default: {
                return new Writer(conf, opts);
            }
            case 2: {
                return new RecordCompressWriter(conf, opts);
            }
            case 3: 
        }
        return new BlockCompressWriter(conf, opts);
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass) throws IOException {
        return SequenceFile.createWriter(conf, Writer.filesystem(fs), Writer.file(name), Writer.keyClass(keyClass), Writer.valueClass(valClass));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType) throws IOException {
        return SequenceFile.createWriter(conf, Writer.filesystem(fs), Writer.file(name), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, Progressable progress) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType), Writer.progressable(progress));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec), Writer.progressable(progress), Writer.metadata(metadata));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, CompressionType compressionType, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.bufferSize(bufferSize), Writer.replication(replication), Writer.blockSize(blockSize), Writer.compression(compressionType, codec), Writer.progressable(progress), Writer.metadata(metadata));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, boolean createParent, CompressionType compressionType, CompressionCodec codec, Metadata metadata) throws IOException {
        return SequenceFile.createWriter(FileContext.getFileContext((URI)fs.getUri(), (Configuration)conf), conf, name, keyClass, valClass, compressionType, codec, metadata, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[]{Options.CreateOpts.bufferSize((int)bufferSize), createParent ? Options.CreateOpts.createParent() : Options.CreateOpts.donotCreateParent(), Options.CreateOpts.repFac((short)replication), Options.CreateOpts.blockSize((long)blockSize)});
    }

    public static Writer createWriter(FileContext fc, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Metadata metadata, EnumSet<CreateFlag> createFlag, Options.CreateOpts ... opts) throws IOException {
        return SequenceFile.createWriter(conf, fc.create(name, createFlag, opts), keyClass, valClass, compressionType, codec, metadata).ownStream();
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Progressable progress) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec), Writer.progressable(progress));
    }

    @Deprecated
    public static Writer createWriter(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Metadata metadata) throws IOException {
        return SequenceFile.createWriter(conf, Writer.stream(out), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec), Writer.metadata(metadata));
    }

    @Deprecated
    public static Writer createWriter(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec) throws IOException {
        return SequenceFile.createWriter(conf, Writer.stream(out), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec));
    }

    private static int getBufferSize(Configuration conf) {
        return conf.getInt("io.file.buffer.size", 4096);
    }

    static /* synthetic */ Log access$800() {
        return LOG;
    }

    static class BlockCompressWriter
    extends Writer {
        private int noBufferedRecords = 0;
        private DataOutputBuffer keyLenBuffer = new DataOutputBuffer();
        private DataOutputBuffer keyBuffer = new DataOutputBuffer();
        private DataOutputBuffer valLenBuffer = new DataOutputBuffer();
        private DataOutputBuffer valBuffer = new DataOutputBuffer();
        private final int compressionBlockSize;

        BlockCompressWriter(Configuration conf, Writer.Option ... options) throws IOException {
            super(conf, options);
            this.compressionBlockSize = conf.getInt("io.seqfile.compress.blocksize", 1000000);
            this.keySerializer.close();
            this.keySerializer.open(this.keyBuffer);
            this.uncompressedValSerializer.close();
            this.uncompressedValSerializer.open(this.valBuffer);
        }

        private synchronized void writeBuffer(DataOutputBuffer uncompressedDataBuffer) throws IOException {
            this.deflateFilter.resetState();
            this.buffer.reset();
            this.deflateOut.write(uncompressedDataBuffer.getData(), 0, uncompressedDataBuffer.getLength());
            this.deflateOut.flush();
            this.deflateFilter.finish();
            WritableUtils.writeVInt(this.out, this.buffer.getLength());
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
        }

        @Override
        public synchronized void sync() throws IOException {
            if (this.noBufferedRecords > 0) {
                super.sync();
                WritableUtils.writeVInt(this.out, this.noBufferedRecords);
                this.writeBuffer(this.keyLenBuffer);
                this.writeBuffer(this.keyBuffer);
                this.writeBuffer(this.valLenBuffer);
                this.writeBuffer(this.valBuffer);
                this.out.flush();
                this.keyLenBuffer.reset();
                this.keyBuffer.reset();
                this.valLenBuffer.reset();
                this.valBuffer.reset();
                this.noBufferedRecords = 0;
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.out != null) {
                this.sync();
            }
            super.close();
        }

        @Override
        public synchronized void append(Object key, Object val) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key + " is not " + this.keyClass);
            }
            if (val.getClass() != this.valClass) {
                throw new IOException("wrong value class: " + val + " is not " + this.valClass);
            }
            int oldKeyLength = this.keyBuffer.getLength();
            this.keySerializer.serialize(key);
            int keyLength = this.keyBuffer.getLength() - oldKeyLength;
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + key);
            }
            WritableUtils.writeVInt(this.keyLenBuffer, keyLength);
            int oldValLength = this.valBuffer.getLength();
            this.uncompressedValSerializer.serialize(val);
            int valLength = this.valBuffer.getLength() - oldValLength;
            WritableUtils.writeVInt(this.valLenBuffer, valLength);
            ++this.noBufferedRecords;
            int currentBlockSize = this.keyBuffer.getLength() + this.valBuffer.getLength();
            if (currentBlockSize >= this.compressionBlockSize) {
                this.sync();
            }
        }

        @Override
        public synchronized void appendRaw(byte[] keyData, int keyOffset, int keyLength, ValueBytes val) throws IOException {
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed");
            }
            int valLength = val.getSize();
            WritableUtils.writeVInt(this.keyLenBuffer, keyLength);
            this.keyBuffer.write(keyData, keyOffset, keyLength);
            WritableUtils.writeVInt(this.valLenBuffer, valLength);
            val.writeUncompressedBytes((DataOutputStream)this.valBuffer);
            ++this.noBufferedRecords;
            int currentBlockSize = this.keyBuffer.getLength() + this.valBuffer.getLength();
            if (currentBlockSize >= this.compressionBlockSize) {
                this.sync();
            }
        }
    }

    static class RecordCompressWriter
    extends Writer {
        RecordCompressWriter(Configuration conf, Writer.Option ... options) throws IOException {
            super(conf, options);
        }

        @Override
        public synchronized void append(Object key, Object val) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (val.getClass() != this.valClass) {
                throw new IOException("wrong value class: " + val.getClass().getName() + " is not " + this.valClass);
            }
            this.buffer.reset();
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + key);
            }
            this.deflateFilter.resetState();
            this.compressedValSerializer.serialize(val);
            this.deflateOut.flush();
            this.deflateFilter.finish();
            this.checkAndWriteSync();
            this.out.writeInt(this.buffer.getLength());
            this.out.writeInt(keyLength);
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
        }

        @Override
        public synchronized void appendRaw(byte[] keyData, int keyOffset, int keyLength, ValueBytes val) throws IOException {
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + keyLength);
            }
            int valLength = val.getSize();
            this.checkAndWriteSync();
            this.out.writeInt(keyLength + valLength);
            this.out.writeInt(keyLength);
            this.out.write(keyData, keyOffset, keyLength);
            val.writeCompressedBytes((DataOutputStream)this.out);
        }
    }

    public static class Writer
    implements Closeable,
    Syncable {
        private Configuration conf;
        FSDataOutputStream out;
        boolean ownOutputStream = true;
        DataOutputBuffer buffer = new DataOutputBuffer();
        Class keyClass;
        Class valClass;
        private final CompressionType compress;
        CompressionCodec codec = null;
        CompressionOutputStream deflateFilter = null;
        DataOutputStream deflateOut = null;
        Metadata metadata = null;
        Compressor compressor = null;
        protected Serializer keySerializer;
        protected Serializer uncompressedValSerializer;
        protected Serializer compressedValSerializer;
        long lastSyncPos;
        byte[] sync;

        public static Option file(Path value) {
            return new FileOption(value);
        }

        @Deprecated
        private static Option filesystem(FileSystem fs) {
            return new FileSystemOption(fs);
        }

        public static Option bufferSize(int value) {
            return new BufferSizeOption(value);
        }

        public static Option stream(FSDataOutputStream value) {
            return new StreamOption(value);
        }

        public static Option replication(short value) {
            return new ReplicationOption((int)value);
        }

        public static Option blockSize(long value) {
            return new BlockSizeOption(value);
        }

        public static Option progressable(Progressable value) {
            return new ProgressableOption(value);
        }

        public static Option keyClass(Class<?> value) {
            return new KeyClassOption(value);
        }

        public static Option valueClass(Class<?> value) {
            return new ValueClassOption(value);
        }

        public static Option metadata(Metadata value) {
            return new MetadataOption(value);
        }

        public static Option compression(CompressionType value) {
            return new CompressionOption(value);
        }

        public static Option compression(CompressionType value, CompressionCodec codec) {
            return new CompressionOption(value, codec);
        }

        Writer(Configuration conf, Option ... opts) throws IOException {
            FSDataOutputStream out;
            boolean ownStream;
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = Time.now();
                digester.update((new UID() + "@" + time).getBytes());
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            BlockSizeOption blockSizeOption = (BlockSizeOption)Options.getOption(BlockSizeOption.class, (Object[])opts);
            BufferSizeOption bufferSizeOption = (BufferSizeOption)Options.getOption(BufferSizeOption.class, (Object[])opts);
            ReplicationOption replicationOption = (ReplicationOption)Options.getOption(ReplicationOption.class, (Object[])opts);
            ProgressableOption progressOption = (ProgressableOption)Options.getOption(ProgressableOption.class, (Object[])opts);
            FileOption fileOption = (FileOption)Options.getOption(FileOption.class, (Object[])opts);
            FileSystemOption fsOption = (FileSystemOption)Options.getOption(FileSystemOption.class, (Object[])opts);
            StreamOption streamOption = (StreamOption)Options.getOption(StreamOption.class, (Object[])opts);
            KeyClassOption keyClassOption = (KeyClassOption)Options.getOption(KeyClassOption.class, (Object[])opts);
            ValueClassOption valueClassOption = (ValueClassOption)Options.getOption(ValueClassOption.class, (Object[])opts);
            MetadataOption metadataOption = (MetadataOption)Options.getOption(MetadataOption.class, (Object[])opts);
            CompressionOption compressionTypeOption = (CompressionOption)Options.getOption(CompressionOption.class, (Object[])opts);
            if (fileOption == null == (streamOption == null)) {
                throw new IllegalArgumentException("file or stream must be specified");
            }
            if (fileOption == null && (blockSizeOption != null || bufferSizeOption != null || replicationOption != null || progressOption != null)) {
                throw new IllegalArgumentException("file modifier options not compatible with stream");
            }
            boolean bl = ownStream = fileOption != null;
            if (ownStream) {
                Path p = fileOption.getValue();
                FileSystem fs = fsOption != null ? fsOption.getValue() : p.getFileSystem(conf);
                int bufferSize = bufferSizeOption == null ? SequenceFile.getBufferSize(conf) : bufferSizeOption.getValue();
                short replication = replicationOption == null ? fs.getDefaultReplication(p) : (short)replicationOption.getValue();
                long blockSize = blockSizeOption == null ? fs.getDefaultBlockSize(p) : blockSizeOption.getValue();
                Progressable progress = progressOption == null ? null : progressOption.getValue();
                out = fs.create(p, true, bufferSize, replication, blockSize, progress);
            } else {
                out = streamOption.getValue();
            }
            Class keyClass = keyClassOption == null ? Object.class : keyClassOption.getValue();
            Class valueClass = valueClassOption == null ? Object.class : valueClassOption.getValue();
            Metadata metadata = metadataOption == null ? new Metadata() : metadataOption.getValue();
            this.compress = compressionTypeOption.getValue();
            CompressionCodec codec = compressionTypeOption.getCodec();
            if (codec != null && codec instanceof GzipCodec && !NativeCodeLoader.isNativeCodeLoaded() && !ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
                throw new IllegalArgumentException("SequenceFile doesn't work with GzipCodec without native-hadoop code!");
            }
            this.init(conf, out, ownStream, keyClass, valueClass, codec, metadata);
        }

        @Deprecated
        public Writer(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = Time.now();
                digester.update((new UID() + "@" + time).getBytes());
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.compress = CompressionType.NONE;
            this.init(conf, fs.create(name), true, keyClass, valClass, null, new Metadata());
        }

        @Deprecated
        public Writer(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, Progressable progress, Metadata metadata) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = Time.now();
                digester.update((new UID() + "@" + time).getBytes());
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.compress = CompressionType.NONE;
            this.init(conf, fs.create(name, progress), true, keyClass, valClass, null, metadata);
        }

        @Deprecated
        public Writer(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, Progressable progress, Metadata metadata) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = Time.now();
                digester.update((new UID() + "@" + time).getBytes());
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.compress = CompressionType.NONE;
            this.init(conf, fs.create(name, true, bufferSize, replication, blockSize, progress), true, keyClass, valClass, null, metadata);
        }

        boolean isCompressed() {
            return this.compress != CompressionType.NONE;
        }

        boolean isBlockCompressed() {
            return this.compress == CompressionType.BLOCK;
        }

        Writer ownStream() {
            this.ownOutputStream = true;
            return this;
        }

        private void writeFileHeader() throws IOException {
            this.out.write(VERSION);
            Text.writeString(this.out, this.keyClass.getName());
            Text.writeString(this.out, this.valClass.getName());
            this.out.writeBoolean(this.isCompressed());
            this.out.writeBoolean(this.isBlockCompressed());
            if (this.isCompressed()) {
                Text.writeString(this.out, this.codec.getClass().getName());
            }
            this.metadata.write(this.out);
            this.out.write(this.sync);
            this.out.flush();
        }

        void init(Configuration conf, FSDataOutputStream out, boolean ownStream, Class keyClass, Class valClass, CompressionCodec codec, Metadata metadata) throws IOException {
            this.conf = conf;
            this.out = out;
            this.ownOutputStream = ownStream;
            this.keyClass = keyClass;
            this.valClass = valClass;
            this.codec = codec;
            this.metadata = metadata;
            SerializationFactory serializationFactory = new SerializationFactory(conf);
            this.keySerializer = serializationFactory.getSerializer(keyClass);
            if (this.keySerializer == null) {
                throw new IOException("Could not find a serializer for the Key class: '" + keyClass.getCanonicalName() + "'. " + "Please ensure that the configuration '" + "io.serializations" + "' is " + "properly configured, if you're using" + "custom serialization.");
            }
            this.keySerializer.open(this.buffer);
            this.uncompressedValSerializer = serializationFactory.getSerializer(valClass);
            if (this.uncompressedValSerializer == null) {
                throw new IOException("Could not find a serializer for the Value class: '" + valClass.getCanonicalName() + "'. " + "Please ensure that the configuration '" + "io.serializations" + "' is " + "properly configured, if you're using" + "custom serialization.");
            }
            this.uncompressedValSerializer.open(this.buffer);
            if (this.codec != null) {
                ReflectionUtils.setConf(this.codec, this.conf);
                this.compressor = CodecPool.getCompressor(this.codec);
                this.deflateFilter = this.codec.createOutputStream(this.buffer, this.compressor);
                this.deflateOut = new DataOutputStream(new BufferedOutputStream(this.deflateFilter));
                this.compressedValSerializer = serializationFactory.getSerializer(valClass);
                if (this.compressedValSerializer == null) {
                    throw new IOException("Could not find a serializer for the Value class: '" + valClass.getCanonicalName() + "'. " + "Please ensure that the configuration '" + "io.serializations" + "' is " + "properly configured, if you're using" + "custom serialization.");
                }
                this.compressedValSerializer.open(this.deflateOut);
            }
            this.writeFileHeader();
        }

        public Class getKeyClass() {
            return this.keyClass;
        }

        public Class getValueClass() {
            return this.valClass;
        }

        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }

        @Override
        public void sync() throws IOException {
            if (this.sync != null && this.lastSyncPos != this.out.getPos()) {
                this.out.writeInt(-1);
                this.out.write(this.sync);
                this.lastSyncPos = this.out.getPos();
            }
        }

        @Deprecated
        public void syncFs() throws IOException {
            if (this.out != null) {
                this.out.sync();
            }
        }

        @Override
        public void hsync() throws IOException {
            if (this.out != null) {
                this.out.hsync();
            }
        }

        @Override
        public void hflush() throws IOException {
            if (this.out != null) {
                this.out.hflush();
            }
        }

        Configuration getConf() {
            return this.conf;
        }

        @Override
        public synchronized void close() throws IOException {
            this.keySerializer.close();
            this.uncompressedValSerializer.close();
            if (this.compressedValSerializer != null) {
                this.compressedValSerializer.close();
            }
            CodecPool.returnCompressor(this.compressor);
            this.compressor = null;
            if (this.out != null) {
                if (this.ownOutputStream) {
                    this.out.close();
                } else {
                    this.out.flush();
                }
                this.out = null;
            }
        }

        synchronized void checkAndWriteSync() throws IOException {
            if (this.sync != null && this.out.getPos() >= this.lastSyncPos + 2000L) {
                this.sync();
            }
        }

        public void append(Writable key, Writable val) throws IOException {
            this.append((Object)key, (Object)val);
        }

        public synchronized void append(Object key, Object val) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (val.getClass() != this.valClass) {
                throw new IOException("wrong value class: " + val.getClass().getName() + " is not " + this.valClass);
            }
            this.buffer.reset();
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + key);
            }
            if (this.compress == CompressionType.RECORD) {
                this.deflateFilter.resetState();
                this.compressedValSerializer.serialize(val);
                this.deflateOut.flush();
                this.deflateFilter.finish();
            } else {
                this.uncompressedValSerializer.serialize(val);
            }
            this.checkAndWriteSync();
            this.out.writeInt(this.buffer.getLength());
            this.out.writeInt(keyLength);
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
        }

        public synchronized void appendRaw(byte[] keyData, int keyOffset, int keyLength, ValueBytes val) throws IOException {
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + keyLength);
            }
            int valLength = val.getSize();
            this.checkAndWriteSync();
            this.out.writeInt(keyLength + valLength);
            this.out.writeInt(keyLength);
            this.out.write(keyData, keyOffset, keyLength);
            val.writeUncompressedBytes((DataOutputStream)this.out);
        }

        public synchronized long getLength() throws IOException {
            return this.out.getPos();
        }

        public static interface Option {
        }
    }

    public static class Metadata
    implements Writable {
        private TreeMap<Text, Text> theMetadata;

        public Metadata() {
            this(new TreeMap<Text, Text>());
        }

        public Metadata(TreeMap<Text, Text> arg) {
            this.theMetadata = arg == null ? new TreeMap() : arg;
        }

        public Text get(Text name) {
            return this.theMetadata.get(name);
        }

        public void set(Text name, Text value) {
            this.theMetadata.put(name, value);
        }

        public TreeMap<Text, Text> getMetadata() {
            return new TreeMap<Text, Text>((SortedMap<Text, Text>)this.theMetadata);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.theMetadata.size());
            for (Map.Entry<Text, Text> en : this.theMetadata.entrySet()) {
                en.getKey().write(out);
                en.getValue().write(out);
            }
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            int sz = in.readInt();
            if (sz < 0) {
                throw new IOException("Invalid size: " + sz + " for file metadata object");
            }
            this.theMetadata = new TreeMap();
            for (int i = 0; i < sz; ++i) {
                Text key = new Text();
                Text val = new Text();
                key.readFields(in);
                val.readFields(in);
                this.theMetadata.put(key, val);
            }
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            return this.equals((Metadata)other);
        }

        public boolean equals(Metadata other) {
            if (other == null) {
                return false;
            }
            if (this.theMetadata.size() != other.theMetadata.size()) {
                return false;
            }
            Iterator<Map.Entry<Text, Text>> iter1 = this.theMetadata.entrySet().iterator();
            Iterator<Map.Entry<Text, Text>> iter2 = other.theMetadata.entrySet().iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                Map.Entry<Text, Text> en1 = iter1.next();
                Map.Entry<Text, Text> en2 = iter2.next();
                if (!en1.getKey().equals(en2.getKey())) {
                    return false;
                }
                if (en1.getValue().equals(en2.getValue())) continue;
                return false;
            }
            return !iter1.hasNext() && !iter2.hasNext();
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("size: ").append(this.theMetadata.size()).append("\n");
            for (Map.Entry<Text, Text> en : this.theMetadata.entrySet()) {
                sb.append("\t").append(en.getKey().toString()).append("\t").append(en.getValue().toString());
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    public static enum CompressionType {
        NONE,
        RECORD,
        BLOCK;

    }
}

