/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.HashMap;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.debug.DMLBreakpointManager;
import org.apache.sysml.parser.DataExpression;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;

public class OutputStatement
extends Statement {
    private DataIdentifier _id;
    private DataExpression _paramsExpr;
    public static final String[] WRITE_VALID_PARAM_NAMES = new String[]{"iofilename", "format", "sep", "header", "sparse", "description"};

    public DataIdentifier getIdentifier() {
        return this._id;
    }

    public DataExpression getSource() {
        return this._paramsExpr;
    }

    public void setIdentifier(DataIdentifier t) {
        this._id = t;
    }

    public OutputStatement(ParserRuleContext ctx, DataIdentifier t, Expression.DataOp op, String filename) {
        this._id = t;
        this._paramsExpr = new DataExpression(ctx, op, new HashMap<String, Expression>(), filename);
        this.setCtxValuesAndFilename(ctx, filename);
    }

    public OutputStatement(DataIdentifier t, Expression.DataOp op, ParseInfo parseInfo) {
        this._id = t;
        this._paramsExpr = new DataExpression(op, new HashMap<String, Expression>(), parseInfo);
        this.setParseInfo(parseInfo);
    }

    public static boolean isValidParamName(String key) {
        for (String paramName : WRITE_VALID_PARAM_NAMES) {
            if (!paramName.equals(key)) continue;
            return true;
        }
        return false;
    }

    public void addExprParam(String name, Expression value, boolean fromMTDFile) {
        if (this._paramsExpr.getVarParam(name) != null) {
            this.raiseValidateError("attempted to add IOStatement parameter " + name + " more than once", false);
        }
        if (!OutputStatement.isValidParamName(name)) {
            this.raiseValidateError("attempted to add invalid write statement parameter: " + name, false);
        }
        this._paramsExpr.addVarParam(name, value);
    }

    @Override
    public Statement rewriteStatement(String prefix) {
        OutputStatement newStatement = new OutputStatement(null, Expression.DataOp.WRITE, this);
        newStatement._id = (DataIdentifier)this._id.rewriteExpression(prefix);
        Expression.DataOp op = this._paramsExpr.getOpCode();
        HashMap<String, Expression> newExprParams = new HashMap<String, Expression>();
        for (String key : this._paramsExpr.getVarParams().keySet()) {
            Expression newExpr = this._paramsExpr.getVarParam(key).rewriteExpression(prefix);
            newExprParams.put(key, newExpr);
        }
        DataExpression newParamerizedExpr = new DataExpression(op, newExprParams, this);
        newStatement.setExprParams(newParamerizedExpr);
        return newStatement;
    }

    public void setExprParams(DataExpression newParamerizedExpr) {
        this._paramsExpr = newParamerizedExpr;
    }

    public Expression getExprParam(String key) {
        return this._paramsExpr.getVarParam(key);
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) {
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) {
        return lo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WRITE(");
        sb.append("id=" + this._id.toString());
        for (String key : this._paramsExpr.getVarParams().keySet()) {
            sb.append(", ");
            sb.append(key);
            sb.append("=");
            Expression exp = this._paramsExpr.getVarParam(key);
            if (exp instanceof StringIdentifier) {
                sb.append("\"");
                sb.append(exp.toString());
                sb.append("\"");
                continue;
            }
            sb.append(exp.toString());
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._id.variablesRead());
        for (String key : this._paramsExpr.getVarParams().keySet()) {
            result.addVariables(this._paramsExpr.getVarParam(key).variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        return null;
    }

    @Override
    public boolean controlStatement() {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            DMLBreakpointManager.insertBreakpoint(this._paramsExpr.getBeginLine());
            return true;
        }
        Expression fmt = this._paramsExpr.getVarParam("format");
        return fmt != null && fmt.toString().equalsIgnoreCase("csv");
    }
}

